c
c   @(#)tricon.f	1.3
c   02/04/19 16:41:46
c  
c   PROGRAM NAME:  Manifold

c   (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
c   CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.

c   Please refer to the LICENSE file in the top directory

c 
c       author: Mike Henderson mhender@watson.ibm.com

c
c     real    s(-2:ldx,-2:ldy,-2:ldz)          array of values on grid
c             nx,ny,nz                         cube is 0:nx,0:ny,0:nz
c             xl,xr,yl,yr,zl,zr                values of cube corners
c             v(1:nl)                          values for surfaces
c             h                                displacment for labels
c             ired(1:nl)..iblu(1:nl)           surface color
c             iered(1:nl)..ieblu(1:nl)         edge colors
c             vol(1:nl)                        volume inside surfaces
c             area(1:nl)                       area of surfaces
c     logical contour                          true if surfaces plotted
c     logical volume                           true if volume and area
c                                                   computed
c
      subroutine tricon(s,ldx,ldy,ldz,nx,ny,nz,
     *         xl,xr,yl,yr,zl,zr,
     *         v,nl,h,
     *         ired,igrn,iblu,iered,iegrn,ieblu,
     *         vol,area,
     *         contour,volume)
      real*8 TetraVolume,TriangleArea,TentVolume,SquareArea
      real*8 tetvol,thisvol
      real*8 totvol
      integer flag  (100)
      data if1,if2,if3,if4/1,1,1,1/
      integer ntri/0/

      logical contour,volume

      real    s(-2:ldx,-2:ldy,-2:ldz)
      real    v(100)
      real    s0(18)
      real    s1(18)
      real    se(6)
      real    x(18),y(18),z(18)
      real    nrmx(8),nrmy(8),nrmz(8)
      real    nrm(3,18)
      integer iflag(18)

      real*8  vol(nl),area(nl)
c
c   iedge(*,i) stores the corner numbers of the endpoints of edge i
c
      integer iedge(2,18)
      data    iedge/1,2,
     *              2,3,
     *              3,4,
     *              1,4,
     *              2,4,
     *              1,5,
     *              2,6,
     *              3,7,
     *              4,8,
     *              2,5,
     *              2,7,
     *              4,5,
     *              4,7,
     *              5,6,
     *              6,7,
     *              7,8,
     *              8,5,
     *              5,7/
c
c   ipt(*,i,ifx,ify,ifz) stores the (dx,dy,dz) displacements of corner
c            i ( (ifx,ify,ifz) are "flips")
c
      integer ipt(3,8,0:1,0:1,0:1)
      data    ((ipt(i,j,0,0,0),i=1,3),j=1,8)/
     *            0,0,0,
     *            1,0,0,
     *            1,1,0,
     *            0,1,0,
     *            0,0,1,
     *            1,0,1,
     *            1,1,1,
     *            0,1,1/
      data    ((ipt(i,j,1,0,0),i=1,3),j=1,8)/
     *            1,0,0,
     *            0,0,0,
     *            0,1,0,
     *            1,1,0,
     *            1,0,1,
     *            0,0,1,
     *            0,1,1,
     *            1,1,1/
      data    ((ipt(i,j,0,1,0),i=1,3),j=1,8)/
     *            0,1,0,
     *            1,1,0,
     *            1,0,0,
     *            0,0,0,
     *            0,1,1,
     *            1,1,1,
     *            1,0,1,
     *            0,0,1/
      data    ((ipt(i,j,1,1,0),i=1,3),j=1,8)/
     *            1,1,0,
     *            0,1,0,
     *            0,0,0,
     *            1,0,0,
     *            1,1,1,
     *            0,1,1,
     *            0,0,1,
     *            1,0,1/
      data    ((ipt(i,j,0,0,1),i=1,3),j=1,8)/
     *            0,0,1,
     *            1,0,1,
     *            1,1,1,
     *            0,1,1,
     *            0,0,0,
     *            1,0,0,
     *            1,1,0,
     *            0,1,0/
      data    ((ipt(i,j,1,0,1),i=1,3),j=1,8)/
     *            1,0,1,
     *            0,0,1,
     *            0,1,1,
     *            1,1,1,
     *            1,0,0,
     *            0,0,0,
     *            0,1,0,
     *            1,1,0/
      data    ((ipt(i,j,0,1,1),i=1,3),j=1,8)/
     *            0,1,1,
     *            1,1,1,
     *            1,0,1,
     *            0,0,1,
     *            0,1,0,
     *            1,1,0,
     *            1,0,0,
     *            0,0,0/
      data    ((ipt(i,j,1,1,1),i=1,3),j=1,8)/
     *            1,1,1,
     *            0,1,1,
     *            0,0,1,
     *            1,0,1,
     *            1,1,0,
     *            0,1,0,
     *            0,0,0,
     *            1,0,0/
c
c  ite(*,i) stores the six edges of tetrahedron i
c
      integer ite(6,5)
      data    ite/ 1,    5,   4,     6,   10,   12,
     *             2,    3,   5,    11,    8,   13,
     *            18,   16,   17,   12,   13,    9,
     *            14,   15,   18,   10,    7,   11,
     *            12,   18,   13,    5,   10,   11/
c
c  itp(*,i) stores the four corners of tetrahedron i
c
      integer itp(4,5)
      data    itp/ 1,2,4,5,
     *             2,3,4,7,
     *             4,5,7,8,
     *             5,6,7,2,
     *             2,4,5,7/

      logical degenerate
      integer ired(100),igrn(100),iblu(100)
      integer iered(100),iegrn(100),ieblu(100)
      character*15 string
c
c  For this cell make table of corner values
c
      x0=xl
      y0=yl
      z0=zl
      xscl=(xr-xl)/nx
      yscl=(yr-yl)/ny
      zscl=(zr-zl)/nz

      npols=0
      ncells=0

      vmin=v(1)
      vmax=v(1)
      do 340 il=1,nl
         if(volume)then
            area(il)=0.d0
            vol (il)=0.d0
         endif
         vmax=max(vmax,v(il))
         vmin=min(vmin,v(il))
  340 continue
      totvol=0.d0
      ivols=0

      nmins=0
      nmaxs=0
      ifz=1
      do 10 iz=1,nz
       ifz=mod(ifz+1,2)
       ify=1
       do 9 iy=1,ny
        ify=mod(ify+1,2)
        ifx=1
        do 8 ix=1,nx
         ifx=mod(ifx+1,2)
         totvol=totvol+xscl*yscl*zscl
         ivols=ivols+1

         smaxcube=s(ix-1,iy-1,iz-1)
         smincube=s(ix-1,iy-1,iz-1)
         do 651 ic=1,8
            st=s(ix-1+ipt(1,ic,ifx,ify,ifz),
     *           iy-1+ipt(2,ic,ifx,ify,ifz),
     *           iz-1+ipt(3,ic,ifx,ify,ifz))
            smaxcube=max(smaxcube,st)
            smincube=min(smincube,st)
  651    continue

c Check if max of all levels is less than min over cube
c    or if min of all levels is greater than max over cube

         idiscard1=0
         if(vmax.lt.smincube)idiscard1=1
         if(vmin.gt.smaxcube)then
            if(volume)then
               do 938 il=1,nl
                  vol(il)=vol(il)+1.d0*xscl*yscl*zscl
  938          continue
            endif
            idiscard1=2
         endif
         if(idiscard1.ne.0)go to 8

         do 652 ic=1,8
            ix0=ix-1+ipt(1,ic,ifx,ify,ifz)
            iy0=iy-1+ipt(2,ic,ifx,ify,ifz)
            iz0=iz-1+ipt(3,ic,ifx,ify,ifz)
            nrmx(ic)=(s(ix0+1,iy0,iz0)-s(ix0-1,iy0,iz0))*(nx-1)
            nrmy(ic)=(s(ix0,iy0+1,iz0)-s(ix0,iy0-1,iz0))*(ny-1)
            nrmz(ic)=(s(ix0,iy0,iz0+1)-s(ix0,iy0,iz0-1))*(nz-1)
            d=sqrt(nrmx(ic)**2+nrmy(ic)**2+nrmz(ic)**2)
            if(d.gt.1.d-7)then
               d=1./d
               nrmx(ic)=nrmx(ic)*d
               nrmy(ic)=nrmy(ic)*d
               nrmz(ic)=nrmz(ic)*d
            else
               d=1.
               nrmx(ic)=1.
               nrmy(ic)=0.
               nrmz(ic)=0.
            endif
  652    continue

         gx=.125*(nrmx(1)+nrmx(2)+nrmx(3)+nrmx(4)
     *           +nrmx(5)+nrmx(6)+nrmx(7)+nrmx(8))
         gy=.125*(nrmy(1)+nrmy(2)+nrmy(3)+nrmy(4)
     *           +nrmy(5)+nrmy(6)+nrmy(7)+nrmy(8))
         gz=.125*(nrmz(1)+nrmz(2)+nrmz(3)+nrmz(4)
     *           +nrmz(5)+nrmz(6)+nrmz(7)+nrmz(8))
         d=gx**2+gy**2+gz**2
         if(d.lt.1.e-7)go to 44


         do 1 ie=1,18
          s0(ie)=s(ix-1+ipt(1,iedge(1,ie),ifx,ify,ifz),
     *             iy-1+ipt(2,iedge(1,ie),ifx,ify,ifz),
     *             iz-1+ipt(3,iedge(1,ie),ifx,ify,ifz))
          s1(ie)=s(ix-1+ipt(1,iedge(2,ie),ifx,ify,ifz),
     *             iy-1+ipt(2,iedge(2,ie),ifx,ify,ifz),
     *             iz-1+ipt(3,iedge(2,ie),ifx,ify,ifz))
    1    continue
c
c  Loop over each level
c
         do 4 il=1,nl
            call shpgc(ired(il),igrn(il),iblu(il))
            call shpec(iered(il),iegrn(il),ieblu(il))
            call shbgc(ired(il),igrn(il),iblu(il))
            call shbec(iered(il),iegrn(il),ieblu(il))
            call shlinc(iered(il),iegrn(il),ieblu(il))

c
c  Quick Discard of all tetrahedra
c
c Check if max of this level is less than min over cube
c    or if min of this level is greater than smax over cube
            idiscard2=0
            if(v(il).lt.smincube)idiscard2=1
            if(v(il).gt.smaxcube)then
               vol(il)=vol(il)+1.d0*xscl*yscl*zscl
               idiscard2=2
            endif
            if(idiscard2.ne.0)go to 4
c
c     Loop over each tetrahedron
c
          do 3 it=1,5
c can do this with s0() and s1()
            ss1=s(ix-1+ipt(1,itp(1,it),ifx,ify,ifz),
     *            iy-1+ipt(2,itp(1,it),ifx,ify,ifz),
     *            iz-1+ipt(3,itp(1,it),ifx,ify,ifz))
            ss2=s(ix-1+ipt(1,itp(2,it),ifx,ify,ifz),
     *            iy-1+ipt(2,itp(2,it),ifx,ify,ifz),
     *            iz-1+ipt(3,itp(2,it),ifx,ify,ifz))
            ss3=s(ix-1+ipt(1,itp(3,it),ifx,ify,ifz),
     *            iy-1+ipt(2,itp(3,it),ifx,ify,ifz),
     *            iz-1+ipt(3,itp(3,it),ifx,ify,ifz))
            ss4=s(ix-1+ipt(1,itp(4,it),ifx,ify,ifz),
     *            iy-1+ipt(2,itp(4,it),ifx,ify,ifz),
     *            iz-1+ipt(3,itp(4,it),ifx,ify,ifz))
            smax=max(ss1,ss2,ss3,ss4)
            smin=min(ss1,ss2,ss3,ss4)

c Check if max of this level is less than min over tetrahedron
c    or if min of this level is greater than smax over tetrahedron

            idiscard3=0
            if(v(il).lt.smin)idiscard3=1
            if(v(il).gt.smax)then
               if(volume)then
                  x1=x0+(ix-1+ipt(1,itp(1,it),ifx,ify,ifz))*xscl
                  y1=y0+(iy-1+ipt(2,itp(1,it),ifx,ify,ifz))*yscl
                  z1=z0+(iz-1+ipt(3,itp(1,it),ifx,ify,ifz))*zscl
                  x2=x0+(ix-1+ipt(1,itp(2,it),ifx,ify,ifz))*xscl
                  y2=y0+(iy-1+ipt(2,itp(2,it),ifx,ify,ifz))*yscl
                  z2=z0+(iz-1+ipt(3,itp(2,it),ifx,ify,ifz))*zscl
                  x3=x0+(ix-1+ipt(1,itp(3,it),ifx,ify,ifz))*xscl
                  y3=y0+(iy-1+ipt(2,itp(3,it),ifx,ify,ifz))*yscl
                  z3=z0+(iz-1+ipt(3,itp(3,it),ifx,ify,ifz))*zscl
                  x4=x0+(ix-1+ipt(1,itp(4,it),ifx,ify,ifz))*xscl
                  y4=y0+(iy-1+ipt(2,itp(4,it),ifx,ify,ifz))*yscl
                  z4=z0+(iz-1+ipt(3,itp(4,it),ifx,ify,ifz))*zscl

                  vol(il)=vol(il)+
     *                TetraVolume(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4)
               endif
               idiscard3=2
            endif
            if(idiscard3.ne.0)go to 3

            degenerate=.false.
            n=0
            if(volume)then
               x1=x0+(ix-1+ipt(1,itp(1,it),ifx,ify,ifz))*xscl
               y1=y0+(iy-1+ipt(2,itp(1,it),ifx,ify,ifz))*yscl
               z1=z0+(iz-1+ipt(3,itp(1,it),ifx,ify,ifz))*zscl
               x2=x0+(ix-1+ipt(1,itp(2,it),ifx,ify,ifz))*xscl
               y2=y0+(iy-1+ipt(2,itp(2,it),ifx,ify,ifz))*yscl
               z2=z0+(iz-1+ipt(3,itp(2,it),ifx,ify,ifz))*zscl
               x3=x0+(ix-1+ipt(1,itp(3,it),ifx,ify,ifz))*xscl
               y3=y0+(iy-1+ipt(2,itp(3,it),ifx,ify,ifz))*yscl
               z3=z0+(iz-1+ipt(3,itp(3,it),ifx,ify,ifz))*zscl
               x4=x0+(ix-1+ipt(1,itp(4,it),ifx,ify,ifz))*xscl
               y4=y0+(iy-1+ipt(2,itp(4,it),ifx,ify,ifz))*yscl
               z4=z0+(iz-1+ipt(3,itp(4,it),ifx,ify,ifz))*zscl

               tetvol=TetraVolume(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4)
            endif
c
c        Loop over each edge of tetrahedron, computing crossings
c
            do 2 k=1,6
               ie=ite(k,it)
               if(abs(s1(ie)-s0(ie)).gt.1.e-7)then
                  t=(v(il)-s0(ie))/(s1(ie)-s0(ie))
                  if(abs(t-.5).le..5)then
                     if(abs(t).lt..01)degenerate=.true.
                     if(abs(t-1.).lt..01)degenerate=.true.
                     n=n+1
                     ic1=iedge(1,ie)
                     ic2=iedge(2,ie)
                     xx=ix-1+(1.-t)*ipt(1,ic1,ifx,ify,ifz)
     *                          +t *ipt(1,ic2,ifx,ify,ifz)
                     yy=iy-1+(1.-t)*ipt(2,ic1,ifx,ify,ifz)
     *                          +t *ipt(2,ic2,ifx,ify,ifz)
                     zz=iz-1+(1.-t)*ipt(3,ic1,ifx,ify,ifz)
     *                          +t *ipt(3,ic2,ifx,ify,ifz)
                     x(n)=x0+xscl*xx
                     y(n)=y0+yscl*yy
                     z(n)=z0+zscl*zz
                     nrm(1,n)=(1.-t)*nrmx(ic1)+t*nrmx(ic2)
                     nrm(2,n)=(1.-t)*nrmy(ic1)+t*nrmy(ic2)
                     nrm(3,n)=(1.-t)*nrmz(ic1)+t*nrmz(ic2)
                     iflag(n)=0
                  endif
               else
                  if(abs(s0(ie)-v(il)).lt.1.e-7)then
                     degenerate=.true.
                     n=n+1
                     ic1=iedge(1,ie)
                     ic2=iedge(2,ie)
                     xx=ix-1+ipt(1,ic1,ifx,ify,ifz)
                     yy=iy-1+ipt(2,ic1,ifx,ify,ifz)
                     zz=iz-1+ipt(3,ic1,ifx,ify,ifz)
                     x(n)=x0+xscl*xx
                     y(n)=y0+yscl*yy
                     z(n)=z0+zscl*zz
                     nrm(1,n)=nrmx(ic1)
                     nrm(2,n)=nrmy(ic1)
                     nrm(3,n)=nrmz(ic1)
                     iflag(n)=0

                     n=n+1
                     xx=ix-1+ipt(1,ic2,ifx,ify,ifz)
                     yy=iy-1+ipt(2,ic2,ifx,ify,ifz)
                     zz=iz-1+ipt(3,ic2,ifx,ify,ifz)
                     x(n)=x0+xscl*xx
                     y(n)=y0+yscl*yy
                     z(n)=z0+zscl*zz
                     nrm(1,n)=nrmx(ic2)
                     nrm(2,n)=nrmy(ic2)
                     nrm(3,n)=nrmz(ic2)
                     iflag(n)=0
                  endif
               endif
    2       continue
c
c        Process crossings
c

            if(degenerate)then
c
c           Remove duplicates
c
               do 6 i1=1,n-1
                  if(iflag(i1).eq.0)then
                     do 5 i2=i1+1,n
                        if(abs(x(i1)-x(i2))+abs(y(i1)-y(i2))+
     *                     abs(z(i1)-z(i2)).lt.3.e-5)then
                           iflag(i2)=1
                        endif
    5                continue
                  endif
    6          continue
               ito=0
               do 7 i1=1,n
                  if(iflag(i1).eq.0)then
                    ito=ito+1
                    x(ito)=x(i1)
                    y(ito)=y(i1)
                    z(ito)=z(i1)
                    nrm(1,ito)=nrm(1,i1)
                    nrm(2,ito)=nrm(2,i1)
                    nrm(3,ito)=nrm(3,i1)
                    iflag(ito)=iflag(i1)
                  endif
    7          continue
               n=ito
            endif
c
c        If there are three it's simple
c
            idiscard=idiscard1+idiscard2+idiscard3

            if(n.eq.3)then
               if( gx*((y(2)-y(1))*(z(3)-z(1))-(y(3)-y(1))*(z(2)-z(1)))
     *           + gy*((x(2)-x(1))*(z(3)-z(1))-(x(3)-x(1))*(z(2)-z(1)))
     *           + gz*((x(2)-x(1))*(y(3)-y(1))-(x(3)-x(1))*(y(2)-y(1)))
     *              .gt.0.)then
                 t=x(2)
                 x(2)=x(3)
                 x(3)=t
                 t=y(2)
                 y(2)=y(3)
                 y(3)=t
                 t=z(2)
                 z(2)=z(3)
                 z(3)=t
                 t=nrm(1,2)
                 nrm(1,2)=nrm(1,3)
                 nrm(1,3)=t
                 t=nrm(2,2)
                 nrm(2,2)=nrm(2,3)
                 nrm(2,3)=t
                 t=nrm(3,2)
                 nrm(3,2)=nrm(3,3)
                 nrm(3,3)=t
               endif
               if(contour)then
c                 call shpgnrm(3,x,y,z,nrm)
                  call shpg(3,x,y,z)
                  ntri=ntri+1
                  call shlnonrm(x(1),y(1),z(1),nrm(1,1),
     *                          x(2),y(2),z(2),nrm(1,2),0,0,1)
                  call shlnonrm(x(2),y(2),z(2),nrm(1,2),
     *                          x(3),y(3),z(3),nrm(1,3),0,0,1)
                  call shlnonrm(x(3),y(3),z(3),nrm(1,3),
     *                          x(1),y(1),z(1),nrm(1,1),0,0,1)

                  npols=npols+1
               endif
               if(volume)then
                  area(il)=area(il)+TriangleArea(x(1),y(1),z(1),
     *                                   x(2),y(2),z(2),x(3),y(3),z(3))
                  f1=gx*(x1-x(1))+gy*(y1-y(1))+gz*(z1-z(1))
                  f2=gx*(x2-x(1))+gy*(y2-y(1))+gz*(z2-z(1))
                  f3=gx*(x3-x(1))+gy*(y3-y(1))+gz*(z3-z(1))
                  f4=gx*(x4-x(1))+gy*(y4-y(1))+gz*(z4-z(1))
                  if1=1
                  if(f1.lt.0.)if1=-1
                  if2=1
                  if(f2.lt.0.)if2=-1
                  if3=1
                  if(f3.lt.0.)if3=-1
                  if4=1
                  if(f4.lt.0.)if4=-1

                  if(if1.ne.if2.and.if1.ne.if3.and.if1.ne.if4)then
                     thisvol=TetraVolume(x1  ,y1  ,z1  ,x(1),y(1),z(1),
     *                                x(2),y(2),z(2),x(3),y(3),z(3))
                     if(if1.lt.0)thisvol=tetvol-thisvol
                     iii=1
                  endif

                  if(if2.ne.if1.and.if2.ne.if3.and.if2.ne.if4)then
                  thisvol=TetraVolume(x2  ,y2  ,z2  ,x(1),y(1),z(1),
     *                                x(2),y(2),z(2),x(3),y(3),z(3))
                     if(if2.lt.0)thisvol=tetvol-thisvol
                     iii=2
                  endif

                  if(if3.ne.if1.and.if3.ne.if2.and.if3.ne.if4)then
                     thisvol=TetraVolume(x3  ,y3  ,z3  ,x(1),y(1),z(1),
     *                                   x(2),y(2),z(2),x(3),y(3),z(3))
                     if(if3.lt.0)thisvol=tetvol-thisvol
                     iii=3
                  endif

                  if(if4.ne.if1.and.if4.ne.if2.and.if4.ne.if3)then
                     thisvol=TetraVolume(x4  ,y4  ,z4  ,x(1),y(1),z(1),
     *                                   x(2),y(2),z(2),x(3),y(3),z(3))
                     if(if4.lt.0)thisvol=tetvol-thisvol
                     iii=4
                  endif

                  if(thisvol.lt.0.)then
                     write(6,*)' tricon -- Severe error:'
                     write(6,*)'               volume of cell negative!'
                     write(6,*)'              ',ix,iy,iz
                     write(6,*)' corner 1     ',x(1),y(1),z(1)
                     write(6,*)' corner 2     ',x(2),y(2),z(2)
                     write(6,*)' corner 3     ',x(3),y(3),z(3)
                     write(6,*)' extra corner ',iii
                 if(iii.eq.1)write(6,*)'              ',x1,y1,z1
                 if(iii.eq.2)write(6,*)'              ',x2,y2,z2
                 if(iii.eq.3)write(6,*)'              ',x3,y3,z3
                 if(iii.eq.4)write(6,*)'              ',x4,y4,z4
                  endif
                  vol(il)=vol(il)+thisvol
               endif
            endif
c
c        If there are four there are two cases
c
            if(n.eq.4)then
               a=(x(2)-x(1))*
     *                ((y(3)-y(1))*(z(4)-z(1))-(y(4)-y(1))*(z(3)-z(1)))
     *          -(y(2)-y(1))*
     *                ((x(3)-x(1))*(z(4)-z(1))-(x(4)-x(1))*(z(3)-z(1)))
     *          +(z(2)-z(1))*
     *                ((x(3)-x(1))*(y(4)-y(1))-(x(4)-x(1))*(y(3)-y(1)))
c
c             Not coplanar points, plot faces of tetrahedron
c
               if(abs(a).gt.1.e-3)then
                  if(contour)then
c                    call shpgnrm(3,x(1),y(1),z(1),nrm(1,1))
c                    call shpgnrm(3,x(2),y(2),z(2),nrm(1,2))
                     call shpg(3,x(1),y(1),z(1))
                     call shpg(3,x(2),y(2),z(2))
                     tt=x(4)
                     x(4)=x(3)
                     x(3)=tt
                     tt=y(4)
                     y(4)=y(3)
                     y(3)=tt
                     tt=z(4)
                     z(4)=z(3)
                     z(3)=tt
                     tt=nrm(1,4)
                     nrm(1,4)=nrm(1,3)
                     nrm(1,3)=tt
                     tt=nrm(2,4)
                     nrm(2,4)=nrm(2,3)
                     nrm(2,3)=tt
                     tt=nrm(3,4)
                     nrm(3,4)=nrm(3,3)
                     nrm(3,3)=tt
c                    call shpgnrm(3,x(1),y(1),z(1),nrm(1,1))
c                    call shpgnrm(3,x(2),y(2),z(2),nrm(1,2))
                     call shpg(3,x(1),y(1),z(1))
                     call shpg(3,x(2),y(2),z(2))
                     npols=npols+4
                  endif
                  if(volume)then
                     area(il)=area(il)
     *                     +TriangleArea(x(1),y(1),z(1),x(2),y(2),z(2),
     *                                                  x(3),y(3),z(3))
                     area(il)=area(il)
     *                     +TriangleArea(x(1),y(1),z(1),x(3),y(3),z(3),
     *                                                  x(4),y(4),z(4))
                     area(il)=area(il)
     *                     +TriangleArea(x(1),y(1),z(1),x(2),y(2),z(2),
     *                                                  x(4),y(4),z(4))
                     area(il)=area(il)
     *                     +TriangleArea(x(2),y(2),z(2),x(3),y(3),z(3),
     *                                                  x(4),y(4),z(4))

                     if(tetvol.lt.0.)then
                        write(6,*)' tricon -- Severe error:'
                        write(6,*)'            volume of cell negative!'
                        write(6,*)'            whole tetrahedron'
                        write(6,*)'              ',ix,iy,iz
                     endif
                     vol(il)=vol(il)+tetvol
                  endif
               else
c
c             Coplanar points, reorder and draw
c
                  a23a34=
     *                ((y(3)-y(1))*(z(4)-z(1))-(y(4)-y(1))*(z(3)-z(1)))*
     *                ((y(2)-y(1))*(z(3)-z(1))-(y(3)-y(1))*(z(2)-z(1)))
     *               +((x(3)-x(1))*(z(4)-z(1))-(x(4)-x(1))*(z(3)-z(1)))*
     *                ((x(2)-x(1))*(z(3)-z(1))-(x(3)-x(1))*(z(2)-z(1)))
     *               +((x(3)-x(1))*(y(4)-y(1))-(x(4)-x(1))*(y(3)-y(1)))*
     *                ((x(2)-x(1))*(y(3)-y(1))-(x(3)-x(1))*(y(2)-y(1)))

                  if(a23a34.lt.0.)then
                     tt=x(4)
                     x(4)=x(3)
                     x(3)=tt
                     tt=y(4)
                     y(4)=y(3)
                     y(3)=tt
                     tt=z(4)
                     z(4)=z(3)
                     z(3)=tt
                     tt=nrm(1,4)
                     nrm(1,4)=nrm(1,3)
                     nrm(1,3)=tt
                     tt=nrm(2,4)
                     nrm(2,4)=nrm(2,3)
                     nrm(2,3)=tt
                     tt=nrm(3,4)
                     nrm(3,4)=nrm(3,3)
                     nrm(3,3)=tt
                  endif
                  if( gx*((y(2)-y(1))*(z(3)-z(1))
     *                   -(y(3)-y(1))*(z(2)-z(1)))
     *              + gy*((x(2)-x(1))*(z(3)-z(1))
     *                   -(x(3)-x(1))*(z(2)-z(1)))
     *              + gz*((x(2)-x(1))*(y(3)-y(1))
     *                   -(x(3)-x(1))*(y(2)-y(1)))
     *                                             .gt.0.)then
                     t=x(2)
                     x(2)=x(4)
                     x(4)=t
                     t=y(2)
                     y(2)=y(4)
                     y(4)=t
                     t=z(2)
                     z(2)=z(4)
                     z(4)=t
                     tt=nrm(1,4)
                     nrm(1,4)=nrm(1,2)
                     nrm(1,2)=tt
                     tt=nrm(2,4)
                     nrm(2,4)=nrm(2,2)
                     nrm(2,2)=tt
                     tt=nrm(3,4)
                     nrm(3,4)=nrm(3,2)
                     nrm(3,2)=tt
                  endif
                  if(contour)then
c                    call shpgnrm(4,x,y,z,nrm)   !c3
                  ntri=ntri+1
                     call shpg(4,x,y,z)
                     call shlnonrm(x(1),y(1),z(1),nrm(1,1),
     *                             x(2),y(2),z(2),nrm(1,2),0,0,1)
                     call shlnonrm(x(2),y(2),z(2),nrm(1,2),
     *                             x(3),y(3),z(3),nrm(1,3),0,0,1)
                     call shlnonrm(x(3),y(3),z(3),nrm(1,3),
     *                             x(4),y(4),z(4),nrm(1,4),0,0,1)
                     call shlnonrm(x(4),y(4),z(4),nrm(1,4),
     *                             x(1),y(1),z(1),nrm(1,1),0,0,1)
                     npols=npols+1
                  endif
                  if(volume)then
                     area(il)=area(il)
     *                     +SquareArea(x(1),y(1),z(1),x(2),y(2),z(2),
     *                                 x(3),y(3),z(3),x(4),y(4),z(4))
                     f1=gx*(x1-x(1))+gy*(y1-y(1))+gz*(z1-z(1))
                     f2=gx*(x2-x(1))+gy*(y2-y(1))+gz*(z2-z(1))
                     f3=gx*(x3-x(1))+gy*(y3-y(1))+gz*(z3-z(1))
                     f4=gx*(x4-x(1))+gy*(y4-y(1))+gz*(z4-z(1))
                     if1=1
                     if(f1.lt.0.)if1=-1
                     if2=1
                     if(f2.lt.0.)if2=-1
                     if3=1
                     if(f3.lt.0.)if3=-1
                     if4=1
                     if(f4.lt.0.)if4=-1

                     thisvol=0.d0
                     if(if1.eq.if2)then
c                      thisvol=TentVolume(x(1),y(1),z(1),x(2),y(2),z(2),
c    *                                    x(3),y(3),z(3),x(4),y(4),z(4),
c    *                                    x1  ,y1  ,z1  ,x2  ,y2  ,z2  )
                       tentvol=thisvol
                       if(if1.lt.0)thisvol=tetvol-thisvol
                       iii=1
                       jjj=2
                     endif
                     if(if1.eq.if3)then
c                      thisvol=TentVolume(x(1),y(1),z(1),x(2),y(2),z(2),
c    *                                    x(3),y(3),z(3),x(4),y(4),z(4),
c    *                                    x1  ,y1  ,z1  ,x3  ,y3  ,z3  )
                       tentvol=thisvol
                       if(if1.lt.0)thisvol=tetvol-thisvol
                       iii=1
                       jjj=3
                     endif
                     if(if1.eq.if4)then
c                      thisvol=TentVolume(x(1),y(1),z(1),x(2),y(2),z(2),
c    *                                    x(3),y(3),z(3),x(4),y(4),z(4),
c    *                                    x1  ,y1  ,z1  ,x4  ,y4  ,z4  )
                       tentvol=thisvol
                       if(if1.lt.0)thisvol=tetvol-thisvol
                       iii=1
                       jjj=4
                     endif

                     if(thisvol.lt.0.)then
                        write(6,*)' tricon -- Severe error:'
                        write(6,*)'            volume of cell negative!'
                        write(6,*)'            Tent'
                        write(6,*)'            tetvol',tetvol
                        write(6,*)'            tentvol',tentvol
                        write(6,*)'            thisvol',thisvol
                        write(6,*)'            if1 ',if1
                        write(6,*)'           ',ix,iy,iz
                     write(6,*)'Tetrahedron:'
                     write(6,*)' corner 1     ',x1,y1,z1
                     write(6,*)' corner 2     ',x2,y2,z2
                     write(6,*)' corner 3     ',x3,y3,z3
                     write(6,*)' corner 4     ',x4,y4,z4
                     write(6,*)'Tent:    '
                     write(6,*)' corner 1     ',x(1),y(1),z(1)
                     write(6,*)' corner 2     ',x(2),y(2),z(2)
                     write(6,*)' corner 3     ',x(3),y(3),z(3)
                     write(6,*)' corner 4     ',x(4),y(4),z(4)
                     write(6,*)' extra corner ',iii,jjj
                 if(iii.eq.1)write(6,*)'              ',x1,y1,z1
                 if(iii.eq.2)write(6,*)'              ',x2,y2,z2
                 if(iii.eq.3)write(6,*)'              ',x3,y3,z3
                 if(iii.eq.4)write(6,*)'              ',x4,y4,z4
                 if(jjj.eq.1)write(6,*)'              ',x1,y1,z1
                 if(jjj.eq.2)write(6,*)'              ',x2,y2,z2
                 if(jjj.eq.3)write(6,*)'              ',x3,y3,z3
                 if(jjj.eq.4)write(6,*)'              ',x4,y4,z4
                     endif
                     vol(il)=vol(il)+thisvol
                  endif
               endif
            endif
    3     continue
    4    continue
   44    continue
         ncells=ncells+1
    8   continue
    9  continue
   10 continue
      write(6,*)'ntri=',ntri
      return
      end



      function TriangleArea(x1,y1,z1,x2,y2,z2,x3,y3,z3)
      real*8 TriangleArea
      TriangleArea=.5d0*sqrt(
     *              ((y2-y1)*(z3-z1)-(y3-y1)*(z2-z1))**2
     *             +((z2-z1)*(x3-x1)-(z3-z1)*(x2-x1))**2
     *             +((x2-x1)*(y3-y1)-(x3-x1)*(y2-y1))**2
     *                       )
      return
      end



      function SquareArea(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4)
      real*8 SquareArea,TriangleArea
      SquareArea=TriangleArea(x1,y1,z1,x2,y2,z2,x3,y3,z3)
     *          +TriangleArea(x1,y1,z1,x3,y3,z3,x4,y4,z4)
      return
      end



      function TetraVolume(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4)
      real*8 TetraVolume,TriangleArea,b,x,y,k,d
      b=TriangleArea(x1,y1,z1,x2,y2,z2,x3,y3,z3)
      x=1.d0*(y3-y1)*(z2-z1)-(y2-y1)*(z3-z1)
      y=1.d0*(z3-z1)*(x2-x1)-(z2-z1)*(x3-x1)
      z=1.d0*(x3-x1)*(y2-y1)-(x2-x1)*(y3-y1)
      d=sqrt(x**2+y**2+z**2)
      if(d.eq.0.d0)then
         write(6,*)' error in TetraVolume, base is zero'
         write(6,*)'         ',x1,y1,z1
         write(6,*)'         ',x2,y2,z2
         write(6,*)'         ',x3,y3,z3
         TetraVolume=0.
         return
      endif
      h=abs((x4-x1)*x+(y4-y1)*y+(z4-z1)*z)/d
      TetraVolume=b*h/3.
      return
      end



      function TentVolume(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,
     *                    x5,y5,z5,x6,y6,z6)
      real*8 TentVolume,TetraVolume,abs56,abs12,abs14
      real*8 dot5612,dot5614
c
c Warning! (1,2,3,4) is assumed to be the base and coplanar!,
c     (5->6) must not cross (1,2,3,4)!
c
      TentVolume=0.d0
      abs56=sqrt(1.d0*(x6-x5)*(x6-x5)+(y6-y5)*(y6-y5)+(z6-z5)*(z6-z5))
      abs12=sqrt(1.d0*(x2-x1)*(x2-x1)+(y2-y1)*(y2-y1)+(z2-z1)*(z2-z1))
      abs14=sqrt(1.d0*(x4-x1)*(x4-x1)+(y4-y1)*(y4-y1)+(z4-z1)*(z4-z1))
      if(abs12.eq.0.d0)then
          write(6,*)' error in TentVolume 1=2 '
          write(6,*)' 1 ',x1,y1,z1
          write(6,*)' 2 ',x2,y2,z2
          write(6,*)' 3 ',x3,y3,z3
          write(6,*)' 4 ',x4,y4,z4
          write(6,*)' 5 ',x5,y5,z5
          write(6,*)' 6 ',x6,y6,z6
          return
      endif
      if(abs14.eq.0.d0)then
          write(6,*)' error in TentVolume 1=4 '
          write(6,*)' 1 ',x1,y1,z1
          write(6,*)' 2 ',x2,y2,z2
          write(6,*)' 3 ',x3,y3,z3
          write(6,*)' 4 ',x4,y4,z4
          write(6,*)' 5 ',x5,y5,z5
          write(6,*)' 6 ',x6,y6,z6
          return
      endif
      if(abs56.eq.0.d0)then
          write(6,*)' error in TentVolume 5=6 '
          write(6,*)' 1 ',x1,y1,z1
          write(6,*)' 2 ',x2,y2,z2
          write(6,*)' 3 ',x3,y3,z3
          write(6,*)' 4 ',x4,y4,z4
          write(6,*)' 5 ',x5,y5,z5
          write(6,*)' 6 ',x6,y6,z6
          return
      endif
      abs12=1.d0/abs12
      abs14=1.d0/abs14
      abs56=1.d0/abs56
      dot5612=(1.d0*(x6-x5)*(x2-x1)+(y6-y5)*(y2-y1)+(z6-z5)*(z2-z1))
     *   *abs56*abs12
      dot5614=(1.d0*(x6-x5)*(x4-x1)+(y6-y5)*(y4-y1)+(z6-z5)*(z4-z1))
     *   *abs56*abs14
      if(abs(dot5612).gt.abs(dot5614))then
         if(dot5612.gt.0)then
            TentVolume=TetraVolume(x1,y1,z1,x2,y2,z2,x4,y4,z4,x5,y5,z5)
     *                +TetraVolume(x2,y2,z2,x4,y4,z4,x5,y5,z5,x6,y6,z6)
     *                +TetraVolume(x2,y2,z2,x3,y3,z3,x4,y4,z4,x6,y6,z6)
         else
            TentVolume=TetraVolume(x1,y1,z1,x2,y2,z2,x4,y4,z4,x6,y6,z6)
     *                +TetraVolume(x2,y2,z2,x4,y4,z4,x6,y6,z6,x5,y5,z5)
     *                +TetraVolume(x2,y2,z2,x3,y3,z3,x4,y4,z4,x5,y5,z5)
         endif
      else
         if(dot5614.gt.0)then
            TentVolume=TetraVolume(x1,y1,z1,x2,y2,z2,x4,y4,z4,x5,y5,z5)
     *                +TetraVolume(x2,y2,z2,x4,y4,z4,x5,y5,z5,x6,y6,z6)
     *                +TetraVolume(x2,y2,z2,x3,y3,z3,x4,y4,z4,x6,y6,z6)
         else
            TentVolume=TetraVolume(x1,y1,z1,x2,y2,z2,x4,y4,z4,x6,y6,z6)
     *                +TetraVolume(x2,y2,z2,x4,y4,z4,x6,y6,z6,x5,y5,z5)
     *                +TetraVolume(x2,y2,z2,x3,y3,z3,x4,y4,z4,x5,y5,z5)
         endif
      endif
      return
      end



      subroutine ProcessExtrema(n,extrema,flag,nx,ny,nz)
      real extrema(3,n)
      real dx,dy,dz
      integer flag(n)

      dx=6.28/nx
      dy=6.28/ny
      dz=6.28/nz

      do 1 i=1,n
         flag(i)=0
    1 continue
c
c  flag=1 in "true" set
c       0     discarded
c
      do 3 i=1,n
c
c        is this point near any points in the "true" set?
c
         inear=0
         do 2 j=1,n
            if(flag(j).eq.0.or.i.eq.j)go to 2
            rdx=abs(extrema(1,i)-extrema(1,j))
            rdx=min(rdx,6.28-rdx)
            rdy=abs(extrema(2,i)-extrema(2,j))
            rdy=min(rdy,6.28-rdy)
            rdz=abs(extrema(3,i)-extrema(3,j))
            rdz=min(rdz,6.28-rdz)

            if(max(rdx,rdy,rdz).le.dx)inear=1
    2    continue
c
c        if it is not, add it to the "true" set
c
         if(inear.eq.0)flag(i)=1
    3 continue
c
c     Now compress the set
c
      ntrue=0
      do 4 i=1,n
         if(flag(i).eq.1)then
            ntrue=ntrue+1
            extrema(1,ntrue)=extrema(1,i)
            extrema(2,ntrue)=extrema(2,i)
            extrema(3,ntrue)=extrema(3,i)
         endif
    4 continue
      n=ntrue

      return
      end
