/*
 *  PROGRAM NAME:  multifario
 *
 *  (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
 *  CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
 *
 *  Please refer to the LICENSE file in the top directory
 *
 *      author: Mike Henderson mhender@watson.ibm.com
 */

static char *id="@(#) $Id: MFListOfCharts.c 257 2006-08-30 20:30:07Z mhender $";

static char MFListOfChartsErrorMsg[256]="";

#include <MFListOfCharts.h>
#include <stdio.h>
#include <stdlib.h>

struct MFListOfChartsSt {
                       int n;
                       int *charts;
                      };

MFListOfCharts MFCreateListOfCharts(int n,int *charts, MFErrorHandler e)
 {
  static char RoutineName[]={"MFCreateListOfCharts"};
  MFListOfCharts this;
  int i,j,k;

  this=malloc(sizeof(struct MFListOfChartsSt));

#ifndef MFNOSAFETYNET
  if(this==NULL)
   {
    sprintf(MFListOfChartsErrorMsg,"Out of memory, trying to allocate %d bytes",sizeof(struct MFListOfChartsSt));
    MFSetError(e,12,RoutineName,MFListOfChartsErrorMsg,__LINE__,__FILE__);
    return NULL;
   }
#endif

  this->n=n;
  this->charts=charts;

  for(i=0;i<n-1;i++)
   for(j=i+1;j<n;j++)
    {
     if(this->charts[i]>this->charts[j])
      {
       k=this->charts[j];
       this->charts[j]=this->charts[i];
       this->charts[i]=k;
      }
    }

  return this;
 }

int MFNumberOfIntersectingCharts(MFListOfCharts L, MFErrorHandler r)
 {
  static char RoutineName[]={"MFNumberOfIntersectingCharts"};

  return L->n;
 }

int MFIntersectingChart(MFListOfCharts L,int chart, MFErrorHandler r)
 {
  static char RoutineName[]={"MFIntersectingChart"};

  return L->charts[chart];
 }

void MFFreeListOfIntersectingCharts(MFListOfCharts L, MFErrorHandler e)
 {
  static char RoutineName[]={"MFFreeListOfIntersectingCharts"};

  if(L->charts!=NULL)free(L->charts);
  free(L);

  return;
 }
