/*
 *  PROGRAM NAME:  multifario
 *
 *  (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
 *  CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
 *
 *  Please refer to the LICENSE file in the top directory
 *
 *      author: Mike Henderson mhender@watson.ibm.com
 *      date:   April 21, 2002
 */

#include <MFNSpace.h>
#include <MFNVector.h>
#include <MFErrorHandler.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <MFTime.h>

static char *id="@(#) $Id: MFLOCANSpace.c 257 2006-08-30 20:30:07Z mhender $";

void MFSetError(int,char*,char*,int,char*);
static char MFLOCANSpaceErrorMsg[256]="";

double MFLOCANSpaceDistance(MFNSpace,MFNVector,MFNVector,void*);
void MFLOCANSpaceDirection(MFNSpace,MFNVector,MFNVector,MFNVector,void*);
void MFLOCANSpaceAdd(MFNSpace,MFNVector,MFNVector,MFNVector,void*);
void MFLOCANSpaceScale(MFNSpace,double,MFNVector,MFNVector,void*);
double MFLOCANSpaceInner(MFNSpace,MFNVector,MFNVector,void*);

void MFWriteLOCANSpace(FILE*,MFNSpace,void*);
MFNSpace MFReadLOCANSpace(FILE*);

double *MFLOCANVP(MFNVector);
double *MFLOCANVX(MFNVector);
int MFLOCANVNP(MFNVector);
int MFLOCANVNX(MFNVector);

extern double scaled_dp(double*,double*,void*);

MFNSpace MFCreateLOCANSpace(void *d)
 {
  static char RoutineName[]={"MFCreateLOCANSpace"};
  MFNSpace this;

#ifdef MFTIMINGS
  clock_t starttime;

  MFCalledMFCreateNSpace++;
  starttime=clock();
#endif

  this=MFCreateNSpaceBaseClass("LOCANSpace");
  MFNSpaceSetDistance(this,MFLOCANSpaceDistance);
  MFNSpaceSetInnerProduct(this,MFLOCANSpaceInner);
  MFNSpaceSetDirection(this,MFLOCANSpaceDirection);
  MFNSpaceSetAdd(this,MFLOCANSpaceAdd);
  MFNSpaceSetScale(this,MFLOCANSpaceScale);

  MFNSpaceSetData(this,(void*)d);

#ifdef MFTIMINGS
    MFTimeMFCreateNSpace+=clock()-starttime;
#endif
  return this;
 }

double MFLOCANSpaceDistance(MFNSpace this,MFNVector v0,MFNVector v1,void *d)
 {
  static char RoutineName[]={"MFNSpaceDistance"};
  double result;
  MFNVector dv;

#ifdef MFTIMINGS
  clock_t starttime;

  MFCalledMFNSpaceDistance++;
  starttime=clock();
#endif
  dv=MFCloneNVector(v0);
  MFLOCANSpaceDirection(this,v0,v1,dv,d);
  result=MFLOCANSpaceInner(this,dv,dv,d);
  MFFreeNVector(dv);

#ifdef MFTIMINGS
    MFTimeMFNSpaceDistance+=clock()-starttime;
#endif
  return sqrt(result);
 }

void MFLOCANSpaceDirection(MFNSpace this,MFNVector v0,MFNVector v1,MFNVector diff,void *d)
 {
  static char RoutineName[]={"MFNSpaceDirection"};
  int i;

#ifdef MFTIMINGS
  clock_t starttime;

  MFCalledMFNSpaceDirection++;
  starttime=clock();
#endif

  MFNVDiff(v1,v0,diff);

#ifdef MFTIMINGS
    MFTimeMFNSpaceDirection+=clock()-starttime;
#endif
  return;
 }

double MFLOCANSpaceInner(MFNSpace this,MFNVector v0,MFNVector v1,void *d)
 {
  static char RoutineName[]={"MFNSpaceInner"};
  double result;
  double *x0,*p0;
  double *x1,*p1;
  int i,np;

#ifdef MFTIMINGS
  clock_t starttime;

  MFCalledMFNSpaceInner++;
  starttime=clock();
#endif

  x0=MFLOCANVX(v0);
  p0=MFLOCANVP(v0);
  x1=MFLOCANVX(v1);
  p1=MFLOCANVP(v1);
  np=MFLOCANVNP(v0);

  result=scaled_dp(x0,x1,d);
  for(i=0;i<np;i++)result+=p0[i]*p1[i];

#ifdef MFTIMINGS
    MFTimeMFNSpaceInner+=clock()-starttime;
#endif
  return result;
 }

void MFWriteLOCANSpace(FILE *fid,MFNSpace this,void *d)
 {
  static char RoutineName[]={"MFWriteLOCA"};
  int i;

#ifdef MFTIMINGS
  clock_t starttime;

  MFCalledMFWriteNSpace++;
  starttime=clock();
#endif

#ifdef MFTIMINGS
    MFTimeMFWriteNSpace+=clock()-starttime;
#endif
  return;
 }

MFNSpace MFReadLOCANSpace(FILE *fid)
 {
  static char RoutineName[]={"MFReadNSpace"};
  int i;
  MFNSpace Omega;
  char tag[100]="";

#ifdef MFTIMINGS
  clock_t starttime;

  MFCalledMFReadNSpace++;
  starttime=clock();
#endif

  abort();
  Omega=MFCreateLOCANSpace((void*)NULL);

#ifdef MFTIMINGS
    MFTimeMFReadNSpace+=clock()-starttime;
#endif
  return Omega;
 }

void MFLOCANSpaceAdd(MFNSpace this,MFNVector v0,MFNVector v1,MFNVector sum,void *d)
 {
  static char RoutineName[]={"MFNSpaceAdd"};
  int i;

#ifdef MFTIMINGS
  clock_t starttime;

  MFCalledMFNSpaceAdd++;
  starttime=clock();
#endif

  MFNVAdd(v0,v1,sum);

#ifdef MFTIMINGS
    MFTimeMFNSpaceAdd+=clock()-starttime;
#endif
  return;
 }

void MFLOCANSpaceScale(MFNSpace this,double s, MFNVector v,MFNVector w,void *d)
 {
  static char RoutineName[]={"MFNSpaceScale"};
  int i;
  double *vx,*vp;
  double *wx,*wp;
  int nx,np;

#ifdef MFTIMINGS
  clock_t starttime;

  MFCalledMFNSpaceScale++;
  starttime=clock();
#endif

  vx=MFLOCANVX(v);
  vp=MFLOCANVP(v);
  wx=MFLOCANVX(w);
  wp=MFLOCANVP(w);
  nx=MFLOCANVNX(v);
  np=MFLOCANVNP(v);

  for(i=0;i<nx;i++)wx[i]=s*vx[i];
  for(i=0;i<np;i++)wp[i]=s*vp[i];

#ifdef MFTIMINGS
    MFTimeMFNSpaceScale+=clock()-starttime;
#endif
  return;
 }
