/*
 *  PROGRAM NAME:  multifario
 *
 *  (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
 *  CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
 *
 *  Please refer to the LICENSE file in the top directory
 *
 *      author: Mike Henderson mhender@watson.ibm.com
 *      date:   April 22, 2002 Modified MFTorus
 */

static char *id="@(#) $Id: MFLOCA.c 257 2006-08-30 20:30:07Z mhender $";

#include <MFImplicitMF.h>
#include <MFLOCA.h>
#include <MFErrorHandler.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

static char MFLOCAMFErrorHandlerMsg[256]="";
void MFSetError(int,char*,char*,int,char*);

extern int MFProjectLOCA(int,int,MFNVector,MFNKMatrix,MFNVector,void*,int*);
extern int MFTangentLOCA(int,int,MFNVector,MFNKMatrix,void*);
extern double MFScaleLOCA(int,int,MFNVector,MFNKMatrix,void*);

int MFLOCAProjectToSave(MFNVector,double*,void*);
int MFLOCAProjectToDraw(MFNVector,double*,void*);
int MFLOCAProjectForBB(MFNVector,double*,void*);

double *MFLOCANVP(MFNVector);
double *MFLOCANVX(MFNVector);
double MFPrintMetricLOCA(double*,double*);

MFNVector MFLOCAVectorFactory(MFImplicitMF);
MFNKMatrix MFLOCAMatrixFactory(MFImplicitMF);

MFImplicitMF MFIMFCreateLOCA(int np, void *con)
 {
  static char RoutineName[]={"MFIMFCreateLOCA"};
  MFImplicitMF loca;
  MFNSpace space;

  loca=MFIMFCreateBaseClass(-1,np,"LOCA");

  space=MFCreateLOCANSpace(con);
  MFIMFSetSpace(loca,space);
  MFFreeNSpace(space);

  MFIMFSetData(loca,(void*)con);
  MFIMFSetProject(loca,MFProjectLOCA);
  MFIMFSetTangent(loca,MFTangentLOCA);
  MFIMFSetScale(loca,MFScaleLOCA);
  MFIMFSetProjectForSave(loca,MFLOCAProjectToSave);
  MFIMFSetProjectForDraw(loca,MFLOCAProjectToDraw);
  MFIMFSetProjectForBB(loca,MFLOCAProjectForBB);

  MFIMFSetVectorFactory(loca,MFLOCAVectorFactory);
  MFIMFSetMatrixFactory(loca,MFLOCAMatrixFactory);

  return loca;
 }

int MFLOCAProjectToSave(MFNVector u, double *x, void *d)
 {
  int i,np;
  double *p;

  np=MFLOCANVNP(u);
  if(x==(double*)NULL)return np;

  p=MFLOCANVP(u);
  for(i=0;i<np;i++)x[i]=p[i];

  return 0;
 }

int MFLOCAProjectToDraw(MFNVector u, double *x, void *d)
 {
  int i,np;
  double *p;
  double *y;

  np=MFLOCANVNP(u);
  if(x==(double*)NULL)return np+1;

  p=MFLOCANVP(u);
  y=MFLOCANVX(u);
  x[0]=MFPrintMetricLOCA(y,p);
  for(i=0;i<np;i++)x[i+1]=p[i];

  return 0;
 }

int MFLOCAProjectForBB(MFNVector u, double *x, void *d)
 {
  int i;
  int np;
  double *p;

  np=MFLOCANVNP(u);
  if(x==(double*)NULL)return np;

  p=MFLOCANVP(u);
  for(i=0;i<np;i++)x[i]=p[i];

  return 0;
 }

MFNVector MFLOCAVectorFactory(MFImplicitMF this)
 {
  static char RoutineName[]={"MFLOCAVectorFactory"};
  struct MFLOCAData *data;

  data=(struct MFLOCAData*)MFIMFGetData(this);

  if(!strcmp(MFImplicitMFId(this),"LOCA"))
    return MFCreateLOCANVector(MFIMF_N(this));

   else
    return (MFNVector)NULL;
 }

MFNKMatrix MFLOCAMatrixFactory(MFImplicitMF this)
 {
  static char RoutineName[]={"MFLOCAMatrixFactory"};
  MFNKMatrix A;
  struct MFLOCAData *data;
  int i,k;
  MFNVector *col;

  k=MFIMF_K(this);
  col=malloc(k*sizeof(MFNVector));
  if(col==(MFNVector*)NULL)
   {
    sprintf(MFLOCAMFErrorHandlerMsg,"Out of memory trying to allocate %d NVectors",k);
    MFSetError(4,RoutineName,MFLOCAMFErrorHandlerMsg,__LINE__,__FILE__);
    return (MFNKMatrix)NULL;
   }

  data=(struct MFLOCAData*)MFIMFGetData(this);

  if(!strcmp(MFImplicitMFId(this),"LOCA"))
   {
    for(i=0;i<k;i++)col[i]=MFLOCAVectorFactory(this);
    A=MFCreateNKMatrix(k,col);
    for(i=0;i<k;i++)MFFreeNVector(col[i]);
    free(col);
    return A;
   }else{
    return (MFNKMatrix)NULL;
   }
 }
