/* 
    @(#)MFError.c	1.6
    02/04/19 16:30:04
   
    PROGRAM NAME:  multifario

    (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
    CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.

    Please refer to the LICENSE file in the top directory

*/
/*      author: Mike Henderson mhender@watson.ibm.com */
/*      date:   Feb. 10, 1999                         */

#include <MFError.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

static int MFERRORNError=0;
static int MFERRORMError=0;
static int *MFERRORErrorSev=(int*)NULL;
static char **MFERRORErrorRtn=(char**)NULL;
static char **MFERRORErrorMsg=(char**)NULL;
static char **MFERRORErrorFile=(char**)NULL;
static int *MFERRORErrorLine=(int*)NULL;

void MFSetError(int sev,char *routine,char *msg,int line,char *file)
 {
  printf("MFSetError(%d,\"%s\",\"%s\",%d,\"%s\");\n",sev,routine,msg,line,file);fflush(stdout);

  if(errno>0){printf("MFError : %s\n",strerror(errno));fflush(stdout);}
  if(!(MFERRORNError<MFERRORMError))
   {
    MFERRORMError+=100;
    MFERRORErrorSev=(int*)realloc((void*)MFERRORErrorSev,MFERRORMError*sizeof(int)); /*done*/
    if(MFERRORErrorSev==(int*)NULL)
     {
      printf("Out of memory in MFSetError, line %d file %s, allocating %d bytes\n",__LINE__,__FILE__,MFERRORMError*sizeof(int));
      fflush(stdout);
      abort();
     }
    MFERRORErrorRtn=(char**)realloc((void*)MFERRORErrorRtn,MFERRORMError*sizeof(char*)); /*done*/
    if(MFERRORErrorRtn==(char**)NULL)
     {
      printf("Out of memory in MFSetError, line %d file %s, allocating %d bytes\n",__LINE__,__FILE__,MFERRORMError*sizeof(char*));
      fflush(stdout);
      abort();
     }
    MFERRORErrorMsg=(char**)realloc((void*)MFERRORErrorMsg,MFERRORMError*sizeof(char*)); /*done*/
    if(MFERRORErrorMsg==(char**)NULL)
     {
      printf("Out of memory in MFSetError, line %d file %s, allocating %d bytes\n",__LINE__,__FILE__,MFERRORMError*sizeof(char*));
      fflush(stdout);
      abort();
     }
    MFERRORErrorFile=(char**)realloc((void*)MFERRORErrorFile,MFERRORMError*sizeof(char*)); /*done*/
    if(MFERRORErrorFile==(char**)NULL)
     {
      printf("Out of memory in MFSetError, line %d file %s, allocating %d bytes\n",__LINE__,__FILE__,MFERRORMError*sizeof(char*));
      fflush(stdout);
      abort();
     }
    MFERRORErrorLine=(int*)realloc((void*)MFERRORErrorLine,MFERRORMError*sizeof(int)); /*done*/
    if(MFERRORErrorLine==(int*)NULL)
     {
      printf("Out of memory in MFSetError, line %d file %s, allocating %d bytes\n",__LINE__,__FILE__,MFERRORMError*sizeof(int));
      fflush(stdout);
      abort();
     }
   }

  MFERRORErrorSev[MFERRORNError]=sev;
  MFERRORErrorRtn[MFERRORNError]=(char*)malloc((strlen(routine)+1)*sizeof(char)); /*done*/
  if(MFERRORErrorRtn[MFERRORNError]==(char*)NULL)
   {
    printf("Out of memory in MFSetError, line %d file %s, allocating %d bytes\n",__LINE__,__FILE__,(strlen(routine)+1)*sizeof(char));
    fflush(stdout);
    abort();
   }
  strcpy(MFERRORErrorRtn[MFERRORNError],routine);
  MFERRORErrorMsg[MFERRORNError]=(char*)malloc((strlen(msg)+1)*sizeof(char)); /*done*/
  if(MFERRORErrorMsg[MFERRORNError]==(char*)NULL)
   {
    printf("Out of memory in MFSetError, line %d file %s, allocating %d bytes\n",__LINE__,__FILE__,(strlen(msg)+1)*sizeof(char));
    fflush(stdout);
    abort();
   }
  strcpy(MFERRORErrorMsg[MFERRORNError],msg);
  MFERRORErrorFile[MFERRORNError]=(char*)malloc((strlen(file)+1)*sizeof(char)); /*done*/
  if(MFERRORErrorFile[MFERRORNError]==(char*)NULL)
   {
    printf("Out of memory in MFSetError, line %d file %s, allocating %d bytes\n",__LINE__,__FILE__,(strlen(file)+1)*sizeof(char));
    fflush(stdout);
    abort();
   }
  strcpy(MFERRORErrorFile[MFERRORNError],file);
  MFERRORErrorLine[MFERRORNError]=line;
/*
  printf("  MFERRORErrorSev[%d]=%d\n",MFERRORNError,MFERRORErrorSev[MFERRORNError]);fflush(stdout);
  printf("  MFERRORErrorRtn[%d]=\"%s\"\n",MFERRORNError,MFERRORErrorRtn[MFERRORNError]);fflush(stdout);
  printf("  MFERRORErrorMsg[%d]=\"%s\"\n",MFERRORNError,MFERRORErrorMsg[MFERRORNError]);fflush(stdout);
  printf("  MFERRORErrorFile[%d]=\"%s\"\n",MFERRORNError,MFERRORErrorFile[MFERRORNError]);fflush(stdout);
  printf("  MFERRORErrorLine[%d]=%d\n",MFERRORNError,MFERRORErrorLine[MFERRORNError]);fflush(stdout);
*/
  MFERRORNError++;

  if(sev>4){printf("MFError: Aborting due to severe error %d %s\n    Line %d in file %s",errno,strerror(errno),line,file);fflush(stdout);abort();}

  return;
 }

int MFNErrors()
 {
  return MFERRORNError;
 }

int MFErrorSev(int n)
 {
  if(n<0||!(n<MFERRORNError))return 0;
/*printf("  MFERRORErrorSev(%d)=%d\n",n,MFERRORErrorSev[n]);fflush(stdout);*/
  return MFERRORErrorSev[n];
 }

char *MFErrorRoutine(int n)
 {
  if(n<0||!(n<MFERRORNError))return (char*)NULL;
/*printf("  MFERRORErrorRtn(%d)=\"%s\"\n",n,MFERRORErrorRtn[n]);fflush(stdout);*/
  return MFERRORErrorRtn[n];
 }

char *MFErrorMsg(int n)
 {
  if(n<0||!(n<MFERRORNError))return (char*)NULL;
/*printf("  MFERRORErrorMsg(%d)=\"%s\"\n",n,MFERRORErrorMsg[n]);fflush(stdout);*/
  return MFERRORErrorMsg[n];
 }

int MFErrorLine(int n)
 {
  if(n<0||!(n<MFERRORNError))return 0;
/*printf("  MFERRORErrorLine(%d)=%d\n",n,MFERRORErrorLine[n]);fflush(stdout);*/
  return MFERRORErrorLine[n];
 }

char *MFErrorFile(int n)
 {
  if(n<0||!(n<MFERRORNError))return (char*)NULL;
/*printf("  MFERRORErrorFile(%d)=\"%s\"\n",n,MFERRORErrorFile[n]);fflush(stdout);*/
  return MFERRORErrorFile[n];
 }

int MFError()
 {
  return(MFERRORNError!=0);
 }

void MFClearErrors()
 {
  int i;
  for(i=0;i<MFERRORNError;i++)
   {
    if(MFERRORErrorRtn[i]!=(char*)NULL)free(MFERRORErrorRtn[i]);
    if(MFERRORErrorMsg[i]!=(char*)NULL)free(MFERRORErrorMsg[i]);
    if(MFERRORErrorFile[i]!=(char*)NULL)free(MFERRORErrorFile[i]);
   }
  free(MFERRORErrorSev);MFERRORErrorSev=(int*)NULL;
  free(MFERRORErrorRtn);MFERRORErrorRtn=(char**)NULL;
  free(MFERRORErrorMsg);MFERRORErrorMsg=(char**)NULL;
  free(MFERRORErrorFile);MFERRORErrorFile=(char**)NULL;
  free(MFERRORErrorLine);MFERRORErrorLine=(int*)NULL;
  MFERRORMError=0;
  MFERRORNError=0;
  return;
 }
