/*
 *  PROGRAM NAME:  multifario
 *
 *  (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
 *  CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
 *
 *  Please refer to the LICENSE file in the top directory
 *
 *      author: Mike Henderson mhender@watson.ibm.com
 */

static char *id="@(#) $Id: MFContinuationMethod.c 250 2006-08-19 02:57:36Z mhender $";

char MFContinuationMethodErrorMsg[256];

#include <MFAtlas.h>
#include <MFContinuationMethod.h>
#include <MFErrorHandler.h>

struct MFContinuationMethodST{
                              char *type;
                              void *parmBlock;
                              void (*ExtendAtlasMultipleWithTangents)(struct MFContinuationMethodST*,MFAtlas,MFImplicitMF,MFNRegion,int,MFNVector*,MFNKMatrix*,MFErrorHandler);
                              void (*CloseAtlas)(struct MFContinuationMethodST*,MFAtlas,MFErrorHandler);
                              void (*FlushAtlas)(struct MFContinuationMethodST*,MFAtlas,MFErrorHandler);
                              void (*FreeParmBlock)(void*,MFErrorHandler);
                              int nRefs;
                             };

MFContinuationMethod MFCreateContinuationMethodBaseClass(char *type, MFErrorHandler e)
 {
  static char RoutineName[]={"MFCreateContinuationMethodBaseClass"};
  MFContinuationMethod result;

  result=malloc(sizeof(struct MFContinuationMethodST));

#ifndef MFNOSAFETYNET
  if(result==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Out of space trying to allocate %d bytes.",sizeof(struct MFContinuationMethodST));
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return NULL;
   }
#endif

  result->type=malloc((strlen(type)+1)*sizeof(char));

#ifndef MFNOSAFETYNET
  if(result->type==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Out of space trying to allocate %d bytes.",10*sizeof(char));
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    free(result);
    return NULL;
   }
#endif

  strcpy(result->type,type);

  result->ExtendAtlasMultipleWithTangents=NULL;
  result->CloseAtlas=NULL;
  result->FlushAtlas=NULL;
  result->nRefs=1;

  return result;
 }

void MFFreeContinuationMethod(MFContinuationMethod this, MFErrorHandler e)
 {
  static char RoutineName[]={"MFFreeContinuationMethod"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,4,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  this->nRefs--;

  if(this->nRefs<1)
   {
    if(this->type!=NULL)free(this->type);
    if(this->parmBlock!=NULL && this->FreeParmBlock!=NULL)this->FreeParmBlock(this->parmBlock,e);
    free(this);
   }

  return;
 }

void MFRefContinuationMethod(MFContinuationMethod this, MFErrorHandler e)
 {
  static char RoutineName[]={"MFRefContinuationMethod"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  this->nRefs++;

  return;
 }

void MFContinuationMethodExtendAtlasMultipleWithTangents(MFContinuationMethod this,MFAtlas A,MFImplicitMF M,MFNRegion Omega,int n,MFNVector *u0,MFNKMatrix *Phi0, MFErrorHandler e)
 {
  static char RoutineName[]={"MFContinuationMethodExtendAtlasMultipleWithTangents"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }

  if(this->ExtendAtlasMultipleWithTangents==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"This ContinuationMethod has no ComputeAtlasMultipleWithTangents");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  this->ExtendAtlasMultipleWithTangents(this,A,M,Omega,n,u0,Phi0,e);

  return;
 }

void MFFlushAtlas(MFContinuationMethod this,MFAtlas A, MFErrorHandler e)
 {
  static char RoutineName[]={"MFContinuationMethodFlushAtlas"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  if(this->FlushAtlas==NULL)return;

  this->FlushAtlas(this,A,e);

  return;
 }

void MFCloseAtlas(MFContinuationMethod this,MFAtlas A, MFErrorHandler e)
 {
  static char RoutineName[]={"MFContinuationMethodCloseAtlas"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  if(this->CloseAtlas==NULL)return;

  this->CloseAtlas(this,A,e);

  return;
 }

MFAtlas MFComputeAtlas(MFContinuationMethod this, MFImplicitMF M, MFNRegion Omega, MFNVector u0, MFErrorHandler e)
 {
  static char RoutineName[]={"MFComputeAtlas"};
  MFAtlas S;

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }

  if(this->ExtendAtlasMultipleWithTangents==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"This ContinuationMethod has no ComputeAtlas");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  S=MFCreateAtlas(M,e);

  MFExtendAtlasMultipleWithTangents(S,this,M,Omega,1,&u0,NULL,e);

  return S;
 }

MFAtlas MFComputeAtlasWithTangent(MFContinuationMethod this, MFImplicitMF M, MFNRegion Omega, MFNVector u0, MFNKMatrix Phi0, MFErrorHandler e)
 {
  static char RoutineName[]={"MFComputeAtlasWithTangent"};
  MFAtlas S;

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }

  if(this->ExtendAtlasMultipleWithTangents==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"This ContinuationMethod has no ComputeAtlasWithTangent");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  S=MFCreateAtlas(M,e);

  MFExtendAtlasMultipleWithTangents(S,this,M,Omega,1,&u0,&Phi0,e);
  
  return S;
 }


MFAtlas MFComputeAtlasMultiple(MFContinuationMethod this, MFImplicitMF M, MFNRegion Omega, int m, MFNVector *u0, MFErrorHandler e)
 {
  static char RoutineName[]={"MFComputeAtlasMultiple"};
  MFAtlas S;

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }

  if(this->ExtendAtlasMultipleWithTangents==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"This ContinuationMethod has no ComputeAtlasMultiple");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  S=MFCreateAtlas(M,e);

  MFExtendAtlasMultipleWithTangents(S,this,M,Omega,m,u0,NULL,e);

  return S;
 }

MFAtlas MFComputeAtlasMultipleWithTangents(MFContinuationMethod this, MFImplicitMF M, MFNRegion Omega, int m, MFNVector *u0, MFNKMatrix *Phi0, MFErrorHandler e)
 {
  static char RoutineName[]={"MFComputeAtlasMultipleWithTangents"};
  MFAtlas S;

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }

  if(this->ExtendAtlasMultipleWithTangents==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"This ContinuationMethod has no ComputeAtlasMultipleWithTangents");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  S=MFCreateAtlas(M,e);

  MFExtendAtlasMultipleWithTangents(S,this,M,Omega,m,u0,Phi0,e);

  return S;
 }

void MFExtendAtlas(MFAtlas S, MFContinuationMethod this, MFImplicitMF M, MFNRegion Omega, MFNVector u0, MFErrorHandler e)
 {
  static char RoutineName[]={"MFExtendAtlas"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }

  if(this->ExtendAtlasMultipleWithTangents==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"This ContinuationMethod has no ExtendAtlas");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  MFExtendAtlasMultipleWithTangents(S,this,M,Omega,1,&u0,NULL,e);

  return;
 }

void MFExtendAtlasMultiple(MFAtlas S, MFContinuationMethod this, MFImplicitMF M, MFNRegion Omega, int m, MFNVector *u0, MFErrorHandler e)
 {
  static char RoutineName[]={"MFExtendAtlasMultiple"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }

  if(this->ExtendAtlasMultipleWithTangents==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"This ContinuationMethod has no ExtendAtlasMultiple");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  MFExtendAtlasMultipleWithTangents(S,this,M,Omega,m,u0,NULL,e);

  return;
 }

void MFExtendAtlasWithTangent(MFAtlas S, MFContinuationMethod this, MFImplicitMF M, MFNRegion Omega, MFNVector u0,MFNKMatrix Phi0, MFErrorHandler e)
 {
  static char RoutineName[]={"MFExtendAtlasWithTangent"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }

  if(this->ExtendAtlasMultipleWithTangents==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"This ContinuationMethod has no ExtendAtlasWithTangent");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  MFExtendAtlasMultipleWithTangents(S,this,M,Omega,1,&u0,&Phi0,e);

  return;
 }

void MFExtendAtlasMultipleWithTangents(MFAtlas S, MFContinuationMethod this, MFImplicitMF M, MFNRegion Omega, int m, MFNVector *u0, MFNKMatrix *Phi0, MFErrorHandler e)
 {
  static char RoutineName[]={"MFExtendAtlasMultipleWithTangents"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }

  if(this->ExtendAtlasMultipleWithTangents==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"This ContinuationMethod has no ExtendAtlasWithTangent");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  this->ExtendAtlasMultipleWithTangents(this,S,M,Omega,m,u0,Phi0,e);

  return;
 }

char *MFContinuationMethodGetType(MFContinuationMethod this, MFErrorHandler e)
 {
  static char RoutineName[]={"MFContinuationMethodGetType"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  return this->type;
 }

void *MFContinuationMethodGetParmBlock(MFContinuationMethod this, MFErrorHandler e)
 {
  static char RoutineName[]={"MFContinuationMethodGetParmBlock"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  return this->parmBlock;
 }

void MFContinuationMethodSetParmBlock(MFContinuationMethod this, void *parmBlock, MFErrorHandler e)
 {
  static char RoutineName[]={"MFContinuationMethodSetParmBlock"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  this->parmBlock=parmBlock;
  return;
 }

void MFContinuationMethodSetFreeParmBlock(MFContinuationMethod this, void (*FreeParmBlock)(void*,MFErrorHandler), MFErrorHandler e)
 {
  static char RoutineName[]={"MFContinuationMethodSetFreeParmBlock"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  this->FreeParmBlock=FreeParmBlock;
  return;
 }

void MFContinuationMethodSetExtendAtlasMultipleWithTangents(MFContinuationMethod this, void (*ExtendAtlasMultipleWithTangents)(struct MFContinuationMethodST*,MFAtlas,MFImplicitMF,MFNRegion,int,MFNVector*,MFNKMatrix*,MFErrorHandler), MFErrorHandler e)
 {
  static char RoutineName[]={"MFContinuationMethodSetExtendAtlasMultipleWithTangents"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  this->ExtendAtlasMultipleWithTangents=ExtendAtlasMultipleWithTangents;
  return;
 }

void MFContinuationMethodSetCloseAtlas(MFContinuationMethod this, void (*CloseAtlas)(struct MFContinuationMethodST*,MFAtlas,MFErrorHandler), MFErrorHandler e)
 {
  static char RoutineName[]={"MFContinuationMethodSetCloseAtlas"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  this->CloseAtlas=CloseAtlas;
  return;
 }

void MFContinuationMethodSetFlushAtlas(MFContinuationMethod this, void (*FlushAtlas)(struct MFContinuationMethodST*,MFAtlas,MFErrorHandler), MFErrorHandler e)
 {
  static char RoutineName[]={"MFContinuationMethodSetFlushAtlas"};

#ifdef MFNOCONFIDENCE
  if(this==NULL)
   {
    sprintf(MFContinuationMethodErrorMsg,"Pointer to ContinuationMethod (argument 1) is NULL");
    MFSetError(e,12,RoutineName,MFContinuationMethodErrorMsg,__LINE__,__FILE__);
    return;
   }
#endif

  this->FlushAtlas=FlushAtlas;
  return;
 }

