/* 
    @(#)MFPolytope.h	1.6
    02/11/11 15:04:50
   
    PROGRAM NAME:  Manifold
   
    (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
    CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
   
    Please refer to the LICENSE file in the top directory

*/
/*      author: Mike Henderson mhender@watson.ibm.com */

#ifndef __NEWPOLYTOPE_H__
#define __NEWPOLYTOPE_H__
#include <MFBase.h>

#include <stdio.h>
#include <MFKVector.h>
#include <MFErrorHandler.h>

struct MFPolytopeSt;
typedef struct MFPolytopeSt *MFPolytope;

#ifdef __cplusplus
 extern "C" {
#endif

MFPolytope MFCreateHyperCubeAtOrigin(int,double,MFErrorHandler);
MFPolytope MFCreateSimplexAtOrigin(int,double,MFErrorHandler);
void MFSubtractHalfSpaceFromPolytope(MFPolytope,int,MFKVector,double,MFErrorHandler);
void MFClipPolytope(MFPolytope P,int,double*,int,MFErrorHandler);
void MFFreePolytope(MFPolytope,MFErrorHandler);

int MFPolytopeDimension(MFPolytope,MFErrorHandler);
int MFPolytopeNumberOfVertices(MFPolytope,MFErrorHandler);
void MFPolytopeVertex(MFPolytope,int,MFKVector,MFErrorHandler);
int MFPolytopeVertexIndex(MFPolytope,int,int,MFErrorHandler);
int MFPolytopeNumberOfVertexIndices(MFPolytope,int,MFErrorHandler);
double MFPolytopeRadiusOfVertex(MFPolytope,int,MFErrorHandler);
double MFPolytopeLargestRadiusOfVertex(MFPolytope,MFErrorHandler);

int MFPolytopeNumberOfFaces(MFPolytope,MFErrorHandler);
int MFPolytopeFaceIndex(MFPolytope,int,MFErrorHandler);
MFKVector MFPolytopeFaceNormal(MFPolytope,int,MFErrorHandler);
double MFPolytopeFaceOrigin(MFPolytope,int,MFErrorHandler);
int MFPolytopeNumberOfVerticesOnFace(MFPolytope,int,MFErrorHandler);

int MFPolytopeInterior(MFPolytope,MFKVector,MFErrorHandler);
MFPolytope MFPolytopeRemoveSmallEdges(MFPolytope,double,MFErrorHandler);

void MFWritePolytope(FILE*,MFPolytope,MFErrorHandler);
MFPolytope MFReadPolytope(FILE*,MFErrorHandler);
int MFPolytopeClosestFace(MFPolytope,MFKVector,double*,MFErrorHandler);

void MFPolytopeSetVertexMark(MFPolytope,int,int,MFErrorHandler);
int MFPolytopeGetVertexMark(MFPolytope,int,MFErrorHandler);

#ifdef __cplusplus
}
#endif

#endif
