/* 
    @(#)MFNVector.h	1.14
    03/07/07 22:24:11
   
    PROGRAM NAME:  Manifold
   
    (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
    CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
   
    Please refer to the LICENSE file in the top directory

*/
/*      author: Mike Henderson mhender@watson.ibm.com */
/*      date:   November 11, 1997                     */
/*              February 2, 1999   Ported to C        */

#ifndef __MFNVECTOR_H__
#define __MFNVECTOR_H__
#include <MFBase.h>

#include <stdio.h>
#include <MFErrorHandler.h>

struct MFNVectorSt;
typedef struct MFNVectorSt *MFNVector;

#ifdef __cplusplus
 extern "C" {
#endif

MFNVector MFCreateNVectorBaseClass(char*,MFErrorHandler);
void MFNVectorSetPrint(MFNVector,void (*)(FILE*,void*,MFErrorHandler),MFErrorHandler);
void MFNVectorSetData(MFNVector,void*,MFErrorHandler);
void *MFNVectorGetData(MFNVector,MFErrorHandler);
void MFNVectorSetFreeData(MFNVector,void (*)(void*,MFErrorHandler),MFErrorHandler);
void MFNVectorSetWriteData(MFNVector,void (*)(FILE*,void*,MFErrorHandler),MFErrorHandler);
void MFNVectorSetClone(MFNVector,MFNVector (*)(void*,MFErrorHandler),MFErrorHandler);
void MFNVectorSetGetNC(MFNVector,int (*)(void*,MFErrorHandler),MFErrorHandler);
void MFNVectorSetGetC(MFNVector,double (*)(int,void*,MFErrorHandler),MFErrorHandler);
void MFNVectorSetSetC(MFNVector,void (*)(int,double,void*,MFErrorHandler),MFErrorHandler);
void MFNVectorSetAdd(MFNVector,void (*)(void*,void*,void*,MFErrorHandler),MFErrorHandler);
void MFNVectorSetDiff(MFNVector,void (*)(void*,void*,void*,MFErrorHandler),MFErrorHandler);

MFNVector MFCloneNVector(MFNVector,MFErrorHandler);
MFNVector MFCreateNVector(int,MFErrorHandler);
MFNVector MFCreateNVectorWithData(int,double*,MFErrorHandler);
MFNVector MFCreateWrappedNVector(int,double*,MFErrorHandler);

void MFRefNVector(MFNVector,MFErrorHandler);
void MFFreeNVector(MFNVector,MFErrorHandler);
int MFNV_NC(MFNVector,MFErrorHandler);
double MFNV_C(MFNVector,int,MFErrorHandler);
void MFNVSetC(MFNVector,int,double,MFErrorHandler);
void MFNVAdd(MFNVector,MFNVector,MFNVector,MFErrorHandler);
void MFNVDiff(MFNVector,MFNVector,MFNVector,MFErrorHandler);

int MFNVGetIndex(MFNVector,MFErrorHandler);
void MFNVSetIndex(MFNVector,int,MFErrorHandler);

int MFNVGetIndex2(MFNVector,MFErrorHandler);
void MFNVSetIndex2(MFNVector,int,MFErrorHandler);

void MFWriteNVector(FILE*,MFNVector,MFErrorHandler);
MFNVector MFReadNVector(FILE*,MFErrorHandler);

char *MFNVGetId(MFNVector,MFErrorHandler);
double *MFNV_CStar(MFNVector,MFErrorHandler);

#ifdef __cplusplus
}
#endif

#endif
