/* 
    @(#)MFKVector.h	1.3
    02/04/19 14:41:38
   
    PROGRAM NAME:  Manifold
   
    (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
    CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
   
    Please refer to the LICENSE file in the top directory

*/
/*      author: Mike Henderson mhender@watson.ibm.com */
/*      date:   November 11, 1997                     */
/*              February 2, 1999   Ported to C        */

#ifndef __MFKVECTOR_H__
#define __MFKVECTOR_H__
#include <MFBase.h>

#include <stdio.h>
#include <MFErrorHandler.h>

struct MFKVectorSt;
typedef struct MFKVectorSt *MFKVector;

#ifdef __cplusplus
 extern "C" {
#endif

MFKVector MFCreateKVector(int,MFErrorHandler);
MFKVector MFCreateKVectorWithData(int,double*,MFErrorHandler);
void MFRefKVector(MFKVector,MFErrorHandler);
void MFFreeKVector(MFKVector,MFErrorHandler);
int MFKV_NC(MFKVector,MFErrorHandler);
double MFKV_C(MFKVector,int,MFErrorHandler);
void MFKVSetC(MFKVector,int,double,MFErrorHandler);

double MFKVDot(MFKVector,MFKVector,MFErrorHandler);
double MFKVNorm(MFKVector,MFErrorHandler);
void MFKVScale(double,MFKVector,MFErrorHandler);
void MFKVScaleMul(double,MFKVector,MFKVector,MFErrorHandler);
void MFKVDiff(MFKVector,MFKVector,MFKVector,MFErrorHandler);
void MFKVAdd(MFKVector,MFKVector,MFKVector,MFErrorHandler);

void MFWriteKVector(FILE*,MFKVector,MFErrorHandler);
MFKVector MFReadKVector(FILE*,MFErrorHandler);

double *MFKV_CStar(MFKVector,MFErrorHandler);

#ifdef __cplusplus
}
#endif

#endif
