/* 
    @(#)MFImplicitMF.h	1.21
    03/07/24 11:20:52
   
    PROGRAM NAME:  Manifold
   
    (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
    CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
   
    Please refer to the LICENSE file in the top directory

*/
/*      author: Mike Henderson mhender@watson.ibm.com */
/*      date:   February 19, 1999                     */
/*              October 6, 2004   Added ProjectFromCenter */

#ifndef __MFIMPLICITMF_H__
#define __MFIMPLICITMF_H__
#include <MFBase.h>

#include <MFKVector.h>
#include <MFNVector.h>
#include <MFNKMatrix.h>
#include <MFNSpace.h>
#include <IMFFlow.h>
#include <MFErrorHandler.h>

struct MFImplicitMFSt;
typedef struct MFImplicitMFSt *MFImplicitMF;

#ifdef __cplusplus
 extern "C" {
#endif

void MFRefImplicitMF(MFImplicitMF,MFErrorHandler);
void MFFreeImplicitMF(MFImplicitMF,MFErrorHandler);
char *MFImplicitMFId(MFImplicitMF,MFErrorHandler);
int MFIMF_N(MFImplicitMF,MFErrorHandler);
int MFIMF_K(MFImplicitMF,MFErrorHandler);
int MFIMFProject(MFImplicitMF,MFNVector,MFNKMatrix,MFNVector,MFErrorHandler);
int MFIMFProjectFromCenter(MFImplicitMF,MFNVector,MFNKMatrix,MFKVector,MFNVector,MFErrorHandler);
MFNKMatrix MFIMFTangentSpace(MFImplicitMF,MFNVector,MFErrorHandler);
MFNKMatrix MFIMFTangentSpaceWithGuess(MFImplicitMF,MFNVector,MFNKMatrix,MFErrorHandler);
double MFIMFScale(MFImplicitMF,MFNVector,MFNKMatrix,MFErrorHandler);
MFNSpace MFIMFNSpace(MFImplicitMF,MFErrorHandler);
void MFIMFEvaluate(MFImplicitMF,MFNVector,MFNVector,MFErrorHandler);
void MFIMFApplyJacobian(MFImplicitMF,MFNVector,MFNKMatrix,MFNKMatrix,MFErrorHandler);
void MFIMFApplySecDer(MFImplicitMF,MFNVector,MFNVector,MFNVector,MFNVector,MFErrorHandler);

MFImplicitMF MFIMFCreateAlgebraicExpression(char*,char*,MFErrorHandler);
MFImplicitMF MFIMFCreateAlgebraicExpressionWithRadius(char*,char*,double,MFErrorHandler);
MFImplicitMF MFIMFCreateAlgebraicSubroutine(int,int,
                              void (*)(int*,double*,int*,double*,MFErrorHandler),
                              void (*)(int*,double*,int*,double*,MFErrorHandler),
                              void (*)(int*,double*,int*,double*,MFErrorHandler),
                              MFErrorHandler);
MFImplicitMF MFIMFCreateAlgebraicSubroutineWithRadius(int,int,
                              void (*)(int*,double*,int*,double*,MFErrorHandler),
                              void (*)(int*,double*,int*,double*,MFErrorHandler),
                              void (*)(int*,double*,int*,double*,MFErrorHandler),
                              double,MFErrorHandler);
MFImplicitMF MFIMFCreateTorus(double,double,double,double,double,MFErrorHandler);
MFImplicitMF MFIMFCreateSphere(double,double,double,double,MFErrorHandler);
MFImplicitMF MFIMFCreateCircle(double,double,double,MFErrorHandler);
MFImplicitMF MFIMFCreatePendula(int,double,double,int,MFErrorHandler);
MFImplicitMF MFIMFCreatePendulaFour(int,int,MFErrorHandler);
MFImplicitMF MFIMFCreatePlane(MFErrorHandler);
MFImplicitMF MFIMFCreateNSpace(int,MFErrorHandler);
MFImplicitMF MFIMFCreateNSpaceWithRadius(int,double,MFErrorHandler);
MFImplicitMF MFIMFCreateCSTR(double,double,double,double,double,double,double,double,double,double,double,double,MFErrorHandler);
MFImplicitMF MFIMFCreateFlat(int,int,double*,double*,MFErrorHandler);
MFImplicitMF MFIMFCreatePolygonIn3SpaceWithRadius(int,double*,double,MFErrorHandler);
MFImplicitMF MFIMFCreateEdgeIn3SpaceWithRadius(double*,double*,double,MFErrorHandler);
MFImplicitMF MFIMFCreateSwallow(MFErrorHandler);

void MFWriteImplicitMF(FILE*,MFImplicitMF,MFErrorHandler);
MFImplicitMF MFReadImplicitMF(FILE*,MFErrorHandler);

typedef void (*MFTPBVPFFUNCTION)(double,int,double*,int,double*,double*,double*,double*,MFErrorHandler);
typedef void (*MFTPBVPAFUNCTION)(int,int,double*,double*,int,double*,double*,double*,double*,double*,MFErrorHandler);
typedef void (*MFTPBVPLFUNCTION)(int,double,int,double*,int,double*,double*,double*,double*,MFErrorHandler);
typedef void (*MFTPBVPMFUNCTION)(int,int,double*,double*,double*,MFErrorHandler);
MFImplicitMF MFIMFCreateTPBVP(int k, int nx,int nu,int np, MFTPBVPFFUNCTION f, MFTPBVPFFUNCTION fu, MFTPBVPFFUNCTION fl, int nbc, MFTPBVPAFUNCTION a, MFTPBVPAFUNCTION au, MFTPBVPAFUNCTION al, int nic, MFTPBVPLFUNCTION l, MFTPBVPLFUNCTION lu, MFTPBVPLFUNCTION ll, MFTPBVPMFUNCTION m, MFTPBVPMFUNCTION ml,MFErrorHandler);
void MFTPBVPSetEpsilon(MFImplicitMF,double,MFErrorHandler);
MFNVector MFTPBVPIntegrateForInitialSolution(MFImplicitMF,double*,double*,double*,MFErrorHandler);
MFNVector MFTPBVPIntegrateForTangent(MFImplicitMF,MFNVector,double*,double*,MFErrorHandler);
int MFIMFStop(MFImplicitMF,MFNVector,MFNKMatrix,MFNVector,MFNKMatrix,MFErrorHandler);

int MFIMFProjectToSave(MFImplicitMF,MFNVector,double*,MFErrorHandler);
int MFIMFProjectToDraw(MFImplicitMF,MFNVector,double*,MFErrorHandler);
int MFIMFProjectToBB(MFImplicitMF,MFNVector,double*,MFErrorHandler);

MFImplicitMF MFIMFCreateBaseClass(int,int,char*,MFErrorHandler);
void MFIMFSetData(MFImplicitMF,void*,MFErrorHandler);
void *MFIMFGetData(MFImplicitMF,MFErrorHandler);
void MFIMFSetWriteData(MFImplicitMF,void (*)(FILE*,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetFreeData(MFImplicitMF,void (*)(void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetProjectFromCenter(MFImplicitMF,int (*)(int,int,MFNVector,MFNKMatrix, MFKVector,MFNVector,void*,int*,MFErrorHandler),MFErrorHandler);
void MFIMFSetProject(MFImplicitMF,int (*)(int,int,MFNVector,MFNKMatrix,MFNVector,void*,int*,MFErrorHandler),MFErrorHandler);
void MFIMFSetTangent(MFImplicitMF,int (*)(int,int,MFNVector,MFNKMatrix,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetTangentWithGuess(MFImplicitMF,int (*)(int,int,MFNVector,MFNKMatrix,MFNKMatrix,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetEvaluate(MFImplicitMF,void (*)(int,MFNVector,MFNVector,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetApplyJacobian(MFImplicitMF,void (*)(int,int,MFNVector,MFNKMatrix,MFNKMatrix,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetApplySecDer(MFImplicitMF,void (*)(int,int,MFNVector,MFNVector,MFNVector,MFNVector,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetScale(MFImplicitMF,double (*)(int,int,MFNVector,MFNKMatrix,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetStop(MFImplicitMF,int (*)(MFImplicitMF,MFNVector,MFNKMatrix,MFNVector,MFNKMatrix,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetR(MFImplicitMF,double,MFErrorHandler);
double MFIMFGetR(MFImplicitMF,MFErrorHandler);
void MFIMFSetRMin(MFImplicitMF,double,MFErrorHandler);
double MFIMFGetRMin(MFImplicitMF,MFErrorHandler);
void MFIMFSetProjectForSave(MFImplicitMF,int (*)(MFNVector,double*,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetProjectForDraw(MFImplicitMF,int (*)(MFNVector,double*,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetProjectForBB(MFImplicitMF,int (*)(MFNVector,double*,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetVectorFactory(MFImplicitMF,MFNVector (*)(MFImplicitMF,MFErrorHandler),MFErrorHandler);
void MFIMFSetMatrixFactory(MFImplicitMF,MFNKMatrix (*)(MFImplicitMF,MFErrorHandler),MFErrorHandler);
MFNVector MFIMFVectorFactory(MFImplicitMF,MFErrorHandler);
MFNKMatrix MFIMFMatrixFactory(MFImplicitMF,MFErrorHandler);

void MFIMFSetSingular(MFImplicitMF,int (*)(int,int,MFNVector,MFNKMatrix,MFNVector,void*,MFErrorHandler),MFErrorHandler);
int MFIMFSingular(MFImplicitMF,MFNVector,MFNKMatrix,MFNVector,MFErrorHandler);

void MFIMFSetSetStability(MFImplicitMF,void (*)(MFImplicitMF,MFNVector,MFNKMatrix,void*,MFErrorHandler),MFErrorHandler);
void MFIMFSetStability(MFImplicitMF,MFNVector,MFNKMatrix,MFErrorHandler);

MFImplicitMF MFIMFCreateOrthogonalFoliation(IMFFlow,MFErrorHandler);


#ifdef __cplusplus
}
#endif

#endif
