#ifndef __MFERROR_H__
#define __MFERROR_H__
/*
    (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
    CORPORATION 06/21/2005.  ALL RIGHTS RESERVED.

    Please refer to the LICENSE file in the top directory
*/
/*      author: Mike Henderson mhender@watson.ibm.com */
/*      version: %W% %D% %T% */
/*      date:   June 21, 2005                     */


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

struct MFErrorHandlerSt;
typedef struct MFErrorHandlerSt *MFErrorHandler;

#ifdef __cplusplus
 extern "C" {
#endif

MFErrorHandler MFCreateErrorHandler();
void MFSetErroHandlerr(MFErrorHandler,int,char*,char*,int,char*);
void MFRefErrorHandler(MFErrorHandler);
void MFFreeErrorHandler(MFErrorHandler);
int MFGetNErrors(MFErrorHandler);
int MFErrorHandlerGetSev(MFErrorHandler,int);
char *MFErrorHandlerGetRoutine(MFErrorHandler,int);
char *MFErrorHandlerGetMsg(MFErrorHandler,int);
int MFErrorHandlerGetLine(MFErrorHandler,int);
char *MFErrorHandlerGetFile(MFErrorHandler,int);
int MFIsError(MFErrorHandler);
void MFClearErrors(MFErrorHandler);
void MFErrorHandlerOutOfMemory(MFErrorHandler);


#ifdef __cplusplus
}
#endif

#endif
