#ifndef __MFCONTINUATIONMETHOD__
#define __MFCONTINUATIONMETHOD__
#include <MFImplicitMF.h>
#include <MFNRegion.h>
#include <MFNVector.h>
#include <MFNKMatrix.h>
#include <MFErrorHandler.h>

struct MFContinuationMethodST;
typedef struct MFContinuationMethodST *MFContinuationMethod;

#ifdef __cplusplus
 extern "C" {
#endif

MFContinuationMethod MFCreateContinuationMethodBaseClass(char *type,MFErrorHandler);
void MFFreeContinuationMethod(MFContinuationMethod this,MFErrorHandler);
void MFRefContinuationMethod(MFContinuationMethod this,MFErrorHandler);
char *MFContinuationMethodGetType(MFContinuationMethod this,MFErrorHandler);
void *MFContinuationMethodGetParmBlock(MFContinuationMethod this,MFErrorHandler);
void MFContinuationMethodSetParmBlock(MFContinuationMethod this, void *parms,MFErrorHandler);
void MFContinuationMethodSetFreeParmBlock(MFContinuationMethod this, void (*FreeParmBlock)(void*,MFErrorHandler),MFErrorHandler);
void MFContinuationMethodSetExtendAtlasMultipleWithTangents(MFContinuationMethod this, void (*ExtendAtlasMultipleWithTangents)(struct MFContinuationMethodST*,MFAtlas,MFImplicitMF,MFNRegion,int,MFNVector*,MFNKMatrix*,MFErrorHandler),MFErrorHandler);
void MFContinuationMethodSetCloseAtlas(MFContinuationMethod this, void (*CloseAtlas)(struct MFContinuationMethodST*,MFAtlas,MFErrorHandler),MFErrorHandler);
void MFContinuationMethodSetFlushAtlas(MFContinuationMethod this, void (*FlushAtlas)(struct MFContinuationMethodST*,MFAtlas,MFErrorHandler),MFErrorHandler);

MFAtlas MFComputeAtlas(MFContinuationMethod H, MFImplicitMF M, MFNRegion Omega, MFNVector u0,MFErrorHandler);
MFAtlas MFComputeAtlasWithTangent(MFContinuationMethod H, MFImplicitMF M, MFNRegion Omega, MFNVector u0, MFNKMatrix Phi0,MFErrorHandler);
MFAtlas MFComputeAtlasMultiple(MFContinuationMethod H, MFImplicitMF M, MFNRegion Omega, int m, MFNVector *u0,MFErrorHandler);
MFAtlas MFComputeAtlasMultipleWithTangents(MFContinuationMethod H, MFImplicitMF M, MFNRegion Omega, int m, MFNVector *u0, MFNKMatrix *Phi0,MFErrorHandler);
void MFExtendAtlas(MFAtlas S, MFContinuationMethod H, MFImplicitMF M, MFNRegion Omega, MFNVector u0,MFErrorHandler);
void MFExtendAtlasMultiple(MFAtlas S, MFContinuationMethod H, MFImplicitMF M, MFNRegion Omega, int m, MFNVector *u0,MFErrorHandler);
void MFExtendAtlasWithTangent(MFAtlas S, MFContinuationMethod H, MFImplicitMF M, MFNRegion Omega, MFNVector u0,MFNKMatrix Phi0,MFErrorHandler);
void MFExtendAtlasMultipleWithTangents(MFAtlas S, MFContinuationMethod H, MFImplicitMF M, MFNRegion Omega, int m, MFNVector *u0, MFNKMatrix *Phi0,MFErrorHandler);
void MFFlushAtlas(MFContinuationMethod H, MFAtlas S,MFErrorHandler);
void MFCloseAtlas(MFContinuationMethod H, MFAtlas S,MFErrorHandler);

MFContinuationMethod MFCreateHendersonsMethod(MFErrorHandler);
void MFHendersonSetFilename(MFContinuationMethod,char*,MFErrorHandler);
char *MFHendersonGetFilename(MFContinuationMethod,MFErrorHandler);
void MFHendersonAddClipF(MFContinuationMethod,double (*)(MFNVector,MFErrorHandler),MFErrorHandler);
void MFHendersonClearClipF(MFContinuationMethod,MFErrorHandler);

int MFHendersonSetIntegerParameter(MFContinuationMethod,char*,int,MFErrorHandler);
int MFHendersonGetIntegerParameter(MFContinuationMethod,char*,MFErrorHandler);
int MFHendersonSetRealParameter(MFContinuationMethod,char*,double,MFErrorHandler);
double MFHendersonGetRealParameter(MFContinuationMethod,char*,MFErrorHandler);

#ifdef __cplusplus
}
#endif

#endif
