/* 
 *  @(#)MFChart.h	1.9
 *  03/01/02 10:14:58
 * 
 *  PROGRAM NAME:  multifario
 * 
 *  (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
 *  CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
 * 
 *  Please refer to the LICENSE file in the top directory
 *
 *
 *      author: Mike Henderson mhender@watson.ibm.com
 *      date:   February 18, 1999
 */

#ifndef __MFCHART_H__
#define __MFCHART_H__
#include <MFBase.h>

#include <MFNVector.h>
#include <MFKVector.h>
#include <MFNKMatrix.h>
#include <MFImplicitMF.h>
#include <MFPolytope.h>
#include <MFErrorHandler.h>
#include <stdio.h>

struct MFChartSt;
typedef struct MFChartSt *MFChart;

#ifdef __cplusplus
 extern "C" {
#endif

MFChart MFCreateChart(MFImplicitMF,MFNVector,MFNKMatrix,double,MFErrorHandler);
void MFSubtractHalfSpaceFromChart(MFChart,int,MFKVector,double,MFErrorHandler);

void MFRefChart(MFChart,MFErrorHandler);
void MFFreeChart(MFChart,MFErrorHandler);

MFPolytope MFChartPolytope(MFChart,MFErrorHandler);
MFNVector MFChartCenter(MFChart,MFErrorHandler);
double MFChartRadius(MFChart,MFErrorHandler);
MFNKMatrix MFChartTangentSpace(MFChart,MFErrorHandler);
int MFChartEvaluate(MFChart,MFKVector,MFNVector,MFErrorHandler);
int MFChartInterior(MFChart,MFKVector,MFErrorHandler);
int MFChartHasBoundary(MFChart,MFErrorHandler);
int MFChartK(MFChart,MFErrorHandler);
int MFChartN(MFChart,MFErrorHandler);
void MFChartProjectIntoTangentSpace(MFChart,MFNVector,MFKVector,MFErrorHandler);
void MFChartProjectVectorIntoTangentSpace(MFChart,MFNVector,MFKVector,MFErrorHandler);
void MFChartPointInTangentSpace(MFChart,MFKVector,MFNVector,MFErrorHandler);

void MFWriteChart(FILE*,MFChart,MFErrorHandler);
struct MFAtlasSt;
MFChart MFReadChart(FILE*,struct MFAtlasSt*,MFErrorHandler);

int MFChartGetPositionInBoundaryList(MFChart,MFErrorHandler);
void MFChartSetPositionInBoundaryList(MFChart,int,MFErrorHandler);
MFImplicitMF MFChartGetManifold(MFChart,MFErrorHandler);
int MFChartIsSingular(MFChart,MFErrorHandler);
void MFChartSetSingular(MFChart,MFErrorHandler);
void MFChartSetNonSingular(MFChart,MFErrorHandler);
void MFChartSetNonSingular(MFChart,MFErrorHandler);

void MFChartClean(MFChart,MFErrorHandler);
int MFChartPageOut(MFChart,FILE*,int,MFErrorHandler);
int MFChartPaged(MFChart,MFErrorHandler);

int MFChartNearBoundary(MFChart,MFErrorHandler);
void MFChartSetNearBoundary(MFChart,int,MFErrorHandler);

int MFChartNumberOfFaces(MFChart,MFErrorHandler);

double MFChartSuggestedRadius(MFChart,MFErrorHandler);
void MFSetSuggestedChartRadius(MFChart,double,MFErrorHandler);

int MFChartReferenceNumber(MFChart,MFErrorHandler);
void MFChartSetReferenceNumber(MFChart,int,MFErrorHandler);


#ifdef __cplusplus
}
#endif

#endif
