/* 
    @(#)MFBinaryTree.h	1.5
    02/07/26 09:10:35
   
    PROGRAM NAME:  Manifold
    
    (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
    CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
    
    Please refer to the LICENSE file in the top directory 

*/
/*      author: Mike Henderson mhender@watson.ibm.com */

#ifndef __MFBINARYTREE_H__
#define __MFBINARYTREE_H__
#include <MFBase.h>
#include <MFChart.h>
#include <MFListOfCharts.h>

#ifdef __cplusplus
 extern "C" {
#endif
#include <MFErrorHandler.h>

struct MFBinaryTreeSt;
typedef struct MFBinaryTreeSt *MFBinaryTree;

MFBinaryTree MFCreateBinaryTree(int,MFErrorHandler);
void MFFreeBinaryTree(MFBinaryTree,MFErrorHandler);

void MFBinaryTreeAddChart(MFBinaryTree,int,double*,double,MFErrorHandler);

MFListOfCharts MFCreateListOfIntersectingCharts(MFBinaryTree,int,double*,double,MFErrorHandler);
MFListOfCharts MFCreateListOfNearbyCharts(MFBinaryTree,double*,double,MFErrorHandler);

void MFWriteBinaryTree(FILE*,MFBinaryTree,MFErrorHandler);
MFBinaryTree MFReadBinaryTree(FILE*,MFErrorHandler);
void MFRecomputeBoundingBoxes(MFBinaryTree,int,double*,double,MFErrorHandler);


#ifdef __cplusplus
}
#endif

#endif
