/* 
    %W%
    %D% %T%

    PROGRAM NAME:  Manifold
   
    (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
    CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
   
    Please refer to the LICENSE file in the top directory

*/
/*      author: Mike Henderson mhender@watson.ibm.com */
/*      date:   February 22, 1999                     */

#ifndef __MFATLAS_H__
#define __MFATLAS_H__

#include <stdlib.h>
#include <MFBase.h>
#include <stdio.h>

#include <MFKVector.h>
#include <MFNVector.h>
#include <MFNRegion.h>
#include <MFNKMatrix.h>
#include <MFImplicitMF.h>
#include <MFErrorHandler.h>

#ifdef __cplusplus
 extern "C" {
#endif

struct MFAtlasSt;
typedef struct MFAtlasSt *MFAtlas;
#include <MFContinuationMethod.h>

MFAtlas MFCreateAtlas(MFImplicitMF,MFErrorHandler);
void MFFreeAtlas(MFAtlas,MFErrorHandler);
void MFRefAtlas(MFAtlas,MFErrorHandler);

int MFAtlasAddChart(MFAtlas,MFNVector,MFErrorHandler);
void MFAtlasReduceChartRadius(MFAtlas,int,double,MFErrorHandler);
/*int MFAtlasAddChartWithApproxTS(MFAtlas,MFNVector,MFNKMatrix,MFErrorHandler);*/
int MFAtlasAddChartWithApproxTS(MFAtlas,MFNVector,MFNKMatrix,double,double,MFErrorHandler);

int MFAtlasK(MFAtlas,MFErrorHandler);
int MFAtlasN(MFAtlas,MFErrorHandler);

MFImplicitMF MFAtlasMF(MFAtlas,MFErrorHandler);
int MFAtlasNumberOfCharts(MFAtlas,MFErrorHandler);
double MFAtlasChartRadius(MFAtlas,int,MFErrorHandler);
MFNVector MFAtlasChartCenter(MFAtlas,int,MFErrorHandler);
MFNVector MFAtlasCenterOfChart(MFAtlas,int,MFErrorHandler);
MFNKMatrix MFAtlasChartTangentSpace(MFAtlas,int,MFErrorHandler);
int MFAtlasIsPointInChart(MFAtlas,int,MFKVector,MFErrorHandler);
int MFAtlasIsChartNearBoundary(MFAtlas,int,MFErrorHandler);
void MFAtlasEvaluateChart(MFAtlas,int,MFKVector,MFNVector,MFErrorHandler);

int MFAtlasNumberOfChartNeighbors(MFAtlas,int,MFErrorHandler);
int MFAtlasChartNeighbor(MFAtlas,int,int,MFErrorHandler);

int MFAtlasNumberOfChartsWithBoundary(MFAtlas,MFErrorHandler);
int MFAtlasChartWithBoundary(MFAtlas,int,MFErrorHandler);

int MFAtlasPointOnBoundaryInsideRegion(MFAtlas,MFNRegion,MFNVector,MFNKMatrix*,double*,MFErrorHandler);

MFAtlas MFReadAtlas(FILE*,MFErrorHandler);
void MFWriteAtlas(FILE*,MFAtlas,MFErrorHandler);
void MFWriteChartCenters(FILE*,MFAtlas,MFErrorHandler);
int MFReadChartCenters(FILE*,MFNVector**,MFNKMatrix**,double**,MFErrorHandler);

void MFAtlasSetEpsilon(MFAtlas,double,MFErrorHandler);
void MFAtlasSetRMin(MFAtlas,double,MFErrorHandler);
void MFAtlasSetDotMin(MFAtlas,double,MFErrorHandler);
void MFAtlasSetVerbose(MFAtlas,int,MFErrorHandler);

void MFAtlasReduceChartRadius(MFAtlas,int,double,MFErrorHandler);

struct MFChartSt;

MFAtlas MFComputeAtlas(MFContinuationMethod,MFImplicitMF,MFNRegion,MFNVector,MFErrorHandler);
MFAtlas MFComputeAtlasWithTangent(MFContinuationMethod,MFImplicitMF,MFNRegion,MFNVector,MFNKMatrix,MFErrorHandler);
MFAtlas MFComputeAtlasMultiple(MFContinuationMethod,MFImplicitMF,MFNRegion,int,MFNVector*,MFErrorHandler);
MFAtlas MFComputeAtlasMultipleWithTangents(MFContinuationMethod,MFImplicitMF,MFNRegion,int,MFNVector*,MFNKMatrix*,MFErrorHandler);
MFAtlas MFAnimateAtlas(MFImplicitMF,MFNRegion,MFNVector,double,int,int,char*,int,int,int,MFErrorHandler);
MFAtlas MFComputeInvariantMap(MFImplicitMF,MFNRegion,MFNVector,MFNKMatrix,double,double,int,int,MFErrorHandler);

double MFVolumeOfChart(struct MFChartSt*,MFNRegion,MFErrorHandler);
double MFVolumeOfAtlas(MFAtlas,MFNRegion,MFErrorHandler);

int MFAtlasAddChartWithAll(MFAtlas,MFNVector,MFNKMatrix,double,MFErrorHandler);
int MFAtlasPointOnBoundaryWOProject(MFAtlas,MFNRegion,MFKVector,MFErrorHandler);

int MFComputePointsOn3dEdge(double,double**,double,double,double,double,double,double,MFErrorHandler);
int MFComputePointsOn3dPolygon(double,int,double*,int,double*,double*,double**,double**,MFErrorHandler);

MFNVector MFAtlasGetPointOnBoundaryChart(MFAtlas,MFNRegion,int,double,MFErrorHandler);
int MFAtlasGetSingularChartWithBoundary(MFAtlas,MFNRegion,MFErrorHandler);

void MFExtendAtlas(MFAtlas,MFContinuationMethod,MFImplicitMF,MFNRegion,MFNVector,MFErrorHandler);
void MFExtendAtlasMultiple(MFAtlas,MFContinuationMethod,MFImplicitMF,MFNRegion,int,MFNVector*,MFErrorHandler);
void MFExtendAtlasWithTangent(MFAtlas,MFContinuationMethod,MFImplicitMF,MFNRegion,MFNVector,MFNKMatrix,MFErrorHandler);
void MFExtendAtlasMultipleWithTangents(MFAtlas,MFContinuationMethod,MFImplicitMF,MFNRegion,int,MFNVector*,MFNKMatrix*,MFErrorHandler);
void MFCloseAtlas(MFContinuationMethod,MFAtlas,MFErrorHandler);
void MFFlushAtlas(MFContinuationMethod,MFAtlas,MFErrorHandler);

int MFAtlasIsChartSingular(MFAtlas,int,MFErrorHandler);
double MFAtlasChartSuggestedRadius(MFAtlas,int,MFErrorHandler);

void MFAtlasAddClipF(MFAtlas,double (*)(MFNVector,MFErrorHandler),MFErrorHandler);
void MFAtlasClearClipF(MFAtlas,MFErrorHandler);

void MFAtlasSetExpFactor(MFAtlas,double,MFErrorHandler);
double MFAtlasGetExpFactor(MFAtlas,MFErrorHandler);

void MFAtlasClosePlotfile(MFAtlas,MFErrorHandler);
void MFAtlasCloseCenterfile(MFAtlas,MFErrorHandler);

#ifdef __cplusplus
}
#endif

#endif
