#ifndef __IMFFLOW_H__
#define __IMFFLOW_H__
#include <MFNVector.h>
#include <MFNKMatrix.h>
#include <MFErrorHandler.h>

#ifdef __cplusplus
 extern "C" {
#endif

struct IMFFlowSt;
typedef struct IMFFlowSt *IMFFlow;
typedef void (*MFFlowFunction)(double*,double*,double*,void*,MFErrorHandler);
typedef void (*MFFlowFreeData)(void*,MFErrorHandler);

IMFFlow IMFCreateFlow(int,int,MFFlowFunction,MFFlowFunction,MFFlowFunction,MFFlowFunction,MFFlowFunction,void*,MFFlowFreeData,MFErrorHandler);
IMFFlow IMFCreateFatFlow(IMFFlow,int,MFErrorHandler);
IMFFlow IMFCreateBackwardFatFlow(IMFFlow,int,MFErrorHandler);
IMFFlow IMFCreateBackwardFlow(IMFFlow,MFErrorHandler);
void IMFFreeFlow(IMFFlow,MFErrorHandler);
void IMFRefFlow(IMFFlow,MFErrorHandler);
void IMFEvaluateFlow(IMFFlow,MFNVector,MFKVector,double*,MFErrorHandler);
void IMFEvaluateDerivativeOfFlow(IMFFlow,MFNVector,MFKVector,double*,MFErrorHandler);
void IMFEvaluateParameterDerivativeOfFlow(IMFFlow,MFNVector,MFKVector,double*,MFErrorHandler);
void IMFEvaluateSecondDerivativeOfFlow(IMFFlow,MFNVector,MFKVector,double*,MFErrorHandler);
void IMFEvaluateThirdDerivativeOfFlow(IMFFlow,MFNVector,MFKVector,double*,MFErrorHandler);
int IMFFlowNU(IMFFlow,MFErrorHandler);
int IMFFlowNP(IMFFlow,MFErrorHandler);
void *IMFFlowData(IMFFlow,MFErrorHandler);
MFFlowFreeData IMFFreeData(IMFFlow,MFErrorHandler);
double IMFFlowR(IMFFlow,double,MFNVector,MFKVector,MFNKMatrix,MFErrorHandler);

#ifdef __cplusplus
}
#endif

#endif
