#ifndef __IMFEXPANSION_H__
#define __IMFEXPANSION_H__
#include <MFAtlas.h>
#include <MFErrorHandler.h>

#ifdef __cplusplus
 extern "C" {
#endif

struct IMFExpansionSt;
typedef struct IMFExpansionSt *IMFExpansion;

IMFExpansion IMFCreateExpansion(int,int,MFErrorHandler);
void IMFFreeExpansion(IMFExpansion,MFErrorHandler);
void IMFRefExpansion(IMFExpansion,MFErrorHandler);

void IMFEvaluateExpansion(IMFExpansion,MFKVector,MFNVector,MFErrorHandler);
void IMFEvaluateExpansionDirectionalDerivative(IMFExpansion,MFKVector,MFKVector,MFNVector,MFErrorHandler);
void IMFEvaluateExpansionSecondDirectionalDerivative(IMFExpansion,MFKVector,MFKVector,MFKVector,MFNVector,MFErrorHandler);
void IMFEvaluateExpansionDerivative(IMFExpansion,MFKVector,int,MFNVector,MFErrorHandler);
void IMFEvaluateExpansionSecondDerivative(IMFExpansion,MFKVector,int,int,MFNVector,MFErrorHandler);
void IMFEvaluateExpansionThirdDerivative(IMFExpansion,MFKVector,int,int,int,MFNVector,MFErrorHandler);
void IMFEvaluateExpansionDirectionalDerivativeE(IMFExpansion,double*,double*,double*,MFErrorHandler);

int IMFExpansionN(IMFExpansion,MFErrorHandler);
int IMFExpansionK(IMFExpansion,MFErrorHandler);
int IMFExpansionOrder(IMFExpansion,MFErrorHandler);
double *IMFExpansionU(IMFExpansion,MFErrorHandler);
double *IMFExpansionDu(IMFExpansion,MFErrorHandler);
double *IMFExpansionDDu(IMFExpansion,MFErrorHandler);
double *IMFExpansionDDDu(IMFExpansion,MFErrorHandler);

void IMFExpnSetDerivatives(IMFExpansion,double*,double*,double*,double*,MFErrorHandler);
char *IMFC(double,char*,int*);
void IMFPrintExpansion(FILE*,IMFExpansion,MFErrorHandler);
IMFExpansion IMFCloneExpansion(IMFExpansion,MFErrorHandler);

IMFExpansion IMFRectifyExpansion(IMFExpansion,MFErrorHandler);
struct IMFFlowSt;
IMFExpansion IMFInflateExpansionWithFlow(IMFExpansion,struct IMFFlowSt*,MFKVector,MFErrorHandler);
double IMFExpansionR(IMFExpansion,double,MFErrorHandler);
MFNKMatrix IMFExpansionTS(IMFExpansion,MFErrorHandler);
double *IMFExpansionData(IMFExpansion,MFErrorHandler);
int IMFExpansionDataLn(IMFExpansion,MFErrorHandler);

#ifdef __cplusplus
}
#endif

#endif
