/*
 *
 *  PROGRAM NAME:  multifario
 *
 *  (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
 *  CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
 *
 *  Please refer to the LICENSE file in the top directory
 *
 *      author: Mike Henderson mhender@watson.ibm.com
 */

static char *id="@(#) $Id: MFDrawChartState.c 242 2006-08-15 21:16:26Z mhender $";

static char MFChartStateErrorMsg[256]="";

#include <MFDraw.h>
#include <MFDrawChartState.h>
#include <MFChart.h>
#include <MFPolytope.h>
#include <MFErrorHandler.h>
#include <sh.h>
#include <math.h>
#include <MFErrorHandler.h>
#include <stdlib.h>

struct MFChartStateSt
 {
  int r[128],g[128],b[128];
  MFChart chart;
  int nP;
  int mP;
  int *nV;
  float **pX;
  float **pY;
  float **pZ;
  int nNP;
  int mNP;
  int *nNV;
  float **pNX;
  float **pNY;
  float **pNZ;
  float **pNNrm;
  int *pc;
  int nL;
  float *lX;
  float *lY;
  float *lZ;
  int nPlns;
  int *gInd;
  int nVert;
 };

int MFDrawNCharts=0;
int MFDrawMCharts=0;
MFChartState *MFDrawChartList=NULL;

void MFFreeChartState(MFChartState,MFErrorHandler);

MFChartState MFCreateChartState(MFChart chart, MFErrorHandler e)
 {
  static char RoutineName[]={"MFCreateChartState"};
  MFChartState this;
  MFPolytope P;
  int color;
  int zero=0;
  int half=128;
  int full=255;
  int i;

  this=(MFChartState)malloc(sizeof(struct MFChartStateSt)); /*done*/

#ifndef MFNOSAFETYNET
  if(this==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to allocate %d bytes",sizeof(struct MFChartStateSt));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return NULL;
   }
#endif

  this->chart=chart;
  MFRefChart(chart,e);

  this->nP=0;
  this->mP=0;
  this->nV=NULL;
  this->pX=NULL;
  this->pY=NULL;
  this->pZ=NULL;

  this->nNP=0;
  this->mNP=0;
  this->nNV=NULL;
  this->pNX=NULL;
  this->pNY=NULL;
  this->pNZ=NULL;
  this->pNNrm=NULL;
  this->pc=NULL;

  this->nL=0;
  this->lX=NULL;
  this->lY=NULL;
  this->lZ=NULL;

  this->r[0]=half;
  this->g[0]=half;
  this->b[0]=half;

  P=MFChartPolytope(chart,e);
  this->nVert=MFPolytopeNumberOfVertices(P,e);
  this->nPlns=MFPolytopeNumberOfFaces(P,e);
  this->gInd=(int*)malloc(this->nPlns*sizeof(int)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->nPlns>0&&this->gInd==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to allocate %d bytes",this->nPlns*sizeof(int));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return NULL;
   }
#endif

  for(i=0;i<this->nPlns;i++)
   this->gInd[i]=MFPolytopeFaceIndex(P,i,e);

  return(this);
 }

MFChartState MFAddChartState(MFChart chart, MFErrorHandler e)
 {
  static char RoutineName[]={"MFAddChartState"};
  if(MFDrawNCharts==MFDrawMCharts)
   {
    MFDrawMCharts+=10;
    MFDrawChartList=realloc((void*)MFDrawChartList,MFDrawMCharts*sizeof(MFChartState)); /*done*/

#ifndef MFNOSAFETYNET
    if(MFDrawChartList==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",MFDrawMCharts*sizeof(MFChartState));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return NULL;
     }
#endif

   }
  MFDrawChartList[MFDrawNCharts]=MFCreateChartState(chart,e);
  MFDrawNCharts++;

  return MFDrawChartList[MFDrawNCharts-1];
 }

int MFNChartStates(MFErrorHandler e)
 {
  static char RoutineName[]={"MFNChartStates"};

  return MFDrawNCharts;
 }

void MFClearChartState(MFChartState this, MFErrorHandler e)
 {
  static char RoutineName[]={"MFClearChartState"};
  MFPolytope P;
  int i;

  if(this->nP>0)
   {
    if(this->pX!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pX)[i]!=NULL)free((this->pX)[i]);
      free(this->pX);this->pX=NULL;
     }
    if(this->pY!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pY)[i]!=NULL)free((this->pY)[i]);
      free(this->pY);this->pY=NULL;
     }
    if(this->pZ!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pZ)[i]!=NULL)free((this->pZ)[i]);
      free(this->pZ);this->pZ=NULL;
     }
    if(this->nV!=NULL){free(this->nV);this->nV=(int*)NULL;}
   }
  this->nP=0;
  this->mP=0;

  if(this->nNP>0)
   {
    if(this->pNX!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pNX)[i]!=NULL)free((this->pNX)[i]);
      free(this->pNX);this->pNX=NULL;
     }
    if(this->pNY!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pNY)[i]!=NULL)free((this->pNY)[i]);
      free(this->pNY);this->pNY=NULL;
     }
    if(this->pNZ!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pNZ)[i]!=NULL)free((this->pNZ)[i]);
      free(this->pNZ);this->pNZ=NULL;
     }
    if(this->pNNrm!=NULL)
     {
      for(i=0;i<this->nNP;i++)
       if((this->pNNrm)[i]!=NULL)free((this->pNNrm)[i]);
      free(this->pNNrm);this->pNNrm=NULL;
     }
    if(this->nNV!=NULL){free(this->nNV);this->nNV=(int*)NULL;}
    if(this->pc!=NULL){free(this->pc);this->pc=(int*)NULL;}
   }
  this->nNP=0;
  this->mNP=0;

  this->nL=0;
  if(this->lX!=NULL){free(this->lX);this->lX=(float*)NULL;}
  if(this->lY!=NULL){free(this->lY);this->lY=(float*)NULL;}
  if(this->lZ!=NULL){free(this->lZ);this->lZ=(float*)NULL;}


  P=MFChartPolytope(this->chart,e);
  this->nVert=MFPolytopeNumberOfVertices(P,e);
  this->nPlns=MFPolytopeNumberOfFaces(P,e);
  if(this->gInd!=NULL)free(this->gInd);
  this->gInd=(int*)malloc(this->nPlns*sizeof(int)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->gInd==NULL&&this->nPlns>0)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to allocate %d bytes",this->nPlns*sizeof(int));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return;
   }
#endif

  for(i=0;i<this->nPlns;i++)
   this->gInd[i]=MFPolytopeFaceIndex(P,i,e);

  return;
 }

void MFFreeChartState(MFChartState this, MFErrorHandler e)
 {
  static char RoutineName[]={"MFFreeChartState"};
  MFPolytope P;
  int i;

  if(this->nP>0)
   {
    if(this->pX!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pX)[i]!=NULL)free((this->pX)[i]);
      free(this->pX);this->pX=NULL;
     }
    if(this->pY!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pY)[i]!=NULL)free((this->pY)[i]);
      free(this->pY);this->pY=NULL;
     }
    if(this->pZ!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pZ)[i]!=NULL)free((this->pZ)[i]);
      free(this->pZ);this->pZ=NULL;
     }
    if(this->nV!=NULL){free(this->nV);this->nV=(int*)NULL;}
   }
  this->nP=0;
  this->mP=0;

  if(this->nNP>0)
   {
    if(this->pNX!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pNX)[i]!=NULL)free((this->pNX)[i]);
      free(this->pNX);this->pNX=NULL;
     }
    if(this->pNY!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pNY)[i]!=NULL)free((this->pNY)[i]);
      free(this->pNY);this->pNY=NULL;
     }
    if(this->pNZ!=NULL)
     {
      for(i=0;i<this->nP;i++)
       if((this->pNZ)[i]!=NULL)free((this->pNZ)[i]);
      free(this->pNZ);this->pNZ=NULL;
     }
    if(this->pNNrm!=NULL)
     {
      for(i=0;i<this->nNP;i++)
       if((this->pNNrm)[i]!=NULL)free((this->pNNrm)[i]);
      free(this->pNNrm);this->pNNrm=NULL;
     }
    if(this->nNV!=NULL){free(this->nNV);this->nNV=(int*)NULL;}
    if(this->pc!=NULL){free(this->pc);this->pc=(int*)NULL;}
   }
  this->nNP=0;
  this->mNP=0;

  this->nL=0;
  if(this->lX!=NULL){free(this->lX);this->lX=(float*)NULL;}
  if(this->lY!=NULL){free(this->lY);this->lY=(float*)NULL;}
  if(this->lZ!=NULL){free(this->lZ);this->lZ=(float*)NULL;}

  this->nVert=0;
  this->nPlns=0;
  if(this->gInd!=NULL)free(this->gInd);

  free(this);

  return;
 }

void MFSetChartStateColor(MFChartState this,int c,int r,int g,int b, MFErrorHandler e)
 {
  static char RoutineName[]={"MFSetChartStateColor"};

  this->r[c]=r;
  this->g[c]=g;
  this->b[c]=b;
  return;
 }

void MFGetChartStateColor(MFChartState this,int c,int *r,int *g,int *b, MFErrorHandler e)
 {
  static char RoutineName[]={"MFGetChartStateColor"};

  *r=this->r[c];
  *g=this->g[c];
  *b=this->b[c];
  return;
 }

void MFChartStateAddPolygon(MFChartState this,int n,float *x,float *y,float *z,int c, MFErrorHandler e)
 {
  static char RoutineName[]={"MFChartStateAddPolygon"};
  int i;

  for(i=0;i<n-1;i++)
   if(0 && sqrt((x[i+1]-x[i])*(x[i+1]-x[i])
          +(y[i+1]-y[i])*(y[i+1]-y[i])
          +(z[i+1]-z[i])*(z[i+1]-z[i]))>1.)return;

  if(this->nP+1>this->mP)
   {
    this->mP+=1000;
    this->nV=realloc((void*)(this->nV),this->mP*sizeof(int)); /*done*/

#ifndef MFNOSAFETYNET
    if(this->nV==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",this->mP*sizeof(int));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return;
     }
#endif

    this->pX=realloc((void*)(this->pX),this->mP*sizeof(float*)); /*done*/

#ifndef MFNOSAFETYNET
    if(this->pX==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",this->mP*sizeof(float*));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return;
     }
#endif

    this->pY=realloc((void*)(this->pY),this->mP*sizeof(float*)); /*done*/

#ifndef MFNOSAFETYNET
    if(this->pY==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",this->mP*sizeof(float*));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return;
     }
#endif

    this->pZ=realloc((void*)(this->pZ),this->mP*sizeof(float*)); /*done*/

#ifndef MFNOSAFETYNET
    if(this->pZ==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",this->mP*sizeof(float*));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return;
     }
#endif

    this->pc=(int*)malloc(this->mP*sizeof(int)); /*done*/

#ifndef MFNOSAFETYNET
    if(this->pc==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to allocate %d bytes",n*sizeof(int));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return;
     }
#endif

   }

  this->nV[this->nP]=n;
  this->pX[this->nP]=(float*)malloc(n*sizeof(float)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->pX[this->nP]==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to allocate %d bytes",n*sizeof(float));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return;
   }
#endif

  this->pY[this->nP]=(float*)malloc(n*sizeof(float)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->pY[this->nP]==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to allocate %d bytes",n*sizeof(float));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return;
   }
#endif

  this->pZ[this->nP]=(float*)malloc(n*sizeof(float)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->pZ[this->nP]==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to allocate %d bytes",n*sizeof(float));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return;
   }
#endif

  for(i=0;i<n;i++)
   {
    (this->pX[this->nP])[i]=x[i];
    (this->pY[this->nP])[i]=y[i];
    (this->pZ[this->nP])[i]=z[i];
   }
  this->pc[this->nP]=c;
  this->nP++;
  return;
 }

void MFChartStateAddPolygonWithNormal(MFChartState this,int n,float *x,float *y,float *z,float *nrm, int c, MFErrorHandler e)
 {
  static char RoutineName[]={"MFChartStateAddPolygonWithNormal"};
  int i;

  for(i=0;i<n-1;i++)
   if(0 && sqrt((x[i+1]-x[i])*(x[i+1]-x[i])
          +(y[i+1]-y[i])*(y[i+1]-y[i])
          +(z[i+1]-z[i])*(z[i+1]-z[i]))>1.)return;

  if(this->nNP+1>this->mNP)
   {
    this->mNP+=1000;
    this->nNV=realloc((void*)(this->nNV),this->mNP*sizeof(int)); /*done*/

#ifndef MFNOSAFETYNET
    if(this->nNV==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",this->mNP*sizeof(int));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return;
     }
#endif

    this->pNX=realloc((void*)(this->pNX),this->mNP*sizeof(float*)); /*done*/

#ifndef MFNOSAFETYNET
    if(this->pNX==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",this->mNP*sizeof(float*));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return;
     }
#endif

    this->pNY=realloc((void*)(this->pNY),this->mNP*sizeof(float*)); /*done*/

#ifndef MFNOSAFETYNET
    if(this->pNY==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",this->mNP*sizeof(float*));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return;
     }
#endif

    this->pNZ=realloc((void*)(this->pNZ),this->mNP*sizeof(float*)); /*done*/

#ifndef MFNOSAFETYNET
    if(this->pNZ==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",this->mNP*sizeof(float*));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return;
     }
#endif

    this->pNNrm=realloc((void*)(this->pNNrm),this->mNP*sizeof(float*)); /*done*/

#ifndef MFNOSAFETYNET
    if(this->pNNrm==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",this->mNP*sizeof(float*));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return;
     }
#endif

    this->pc=realloc((void*)(this->pc),this->mNP*sizeof(int)); /*done*/

#ifndef MFNOSAFETYNET
    if(this->pc==NULL)
     {
      sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",this->mNP*sizeof(int));
      MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
      MFErrorHandlerOutOfMemory(e);
      return;
     }
#endif

   }

  this->nNV[this->nNP]=n;
  this->pNX[this->nNP]=(float*)malloc(n*sizeof(float)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->pNX[this->nNP]==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to allocate %d bytes",n*sizeof(float));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return;
   }
#endif

  this->pNY[this->nNP]=(float*)malloc(n*sizeof(float)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->pNY[this->nNP]==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to allocate %d bytes",n*sizeof(float));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return;
   }
#endif

  this->pNZ[this->nNP]=(float*)malloc(n*sizeof(float)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->pNZ[this->nNP]==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to allocate %d bytes",n*sizeof(float));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return;
   }
#endif

  this->pNNrm[this->nNP]=(float*)malloc(3*n*sizeof(float)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->pNNrm[this->nNP]==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to allocate %d bytes",3*n*sizeof(float));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return;
   }
#endif

  for(i=0;i<n;i++)
   {
    (this->pNX[this->nNP])[i]=x[i];
    (this->pNY[this->nNP])[i]=y[i];
    (this->pNZ[this->nNP])[i]=z[i];
    (this->pNNrm[this->nNP])[3*i]=nrm[3*i];
    (this->pNNrm[this->nNP])[3*i+1]=nrm[3*i+1];
    (this->pNNrm[this->nNP])[3*i+1]=nrm[3*i+2];
   }
  this->pc[this->nP]=c;
  this->nNP++;
  return;
 }

void MFChartStateAddLine(MFChartState this,float x0,float y0,float z0,float x1,float y1,float z1, MFErrorHandler e)
 {
  static char RoutineName[]={"MFChartStateAddLine"};
  if(0 && sqrt((x1-x0)*(x1-x0)+(y1-y0)*(y1-y0)+(z1-z0)*(z1-z0))>1.)return;

  this->lX=realloc((void*)(this->lX),2*(this->nL+1)*sizeof(float)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->lX==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",2*(this->nL+1)*sizeof(float));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return;
   }
#endif

  this->lY=realloc((void*)(this->lY),2*(this->nL+1)*sizeof(float)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->lY==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",2*(this->nL+1)*sizeof(float));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return;
   }
#endif

  this->lZ=realloc((void*)(this->lZ),2*(this->nL+1)*sizeof(float)); /*done*/

#ifndef MFNOSAFETYNET
  if(this->lZ==NULL)
   {
    sprintf(MFChartStateErrorMsg,"Out of memory, trying to reallocate %d bytes",2*(this->nL+1)*sizeof(float));
    MFSetError(e,12,RoutineName,MFChartStateErrorMsg,__LINE__,__FILE__);
    MFErrorHandlerOutOfMemory(e);
    return;
   }
#endif


  this->lX[2*this->nL]=x0;
  this->lY[2*this->nL]=y0;
  this->lZ[2*this->nL]=z0;
  this->lX[2*this->nL+1]=x1;
  this->lY[2*this->nL+1]=y1;
  this->lZ[2*this->nL+1]=z1;
  this->nL++;
  return;
 }

MFChartState MFGetChartState(int i, MFErrorHandler e)
 {
  static char RoutineName[]={"MFGetChartState"};
  return MFDrawChartList[i];
 }

int MFChartStateChanged(MFChartState this, MFErrorHandler e)
 {
  static char RoutineName[]={"MFChartStateChanged"};
  MFPolytope P;
  int i;

  P=MFChartPolytope(this->chart,e);

  if(MFPolytopeNumberOfVertices(P,e)!=this->nVert)return 1;
  if(MFPolytopeNumberOfFaces(P,e)!=this->nPlns)return 1;

  for(i=0;i<this->nPlns;i++)
    if(MFPolytopeFaceIndex(P,i,e)!=this->gInd[i])return 1;

  return 0;
 }

void MFDrawChartFromState(MFChartState this, MFErrorHandler e)
 {
  static char RoutineName[]={"MFDrawChartFromState"};
  int i,n;
  int full=255;
  int zero=0;

  for(i=0;i<this->nP;i++)
   {
    shtric(&(this->r[this->pc[i]]),&(this->g[this->pc[i]]),&(this->b[this->pc[i]]));
    shpg(this->nV+i,(this->pX)[i],(this->pY)[i],(this->pZ)[i]);
   }

  shpgc(&full,&full,&zero);
  shpec(&full,&full,&zero);
  shbgc(&full,&full,&zero);
  shbec(&full,&full,&zero);
  for(i=0;i<this->nNP;i++)
   shpg(this->nNV+i,(this->pNX)[i],(this->pNY)[i],(this->pNZ)[i]);
/* shpgnrm(this->nNV+i,(this->pNX)[i],(this->pNY)[i],(this->pNZ)[i],(this->pNNrm)[i]);*/

  shlinc(&zero,&zero,&zero);
  for(i=0;i<this->nL;i++)
   shline(this->lX+2*i,this->lY+2*i,this->lZ+2*i,this->lX+2*i+1,this->lY+2*i+1,this->lZ+2*i+1);

  return;
 }

void MFFreeDrawCharts(MFErrorHandler e)
 {
  static char RoutineName[]={"MFFreeDrawCharts"};
  int i;

  for(i=0;i<MFDrawNCharts;i++)MFFreeChartState(MFDrawChartList[i],e);
  if(MFDrawChartList!=NULL)free(MFDrawChartList);
  MFDrawNCharts=0;
  MFDrawMCharts=0;
  MFDrawChartList=NULL;

  return;
 }
