/* 
    @(#)MFAnimate.c	1.6
    03/02/19 10:59:22
   
    PROGRAM NAME:  multifario

    (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
    CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.

    Please refer to the LICENSE file in the top directory
*/
/*      author: Mike Henderson mhender@watson.ibm.com */

#include <MFAtlas.h>
#include <MFImplicitMF.h>
#include <MFNRegion.h>
#include <MFNVector.h>
#include <MFPrint.h>
#include <stdio.h>
#include <MFDraw.h>
#include <MFEnumPolytope.h>
#include <MFEnumDualPolytope.h>
#include <math.h>
#include <sh.h>
#include <string.h>

MFAtlas MFAnimateAtlas(MFImplicitMF M, MFNRegion Omega, MFNVector u0, double epsilon, int kmax, int verbose, char *stub, int DrawSimp, int DrawAfter, int DrawEvery, MFErrorHandler e)
 {
  int kkk;
  double delta=0.;
  int chart;
  int n;
  MFAtlas S;
  MFNVector u;
  MFNKMatrix Phi;
  FILE *fid;
  double volume;
  MFEnumDualPolytope P;
  int Draw;
  char *filename="";

/*shSetOutputResolution(4096,4096);*/
/*shSetOutputResolution(8192,8192);*/
  shSetOutputResolution(800,800);
  filename=(char*)malloc((strlen(stub)+5)*sizeof(char));
  shSetOutputFormat("tiff");
  MFDrawInitializeFromFile(stub,e);
  if(MFIMF_N(M,e)==MFIMF_K(M,e) && MFIMF_N(M,e)==2){
   float a,d,s;
   int n;
   a=1.;d=0.;s=0.;n=1;
   shsrfp(&a,&d,&s,&n);
  }

  kkk=0;
  S=MFCreateAtlas(M,e);
  MFAtlasSetEpsilon(S,epsilon,e);
  if(verbose){printf("%d) Add initial point to Atlas ",kkk);MFPrintNVector(stdout,u0,e);printf("\n");fflush(stdout);}
  MFAtlasAddChart(S,u0,e);
  if(kkk>=DrawAfter)
   {
    sprintf(filename,"%s%4.4d",stub,0);shSetOutputFilename(filename);
    MFDrawAtlasOnce(S,e);MFDrawDisplay(e);
   }
#ifdef MFVOLUME
  volume=MFVolumeOfAtlas(S,Omega,e);
  if(verbose){printf("  Volume of Atlas %lf\n",volume);fflush(stdout);}
#endif
  kkk++;

  n=MFAtlasN(S,e);
  u=MFCreateNVector(n,e);
  while((kmax<0||kkk<kmax)&&(chart=MFAtlasPointOnBoundaryInsideRegion(S,Omega,u,&Phi,&delta,e))>-1)
   {
    if(verbose){printf("%d) Add boundary point to Atlas ",kkk);MFPrintNVector(stdout,u,e);printf("\n");fflush(stdout);}
    MFAtlasAddChartWithApproxTS(S,u,MFAtlasChartTangentSpace(S,chart,e),delta,MFAtlasChartRadius(S,chart,e),e);
#ifdef MFVOLUME
    volume=MFVolumeOfAtlas(S,Omega,e);
    if(verbose){printf("  Volume of Atlas %lf\n",volume);fflush(stdout);}
#endif
    if(kkk%DrawEvery==0 && kkk>=DrawAfter)
     {
      MFDrawClear(e);
      MFDrawAtlasOnce(S,e);
      if(DrawSimp)
       {
        P=MFEnumDualOfAtlas(S,e);
        MFDrawEnumDualPolytopeEdges(P,e);
        MFFreeEnumDualPolytope(P,e);
       }
      sprintf(filename,"%s%4.4d",stub,kkk);shSetOutputFilename(filename);
      MFDrawDisplay(e);
     }
    kkk++;
/*  if(kkk%1000==0)
     {
      printf("Check pointing, step %d\n",kkk);fflush(stdout);
      fid=fopen("Checkpoint.atlas","w");
      MFWriteAtlas(fid,S,e);
      fclose(fid);
      printf("Done check pointing\n");fflush(stdout);
     }*/

    MFFreeNVector(u,e);
    u=MFCreateNVector(n,e);
   }
  if(verbose&&chart<0){printf("No more points on the boundary\n");fflush(stdout);}
   else if(verbose){printf("Maximum number of charts added (%d)\n",kkk);fflush(stdout);}

  MFDrawClear(e);
  MFDrawAtlasOnce(S,e);
  if(DrawSimp)
   {
    P=MFEnumDualOfAtlas(S,e);
    MFDrawEnumDualPolytopeEdges(P,e);
    MFFreeEnumDualPolytope(P,e);
   }
  sprintf(filename,"%s%4.4d",stub,kkk);shSetOutputFilename(filename);
  MFDrawDisplay(e);
  MFDrawClose(e);

  MFFreeErrorHandler(e);

  return S;
 }
