/* 
 *  @(#)DrawAtlas.c	1.2
 *  99/11/01 12:11:13
 * 
 *  author: Mike Henderson mhender@watson.ibm.com
 */

#include <MFAtlas.h>
#include <MFAtlas.h>
#include <MFImplicitMF.h>
#include <MFNRegion.h>
#include <MFNVector.h>
#include <MFPrint.h>
#include <MFDraw.h>
#include <MFEnumPolytope.h>
#include <MFEnumDualPolytope.h>
#include <MFDX.h>
#include <math.h>
#include <errno.h>
#include <string.h>
#include <sh.h>

int main(int argc, char *argv[])
 {
  float xmin,xmax,dist,alpha,beta;
  int gray;
  MFAtlas S;
  FILE *fid;
  char name[1024]="";

/*printf("%s %s\n",argv[0],argv[1]);*/

  if(argc<2)
   {
    fprintf(stderr,"%s, no atlas file specified\n",argv[0]);
    return 0;
   }
  strcpy(name,argv[1]);
  strcat(name,".atlas");

  fid=fopen(name,"r");
  if(fid==(FILE*)NULL)
   {
    printf("Error, could not open file %s, %s\n",name,strerror(errno));
    fflush(stdout);
    return 12;
   }
  printf("Reading Atlas %s\n",argv[1]);fflush(stdout);
  S=MFReadAtlas(fid);
  fclose(fid);
  printf("Done reading Atlas, %d charts\n",MFAtlasNumberOfCharts(S));fflush(stdout);

  volume=MFVolumeOfAtlas(S,Omega);
  printf("Volume is  %le\n",volume);fflush(stdout);

  MFFreeAtlas(S);
  MFDrawClose();

  return(0);
 }
