/* 
 *  @(#)DrawChemicalReactor.c	1.1
 *  99/10/13 16:31:58
 * 
 *  author: Mike Henderson mhender@watson.ibm.com
 */

#include <sh.h>
#include <math.h>
#include <MFDraw.h>

void tricon(float *s,int *ldx,int *ldy,int *ldz,int *nx,int *ny,int *nz,float *xl,float *xr,float *yl,float *yr,float *zl,float *zr,float *v,int *nl,float *h,int *ired,int *igrn,int *iblu,int *iered,int *iegrn,int *ieblu,float *vol,float *area,int *contour,int *volume);

double f(double x,double y, double z)
 {
  double f;
  double Rxy=.8;
  double Rz=.5;

  f = x*x+y*y-z*z;
  f =     y*y-z*z;
  f = .01*x*x*x+   y*y-z*z;
  f=(sqrt(x*x+y*y)-Rxy)*(sqrt(x*x+y*y)-Rxy)+z*z -Rz*Rz;

  return f;
 }


int main(int argc, char *argv[])
 {
  float *s;
  int nx,ny,nz;
  int ldx,ldy,ldz;
  int i,j,k;
  float xl,xr;
  float yl,yr;
  float zl,zr;
  float x,y,z,dx,dy,dz;
  float v;
  int nl;
  float h;
  int red,green,blue;
  float vol=0.;
  float area=0.;
  int contour,volume;
  int zero=0;
  int half=100;
  int full=255;
  float d,a,b;

  xl=-1.4;
  xr= 1.4;

  yl=xl;
  yr=xr;

  zl=xl;
  zr=xr;

  nx=20;
  ny=20;
  nz=20;

  ldx=nx+1;
  ldy=ny+1;
  ldz=nz+1;

  dx=(xr-xl)/nx;
  dy=(yr-yl)/ny;
  dz=(zr-zl)/nz;

  contour=TRUE;
  volume=FALSE;
  red=zero;
  green=zero;
  blue=full;
  red=180;
  green=180;
  blue=205;
  nl=1;
  v=0.;
  h=0.;

  s=(float*)malloc((ldx+3)*(ldy+3)*(ldz+3)*sizeof(float));
  shSetOutputResolution(4096,4096);
  shSetOutputFormat("tiff");

  MFDrawInitializeFromFile((char*)"Torus");
/*shinit(&full,&full,&full);*/
  shSetOutputFilename("Torus");
/*d=100.;
  a=10.;
  b=20.;
  shview(&d,&a,&b,&xl,&xr,&yl,&yr,&zl,&zr);
  shlinc(&zero,&zero,&zero);
  shcube(&xl,&xr,&yl,&yr,&zl,&zr);*/

  for(i=0;i<ldx+3;i++)
    for(j=0;j<ldy+3;j++)
      for(k=0;k<ldz+3;k++)
       {
        x=xl+(i-2)*dx;
        y=yl+(j-2)*dy;
        z=zl+(k-2)*dz;
        s[i+(ldx+3)*(j+(ldy+3)*k)]=f(x,y,z);
       }

  tricon(s,&ldx,&ldy,&ldz,&nx,&ny,&nz,&xl,&xr,&yl,&yr,&zl,&zr,&v,&nl,&h,&red,&green,&blue,&full,&full,&full,&vol,&area,&contour,&volume);

  shpause();
  shend();

  return(0);
 }
