/*      author: Mike Henderson mhender@watson.ibm.com */

#include <MFAtlas.h>
#include <MFAtlasFriends.h>
#include <MFNRegion.h>
#include <MFNVector.h>
#include <MFEnumPolytope.h>
#include <MFEnumDualPolytope.h>
#include <math.h>
#include <MFDraw.h>
#include <sh.h>

/* nV,v are all of the vertices */
/* nE,e are all of the edges */
/* nP,P are the edges in the bounding polygon */

MFEnumDualPolytope GenerateMeshOnSphere(int nV, double *v,double r)
 {
  MFEnumDualPolytope mesh;
  FILE *fid;
  int i;
  MFImplicitMF M;
  MFNRegion Omega;
  MFAtlas A;
  MFNVector u;
  int kkk;
  MFNKMatrix Phi;
  double R;

  R=sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);
  M=MFIMFCreateSphere(0.,0.,0.,R);
  Omega=MFNRegionCreateCube(-1.1*R,-1.1*R,-1.1*R,1.1*R,1.1*R,1.1*R);
  A=MFCreateAtlas(M);

  kkk=0;
  for(i=0;i<nV;i++)
   {
    u=MFCreateNVector(3);
    MFNVSetC(u,0,v[3*i  ]);
    MFNVSetC(u,1,v[3*i+1]);
    MFNVSetC(u,2,v[3*i+2]);
    Phi=MFIMFTangentSpace(M,u);

    MFAtlasAddChartWithAll(A,u,Phi,r); 
    kkk++;
    MFFreeNVector(u);
    MFFreeNKMatrix(Phi);
   }

  fid=fopen("meshgen.atlas","w");
  MFWriteAtlas(fid,A);
  fclose(fid);

  mesh=MFEnumDualOfAtlas(A);

  MFFreeAtlas(A);
  MFFreeImplicitMF(M);
  MFFreeNRegion(Omega);

  return mesh;
 }

MFEnumDualPolytope GenerateMeshOnSphere3d(int nV, double *v,double r)
 {
  MFEnumDualPolytope mesh;
  FILE *fid;
  int i;
  MFImplicitMF M;
  MFNRegion Omega;
  MFAtlas A;
  MFNVector u;
  int kkk;
  MFNKMatrix Phi;
  double R;

  R=sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);
  M=MFIMFCreateNSpace(3);
  Omega=MFNRegionCreateCube(-R-r,-R-r,-R-r,R+r,R+r,R+r);
  A=MFCreateAtlas(M);

  kkk=0;
  for(i=0;i<nV;i++)
   {
    u=MFCreateNVector(3);
    MFNVSetC(u,0,v[3*i  ]);
    MFNVSetC(u,1,v[3*i+1]);
    MFNVSetC(u,2,v[3*i+2]);
    Phi=MFIMFTangentSpace(M,u);

    MFAtlasAddChartWithAll(A,u,Phi,r); 
    kkk++;
    MFFreeNVector(u);
    MFFreeNKMatrix(Phi);
   }

  fid=fopen("meshgen.atlas","w");
  MFWriteAtlas(fid,A);
  fclose(fid);

  mesh=MFEnumDualOfAtlas(A);

  MFFreeAtlas(A);
  MFFreeImplicitMF(M);
  MFFreeNRegion(Omega);

  return mesh;
 }
