#include <stdlib.h>
#include <MFMesh.h>
#include <MFDX.h>
#include <math.h>

int main(int argc, char *argv[])
 {
  MFEnumDualPolytope mesh;
  int i;
  int nV,mV;
  double *v;
  double lon,lat;
  FILE *fid;
  char name[255];
  double R;

  printf("%d %s %s %s\n",argc,argv[0],argv[1],argv[2]);

  strcpy(name,argv[1]);
  strcat(name,".sphere");
  if(argc<2)
   {
    printf("%s -- You must give the name of a file\n",argv[0]);
    return 8;
   }
  if((fid=fopen(name,"r"))==NULL)
   {
    printf("%s Could not open input file %s\n",argv[0],name);
    return 8;
   }

  R=.1;
  if(argc>2)
   {
    sscanf(argv[2],"%lf",&R);
   }

  printf("input file opened normally\n");
  mV=100;
  v=(double*)malloc(3*mV*sizeof(double));
  nV=0;
  while(!feof(fid))
   {
    if(!(nV<mV))
     {
      mV+=100;
      v=(double*)realloc((void*)v,3*mV*sizeof(double));
     }
    fscanf(fid,"%lf %lf %d %d\n",&lat,&lon,&i,&i);
    v[3*nV  ]=cos(lat)*cos(lon);
    v[3*nV+1]=cos(lat)*sin(lon);
    v[3*nV+2]=sin(lat);
    nV++;
   }

  printf("Closing input file nV=%d\n",nV);
  fclose(fid);
  printf("Radius is %lf\n",&R);

/*nV=10;*/
  mesh=GenerateMeshOnSphere3d(nV,v,R);

  printf("Result has %d vertices\n",MFEnumDualPolytopeNumberOfVertices(mesh));
  printf("           %d edges\n",MFEnumDualPolytopeNumberOfCells(mesh,1));
  printf("           %d faces\n",MFEnumDualPolytopeNumberOfCells(mesh,2));
  fflush(stdout);

  strcpy(name,argv[1]);
  strcat(name,".dx");
  MFDualPolytopeToDXFile(name,mesh);
  MFFreeEnumDualPolytope(mesh);

  return 0;
 }
