/* 
    %W%
    %D% %T%
   
    PROGRAM NAME:  multifario

    (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
    CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.

    Please refer to the LICENSE file in the top directory

*/
/*      author: Mike Henderson mhender@watson.ibm.com */

#include <MFAtlas.h>
#include <MFNRegion.h>
#include <MFNVector.h>
#include <math.h>

int main(int argc, char *argv[])
 {
  MFImplicitMF M;
  int n;
  MFNRegion Omega;
  MFAtlas S;
  MFNVector u0[2];
  FILE *fid;
  MFContinuationMethod H;
  MFErrorHandler e;

  e=MFCreateErrorHandler();

/*M=MFIMFCreateAlgebraicExpression("[x,y,z]","[(z-x)*(x+y+z)]",e);*/
  M=MFIMFCreateAlgebraicExpression("[x,y,z]","[(z-x-.5*(y-1)*(y-1))*(x+y+z)]",e);
  n=MFIMF_N(M,e);
  Omega=MFNRegionCreateHyperCube(n,1.1,e);

  u0[0]=MFIMFVectorFactory(M,e);
  MFNVSetC(u0[0],0, 0.,e);
  MFNVSetC(u0[0],1, 1.,e);
  MFNVSetC(u0[0],2,-1.,e);

  u0[1]=MFIMFVectorFactory(M,e);
  MFNVSetC(u0[1],0, 1.,e);
  MFNVSetC(u0[1],1, 1.,e);
  MFNVSetC(u0[1],2, 1.,e);

  H=MFCreateHendersonsMethod(e);
  MFHendersonSetRealParameter(H,"epsilon",.01,e);
  MFHendersonSetIntegerParameter(H,"maxCharts",-1,e);
  MFHendersonSetIntegerParameter(H,"verbose",1,e);
  MFHendersonSetIntegerParameter(H,"page",1,e);
  MFHendersonSetIntegerParameter(H,"pageEvery",100000,e);
  MFHendersonSetRealParameter(H,"dotmin",.9,e);
  MFHendersonSetIntegerParameter(H,"dumpToPlotFile",1,e);
  MFHendersonSetIntegerParameter(H,"dumpToCenterFile",0,e);
  MFHendersonSetIntegerParameter(H,"branchSwitch",20,e);
  MFHendersonSetFilename(H,"Transcritical",e);

  S=MFComputeAtlasMultiple(H,M,Omega,1,u0,e);

  MFCloseAtlas(H,S,e);

  MFFreeAtlas(S,e);
  MFFreeImplicitMF(M,e);
  MFFreeNRegion(Omega,e);
  MFFreeNVector(u0[0],e);
  MFFreeNVector(u0[1],e);
  MFFreeContinuationMethod(H,e);
  MFFreeErrorHandler(e);

  return(0);
 }
