/*
    %W%
    %D% %T%

    PROGRAM NAME:  multifario

    (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
    CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.

    Please refer to the LICENSE file in the top directory

*/
/*      author: Mike Henderson mhender@watson.ibm.com */

#include <MFAtlas.h>
#include <MFImplicitMF.h>
#include <IMFFlow.h>
#include <IMFLorenz.h>
#include <IMFThreeDFlows.h>

int main(int argc, char *argv[])
 {
  IMFFlow L;
  MFImplicitMF M;
  MFNRegion Omega;
  MFAtlas A;
  MFNVector u0;
  MFNVector ll,ur;
  MFContinuationMethod H;
  char output[1024];
  double R;

  u0=MFIMFVectorFactory(M);

/*L=IMFCreateFlow(3,lorenz,dlorenz,ddlorenz,dddlorenz);
  strcpy(output,"LorenzFoliation");
  R=.35;
  MFNVSetC(u0,0, 50.); MFNVSetC(u0,1, 50.); MFNVSetC(u0,2,  0.);*/

/*L=IMFCreateFlow(3,source,dsource,ddsource,dddsource);
  strcpy(output,"SourceFoliation");
  R=.35;
  MFNVSetC(u0,0, 10.); MFNVSetC(u0,1, 10.); MFNVSetC(u0,2,  0.);*/

/*L=IMFCreateFlow(3,hyperbolic,dhyperbolic,ddhyperbolic,dddhyperbolic);
  strcpy(output,"HyperbolicFoliation");
  R=2.;
  MFNVSetC(u0,0, 10.); MFNVSetC(u0,1, 10.); MFNVSetC(u0,2,  0.);*/

  L=IMFCreateFlow(3,saddlecenter,dsaddlecenter,ddsaddlecenter,dddsaddlecenter);
  strcpy(output,"SaddleCenterFoliation");
  R=2.;
  MFNVSetC(u0,0, 10.); MFNVSetC(u0,1, 10.); MFNVSetC(u0,2,  0.);

/*L=IMFCreateFlow(3,saddlefocus,dsaddlefocus,ddsaddlefocus,dddsaddlefocus);
  strcpy(output,"SaddleFocusFoliation");
  R=.35;
  MFNVSetC(u0,0, 10.); MFNVSetC(u0,1, 10.); MFNVSetC(u0,2,  0.);*/

  M=MFIMFCreateOrthogonalFoliation(L);

  MFIMFSetR(M,R);

  ll=MFIMFVectorFactory(M); MFNVSetC(ll,0,-70.); MFNVSetC(ll,1,-70.); MFNVSetC(ll,2,-30.);
  ur=MFIMFVectorFactory(M); MFNVSetC(ur,0,70.); MFNVSetC(ur,1,70.); MFNVSetC(ur,2,100.);
  Omega=MFNRegionCreateHyperCubeByCorners(3,ll,ur);
  MFFreeNVector(ll);
  MFFreeNVector(ur);

  H=MFCreateHendersonsMethod(e);
  MFHendersonSetRealParameter("epsilon",.05,e);         /* Max distance from TS to M */
  MFHendersonSetRealParameter("epsilon",.0005,e);         /* Max distance from TS to M */
  MFHendersonSetRealParameter("epsilon",5.,e);         /* Max distance from TS to M */
  MFHendersonSetIntegerParameter("maxCharts",20000,e);       /* -1 means infinite */
  MFHendersonSetIntegerParameter("maxCharts",50,e);       /* -1 means infinite */
  MFHendersonSetIntegerParameter("verbose",1,e);          /* Write info to stdout */
  MFHendersonSetIntegerParameter("page",1,e);             /* Page out non-interior polyhedra */
  MFHendersonSetIntegerParameter("dumpToPlotFile",1,e);   /* Write polyhedra to a plotfile */
  MFHendersonSetIntegerParameter("dumpToCenterFile",0,e); /* Write points to a file */
  MFHendersonSetFilename(H,output,e);

  A=MFComputeAtlas(H,M,Omega,u0,e);

  MFCloseAtlas(H,A,e);
  printf("Done computing Atlas\n");fflush(stdout);

  MFFreeAtlas(A,e);
  MFFreeImplicitMF(M,e);
  MFFreeNRegion(Omega,e);
  MFFreeNVector(u0,e);
  MFFreeContinuationMethod(H,e);
  MFFreeErrorHandler(e);

  return(0);
 }
