/*
 *  PROGRAM NAME:  multifario
 *
 *  (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
 *  CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
 *
 *  Please refer to the LICENSE file in the top directory
 *
 *      author: Mike Henderson mhender@watson.ibm.com
 */

static char *id="@(#) $Id: ComputeLine.c 249 2006-08-19 01:12:35Z mhender $";

#include <MFAtlas.h>
#include <MFNRegion.h>
#include <MFNVector.h>
#include <math.h>

int main(int argc, char *argv[])
 {
  MFImplicitMF M;
  int i;
  int n,k;
  MFNRegion Omega;
  MFAtlas S;
  MFNVector u0;
  FILE *fid;
  MFContinuationMethod H;
  MFErrorHandler e;

  e=MFCreateErrorHandler();

  k=1;
  M=MFIMFCreateNSpaceWithRadius(k,.1,e);
  n=MFIMF_N(M,e);
  Omega=MFNRegionCreateHyperCube(n,.5,e);

  u0=MFIMFVectorFactory(M,e);
  for(i=0;i<k;i++)
   {
    MFNVSetC(u0,i, 0.,e);
   }

  H=MFCreateHendersonsMethod(e);
  MFHendersonSetRealParameter(H,"epsilon",.05,e);
  MFHendersonSetIntegerParameter(H,"maxCharts",-1,e);
  MFHendersonSetIntegerParameter(H,"verbose",1,e);
  MFHendersonSetIntegerParameter(H,"page",1,e);
  MFHendersonSetIntegerParameter(H,"dumpToPlotFile",1,e);
  MFHendersonSetIntegerParameter(H,"dumpToCenterFile",0,e);
  MFHendersonSetFilename(H,"Line",e);

  S=MFComputeAtlas(H,M,Omega,u0,e);

/* Use this is Dump to Plotfile is set to zero */
/*
  fid=fopen("Line.atlas","w");
  MFWriteAtlas(fid,S,e);
  fclose(fid);
  printf("Done writing Atlas\n");fflush(stdout);
*/

  MFCloseAtlas(H,S,e);
  printf("Done computing Atlas\n");fflush(stdout);

  MFFreeAtlas(S,e);
  MFFreeImplicitMF(M,e);
  MFFreeNRegion(Omega,e);
  MFFreeContinuationMethod(H,e);
  MFFreeNVector(u0,e);

  MFFreeErrorHandler(e);

  return 0;
 }
