/*
    %W%
    %D% %T%

*/
/*      author: Mike Henderson mhender@watson.ibm.com */
/*      date:   July 18, 2002 Modified AUTO's main program       */

#include <MFAUTO.h>
#include <math.h>
int MFNVectorGetNRefs(MFNVector);
#define TWOPI 6.2831853071795862320

/* AUTBVP */

int f (integer ndim, const doublereal *u, const integer *icp,
          const doublereal *par, integer ijac,
          doublereal *f, doublereal *dfdu, doublereal *dfdp) {
  doublereal e;
  doublereal B;
  doublereal T;

  int p=1;
  int q=4;

  e = par[0];
  B = par[1];
  T = TWOPI*q;

  f[0]=T*u[1];
  f[1]=T*((B-e)*u[1]*u[1]*u[1]+(e/2-B)*u[1]-(1+B*sin(2*u[2]))*u[0]);
  f[2]=T;

  return 0;
}

/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
int stpnt (integer ndim, doublereal t,
           doublereal *u, doublereal *par) {
  int p=1;
  int q=4;
  doublereal e;
  doublereal B;

  par[0] = 11.4;
  par[1] = 0.05*20.;

  e = par[0];
  B = par[1];

  u[0] = 2*        sin(p*t*TWOPI);
  u[1] = 2*        cos(p*t*TWOPI);
  u[2] =   t;

  return 0;
}
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
int a (integer ndim, const doublereal *par, const integer *icp,
          integer nbc, const doublereal *u0, const doublereal *u1, integer ijac,
          doublereal *fb, doublereal *dbc) {
  fb[0] = u0[0]-u1[0];
  fb[1] = u0[1]-u1[1];
  fb[2] = u0[2];
  return 0;
}
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
int ic(integer ndim, const doublereal *par, const integer *icp,
          integer nint, const doublereal *u, const doublereal *uold,
          const doublereal *udot, const doublereal *upold, integer ijac,
          doublereal *fi, doublereal *dint) {
  return 0;
}
int plt(integer ndim, doublereal *u, doublereal *par)
 {

/* If algebraically defined parameters are included this does the projection */
  return 0;
 }

int main(int argc,char *argv[])
{
  MFAUTOTPBVP tpbvp;
  MFNSpace space;
  MFNRegion Omega;
  MFImplicitMF M;
  MFContinuationMethod H;
  MFNVector u0;
  MFNKMatrix Phi0;
  MFAtlas S;

  double epsilon=1.e-6;
  int through=0;
  doublereal rl0[2]={0., 0.};
  doublereal rl1[2]={12.,10.};
  doublereal a0=-50.;
  doublereal a1=50.;
  doublereal ds=.2;

  integer npar=2;
  integer icp[2]={0,1};
  doublereal par[2];

  doublereal thu[3]={1.,1.,1.};
  doublereal thl[2]={1.,1.};

  integer k=2;
  integer jac=0;
  integer ntst=50,ncol=4,ndim=3;
  integer nbc=3,nic=0;

  tpbvp=MFCreateAUTOTPBVP(k,ndim,f,jac,nbc,a,nic,ic,npar,icp,ntst,ncol,plt);

/* Add Boundary Conditions */
/* Add Integral Conditions */
/* Add Pvls */

  space=MFCreateAUTONSpace(tpbvp,thu,thl);
  M=MFCreateAUTOBV(tpbvp,space);
  MFIMFSetR(M,ds);
  Omega=MFNRegionCreateAUTO(space,npar,icp,rl0,rl1,a0,a1);

  H=MFCreateHendersonsMethod(e);
  MFHendersonSetRealParamter(H,"epsilon",epsilon,e);
  MFHendersonSetIntegerParameter(H,"branchSwitch",through,e);
  MFHendersonSetIntegerParameter(H,"maxCharts",100,e);
  MFHendersonSetIntegerParameter(H,"verbose",1,e);
  MFHendersonSetIntegerParameter(H,"page",1,e);
  MFHendersonSetIntegerParameter(H,"dumpToPlotFile",1,e);
  MFHendersonSetIntegerParameter(H,"dumpToCenterFile",1,e);
  MFHendersonSetFilename(H,"Frank",e);

/* Add par */

  par[0]=11.4;
  par[1]=.05*20;

  if(!MFAUTOGetStartPoint(M,tpbvp,stpnt,par,&u0,&Phi0,e))
   {
    printf("Start point could not be found\n");fflush(stdout);
    return 8;
   }

  if(Phi0!=(MFNKMatrix)NULL)S=MFComputeAtlasWithTangent(H,M,Omega,u0,Phi0,e);
    else S=MFComputeAtlas(H,M,Omega,u0,e);

  MFCloseAtlas(H,S,e);
  MFFreeNRegion(Omega,e);
  MFFreeNSpace(space,e);
  MFFreeNVector(u0,e);
  MFFreeImplicitMF(M,e);
  MFFreeContinuationMethod(H,e);
  MFFreeErrorHandler(e);

  return 0;
} 
