/*
 *  PROGRAM NAME:  multifario
 *
 *  (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES
 *  CORPORATION 12/1/2001.  ALL RIGHTS RESERVED.
 *
 *  Please refer to the LICENSE file in the top directory
 *
 *      author: Mike Henderson mhender@watson.ibm.com
 */

static char *id="@(#) $Id: Compute4Space.c 249 2006-08-19 01:12:35Z mhender $";

#include <MFAtlas.h>
#include <MFNRegion.h>
#include <MFNVector.h>
#include <math.h>

int main(int argc, char *argv[])
 {
  MFImplicitMF M;
  int i;
  int n,k;
  MFNRegion Omega;
  MFAtlas S;
  MFNVector u0;
  FILE *fid;
  double R=.5;
  MFContinuationMethod H;
  MFErrorHandler e;

  e=MFCreateErrorHandler();

  k=4;
  M=MFIMFCreateNSpaceWithRadius(k,.1,e);
  n=MFIMF_N(M,e);
  Omega=MFNRegionCreateHyperCube(n,R,e);
  printf("Interior of Four Cube, volume=%lf\n",2*R*2*R*2*R*2*R);

  u0=MFIMFVectorFactory(M,e);
  for(i=0;i<k;i++)
    MFNVSetC(u0,i, 0.,e);

  H=MFCreateHendersonsMethod(e);
  MFHendersonSetRealParameter(H,"epsilon",.1,e);
  MFHendersonSetIntegerParameter(H,"maxCharts",-1,e);
  MFHendersonSetIntegerParameter(H,"verbose",1,e);
  MFHendersonSetIntegerParameter(H,"page",1,e);
  MFHendersonSetFilename(H,"FourSpace",e);


  S=MFComputeAtlas(H,M,Omega,u0,e);

/*fid=fopen("FourSpace.atlas","w");
  MFWriteAtlas(fid,S,e);
  fclose(fid);
  printf("Done writing Atlas\n");fflush(stdout);*/

  MFFreeAtlas(S,e);
  MFFreeContinuationMethod(H,e);
  MFFreeImplicitMF(M,e);
  MFFreeNRegion(Omega,e);
  MFFreeNVector(u0,e);

  MFFreeErrorHandler(e);

  return 0;
 }
