/*
    %W%
    %D% %T%

*/
/*      author: Mike Henderson mhender@watson.ibm.com */
/*      date:   July 18, 2002 Modified AUTO's main program       */

#include <MFAUTO.h>

int MFNVectorGetNRefs(MFNVector);

/* AUTBVP */

int f (integer ndim, const doublereal *u, const integer *icp,
          const doublereal *par, integer ijac,
          doublereal *f, doublereal *dfdu, doublereal *dfdp) {
  doublereal d1;
  doublereal pi;

  pi = atan(1.) * 4;
  f[0] = u[1];
  d1 = par[0] * pi;

  f[1] = -(d1 * d1) * u[0] + u[0] * u[0];

  return 0;
}
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
int stpnt (integer ndim, doublereal t,
           doublereal *u, doublereal *par) {
  par[0] = 0.;
  u[0] = (doublereal)0.;
  u[1] = (doublereal)0.;

  return 0;
}
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
int a (integer ndim, const doublereal *par, const integer *icp,
          integer nbc, const doublereal *u0, const doublereal *u1, integer ijac,
          doublereal *fb, doublereal *dbc) {
  fb[0] = u0[0];
  fb[1] = u1[0];

  return 0;
}
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
int ic(integer ndim, const doublereal *par, const integer *icp,
          integer nint, const doublereal *u, const doublereal *uold,
          const doublereal *udot, const doublereal *upold, integer ijac,
          doublereal *fi, doublereal *dint) {
  return 0;
}
int plt(integer ndim, doublereal *u, doublereal *par)
 {

/* If algebraically defined parameters are included this does the projection */
  return 0;
 }

int main(int argc,char *argv[])
{
  MFAUTOTPBVP tpbvp;
  MFNSpace space;
  MFNRegion Omega;
  MFImplicitMF M;
  MFContinuationMethod H;
  MFNVector u0;
  MFNKMatrix Phi0;
  MFAtlas S;

  double epsilon=1.e-6;
  int through=0;
  doublereal rl0[1]={0.};
  doublereal rl1[1]={5.};
  doublereal a0=-50.;
  doublereal a1=50.;
  doublereal ds=.2;

  integer npar=1;
  integer icp[1]={0};
  doublereal par[1];

  doublereal thu[2]={1.,1.};
  doublereal thl[1]={1.};

  integer k=1;
  integer jac=1;
  integer ntst=5,ncol=4,ndim=2;
  integer nbc=2,nic=0;

  MFErrorHandler e;

  e=MFCreateErrorHandler();

  tpbvp=MFCreateAUTOTPBVP(k,ndim,f,jac,nbc,a,nic,ic,npar,icp,ntst,ncol,plt,e);

  space=MFCreateAUTONSpace(tpbvp,thu,thl,e);
  M=MFCreateAUTOBV(tpbvp,space,e);
  MFIMFSetR(M,ds,e);
  Omega=MFNRegionCreateAUTO(space,npar,icp,rl0,rl1,a0,a1,e);

  H=MFCreateHendersonsMethod(e);
  MFHendersonSetRealParameter(H,"epsilon",epsilon,e);
  MFHendersonSetIntegerParameter(H,"branchSwitch",through,e);
  MFHendersonSetIntegerParameter(H,"maxCharts",100,e);
  MFHendersonSetIntegerParameter(H,"verbose",1,e);
  MFHendersonSetIntegerParameter(H,"page",1,e);
  MFHendersonSetIntegerParameter(H,"dumpToPlotFile",1,e);
  MFHendersonSetIntegerParameter(H,"dumpToCenterFile",1,e);
  MFHendersonSetFilename(H,"AUTINT");

/* Add par */
  par[0]=0.;
  MFAUTOGetStartPoint(M,tpbvp,stpnt,par,&u0,&Phi0,e);

  if(Phi0!=(MFNKMatrix)NULL)S=MFComputeAtlasWithTangent(H,M,Omega,u0,Phi0,e);
    else S=MFComputeAtlas(H,M,Omega,u0,e);

  MFCloseAtlas(H,S,e);
  MFFreeNRegion(Omega,e);
  MFFreeNSpace(space,e);
  MFFreeNVector(u0,e);
  MFFreeImplicitMF(M,e);
  MFFreeHendersonsMethod(H,e);
  MFFreeErrorHandler(e);

  return 0;
} 
