       SUBROUTINE PTREPL( XNEW , IPOLY, VNEW, PNTINT, POLY, NIND, N, 
     +                    LPOLY, LPTINT)

C
C  **********************************************************************
C  THIS SUBROUTINE REPLACES A  POINT WITH A GIVEN INDEX IN THE INTERPOLATION 
C  SET BY ANOTHER GIVEN POINT AND UPDATES NEWTON FUNDAMENTAL POLYNOMIALS
C  ACCORDINGLY. IT CAN ALSO BE USED TO ADD A POINT TO AN INCOMPLETE
C  INTERPOLATION SET, THIS CAN BE DONE BY SETTING INDEX 
C  IPOLY = NIND+1  = NUMBER OF INTERPOLATION POINTS + 1.
C  IF THE INTERPOLATION IS QUADRATIC ( NIND > N+1 ) THEN WE ARE ALLOWED
C  TO REPLACE POINTS ONLY IN THE QUADRATIC BLOCK, THUS IPOLY > N + 1.
C
C  PARAMETERS
C 
C    POLY   (INPUT/OUTPUT) THE SET OF NEWTON FUNDAMENTAL POLYNOMIALS
C
C    XNEW   (INPUT) POINT THAT IS INTRODUCED INTO THE SET
C
C    IPOLY  (INPUT) THE INDEX OF THE POINT THAT HAS TO BE REPLACED
C
C    VNEW   (INPUT) VALUE OF IPOLY-TH POLYNOMIAL AT XGNEW
C
C    PNTINT (INPUT) SET OF INTERPOLATION POINTS
C
C    NIND   (INPUT) NUMBER OF INTERPOLATION POINTS
C
C    N      (INPUT) PROBLEM DIMENSION
C  ********************************************************************
C


C
C  PARAMETERS
C


       DOUBLE PRECISION POLY(LPOLY)  , XNEW(N), VNEW,    
     +                  PNTINT(LPTINT)                 
                       
                  
       INTEGER          NIND, N, LPOLY, LPTINT, IPOLY

C
C  COMMON VARIABLES
C

       INTEGER          IOUT  , IPRINT
       DOUBLE PRECISION MCHEPS, CNSTOL
       COMMON / DFOCM / IOUT  , IPRINT, MCHEPS, CNSTOL
       SAVE / DFOCM /

C
C  LOCAL VARIABLES 
C

       DOUBLE PRECISION VAL

       INTEGER          NP1, DD, NPBEG, NPEND, I, J, K, BLOCK

       INTRINSIC        ABS
C
C  SUBROUTINES AND FUNCTIONS CALLED:
C
C    APPLICATION     :       NEXTNP, EVALX
C    FORTRAN SUPPLIED:       ABS
C

      
       NP1 = N+1
       DD  = NP1*(N+2)/2

C
C  CHECK TO WHICH BLOCK WE ARE ADDING THE POINT, CLEARLY NIND<DD
C
       IF ( IPOLY .LE. NP1 ) THEN
         BLOCK=1
         IF ( NIND .GT. NP1 ) THEN
           IF ( IPRINT .GT. 0 ) WRITE(IOUT,1000) IPOLY
           STOP 
         ENDIF
       ELSE
         BLOCK=2
       ENDIF
C
C  IF WE ONLY DEAL WITH THE LINEAR BLOCK (NO QUADRATIC POLYNOMIALS YET)
C
       IF (BLOCK.EQ.1) THEN

C 
C  "NORMALIZE" THE IPOLY-TH  POLYNOMIAL
C
         NPBEG = (IPOLY-2)*NP1 + 2
         NPEND =  NPBEG + N 
         DO 10 I=NPBEG,NPEND
           POLY(I)=POLY(I)/VNEW
 10      CONTINUE 

C
C  FOR NUMERICAL STABILITY  "RE-ORTHOGONALIZE" THE NEXT POLYNOMIAL
C  WITH RESPECT TO THE PREVIOUS POLYNOMIALS
C 

         IF ( ABS(VNEW) .LT. 1.0D2 ) THEN
           CALL NEXTNP(IPOLY, POLY, PNTINT, NIND, N, LPOLY, LPTINT)
           CALL EVALX(VAL, XNEW, POLY, IPOLY, N, LPOLY)  
           DO 20 I = NPBEG, NPEND
             POLY(I) = POLY(I)/VAL
 20        CONTINUE  
         ENDIF 

C
C  UPDATE THE POLYNOMIALS IN THE LINEAR BLOCK SO THAT THEIR VALUE IS 
C  ZERO AT  THE POINT XNEW 
C
         DO 40 J=2, NIND
           IF ( J .NE. IPOLY ) THEN 
             CALL EVALX( VAL, XNEW, POLY, J, N, LPOLY )
             DO 30 I = NPBEG, NPEND
               K = I - NPBEG + (J-2)*NP1 + 2
               POLY(K) = POLY(K) - VAL*POLY(I)
 30          CONTINUE 
           ENDIF 
 40      CONTINUE

C
C  IF WE ARE  UPDATING POLYNOMIALS IS IN THE QUADRATIC BLOCK
C
       ELSE


C
C  "NORMALIZE" THE IPOLY-TH  POLYNOMIAL
C

         NPBEG = (IPOLY - N - 2)*DD + N*NP1 + 2
         NPEND =  NPBEG + DD - 1
         DO 50 I = NPBEG, NPEND
           POLY(I)=POLY(I)/VNEW
 50      CONTINUE 

C
C  FOR NUMERICAL STABILITY  "RE-ORTHOGONALIZE" THE NEXT POLYNOMIAL
C  WITH RESPECT TO THE PREVIOUS POLYNOMIALS
C 

         IF ( ABS(VNEW) .LT. 1.0D2 ) THEN
           CALL NEXTNP(IPOLY, POLY, PNTINT, NIND, N, LPOLY, LPTINT)
           CALL EVALX(VAL, XNEW, POLY, IPOLY, N, LPOLY)  
           DO 60 I = NPBEG, NPEND
             POLY(I) = POLY(I)/VAL
 60       CONTINUE  
         ENDIF

C
C  UPDATE THE POLYNOMIALS IN THE QUADRATIC BLOCK SO THAT THEIR VALUE IS 
C  ZERO AT  THE POINT XNEW  
C
         DO 80 J=N+2,NIND
           IF ( J .NE. IPOLY ) THEN
             CALL EVALX(VAL, XNEW, POLY, J, N,  LPOLY)
             DO 70 I = NPBEG, NPEND
               K = I - NPBEG + (J-N-2)*DD + N*(N+1) + 2
               POLY(K) = POLY(K)-VAL*POLY(I)
 70          CONTINUE 
           ENDIF 
 80      CONTINUE
       ENDIF

       RETURN


 1000  FORMAT('PTREPL  **** TRYING TO REPLACE A POINT', /, 
     +       '             IN THE LINEAR BLOCK, IPOLY=', I6 ) 
     
       END









