       SUBROUTINE PTEXCH(POLY , XNEW  , PNTINT, IPOLY , NIND, N, 
     +                   LPOLY, LPTINT, PIVTHR, PIVVAL, VMAX, FAIL )




C
C  **********************************************************************
C  THIS SUBROUTINE INCLUDES A POINT XNEW IN THE INTERPOLATION SET BY 
C  UPDATING THE SET OF NEWTON FUNDAMENTAL POLYNOMIALS ACCORDINGLY.
C  FIRST A POINT WHICH IS  REPLACED BY XNEW IS DETERMINED, THEN
C  SUBROUTINE "PTREPL" IS CALLED, WHICH PERFORMS THE UPDATES.
C  IPOLY IS THE INDEX OF THE POINT THAT IS REPLACED BY 'XGNEW'.
C  THE SET OF NEWTON POLYNOMIALS IS UPDATED ACCORDINGLY.
C
C  IF THERE ARE QUADRATIC POLYNOMIALS IN THE INTERPOLATION BASIS THEN
C  WE EVALUATE EACH POLYNOMIAL IN THE QUADRATIC BLOCK AT 'XNEW',
C  OTHERWISE WE EVALUATE POLYNOMIALS OF THE LINEAR BLOCK AT 'XNEW'.
C  WE CHOOSE THE POLYNOMIAL  THAT HAS THE LARGEST VALUE AT XNEW.
C  IF THIS VALUE IS LARGER THEN THE PIVOT THRESHOLD THEN WE SET
C  TO THE INDEX OF THAT POLYNOMIAL.
C  OTHERWISE  WE DECLARE THAT WE FAILED TO INCLUDE XGNEW IN THE 
C  INTERPOLATION SET AND RETURN.
C
C  PARAMETERS
C    POLY   (INPUT/OUTPUT) THE SET OF NEWTON POLYNOMIALS
C
C    XNEW   (INPUT) POINT THAT SHOULD BE ADDED
C
C    PNTINT (INPUT) SET OF INTERPOLATION POINTS BEFORE XNEW IS ADDED 
C
C    NIND   (INPUT) NUMBER OF INTERPOLATION POINTS
C
C    N      (INPUT) PROBLEM DIMENSION
C
C    PIVTHR (INPUT) PIVOT THRESHOLD VALUE
C
C    PIVVAL (INPUT) ARRAY OF PIVOT VALUES 
C
C    FAIL   (OUTPUT) INDICATES IF THE POINT INTERCHANGE FAILED
C
C    IPOLY  (OUTPUT) THE INDEX OF THE POINT THAT WAS REPLACED, IF FAIL=.FALSE.
C
C    VMAX   (OUTPUT) THE VALUE OF THE PIVOT, IF FAIL=.FALSE.
C  *******************************************************************
C

C
C  PARAMETER VARIABLES
C
      DOUBLE PRECISION  POLY(LPOLY)   , XNEW(N), VMAX, 
     +                  PNTINT(LPTINT), PIVTHR , PIVVAL(NIND)
           

                  
      INTEGER           NIND, N, LPOLY, LPTINT, IPOLY
       
      LOGICAL           FAIL

C
C  COMMON VARIABLES
C
      INTEGER          IOUT, IPRINT

      DOUBLE PRECISION MCHEPS, CNSTOL
      COMMON / DFOCM / IOUT  , IPRINT, MCHEPS, CNSTOL
      SAVE / DFOCM /

C
C  LOCAL VARIABLES 
C
      INTEGER          DD, NP1, NP2, BLOCK, I, BASE

      DOUBLE PRECISION VAL
 
      INTRINSIC        ABS

C
C  SUBROUTINES AND FUNCTIONS CALLED:
C
C    APPLICATION     :       EVALX, PTREPL
C    FORTRAN SUPPLIED:       ABS
C
       FAIL =.FALSE.     
       BASE = IPOLY
       NP1  = N + 1 
       NP2  = N + 2      
       DD   = NP1*NP2/2


C
C  CHECK IF INTERPOLATION SET CONTAINS ELEMENTS FROM QUADRATIC BLOCK OR NOT
C

       IF ( NIND .LE. NP1 ) THEN
         BLOCK=1
       ELSE
         BLOCK=2
       ENDIF


C
C  TO IDENTIFY IPOLY WE  EVALUATE ALL NEWTON POLYNOMIALS IN THE LAST
C  BLOCK AT THIS POINT AND CHOOSE THE ONE THAT GIVES THE LARGE PIVOT.
C  IF THIS PIVOT IS LARGER THEN THE PIVOT THRESHOLD THEN WE SET IPOLY TO
C  THE INDEX OF THIS POLYNOMIAL. 
C

       VMAX  = 0.0D0
       IPOLY = 0
       IF (BLOCK.EQ.2) THEN

C
C  IF WE START WITH THE QUADRATIC BLOCK
C

         DO 10 I=NP2, NIND
           IF ( I .NE. BASE ) THEN
             CALL EVALX(VAL, XNEW, POLY, I, N,  LPOLY)
             IF ( ABS(VAL) .GT. ABS(VMAX) ) THEN
               VMAX=VAL
               IPOLY=I
             ENDIF
           ENDIF
 10      CONTINUE
         IF ( IPOLY .EQ. 0 .OR. ABS(VMAX*PIVVAL(IPOLY)) .LT. PIVTHR ) 
     +     THEN
           FAIL=.TRUE.
           RETURN
         ENDIF
       ELSE

C
C  IF WE START FROM THE LINEAR BLOCK
C
         DO 20 I=2, NIND
           CALL EVALX(VAL, XNEW, POLY, I, N, LPOLY)
           IF ( ABS(VAL) .GT. ABS(VMAX) ) THEN
             VMAX  = VAL
             IPOLY = I
           ENDIF
 20      CONTINUE
         IF ( IPOLY .EQ. 0 .OR. ABS(VMAX*PIVVAL(IPOLY)) .LT. PIVTHR ) 
     +     THEN
           FAIL=.TRUE.
           RETURN
         ENDIF   
       ENDIF
C
C  UPDATE THE NEWTON POLYNOMIALS, SO THAT POLYNOMIAL WITH THE
C  INDEX IPOLY CORRESPONDS TO XGNEW IN THE INTERPOLATION SET 
C

       CALL PTREPL( XNEW , IPOLY, VMAX, PNTINT, POLY, NIND, N, 
     +              LPOLY, LPTINT)



       RETURN
       END

  








