      SUBROUTINE FD( LAFLA , PNTINT, VALUES, POLY, N,  Q, NEQCON, 
     +               LPTINT, LPOLY )
 

*    
*  ***********************************************************************
*  THIS SUBROUTINE COMPUTED FINITE DIFFERENCES FOR MULTIVARIATE
*  INTERPOLATION, USING 'Q' INTERPOLATION POINTS AND 'Q' NEWTON
*  FUNDAMENTAL POLYNOMIALS.
*
*  PARAMETERS:
*  
*   N      (INPUT)  DIMENTION OF THE PROBLEM
*
*   Q      (INPUT)  NUMBER OF INTERPOLATION POINTS
* 
*   PNTINT (INPUT)  LIST OF  'NIND' DATA POINTS. THE I-TH POINT OCCUPIES
*                   POSITIONS ( I - 1 ) * N + 1 TO I * N.
*   VALUES (INPUT)  VALUES OF THE OBJECTIVE FUNCTION AT THE 'NIND'
*                   DATA POINTS CONTAINED IN POINTS.
*   POLY   (INPUT)  THE ARRAY CONTAINING COEFFICIENTS OF NEWTON FUNDAMENTAL
*                   POLYNOMIALS (AS COMPUTED BY 'NBUILD')
*   NEQCON (INPUT)  NUMBER OF LINEARLY INDEP. EQUALITY CONSTRAINTS
*
*   LAFLA  (OUTPUT) THE ARRAY OF THE  FINITE DIFFERENCES
* 
*  **************************************************************************
*

       INTEGER          N, Q, NEQCON, LPTINT, LPOLY 

       DOUBLE PRECISION LAFLA(Q), PNTINT(LPTINT), VALUES(Q), POLY(LPOLY)

       INTRINSIC        MIN
C
C  LOCAL VARIABLES
C 
       INTEGER          DD, I, K, L,  NP1, NP2, QP1
       DOUBLE PRECISION VAL

       NP1 = N + 1
       NP2 = N + 2
       DD = (NP1)*(NP2)/2.0
       QP1 = Q + 1

C
C  INITIALISE THE LAFLA, THE FINITE DIFFERENCE OPERATORS ON F
C

       DO 10 I =1,Q
         LAFLA( I ) = VALUES(I)
 10    CONTINUE
C
C  START THE MAJOR ITERATION
C

       DO 100 I=1,Q
C
C  FOR ALL MULTIINDICES ALFA (WHOSE CARDINALITY IS GREATER THAN OR EQUAL
C  TO I), UPDATE THE ASSOCIATED FUNCTION L_ALFA USING
C  THE NEWTON FUNDAMENTAL POLYNOMIALS OF DEGREE EQUAL TO THE 
C  CARDINALITY OF ALFA_{I-1}
C

         IF (I.EQ.2) THEN
C          
C  ALL FINITE DIFFERENCES CORRESPONDING TO DEGREES >= 1 ARE UPDATED.
C  THE NEWTON FUNDAMENTAL POLYNOMIALS OF DEGREE CARDINALITY OF ALFA_I = 0
C  ARE USED IN THE UPDATE. THE UPDATES ARE SKIPPED FOR DUMMY POLYNOMIALS
C  WHOSE INDEX IS ALWAYS HIGHER THAN NP1-NEQCON
C
           DO 110 L = 2, MIN(Q, NP1 - NEQCON) 
             CALL  EVALNP( VAL, PNTINT, L, POLY, 1, N, LPTINT,
     +                     LPOLY )
             LAFLA( L ) = LAFLA( L ) - LAFLA( 1 )*VAL
 110       CONTINUE
           DO 115 L = NP2, Q 
             CALL  EVALNP( VAL, PNTINT, L, POLY, 1, N, LPTINT,
     +                     LPOLY )
             LAFLA( L ) = LAFLA( L ) - LAFLA( 1 )*VAL
 115      CONTINUE

         ELSE
           IF (I.EQ.NP2) THEN
C
C  ALL FINITE DIFFERENCES CORRESPONDING TO DEGREES = 2 ARE UPDATED.
C  THE NEWTON FUNDAMENTAL POLYNOMIALS OF DEGREE CARDINALITY OF ALFA_I = 1
C  ARE USED IN THE UPDATE
C 
             DO 120 L = NP2,Q
               DO 130 K = 2, NP1-NEQCON
                 CALL  EVALNP( VAL, PNTINT, L, POLY, K, N, LPTINT,
     +                         LPOLY )
                 LAFLA( L ) = LAFLA( L ) - LAFLA( K )*VAL
 130           CONTINUE
 120         CONTINUE

           ENDIF
         ENDIF
 100   CONTINUE


       RETURN
       END













