# $Id: test_one.sh.in 1771 2011-01-01 15:41:51Z bradbell $
# -----------------------------------------------------------------------------
# CppAD: C++ Algorithmic Differentiation: Copyright (C) 2003-11 Bradley M. Bell
#
# CppAD is distributed under multiple licenses. This distribution is under
# the terms of the 
#                     GNU General Public License Version 2.
#
# A copy of this license is included in the COPYING file of this distribution.
# Please visit http://www.coin-or.org/CppAD/ for information on other licenses.
# -----------------------------------------------------------------------------
# Run one of the tests
if [ "$1" = "" ]
then
	echo "usage: test_one.sh file [extra]"
	echo "file is the *.cpp file name with extension"
	echo "and extra is extra options for g++ command"
	exit 1
fi
if [ ! -e "$1" ]
then
	echo "Cannot find the file $1"
	exit 1
fi
# determine the function name
fun=`grep "^bool *[a-zA-Z0-9_]*( *void *)" $1 | tail -1 | \
	sed -e "s/^bool *\([a-zA-Z0-9_]*\) *( *void *)/\1/"`
#
if [ -e test_one.exe ]
then
	rm test_one.exe
fi
if [ -e test_one.cpp ]
then
	rm test_one.cpp
fi
sed < example.cpp > test_one.cpp \
-e '/ok *\&= *Run( /d' \
-e "s/.*This line is used by test_one.sh.*/	ok \&= Run( $fun, \"$fun\");/"  
#
cmd="g++ test_one.cpp $*
	-o test_one.exe
	-g -Wall -ansi -pedantic-errors -Wshadow
	-std=c++98 -DCPPAD_ADOLC_EXAMPLES
	-I.. -I/usr/include/boost-1_33_1 
	-I$HOME/include
"
if [ -e /include/adolc/adouble.h ]
then
	cmd="$cmd -I/include -L/lib -ladolc"
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:/lib"
fi
if [ -e /lib/libipopt.a ]
then
	cmd="$cmd -I/include"
	cmd="$cmd -L/lib -lipopt"
	cmd="$cmd  -L/usr/lib/gcc/x86_64-redhat-linux/4.4.7 -L/usr/lib/gcc/x86_64-redhat-linux/4.4.7/../../../../lib64 -L/lib/../lib64 -L/usr/lib/../lib64 -L/usr/lib/gcc/x86_64-redhat-linux/4.4.7/../../.. -lgfortranbegin -lgfortran -lm -lpthread -ldl"
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:/lib"
fi
echo $cmd
$cmd
#
echo "./test_one.exe"
if ! ./test_one.exe
then
	exit 1
fi
exit 0

