/* $Id: speed.cpp 1637 2010-01-27 07:09:30Z bradbell $ */
/* --------------------------------------------------------------------------
CppAD: C++ Algorithmic Differentiation: Copyright (C) 2003-10 Bradley M. Bell

CppAD is distributed under multiple licenses. This distribution is under
the terms of the 
                    GNU General Public License Version 2.

A copy of this license is included in the COPYING file of this distribution.
Please visit http://www.coin-or.org/CppAD/ for information on other licenses.
-------------------------------------------------------------------------- */

# include <cstdio>  // system include files used for I/O
# include <string>  // std::string

// external complied tests
extern double ode_speed(const char* name, size_t& count);

// main program that runs all the cppad_ipopt speed tests
int main(void)
{	using std::printf;
	const char* name;
	double      seconds;
	size_t      count;

	name    = "simple_retape_yes";
	seconds = ode_speed(name, count);
	printf("ode %20s: seconds = %5.2f: eval_r_count = %d\n", 
		name, seconds, count);

	name    = "simple_retape_no";
	seconds = ode_speed(name, count);
	printf("ode %20s: seconds = %5.2f: eval_r_count = %d\n",
		name, seconds, count);

	name    = "fast_retape_yes";
	seconds = ode_speed(name, count);
	printf("ode %20s: seconds = %5.2f: eval_r_count = %d\n",
		name, seconds, count);

	name    = "fast_retape_no";
	seconds = ode_speed(name, count);
	printf("ode %20s: seconds = %5.2f: eval_r_count = %d\n",
		name, seconds, count);
	
	return 0;
}
