/* $Id: math_other.hpp 1369 2009-05-31 01:31:48Z bradbell $ */
# ifndef CPPAD_MATH_OTHER_INCLUDED
# define CPPAD_MATH_OTHER_INCLUDED

/* --------------------------------------------------------------------------
CppAD: C++ Algorithmic Differentiation: Copyright (C) 2003-06 Bradley M. Bell

CppAD is distributed under multiple licenses. This distribution is under
the terms of the 
                    GNU General Public License Version 2.

A copy of this license is included in the COPYING file of this distribution.
Please visit http://www.coin-or.org/CppAD/ for information on other licenses.
-------------------------------------------------------------------------- */

/*
$begin MathOther$$
$spell
	atan
$$

$index atan2, AD$$

$index other, AD math$$
$index math, AD other$$

$section Other AD Math Functions$$

$children%
	cppad/local/abs.hpp%
	cppad/local/atan2.hpp%
	cppad/local/erf.hpp%
	cppad/local/pow.hpp
%$$
$table
$rref abs$$
$rref atan2$$
$rref erf$$
$rref  pow$$
$tend
	

$end
*/

# include <cppad/local/abs.hpp>
# include <cppad/local/atan2.hpp>
# include <cppad/local/erf.hpp>
# include <cppad/local/pow.hpp>

# endif
