#
# Unit Tests for coopr.opt.base.solution
#
#

import os
import sys
from os.path import abspath, dirname
sys.path.insert(0, dirname(dirname(abspath(__file__)))+"/../..")
cooprdir = dirname(abspath(__file__))+os.sep+".."+os.sep+".."+os.sep
currdir = dirname(abspath(__file__))+os.sep

import unittest
from nose.tools import nottest
import coopr.opt
import coopr
import pyutilib.th
import pyutilib.misc
import pyutilib.services
import xml

class OptSolnDebug(pyutilib.th.TestCase):

    def setUp(self):
        pyutilib.services.TempfileManager.tempdir = currdir
        self.results = coopr.opt.SolverResults()
        self.soln = self.results.solution.create()

    def tmp(self):
        self.soln.variable[0]=0.0
        self.soln.variable[1]=0.0
        self.soln.variable[3]=0.0
        pyutilib.services.TempfileManager.clear_tempfiles()

    def tearDown(self):
        pass

    def test_write_solution1(self):
        """ Write a SolverResults Object with solutions """
        self.results.write(filename=currdir+"write_solution1.txt")
        if not os.path.exists(currdir+"write_solution1.txt"):
           self.fail("test_write_solution - failed to write write_solution1.txt")
        self.failUnlessFileEqualsBaseline(currdir+"write_solution1.txt", currdir+"test1_soln.txt")

    def test_write_solution2(self):
        """ Write a SolverResults Object without solutions """
        self.results.write(num=None,filename=currdir+"write_solution2.txt")
        if not os.path.exists(currdir+"write_solution2.txt"):
           self.fail("test_write_solution - failed to write write_solution2.txt")
        self.failUnlessFileEqualsBaseline(currdir+"write_solution2.txt", currdir+"test2_soln.txt")

    def test_delete_solution(self):
        """ Delete a solution from a SolverResults object """
        self.results.solution.delete(0)
        self.results.write(filename=currdir+"delete_solution.txt")
        if not os.path.exists(currdir+"delete_solution.txt"):
           self.fail("test_write_solution - failed to write delete_solution.txt")
        self.failUnlessFileEqualsBaseline(currdir+"delete_solution.txt", currdir+"test4_soln.txt")

    def test_get_solution(self):
        """ Get a solution from a SolverResults object """
        tmp = self.results.solution[0]
        self.failUnlessEqual(tmp,self.soln)

    def test_get_solution_attr_error(self):
        """ Create an error with a solution suffix """
        try:
           tmp = self.soln.bad
           self.fail("Expected attribute error failure for 'bad'")
        except AttributeError:
           pass

    def test_set_solution_attr_error(self):
        """ Create an error with a solution suffix """
        try:
           self.soln.variable = True
           self.fail("Expected attribute error failure for 'var'")
        except AttributeError:
           pass

    def test_soln_pprint1(self):
        """ Write a solution with only zero values, using the results 'write()' method """
        self.soln.variable.add(0,0.0)
        self.soln.variable.add(1,0.0)
        self.soln.variable.add(3,0.0)
        self.results.write(filename=currdir+"soln_pprint.txt")
        if not os.path.exists(currdir+"soln_pprint.txt"):
           self.fail("test_write_solution - failed to write soln_pprint.txt")
        self.failUnlessFileEqualsBaseline(currdir+"soln_pprint.txt", currdir+"test3_soln.txt")

    def test_soln_pprint2(self):
        """ Write a solution with only zero values, using the Solution.pprint() method """
        self.soln.variable.add(0,0.0)
        self.soln.variable.add(1,0.0)
        self.soln.variable.add(3,0.0)
        pyutilib.misc.setup_redirect(currdir+"soln_pprint2.out")
        self.soln.pprint()
        self.soln._variable.pprint()
        pyutilib.misc.reset_redirect()
        self.failUnlessFileEqualsBaseline(currdir+"soln_pprint2.out", currdir+"soln_pprint2.txt")

    def test_soln_suffix_iter(self):
        """ Test a suffix iterator """
        self.soln.variable.add(0,0.0)
        self.soln.variable.add(1,0.1)
        self.soln.variable.add(3,0.3)
        i=0
        for val in self.soln.variable:
          i=i+1
          self.failUnlessEqual(val[1], val[0]/10.0)
        self.failUnlessEqual(i,len(self.soln.variable))

    def test_soln_suffix_getiter(self):
        self.soln.variable.add("x0",0.0)
        self.soln.variable.add(1,0.1)
        self.soln.variable.add("x3",0.3)
        #print "HERE", self.soln.variable._index.keys()
        self.failUnlessEqual(self.soln.variable["x3"],0.3)
        self.failUnlessEqual(self.soln.variable[1],0.1)

    def test_soln_suffix_setattr(self):
        self.soln.variable.add("x(0)",0.0)
        self.soln.variable.add("x3",0.3)
        self.soln.variable.add("y[1,ab]",0.5)
        #self.soln.pprint()
        #print "HERE", self.soln.variable._index.keys()
        self.failUnlessEqual(self.soln.variable.x.keys(),[0])
        self.failUnlessEqual(self.soln.variable.x[0],0.0)
        self.failUnlessEqual(self.soln.variable.x3,0.3)
        self.failUnlessEqual(self.soln.variable.y.keys(),[(1,'ab')])
        self.failUnlessEqual(self.soln.variable.y[1,'ab'],0.5)



if __name__ == "__main__":
   unittest.main()
