#  _________________________________________________________________________
#
#  Coopr: A COmmon Optimization Python Repository
#  Copyright (c) 2008 Sandia Corporation.
#  This software is distributed under the BSD License.
#  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
#  the U.S. Government retains certain rights in this software.
#  For more information, see the Coopr README.txt file.
#  _________________________________________________________________________

#
# The formats that are supported by Pyomo
#
__all__ = ['ProblemFormat', 'ResultsFormat']

from pyutilib.enum import Enum

#
# pyomo - A coopr.pyomo.PyomoModel object
# cpxlp - A CPLEX LP file
# nl - AMPL *.nl file
# mps - A free-format MPS file
# mod - AMPL *.mod file
# lpxlp - A LPSolve LP file
# ospl - An XML file defined by the COIN-OR OS project
# colin - A COLIN shell command
# colin_optproblem - A Python object that inherits from
#                   coopr.opt.colin.OptProblem (this can wrap a COLIN shell
#                   command, or provide a runtime optimization problem)
# 
ProblemFormat = Enum('colin', 'pyomo', 'cpxlp', 'nl', 'mps', 'mod', 'lpxlp', 'ospl', 'colin_optproblem')

#
# sol - AMPL *.sol file
# osrl - osrl XML file defined by the COIN-OR OS project
# log - An unformated logfile
# results - A coopr.opt.SolverResults object
#
ResultsFormat = Enum('sol', 'osrl', 'log', 'results')

