# DIP README

Welcome to the README for the Decomposition in Integer Programming (DIP)
Framework. DIP is distributed under the Eclipse Public License and is freely
redistributable. All source code and documentation is Copyright Matthew
Galati, Ted Ralphs, Lehigh University, and others. This README may be 
redistributed freely.

# DOCUMENTATION

For a quick start guide, please see the INSTALL file in this distribution.
Automatically generated documentation of the source code can be found here:

http://www.coin-or.org/Doxygen/Dip/

Further information can be found here:

http://projects.coin-or.org/Dip

# SUPPORT

## List Serve

DIP users should use the Dip mailing list. To subscribe, go to 
http://list.coin-or.org/mailman/listinfo/dip

## Bug Reports

Bug reports should be reported on the DIP development web site at

https://projects.coin-or.org/Dip/newticket

# CHANGELOG

## Release 0.91.4
 * Updates to dependencies
 * All examples fixed
 * DipPy examples moved into package source subdirectory
 * Samll bug fixes

## Release 0.91.3
 * Fixes for correctly producing Doxygen documentation

## Release 0.91.2
 * Fixed issue with master only variable when solving master as an integer 
   program.
 * Added ability to generate multiple columns per iteration with SYMPHONY and 
   Cbc. 

## Release 0.91.1
 * Updating dependencies.
 * Fix for dependency linking
 * Fix to installation with {{{DESTDIR}}}

## Release 0.91.0
 * Multiple parallel modes added
   * Solution of individual subproblems can be parallelized
   * Multiple subproblems can be solved simultaneously
   * Multiple algorithms can be executed in parallel (branch and cut plus
        one or more decomposition-based algorithms)
 * Warm starting for solutions of subproblems is supported when using
   SYMPHONY as the subproblem solver. 
 * Unbounded feasible regions now supported.
 * Explicit treatment of master-only variables.

## Release 0.9.12:

 * Fixed long-standing issues with stand-alone apps

 * Small some bug fixes 

## Release 0.9.11:

 * Added some new DipPy examples

 * Small bug fixes 

## Release 0.9.10:

 * Fixes to stand-alone app examples

 * Fixes to Visual studio files for examples to support property pages 

New Stable Version 0.91:

 * Changes to the DipPy callback interface to make it more user friendly

 * Changes to the application interface

 * Planning for other changes to the internal algorithm 

## Release 0.9.9:

 * Fixes to DipPy build and examples

 * Fixes to allow CGL cuts to be generated from within DipPy branch and price. 

## Release 0.9.8:

 * Fixes to DipPy examples

 * Support for dependency linking 

## Release 0.9.7:

 * Fixes to DipPy examples

 * Support for dependency linking 

## Release 0.9.6:

 * Fixes to allow proper installation of DipPy on Mac OS X 

## Release 0.9.5:

 * Small fixes to DipPy

## Release 0.9.4:

 * Fixes to parallel subproblem solution mode with OpenMP

## Release 0.9.3:

 * More updates to build system

## Release 0.9.2:

 * Updates to build system

## Release 0.9.1:

 * Fixes to Python installation

 * Fix to DipPy

## Release 0.9.0:

 * DIP now includes DipPy, a Python-based modeling language.

 * DIP is now a complete generic MILP solver, capable of automatically
   detecting block structure and applying a decomposition method.

 * DIP and DipPy build out of the box in Windows, OSX, and Linux with a
   combination of the autotools and a Python setup script.

 * There is now support for solving the subproblems in parallel when there is
   block structure using OpenMP.

 * Numerous bug fixes and improvements. 

## Release 0.82.2:

 * Fixes to build system

 * Updates to dependencies

## Release 0.82.1:

 * Fixes to build system

 * Updates to dependencies

## Release 0.82.0:

 * Support for MSVC++ version 10 added.

 * Support for BuildTools version 0.7 to incorporate recent enhancements,
   including proper library versioning in Linux, prohibiting installation of
   private headers, etc.

 * Updated externals to new stable versions of dependent projects.

 * Minor bug fixes. 

