from gimpy import Graph

if __name__ == '__main__':
    G = Graph(type = 'digraph', splines = 'true', layout = 'dot',
              display = 'pygame', rankdir = 'LR', label = 'IE Prerequisite Map',
              fontsize = '44', labelloc = 't', size = "7.5,10.0!", ratio = 'fill',
              esep = '10', ranksep = '1.8',
              )
    node_format = {
#                   'height':1.0,
#                   'width':2.0,
#                   'fixedsize':'true',
#                   'fontsize':'36',
#                   'fontcolor':'red',
                    'shape':'ellipse',
                   }

    #C = Cluster(graph_name = 'Computing', label = 'Computing Requirements', fontsize = '18')
    cluster_attrs = {'name':'Computing', 'label':'Computing Requirements', 'fontsize':'18'}
    G.add_node('CSE 2', **node_format)
    G.add_node('Eng 97', **node_format)
    G.add_node('IE 112', **node_format)
    G.add_edge('Eng 97', 'CSE 2')
    G.add_edge('CSE 2', 'IE 112', style = 'invisible', arrowhead = 'none')
    G.create_cluster(['CSE 2', 'Eng 97', 'IE 112', 'Eng 97', 'CSE 2'], cluster_attrs)
    G.add_node('IE 305', **node_format)
    #C = Cluster(graph_name = 'Isolated', label = 'Other', fontsize = '18')
    cluster_attrs = {'name':'Isolated', 'label':'Other', 'fontsize':'18'}
    G.add_node('Eng 98', **node_format)
    G.add_node('Chem 30', **node_format)
    G.add_node('Eco 1', **node_format)
    G.add_node('Acct 108', **node_format)
    G.add_node('IE 154', **node_format)
    G.add_edge('IE 305', 'Eng 98', style = 'invisible', arrowhead = 'none')
    G.add_edge('CEE 170', 'Chem 30', style = 'invisible', arrowhead = 'none')
    G.add_edge('CEE 170', 'Eco 1', style = 'invisible', arrowhead = 'none')
    G.add_edge('CEE 170', 'Acct 108', style = 'invisible', arrowhead = 'none')
    G.add_edge('CEE 170', 'IE 154', style = 'invisible', arrowhead = 'none')
    #G.add_subgraph(C)
    G.create_cluster(['Eng 98', 'Chem 30', 'Eco 1', 'Acct 108', 'IE 154'], cluster_attrs)
    #C = Cluster(graph_name = 'English', label = 'English Requirements', fontsize = '18')
    cluster_attrs = {'name':'English', 'label':'English Requirements', 'fontsize':'18'}
    G.add_node('Engl 1', **node_format)
    G.add_node('Engl 2', **node_format)
    G.add_edge('Engl 1', 'Engl 2')
    #G.add_subgraph(C)
    G.create_cluster(['Engl 1', 'Engl 2'], cluster_attrs)
    G.add_node('Math 21', **node_format)
    G.add_node('Physics 11/12')
    G.add_edge('Math 21', 'Physics 11/12')
    G.add_node('Math 22', **node_format)
    G.add_edge('Math 21', 'Math 22')
    G.add_node('Physics 21/22', **node_format)
    G.add_edge('Physics 11/12', 'Physics 21/22')
    G.add_node('Math 23', **node_format)
    G.add_edge('Math 23', 'Physics 21/22', style = 'dashed')
    G.add_edge('Math 22', 'Math 23')
    G.add_node('IE 111', **node_format)
    G.add_edge('Math 22', 'IE 111')
    G.add_node('Mat 33', **node_format)
    G.add_node('Math 205', **node_format)
    G.add_edge('Math 22', 'Math 205')
    G.add_node('IE 121', **node_format)
    G.add_edge('IE 111', 'IE 121')
    #C = Cluster(label = 'Choose Three', graph_name = 'Eng', fontsize = '18')
    cluster_attrs = {'label':'Choose Three', 'name':'Eng', 'fontsize':'18'}
    G.add_node('Mech 2/3', **node_format)
    G.add_node('ME 104', **node_format)
    G.add_node('ECE 83/81', **node_format)
    #G.add_node('CEE 170', **node_format) this is already in G
    G.add_node('Chem 44', **node_format)
    G.add_node('CSE 17', **node_format)
    G.add_edge('Physics 21/22', 'ECE 83/81', style = 'dashed')
    #G.add_subgraph(C)
    G.create_cluster(['Mech 2/3', 'ME 104', 'ECE 83/81', 'CEE 170', 'Chem 44', 'CSE 17'])
    G.add_edge('Math 22', 'Mech 2/3', stlye = 'dashed')
    G.add_edge('Physics 11/12', 'Mech 2')
    G.add_edge('Math 23', 'ME 104', style = 'dashed')
    G.add_edge('Physics 11/12', 'ME 104', style = 'dashed')
    G.add_node('IE 240', **node_format)
    G.add_edge('Math 205', 'IE 240')
    G.add_node('IE 230', **node_format)
    G.add_edge('IE 111', 'IE 230')
    G.add_node('IE 131/132', **node_format)
    G.add_edge('IE 111', 'IE 131/132', style = 'dashed')
    G.add_node('IE 215/216', **node_format)
    G.add_edge('Mat 33', 'IE 215/216')
    G.add_node('IE 224', **node_format)
    G.add_edge('IE 121', 'IE 305')
    G.add_node('IE 226', **node_format)
    G.add_edge('IE 111', 'IE 226')
    G.add_node('IE 251', **node_format)
    G.add_edge('IE 121', 'IE 251')
    G.add_edge('IE 240', 'IE 251')
    G.add_edge('IE 230', 'IE 251')
    G.add_node('IE 316', **node_format)
    G.add_edge('IE 240', 'IE 316')
    G.add_node('IE 339', **node_format)
    G.add_edge('IE 230', 'IE 339')
    #C = Cluster(graph_name = 'TE', label = 'Technical Electives', fontsize = '18')
    cluster_attrs = {'name':'TE', 'label':'Technical Electives', 'fontsize':'18'}
    G.add_node('IE 347', **node_format)
    G.add_node('IE 275', **node_format)
    G.add_node('IE 358', **node_format)
    G.add_node('IE 324', **node_format)
    G.add_node('IE 332', **node_format)
    G.add_node('IE 362', **node_format)
    G.add_node('IE 341', **node_format)
    G.add_node('IE 356', **node_format)
    G.add_node('IE 355', **node_format)
    G.add_node('IE 321', **node_format)
    G.add_node('IE 345', **node_format)
    G.add_node('IE 382', **node_format)
    G.add_node('IE 334', **node_format)
    G.add_node('IE 372', **node_format)
    G.add_node('IE 319', **node_format)
    G.add_node('IE 340', **node_format)
    G.add_node('IE 344', **node_format)
    cluster = ['IE 347', 'IE 275', 'IE 358', 'IE 324', 'IE 332', 'IE 362',
               'IE 341', 'IE 356', 'IE 355', 'IE 321', 'IE 345', 'IE 382',
               'IE 334', 'IE 372', 'IE 319', 'IE 340', 'IE 344']
    G.create_cluster = (cluster, cluster_attrs)
    G.add_edge('IE 316', 'IE 347')
    G.add_edge('IE 224', 'IE 275')
    G.add_edge('Mech 2', 'IE 324')
    G.add_edge('Math 205', 'IE 324')
    G.add_edge('IE 121', 'IE 332')
    G.add_edge('IE 230', 'IE 362')
    G.add_edge('IE 240', 'IE 362')
    G.add_edge('IE 230', 'IE 341')
    G.add_edge('IE 224', 'IE 341')
    G.add_edge('IE 240', 'IE 341')
    G.add_edge('IE 230', 'IE 356')
    G.add_edge('IE 240', 'IE 356')
    G.add_edge('IE 240', 'IE 355')
    G.add_edge('IE 275', 'IE 345')
    G.add_edge('IE 240', 'IE 372')
    G.add_edge('IE 275', 'IE 372')
    G.add_edge('IE 131/132', 'IE 319')
    G.add_edge('IE 215/216', 'IE 340')
    G.add_edge('IE 215/216', 'IE 344')
    G.add_edge('IE 362', 'IE 334', style = 'invisible', arrowhead = 'none')
    G.add_edge('IE 362', 'IE 382', style = 'invisible', arrowhead = 'none')
    G.add_edge('IE 362', 'IE 321', style = 'invisible', arrowhead = 'none')
    G.add_edge('IE 362', 'IE 358', style = 'invisible', arrowhead = 'none')
    #G.add_subgraph(C)

    G.set_display_mode('file')

    G.display(basename = 'IERequirements2', format = 'jpg')
