/*
 * Decompiled with CFR 0.152.
 */
package jphase.fit;

import jphase.ContPhaseVar;
import jphase.DenseContPhaseVar;
import jphase.fit.MomentsContPhaseFitter;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;

public class MomentsACPHFit
extends MomentsContPhaseFitter {
    public MomentsACPHFit(double[] data) {
        super(data);
    }

    public MomentsACPHFit(double m1, double m2, double m3) {
        super(m1, m2, m3);
    }

    @Override
    public ContPhaseVar fit() {
        double n2 = this.m2 / (this.m1 * this.m1);
        double n3 = this.m3 / (this.m1 * this.m2);
        ContPhaseVar res = new DenseContPhaseVar();
        int n = this.getSize(n2, n3);
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            double[] alpha = new double[]{2.0 / n2};
            double[][] A = new double[][]{{-1.0 / this.m1}};
            res = new DenseContPhaseVar(alpha, A);
        } else if (n2 <= (double)n / ((double)n - 1.0) || n3 <= 2.0 * n2 - 1.0) {
            double c = 12.0 * n2 * n2 * ((double)n + 1.0) + 16.0 * n3 * ((double)n + 1.0) + n2 * ((double)n * (n3 - 15.0) * (n3 + 1.0) - 8.0 * (n3 + 3.0));
            double b = 2.0 * (4.0 - (double)n * (3.0 * n2 - 4.0)) / (n2 * (4.0 + (double)n - (double)n * n3) + Math.sqrt((double)n * n2 * c));
            double a = (b * n2 - 2.0) * ((double)n - 1.0) * b / ((b - 1.0) * (double)n);
            double p = (b - 1.0) / a;
            double lambda = (1.0 + a * p) / this.m1;
            double mu = lambda * ((double)n - 1.0) / a;
            DenseContPhaseVar temp = DenseContPhaseVar.Erlang(mu, n - 1);
            double[] initCond = new double[n - 1];
            initCond[0] = p;
            temp.setVector((Vector)new DenseVector(initCond));
            res = temp.sum(DenseContPhaseVar.expo(lambda), new DenseContPhaseVar(n));
        } else if (n2 > (double)n / ((double)n - 1.0)) {
            double f = this.calcF(n, n2, n3);
            double a = 2.0 * (f - 1.0) * ((double)n - 1.0) / (((double)n - 1.0) * (n2 * f * f - 2.0 * f + 2.0) - (double)n);
            double p = (f - 1.0) * a;
            double lambda = (p + a) / this.m1;
            double mu = lambda * (double)(n - 1) / a;
            DenseContPhaseVar temp = DenseContPhaseVar.expo(lambda);
            double[] initCond = new double[]{p};
            temp.setVector((Vector)new DenseVector(initCond));
            res = temp.sum(DenseContPhaseVar.Erlang(mu, n - 1), new DenseContPhaseVar(n));
        } else {
            System.out.println("Error when computing resulting distribution: moments cannot be matched.");
        }
        return res;
    }

    private double calcF(int n, double n2, double n3) {
        double K1 = n - 1;
        double K2 = n - 2;
        double K3 = 3.0 * n2 - 2.0 * n3;
        double K4 = n3 - 3.0;
        double K5 = (double)n - n2;
        double K6 = 1.0 + n2 - n3;
        double K7 = (double)n + n2 - (double)n * n2;
        double K8 = 3.0 + 3.0 * n2 * n2 + n3 - 3.0 * n2 * n3;
        double K9 = 108.0 * K1 * K1 * (4.0 * K2 * K2 * K3 * (double)n * (double)n * n2 + K1 * K1 * K2 * K4 * K4 * (double)n * n2 * n2 + 4.0 * K1 * K5 * (K5 * K5 - 3.0 * K2 * K6 * (double)n * n2) + Math.sqrt(-16.0 * K1 * K1 * Math.pow(K7, 6.0) + Math.pow(4.0 * K1 * K5 * K5 * K5 + K1 * K1 * K2 * K4 * K4 * (double)n * n2 * n2 + 4.0 * K2 * (double)n * n2 * (K4 * (double)n * (double)n - 3.0 * K6 * n2 + K8 * (double)n), 2.0)));
        double K10 = K4 * K4 / (4.0 * K3 * K3) - K5 / (K1 * K3 * n2);
        double K11 = Math.pow(2.0, 0.3333333333333333) * (3.0 * K5 * K5 + K2 * (K3 + 2.0 * K4) * (double)n * n2) / (K3 * Math.pow(K9, 0.3333333333333333) * n2);
        double K12 = Math.pow(K9, 0.3333333333333333) / (3.0 * Math.pow(2.0, 2.3333333333333335) * K1 * K1 * K3 * n2);
        double K13 = Math.sqrt(K10 + K11 + K12);
        double K14 = (6.0 * K1 * K3 * K4 * K5 + 4.0 * K2 * K3 * K3 * (double)n - K1 * K1 * K4 * K4 * K4 * n2) / (4.0 * K1 * K1 * K3 * K3 * K3 * K13 * n2);
        double K15 = -K4 / (2.0 * K3);
        double K16 = Math.sqrt(2.0 * K10 - K11 - K12 - K14);
        double K17 = Math.sqrt(2.0 * K10 - K11 - K12 + K14);
        double K18 = 36.0 * K5 * K5 * K5 + 36.0 * K2 * K4 * K5 * (double)n * n2 + 9.0 * K1 * K2 * K4 * K4 * (double)n * n2 * n2 - Math.sqrt(81.0 * (4.0 * K5 * K5 * K5 + 4.0 * K2 * K4 * K5 * (double)n * n2 + K1 * K2 * K4 * K4 * (double)n * n2 * n2) * (4.0 * K5 * K5 * K5 + 4.0 * K2 * K4 * K5 * (double)n * n2 + K1 * K2 * K4 * K4 * (double)n * n2 * n2) - 48.0 * Math.pow(3.0 * K5 * K5 + 2.0 * K2 * K4 * (double)n * n2, 3.0));
        double K19 = -K5 / (K1 * K4 * n2) - Math.pow(2.0, 0.0) * (3.0 * K5 * K5 + 2.0 * K2 * K4 * (double)n * n2) / (Math.pow(3.0 * K18, 0.3333333333333333) * K1 * K4 * n2) - Math.pow(K18, 0.3333333333333333) / (Math.pow(6.0, 0.6666666666666666) * K1 * K4 * n2);
        double K20 = 6.0 * K1 * K3 * K4 * K5 + 4.0 * K2 * K3 * K3 * (double)n - K1 * K1 * K4 * K4 * K4 * n2;
        double K21 = K11 + K12 + K5 / ((double)(2 * n) * K1 * K3);
        double K22 = Math.sqrt(3.0 * K4 * K4 / (4.0 * K3 * K3) - 3.0 * K5 / (K1 * K3 * n2) + Math.sqrt(4.0 * K21 * K21 - (double)n * K2 / (n2 * K1 * K1 * K3)));
        double f = 0.0;
        if (n3 < 3.0 * n2 / 2.0) {
            f = K13 + K15 - K17;
        } else if (n3 == 3.0 * n2 / 2.0) {
            f = K19;
        } else if (n3 > 3.0 * n2 / 2.0 && K20 > 0.0) {
            f = -K13 + K15 + K16;
        } else if (K20 == 0.0) {
            f = K15 + K22;
        } else if (K20 < 0.0) {
            f = K13 + K15 + K17;
        } else {
            System.out.println("Error when computing f: undefined");
        }
        System.out.println("f: " + f);
        return f;
    }

    public int getSize(double n2, double n3) {
        int n = 0;
        if (n3 <= n2 || n2 <= 1.0) {
            System.out.println("The set of moments (n2, n3) is not representable: (" + n2 + "," + n3 + ")");
        } else {
            if (n2 >= 2.0 && n3 >= 3.0 && n3 == 1.5 * n2) {
                System.out.println("The set of moments (n2, n3) is representable by an exponential distribution: (" + n2 + "," + n3 + ")");
                return 1;
            }
            n = 2;
            while (n <= 100) {
                if (n2 >= 1.0 + 1.0 / (double)n) {
                    System.out.println("Second moment " + n2 + " " + "representable with " + n + " phases");
                    double un = 1.0 / ((double)(n * n) * n2) * ((double)(2 * (n - 2)) * ((double)n * n2 - (double)n - 1.0) * Math.sqrt(1.0 + (double)n * (n2 - 2.0) / (double)(n - 1)) + (double)(n + 2) * ((double)(3 * n) * n2 - (double)(2 * n) - 2.0));
                    double pn = (double)(n + 1) * (n2 - 2.0) / (3.0 * n2 * (double)(n - 1)) * (-2.0 * Math.sqrt(n + 1) / Math.sqrt((double)(4 * (n + 1)) - (double)(3 * n) * n2) - 1.0);
                    double an = (n2 - 2.0) / (pn * (1.0 - n2) + Math.sqrt(pn * pn + pn * (double)n * (n2 - 2.0) / (double)(n - 1)));
                    double ln = ((3.0 + an) * (double)(n - 1) + 2.0 * an) / ((double)(n - 1) * (1.0 + an * pn)) - 2.0 * an * (double)(n + 1) / ((double)(2 * (n - 1)) + an * pn * ((double)n * an + (double)(2 * n) - 2.0));
                    if (n2 >= ((double)n + 1.0) / (double)n && n2 < ((double)n + 4.0) / ((double)n + 1.0) ? n3 >= ln && (n2 >= ((double)n + 1.0) / (double)n && n2 <= (double)n / ((double)n - 1.0) ? n3 <= un : n2 > (double)n / ((double)n - 1.0)) : n2 >= ((double)n + 4.0) / ((double)n + 1.0) && n3 > ((double)n + 1.0) * n2 / (double)n && (n2 >= ((double)n + 1.0) / (double)n && n2 <= (double)n / ((double)n - 1.0) ? n3 <= un : n2 > (double)n / ((double)n - 1.0))) {
                        return n;
                    }
                    System.out.println("Third moment " + n3 + " " + "not representable with " + n + " phases");
                    ++n;
                    continue;
                }
                ++n;
            }
        }
        return n;
    }
}

