/*
 * Decompiled with CFR 0.152.
 */
package jphase.fit;

import java.util.LinkedList;
import java.util.ListIterator;
import jphase.AbstractContPhaseVar;
import jphase.ContPhaseVar;
import jphase.DenseContPhaseVar;
import jphase.HyperErlangVar;
import jphase.MatrixUtils;
import jphase.Utils;
import jphase.fit.FitterUtils;
import jphase.fit.MLContPhaseFitter;

public class EMHyperErlangFit
extends MLContPhaseFitter {
    public static double precision = 1.0E-49;
    public static double precisionCV = 0.1;
    public static int maxIter = 200;

    public EMHyperErlangFit(double[] data) {
        super(data);
    }

    @Override
    public ContPhaseVar fit() {
        return DenseContPhaseVar.HyperErlang(this.doFitHyperErlang());
    }

    public ContPhaseVar fit(int N) {
        if (this.data != null) {
            ContPhaseVar[] vars = new ContPhaseVar[N];
            double[] LH = new double[N];
            int best = 0;
            int i = 1;
            while (i <= N) {
                HyperErlangVar temp = new HyperErlangVar(N, i, new int[i], new double[i], new double[i], true);
                double tempLH = this.doFitNM(temp);
                LH[i - 1] = Math.abs(tempLH) > precision ? tempLH : Double.NEGATIVE_INFINITY;
                vars[i - 1] = temp.copy();
                if (LH[i - 1] > LH[best]) {
                    best = i - 1;
                }
                ++i;
            }
            this.var = vars[best];
            this.logLH = LH[best];
            return this.var;
        }
        return null;
    }

    public HyperErlangVar doFitHyperErlang() {
        double CVC = MatrixUtils.CV(this.data);
        double CVT = 0.0;
        boolean ready = false;
        int N = 1;
        int M = 1;
        AbstractContPhaseVar res = null;
        double logLH = 0.0;
        int k = 0;
        while (!ready) {
            System.out.println("\n\nITERATION: " + ++k);
            System.out.println("N: " + N + "\t M: " + M);
            res = new HyperErlangVar(N, M, new int[M], new double[M], new double[M], true);
            logLH = this.doFitNM((HyperErlangVar)res);
            CVT = res.CV();
            System.out.println("SCV (data): " + CVC + "\t SCV (variable): " + CVT);
            System.out.println("Mean: " + ((HyperErlangVar)res).expectedValue());
            System.out.println("Variance: " + res.variance());
            if (Math.abs(CVT - CVC) < precisionCV) {
                ready = true;
            } else {
                N = CVC > CVT ? Math.max(++M, N) : ++N;
            }
            if (k <= 100) continue;
            ready = true;
        }
        System.out.println("Final LogLH: " + logLH);
        System.out.println(res.toString());
        return res;
    }

    public double doFitNM(HyperErlangVar var) {
        LinkedList<int[]> listaPosib = new LinkedList<int[]>();
        int M = var.getM();
        int N = var.getN();
        double[] alphas = new double[M];
        double[] lambdas = new double[M];
        double tasa = 1.0 / MatrixUtils.average(this.data);
        double md = M;
        md = 1.0 / md;
        HyperErlangVar[] vars = null;
        double[] logLH = null;
        int i = 0;
        while (i < M) {
            alphas[i] = md;
            lambdas[i] = tasa;
            ++i;
        }
        int best = 0;
        if (M <= N) {
            int[] a = new int[M];
            int[] b = new int[M];
            a[0] = N - M + 1;
            int i2 = 1;
            while (i2 < M) {
                a[i2] = 1;
                ++i2;
            }
            System.arraycopy(a, 0, b, 0, M);
            listaPosib.addLast(a);
            this.searchAdd(b, listaPosib, 0);
            logLH = new double[listaPosib.size()];
            vars = new HyperErlangVar[listaPosib.size()];
            ListIterator iter = listaPosib.listIterator();
            int k = 0;
            while (iter.hasNext()) {
                int[] temp = (int[])iter.next();
                int i3 = 0;
                while (i3 < M) {
                    lambdas[i3] = (double)temp[i3] * tasa + Math.pow(10.0, i3 - 2);
                    ++i3;
                }
                HyperErlangVar varTemp = new HyperErlangVar(var.getN(), var.getM(), temp, alphas, lambdas, true);
                logLH[k] = this.doFitNMR(varTemp);
                vars[k] = varTemp;
                if (logLH[k] >= logLH[best]) {
                    best = k;
                }
                ++k;
            }
        }
        var.setR(vars[best].getR());
        var.setAlphas(vars[best].getAlphas());
        var.setLambdas(vars[best].getLambdas());
        return (double)logLH[best];
    }

    private void searchAdd(int[] a, LinkedList<int[]> lista, int k) {
        if (k < a.length - 1) {
            while (a[k] - 1 >= a[k + 1] + 1) {
                int n = k;
                a[n] = a[n] - 1;
                int n2 = k + 1;
                a[n2] = a[n2] + 1;
                int[] b = new int[a.length];
                System.arraycopy(a, 0, b, 0, a.length);
                lista.addLast(b);
                this.searchAdd(a, lista, k + 1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public double doFitNMR(HyperErlangVar var) {
        block10: {
            logLHprev = 0.0;
            logLHnow = 0.0;
            n = var.getN();
            m = var.getM();
            k = this.data.length;
            iter = 0;
            if (m != 1) ** GOTO lbl57
            var.setAlphas(new double[]{1.0});
            lambda = (double)n / FitterUtils.powerMomentK(this.data, 1);
            var.setLambdas(new double[]{lambda});
            i = 0;
            while (i < k) {
                logLHnow += (double)n * Math.log(lambda) + (double)(n - 1) * Math.log(this.data[i]) - lambda * this.data[i] - Math.log(Utils.fact(n - 1));
                ++i;
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                ++iter;
                pm = new double[m][k];
                i = 0;
                while (i < m) {
                    j = 0;
                    while (j < k) {
                        temp = (double)(var.getR()[i] - 1) * Math.log(var.getLambdas()[i] * this.data[j]) - Utils.lnFactorial(var.getR()[i] - 1) - var.getLambdas()[i] * this.data[j];
                        pm[i][j] = var.getLambdas()[i] * Math.exp(temp);
                        ++j;
                    }
                    ++i;
                }
                qm = new double[m][k];
                sumaPm = new double[k];
                logLH = 0.0;
                j = 0;
                while (j < k) {
                    i = 0;
                    while (i < m) {
                        v0 = j;
                        sumaPm[v0] = sumaPm[v0] + var.getAlphas()[i] * pm[i][j];
                        ++i;
                    }
                    if (sumaPm[j] > EMHyperErlangFit.precision) {
                        logLH += Math.log(sumaPm[j]);
                    }
                    ++j;
                }
                i = 0;
                while (i < m) {
                    j = 0;
                    while (j < k) {
                        if (sumaPm[j] > EMHyperErlangFit.precision) {
                            qm[i][j] = var.getAlphas()[i] * pm[i][j] / sumaPm[j];
                        }
                        ++j;
                    }
                    ++i;
                }
                this.mStep(qm, var.getR(), var.getAlphas(), var.getLambdas(), var);
                logLHprev = logLHnow;
                logLHnow = logLH;
lbl57:
                // 2 sources

                ** while ((Math.abs((double)(logLHnow - logLHprev)) > EMHyperErlangFit.precision || iter == 0) && iter <= EMHyperErlangFit.maxIter)
            }
        }
        return logLHnow;
    }

    private void mStep(double[][] Qm, int[] r, double[] alphas, double[] lambdas, HyperErlangVar var) {
        int j;
        int m = r.length;
        int k = this.data.length;
        double[] sumaQm = new double[m];
        int i = 0;
        while (i < m) {
            j = 0;
            while (j < k) {
                int n = i;
                alphas[n] = alphas[n] + Qm[i][j];
                ++j;
            }
            lambdas[i] = alphas[i];
            alphas[i] = alphas[i] / (double)k;
            ++i;
        }
        i = 0;
        while (i < m) {
            j = 0;
            while (j < k) {
                int n = i;
                sumaQm[n] = sumaQm[n] + Qm[i][j] * this.data[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < m) {
            if (sumaQm[i] > precision) {
                lambdas[i] = (double)r[i] * lambdas[i] / sumaQm[i];
            }
            ++i;
        }
        var.setAlphas(alphas);
        var.setLambdas(lambdas);
    }
}

