/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import jphase.SparseContPhaseVar;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class SparseContProbTest
extends TestCase {
    SparseContPhaseVar var1;
    SparseContPhaseVar var2;
    SparseContPhaseVar var3;
    double[][] matrix1 = new double[][]{{-2.0, 2.0}, {2.0, -5.0}};
    double[] vector1 = new double[]{0.2, 0.4};
    double[][] matrix2 = new double[][]{{-6.0, 2.0, 1.0, 2.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, -5.0, 1.0, 0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 1.0, -7.0, 0.0, 0.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 0.0, 0.0, -9.0, 2.0, 1.0, 0.0, 1.0, 3.0, 0.0, 0.0}, {0.0, 2.0, 0.0, 1.0, -8.0, 1.0, 0.0, 1.0, 0.0, 3.0, 0.0}, {0.0, 0.0, 2.0, 2.0, 1.0, -10.0, 2.0, 0.0, 0.0, 3.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 2.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -5.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -4.0, 2.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, -3.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 1.0, -5.0}};
    double[] vector2 = new double[]{0.2, 0.3, 0.1, 0.0, 0.0, 0.1, 0.0, 0.1, 0.0, 0.0, 0.0};
    double[] vector3 = new double[]{1.0, 0.0, 0.0, 0.0};
    double[][] matrix3 = new double[][]{{-0.1, 0.09, 0.0, 0.0}, {0.0, -0.01, 0.01, 0.0}, {0.0, 0.0, -0.01, 0.01}, {0.0, 0.0, 0.0, -0.01}};

    public static void main(String[] args) {
        TestRunner.run(SparseContProbTest.class);
    }

    protected void setUp() throws Exception {
        this.var1 = new SparseContPhaseVar(this.vector1, this.matrix1);
        this.var2 = new SparseContPhaseVar(this.vector2, this.matrix2);
        this.var3 = new SparseContPhaseVar(this.vector3, this.matrix3);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testProb1() {
        double[] realPDF = new double[]{1.2, 0.829464582, 0.609842441, 0.474606218, 0.38706825, 0.326978987, 0.283100439, 0.249155877, 0.221601814, 0.198404217, 0.178365969, 0.160756955, 0.145110311, 0.131109949, 0.118528223, 0.107191176, 0.096958718, 0.087714601, 0.079357984, 0.071800884, 0.064965284, 0.058781354, 0.053186743, 0.048124907, 0.043544973, 0.039400989, 0.03565138, 0.032258674, 0.029188842, 0.026411149, 0.023897774, 0.021623604, 0.019565849, 0.017703914, 0.016019156, 0.014494735, 0.013115381, 0.011867282, 0.010737964, 0.009716113, 0.008791504, 0.007954879, 0.007197874, 0.006512906, 0.00589312, 0.005332316, 0.00482488, 0.004365732, 0.003950277, 0.003574359, 0.003234214, 0.002926437, 0.00264795, 0.002395965, 0.002167958, 0.00196165, 0.001774974, 0.001606063, 0.001453226, 0.001314933, 0.001189801, 0.001076576, 9.74127E-4, 8.81426E-4, 7.97547E-4, 7.21651E-4, 6.52977E-4, 5.90838E-4, 5.34612E-4, 4.83737E-4, 4.37703E-4, 3.9605E-4, 3.58361E-4, 3.24259E-4, 2.93401E-4, 2.6548E-4, 2.40217E-4, 2.17357E-4, 1.96673E-4, 1.77957E-4, 1.61022E-4, 1.45699E-4, 1.31834E-4, 1.19288E-4, 1.07936E-4, 9.76648E-5, 8.83708E-5, 7.99612E-5, 7.23519E-5, 6.54667E-5, 5.92367E-5, 5.35996E-5, 4.84989E-5, 4.38836E-5, 3.97076E-5, 3.59289E-5, 3.25098E-5, 2.94161E-5, 2.66168E-5, 2.40838E-5, 2.1792E-5, 1.97182E-5, 1.78418E-5, 1.61439E-5, 1.46076E-5, 1.32175E-5, 1.19597E-5, 1.08216E-5, 9.79176E-6, 8.85995E-6, 8.01682E-6, 7.25392E-6, 6.56361E-6, 5.939E-6, 5.37383E-6, 4.86244E-6, 4.39972E-6, 3.98103E-6, 3.60219E-6, 3.25939E-6, 2.94922E-6, 2.66857E-6, 2.41462E-6, 2.18484E-6, 1.97692E-6, 1.78879E-6, 1.61857E-6, 1.46454E-6, 1.32517E-6, 1.19906E-6, 1.08496E-6, 9.81711E-7, 8.88289E-7, 8.03757E-7, 7.27269E-7, 6.5806E-7, 5.95438E-7, 5.38774E-7, 4.87503E-7, 4.41111E-7, 3.99134E-7, 3.61151E-7, 3.26783E-7, 2.95686E-7, 2.67547E-7, 2.42087E-7, 2.19049E-7, 1.98204E-7, 1.79342E-7, 1.62276E-7, 1.46833E-7};
        double[] realCDF = new double[]{0.4, 0.499822399, 0.570874086, 0.624573115, 0.667362522, 0.702893254, 0.733293795, 0.759841469, 0.783336035, 0.804305731, 0.823121282, 0.840059266, 0.85533764, 0.869135892, 0.881606698, 0.89288287, 0.903081919, 0.912307701, 0.920654256, 0.928205833, 0.935038403, 0.94122067, 0.946814367, 0.951875703, 0.956455361, 0.960599194, 0.96434872, 0.967741381, 0.970811189, 0.973588867, 0.976102235, 0.978376401, 0.980434154, 0.982296088, 0.983980845, 0.985505265, 0.986884619, 0.988132718, 0.989262036, 0.990283887, 0.991208496, 0.992045121, 0.992802126, 0.993487094, 0.99410688, 0.994667684, 0.99517512, 0.995634268, 0.996049723, 0.996425641, 0.996765786, 0.997073563, 0.99735205, 0.997604035, 0.997832042, 0.99803835, 0.998225026, 0.998393937, 0.998546774, 0.998685067, 0.998810199, 0.998923424, 0.999025873, 0.999118574, 0.999202453, 0.999278349, 0.999347023, 0.999409162, 0.999465388, 0.999516263, 0.999562297, 0.99960395, 0.999641639, 0.999675741, 0.999706599, 0.99973452, 0.999759783, 0.999782643, 0.999803327, 0.999822043, 0.999838978, 0.999854301, 0.999868166, 0.999880712, 0.999892064, 0.999902335, 0.999911629, 0.999920039, 0.999927648, 0.999934533, 0.999940763, 0.9999464, 0.999951501, 0.999956116, 0.999960292, 0.999964071, 0.99996749, 0.999970584, 0.999973383, 0.999975916, 0.999978208, 0.999980282, 0.999982158, 0.999983856, 0.999985392, 0.999986783, 0.99998804, 0.999989178, 0.999990208, 0.99999114, 0.999991983, 0.999992746, 0.999993436, 0.999994061, 0.999994626, 0.999995138, 0.9999956, 0.999996019, 0.999996398, 0.999996741, 0.999997051, 0.999997331, 0.999997585, 0.999997815, 0.999998023, 0.999998211, 0.999998381, 0.999998535, 0.999998675, 0.999998801, 0.999998915, 0.999999018, 0.999999112, 0.999999196, 0.999999273, 0.999999342, 0.999999405, 0.999999461, 0.999999512, 0.999999559, 0.999999601, 0.999999639, 0.999999673, 0.999999704, 0.999999732, 0.999999758, 0.999999781, 0.999999802, 0.999999821, 0.999999838, 0.999999853};
        double x = 0.0;
        int i = 0;
        while (x <= 15.0) {
            double calcPDF = this.var1.pdf(x);
            double calcCDF = this.var1.cdf(x);
            SparseContProbTest.assertEquals((String)"Probability Density Function non equal", (double)realPDF[i], (double)calcPDF, (double)1.0E-5);
            SparseContProbTest.assertEquals((String)"Cumulative Probability Function non equal", (double)realCDF[i], (double)calcCDF, (double)1.0E-5);
            x += 0.1;
            ++i;
        }
        SparseContProbTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix1).add(-1.0, this.var1.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContProbTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector1).add(-1.0, this.var1.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testProb2() {
        double[] realPDF = new double[]{0.3, 0.251426945, 0.276247761, 0.318824335, 0.357498359, 0.38512447, 0.400651826, 0.405405616, 0.401446658, 0.390870529, 0.375535397, 0.356982245, 0.336438961, 0.314856259, 0.292952697, 0.271258273, 0.250153212, 0.229900557, 0.210672769, 0.192573304, 0.175653611, 0.15992663, 0.145377317, 0.131970774, 0.119658568, 0.10838351, 0.098083312, 0.088693283, 0.080148346, 0.072384474, 0.065339715, 0.058954874, 0.053173951, 0.047944391, 0.043217189, 0.038946894, 0.035091542, 0.031612527, 0.028474451, 0.02564494, 0.023094456, 0.020796105, 0.018725434, 0.016860252, 0.015180437, 0.013667773, 0.012305775, 0.011079546, 0.009975629, 0.008981874, 0.008087322, 0.00728209, 0.006557268, 0.005904827, 0.005317535, 0.004788879, 0.004312995, 0.003884601, 0.003498947, 0.003151753, 0.002839173, 0.002557741, 0.002304342, 0.002076171, 0.001870705, 0.001685675, 0.001519039, 0.001368959, 0.001233781, 0.00111202, 0.001002336, 9.03525E-4, 8.14504E-4, 7.34298E-4, 6.62029E-4, 5.96908E-4, 5.38224E-4, 4.85338E-4, 4.37674E-4, 3.94713E-4, 3.55989E-4, 3.21081E-4, 2.89613E-4, 2.61243E-4, 2.35665E-4, 2.12602E-4, 1.91807E-4, 1.73054E-4, 1.56143E-4, 1.40891E-4, 1.27135E-4, 1.14728E-4, 1.03537E-4, 9.34421E-5, 8.43352E-5, 7.61193E-5, 6.8707E-5, 6.20192E-5, 5.59848E-5, 5.05398E-5, 4.56263E-5, 4.11922E-5, 3.71905E-5, 3.3579E-5, 3.03194E-5, 2.73772E-5, 2.47216E-5, 2.23243E-5, 2.01603E-5, 1.82068E-5, 1.64431E-5, 1.48508E-5, 1.34132E-5, 1.21151E-5, 1.0943E-5, 9.88469E-6, 8.92899E-6, 8.06595E-6, 7.28656E-6, 6.58268E-6, 5.94697E-6, 5.37282E-6, 4.85424E-6, 4.38584E-6, 3.96275E-6, 3.58058E-6, 3.23535E-6, 2.92348E-6, 2.64175E-6, 2.38723E-6, 2.15728E-6, 1.94953E-6, 1.76184E-6, 1.59225E-6, 1.43902E-6, 1.30056E-6, 1.17545E-6, 1.06241E-6, 9.60252E-7, 8.67938E-7, 7.84516E-7, 7.09126E-7, 6.40994E-7, 5.7942E-7, 5.23771E-7, 4.73475E-7, 4.28018E-7, 3.86931E-7, 3.49795E-7, 3.16229E-7, 2.85889E-7};
        double[] realCDF = new double[]{0.2, 0.226571413, 0.25265034, 0.282378355, 0.316270297, 0.353503441, 0.392889519, 0.433273978, 0.473680218, 0.513343061, 0.551696079, 0.588343193, 0.623026478, 0.655596602, 0.685987249, 0.714194263, 0.74025868, 0.76425342, 0.786273029, 0.806425643, 0.824827051, 0.841596152, 0.856851654, 0.870709722, 0.883282297, 0.894676013, 0.904991496, 0.914323014, 0.922758321, 0.930378716, 0.937259184, 0.943468652, 0.949070285, 0.954121817, 0.958675905, 0.962780482, 0.966479111, 0.969811331, 0.972812978, 0.975516503, 0.977951264, 0.980143796, 0.982118071, 0.98389573, 0.985496299, 0.986937387, 0.988234874, 0.989403066, 0.990454858, 0.991401863, 0.992254539, 0.993022304, 0.993713636, 0.994336169, 0.994896772, 0.99540163, 0.995856307, 0.996265811, 0.996634651, 0.996966882, 0.997266155, 0.997535755, 0.997778637, 0.997997464, 0.998194628, 0.998372286, 0.998532376, 0.998676645, 0.998806664, 0.998923848, 0.999029471, 0.999124678, 0.999210502, 0.999287872, 0.999357626, 0.999420516, 0.999477222, 0.999528354, 0.999574464, 0.999616046, 0.999653547, 0.999687371, 0.999717878, 0.999745397, 0.99977022, 0.999792613, 0.999812816, 0.999831043, 0.999847488, 0.999862327, 0.999875716, 0.999887799, 0.999898702, 0.999908543, 0.999917424, 0.999925439, 0.999932674, 0.999939205, 0.9999451, 0.999950422, 0.999955226, 0.999959563, 0.999963478, 0.999967014, 0.999970206, 0.999973088, 0.999975691, 0.999978041, 0.999980164, 0.99998208, 0.999983811, 0.999985375, 0.999986787, 0.999988062, 0.999989214, 0.999990254, 0.999991194, 0.999992043, 0.99999281, 0.999993503, 0.999994129, 0.999994694, 0.999995205, 0.999995667, 0.999996084, 0.999996461, 0.999996801, 0.999997109, 0.999997387, 0.999997638, 0.999997865, 0.999998071, 0.999998256, 0.999998424, 0.999998575, 0.999998712, 0.999998836, 0.999998947, 0.999999048, 0.99999914, 0.999999222, 0.999999297, 0.999999364, 0.999999425, 0.99999948, 0.99999953, 0.999999575, 0.999999616, 0.999999653, 0.999999686, 0.999999716};
        double x = 0.0;
        int i = 0;
        while (x <= 1.0) {
            double calcPDF = this.var2.pdf(x);
            double calcCDF = this.var2.cdf(x);
            SparseContProbTest.assertEquals((String)"Probability Density Function non equal", (double)realPDF[i], (double)calcPDF, (double)1.0E-5);
            SparseContProbTest.assertEquals((String)"Cumulative Probability Function non equal", (double)realCDF[i], (double)calcCDF, (double)1.0E-5);
            x += 0.1;
            ++i;
        }
        SparseContProbTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix2).add(-1.0, this.var2.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContProbTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector2).add(-1.0, this.var2.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    /*
     * Opcode count of 32094 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public void testProb3() {
        double[] realPDF = new double[]{0.01, 0.009753099, 0.009512296, 0.009277441, 0.009048389, 0.008824997, 0.008607128, 0.008394646, 0.00818742, 0.007985321, 0.007788224, 0.007596007, 0.00740855, 0.007225738, 0.007047456, 0.006873594, 0.006704045, 0.006538703, 0.006377466, 0.006220232, 0.006066906, 0.005917391, 0.005771594, 0.005629426, 0.005490796, 0.00535562, 0.005223813, 0.005095293, 0.00496998, 0.004847796, 0.004728666, 0.004612513, 0.004499267, 0.004388856, 0.004281211, 0.004176266, 0.004073954, 0.003974212, 0.003876978, 0.00378219, 0.00368979, 0.003599718, 0.003511919, 0.003426337, 0.003342919, 0.003261613, 0.003182366, 0.00310513, 0.003029855, 0.002956495, 0.002885002, 0.002815332, 0.002747442, 0.002681286, 0.002616823, 0.002554014, 0.002492817, 0.002433194, 0.002375107, 0.002318518, 0.002263392, 0.002209694, 0.002157388, 0.002106442, 0.002056825, 0.0020085, 0.001961439, 0.001915612, 0.001870988, 0.001827539, 0.001785236, 0.001744052, 0.00170396, 0.001664934, 0.001626949, 0.001589978, 0.001553999, 0.001518987, 0.001484921, 0.001451775, 0.001419528, 0.00138816, 0.001357648, 0.001327973, 0.001299115, 0.001271054, 0.001243771, 0.001217248, 0.001191466, 0.001166408, 0.001142056, 0.001118394, 0.001095406, 0.001073077, 0.001051388, 0.001030326, 0.001009875, 9.90022E-4, 9.70751E-4, 9.5205E-4, 9.33905E-4, 9.16302E-4, 8.9923E-4, 8.82674E-4, 8.66623E-4, 8.51066E-4, 8.3599E-4, 8.21385E-4, 8.0724E-4, 7.93542E-4, 7.80282E-4, 7.67449E-4, 7.55034E-4, 7.43026E-4, 7.31416E-4, 7.20195E-4, 7.09354E-4, 6.98883E-4, 6.88775E-4, 6.7902E-4, 6.6961E-4, 6.60538E-4, 6.51795E-4, 6.43374E-4, 6.35267E-4, 6.27468E-4, 6.19968E-4, 6.12761E-4, 6.05839E-4, 5.99197E-4, 5.92827E-4, 5.86724E-4, 5.80882E-4, 5.75293E-4, 5.69954E-4, 5.64856E-4, 5.59996E-4, 5.55367E-4, 5.50965E-4, 5.46784E-4, 5.42818E-4, 5.39065E-4, 5.35517E-4, 5.3217E-4, 5.2902E-4, 5.26062E-4, 5.23291E-4, 5.20705E-4, 5.18297E-4, 5.16064E-4, 5.14003E-4, 5.12109E-4, 5.10378E-4, 5.08807E-4, 5.07392E-4, 5.06129E-4, 5.05016E-4, 5.04048E-4, 5.03222E-4, 5.02537E-4, 5.01986E-4, 5.01568E-4, 5.0128E-4, 5.01118E-4, 5.0108E-4, 5.01164E-4, 5.01366E-4, 5.01683E-4, 5.02114E-4, 5.02654E-4, 5.03303E-4, 5.04058E-4, 5.04915E-4, 5.05874E-4, 5.06931E-4, 5.08084E-4, 5.09331E-4, 5.10672E-4, 5.12101E-4, 5.13619E-4, 5.15222E-4, 5.16909E-4, 5.18678E-4, 5.20527E-4, 5.22455E-4, 5.24459E-4, 5.26538E-4, 5.2869E-4, 5.30914E-4, 5.33208E-4, 5.3557E-4, 5.37999E-4, 5.40493E-4, 5.43051E-4, 5.45671E-4, 5.48353E-4, 5.51096E-4, 5.53895E-4, 5.56751E-4, 5.59663E-4, 5.62629E-4, 5.65648E-4, 5.68719E-4, 5.71841E-4, 5.75013E-4, 5.78232E-4, 5.815E-4, 5.84813E-4, 5.88172E-4, 5.91574E-4, 5.9502E-4, 5.98508E-4, 6.02038E-4, 6.05607E-4, 6.09216E-4, 6.12865E-4, 6.1655E-4, 6.20271E-4, 6.24028E-4, 6.2782E-4, 6.31647E-4, 6.35506E-4, 6.39398E-4, 6.43322E-4, 6.47277E-4, 6.51263E-4, 6.55277E-4, 6.59321E-4, 6.63393E-4, 6.67492E-4, 6.71618E-4, 6.75771E-4, 6.79948E-4, 6.84151E-4, 6.88378E-4, 6.92631E-4, 6.96905E-4, 7.01202E-4, 7.05521E-4, 7.09861E-4, 7.14222E-4, 7.18603E-4, 7.23004E-4, 7.27425E-4, 7.31864E-4, 7.36322E-4, 7.40797E-4, 7.4529E-4, 7.498E-4, 7.54327E-4, 7.58869E-4, 7.63427E-4, 7.68E-4, 7.72588E-4, 7.77191E-4, 7.81809E-4, 7.86439E-4, 7.91082E-4, 7.95738E-4, 8.00406E-4, 8.05087E-4, 8.09779E-4, 8.14482E-4, 8.19196E-4, 8.23921E-4, 8.28656E-4, 8.33402E-4, 8.38156E-4, 8.42921E-4, 8.47694E-4, 8.52476E-4, 8.57266E-4, 8.62065E-4, 8.66871E-4, 8.71685E-4, 8.76508E-4, 8.81336E-4, 8.86171E-4, 8.91012E-4, 8.9586E-4, 9.00713E-4, 9.05572E-4, 9.10437E-4, 9.15307E-4, 9.20181E-4, 9.25061E-4, 9.29945E-4, 9.34833E-4, 9.39725E-4, 9.44621E-4, 9.49521E-4, 9.54424E-4, 9.5933E-4, 9.64239E-4, 9.69151E-4, 9.74065E-4, 9.78984E-4, 9.83903E-4, 9.88824E-4, 9.93746E-4, 9.98671E-4, 0.001003596, 0.001008523, 0.001013452, 0.00101838, 0.00102331, 0.00102824, 0.001033171, 0.001038102, 0.001043033, 0.001047964, 0.001052894, 0.001057824, 0.001062754, 0.001067683, 0.00107261, 0.001077537, 0.001082463, 0.001087389, 0.001092313, 0.001097234, 0.001102154, 0.001107072, 0.001111988, 0.001116902, 0.001121814, 0.001126723, 0.00113163, 0.001136535, 0.001141436, 0.001146335, 0.001151231, 0.001156124, 0.001161013, 0.001165899, 0.001170782, 0.001175661, 0.001180537, 0.001185409, 0.001190279, 0.001195143, 0.001200003, 0.001204859, 0.001209711, 0.001214558, 0.001219401, 0.001224239, 0.001229073, 0.001233902, 0.001238726, 0.001243546, 0.00124836, 0.001253169, 0.001257973, 0.001262772, 0.001267565, 0.001272353, 0.001277135, 0.001281912, 0.001286683, 0.001291448, 0.001296209, 0.001300962, 0.00130571, 0.001310451, 0.001315186, 0.001319915, 0.001324638, 0.001329354, 0.001334064, 0.001338767, 0.001343464, 0.001348154, 0.001352837, 0.001357514, 0.001362183, 0.001366846, 0.001371501, 0.00137615, 0.001380791, 0.001385425, 0.001390052, 0.001394672, 0.001399285, 0.00140389, 0.001408488, 0.001413077, 0.001417659, 0.001422234, 0.0014268, 0.001431359, 0.00143591, 0.001440453, 0.001444988, 0.001449515, 0.001454034, 0.001458545, 0.001463048, 0.001467542, 0.001472028, 0.001476506, 0.001480976, 0.001485437, 0.001489889, 0.001494333, 0.001498769, 0.001503197, 0.001507615, 0.001512025, 0.001516426, 0.001520818, 0.001525201, 0.001529575, 0.00153394, 0.001538297, 0.001542644, 0.001546982, 0.001551311, 0.001555631, 0.001559942, 0.001564244, 0.001568536, 0.001572819, 0.001577093, 0.001581357, 0.001585612, 0.001589858, 0.001594094, 0.001598321, 0.001602539, 0.001606746, 0.001610944, 0.001615133, 0.001619311, 0.00162348, 0.001627639, 0.001631788, 0.001635928, 0.001640057, 0.001644177, 0.001648287, 0.001652386, 0.001656476, 0.001660556, 0.001664626, 0.001668686, 0.001672736, 0.001676775, 0.001680805, 0.001684824, 0.001688833, 0.001692832, 0.001696822, 0.0017008, 0.001704768, 0.001708726, 0.001712673, 0.001716611, 0.001720537, 0.001724453, 0.001728359, 0.001732255, 0.001736139, 0.001740014, 0.001743878, 0.001747731, 0.001751573, 0.001755405, 0.001759227, 0.001763038, 0.001766838, 0.001770627, 0.001774406, 0.001778174, 0.001781931, 0.001785679, 0.001789415, 0.00179314, 0.001796854, 0.001800558, 0.00180425, 0.001807932, 0.001811603, 0.001815263, 0.001818912, 0.00182255, 0.001826177, 0.001829793, 0.001833399, 0.001836993, 0.001840576, 0.001844149, 0.00184771, 0.00185126, 0.001854799, 0.001858327, 0.001861844, 0.00186535, 0.001868845, 0.00187233, 0.001875802, 0.001879264, 0.001882714, 0.001886154, 0.001889582, 0.001892998, 0.001896404, 0.001899798, 0.001903182, 0.001906554, 0.001909915, 0.001913264, 0.001916602, 0.00191993, 0.001923245, 0.00192655, 0.001929843, 0.001933125, 0.001936396, 0.001939655, 0.001942903, 0.00194614, 0.001949365, 0.001952581, 0.001955784, 0.001958975, 0.001962155, 0.001965324, 0.001968481, 0.001971628, 0.001974762, 0.001977886, 0.001980998, 0.001984098, 0.001987187, 0.001990265, 0.001993332, 0.001996387, 0.001999431, 0.002002463, 0.002005484, 0.002008493, 0.002011491, 0.002014478, 0.002017453, 0.002020417, 0.002023369, 0.002026312, 0.002029241, 0.002032159, 0.002035066, 0.002037962, 0.002040846, 0.002043718, 0.002046579, 0.002049429, 0.002052267, 0.002055094, 0.00205791, 0.002060714, 0.002063506, 0.002066287, 0.002069057, 0.002071816, 0.002074563, 0.002077298, 0.002080022, 0.002082735, 0.002085436, 0.002088126, 0.002090805, 0.002093473, 0.002096129, 0.002098773, 0.002101406, 0.002104028, 0.002106638, 0.002109237, 0.002111824, 0.0021144, 0.002116965, 0.002119518, 0.00212206, 0.002124591, 0.00212711, 0.002129618, 0.002132115, 0.0021346, 0.002137074, 0.002139536, 0.002141988, 0.002144428, 0.002146856, 0.002149274, 0.00215168, 0.002154074, 0.002156459, 0.002158831, 0.002161192, 0.002163542, 0.00216588, 0.002168207, 0.002170523, 0.002172828, 0.002175121, 0.002177403, 0.002179674, 0.002181934, 0.002184183, 0.00218642, 0.002188646, 0.002190861, 0.002193065, 0.002195258, 0.002197439, 0.00219961, 0.002201769, 0.002203917, 0.002206054, 0.00220818, 0.002210294, 0.002212399, 0.002214492, 0.002216573, 0.002218644, 0.002220703, 0.002222751, 0.002224789, 0.002226815, 0.00222883, 0.002230834, 0.002232828, 0.00223481, 0.002236781, 0.002238742, 0.002240691, 0.002242629, 0.002244557, 0.002246473, 0.002248379, 0.002250274, 0.002252158, 0.002254031, 0.002255893, 0.002257744, 0.002259584, 0.002261415, 0.002263233, 0.002265041, 0.002266838, 0.002268625, 0.0022704, 0.002272165, 0.002273919, 0.002275663, 0.002277395, 0.002279117, 0.002280828, 0.002282529, 0.002284218, 0.002285898, 0.002287566, 0.002289224, 0.002290871, 0.002292508, 0.002294134, 0.002295749, 0.002297354, 0.002298948, 0.002300532, 0.002302105, 0.002303668, 0.002305221, 0.002306762, 0.002308293, 0.002309814, 0.002311324, 0.002312824, 0.002314314, 0.002315793, 0.002317261, 0.002318719, 0.002320167, 0.002321605, 0.002323032, 0.002324449, 0.002325855, 0.002327252, 0.002328637, 0.002330013, 0.002331379, 0.002332734, 0.002334079, 0.002335413, 0.002336738, 0.002338052, 0.002339357, 0.002340651, 0.002341935, 0.002343209, 0.002344473, 0.002345727, 0.00234697, 0.002348204, 0.002349427, 0.002350641, 0.002351844, 0.002353038, 0.002354221, 0.002355395, 0.002356558, 0.002357712, 0.002358856, 0.002359989, 0.002361113, 0.002362227, 0.002363332, 0.002364426, 0.002365511, 0.002366585, 0.00236765, 0.002368706, 0.002369752, 0.002370788, 0.002371814, 0.00237283, 0.002373837, 0.002374834, 0.002375821, 0.002376799, 0.002377767, 0.002378725, 0.002379674, 0.002380614, 0.002381543, 0.002382464, 0.002383374, 0.002384276, 0.002385167, 0.00238605, 0.002386922, 0.002387786, 0.00238864, 0.002389484, 0.00239032, 0.002391145, 0.002391962, 0.00239277, 0.002393568, 0.002394356, 0.002395136, 0.002395906, 0.002396666, 0.002397418, 0.00239816, 0.002398894, 0.002399618, 0.002400332, 0.002401038, 0.002401735, 0.002402422, 0.002403101, 0.00240377, 0.00240443, 0.002405082, 0.002405724, 0.002406357, 0.002406981, 0.002407597, 0.002408203, 0.002408801, 0.002409389, 0.002409969, 0.00241054, 0.002411102, 0.002411656, 0.0024122, 0.002412735, 0.002413262, 0.00241378, 0.002414289, 0.00241479, 0.002415282, 0.002415765, 0.00241624, 0.002416705, 0.002417163, 0.002417611, 0.002418051, 0.002418483, 0.002418906, 0.00241932, 0.002419726, 0.002420123, 0.002420512, 0.002420892, 0.002421264, 0.002421628, 0.002421983, 0.00242233, 0.002422668, 0.002422998, 0.00242332, 0.002423633, 0.002423938, 0.002424235, 0.002424523, 0.002424804, 0.002425076, 0.002425339, 0.002425595, 0.002425843, 0.002426082, 0.002426313, 0.002426536, 0.002426751, 0.002426958, 0.002427157, 0.002427348, 0.00242753, 0.002427705, 0.002427872, 0.002428031, 0.002428182, 0.002428325, 0.00242846, 0.002428587, 0.002428707, 0.002428818, 0.002428922, 0.002429017, 0.002429106, 0.002429186, 0.002429258, 0.002429323, 0.00242938, 0.002429429, 0.002429471, 0.002429505, 0.002429531, 0.00242955, 0.002429561, 0.002429565, 0.002429561, 0.002429549, 0.00242953, 0.002429503, 0.002429469, 0.002429428, 0.002429378, 0.002429322, 0.002429259, 0.002429187, 0.002429109, 0.002429023, 0.002428929, 0.002428828, 0.00242872, 0.002428605, 0.002428482, 0.002428353, 0.002428216, 0.002428071, 0.00242792, 0.002427761, 0.002427595, 0.002427423, 0.002427243, 0.002427055, 0.002426861, 0.00242666, 0.002426452, 0.002426236, 0.002426014, 0.002425784, 0.002425548, 0.002425305, 0.002425055, 0.002424798, 0.002424534, 0.002424263, 0.002423986, 0.002423701, 0.00242341, 0.002423112, 0.002422807, 0.002422495, 0.002422176, 0.002421851, 0.002421519, 0.002421181, 0.002420836, 0.002420484, 0.002420125, 0.00241976, 0.002419388, 0.00241901, 0.002418625, 0.002418234, 0.002417836, 0.002417431, 0.00241702, 0.002416603, 0.002416179, 0.002415749, 0.002415313, 0.00241487, 0.00241442, 0.002413965, 0.002413503, 0.002413034, 0.002412559, 0.002412078, 0.002411591, 0.002411098, 0.002410598, 0.002410092, 0.00240958, 0.002409062, 0.002408537, 0.002408006, 0.00240747, 0.002406927, 0.002406378, 0.002405823, 0.002405262, 0.002404695, 0.002404122, 0.002403543, 0.002402958, 0.002402367, 0.002401771, 0.002401168, 0.002400559, 0.002399945, 0.002399324, 0.002398698, 0.002398066, 0.002397428, 0.002396785, 0.002396135, 0.00239548, 0.002394819, 0.002394152, 0.00239348, 0.002392802, 0.002392118, 0.002391429, 0.002390734, 0.002390033, 0.002389327, 0.002388615, 0.002387898, 0.002387175, 0.002386447, 0.002385713, 0.002384974, 0.002384229, 0.002383479, 0.002382723, 0.002381962, 0.002381195, 0.002380424, 0.002379646, 0.002378864, 0.002378076, 0.002377282, 0.002376484, 0.00237568, 0.002374871, 0.002374057, 0.002373237, 0.002372412, 0.002371582, 0.002370747, 0.002369907, 0.002369062, 0.002368211, 0.002367355, 0.002366495, 0.002365629, 0.002364758, 0.002363882, 0.002363001, 0.002362116, 0.002361225, 0.002360329, 0.002359428, 0.002358523, 0.002357612, 0.002356697, 0.002355776, 0.002354851, 0.002353921, 0.002352986, 0.002352046, 0.002351102, 0.002350152, 0.002349198, 0.002348239, 0.002347276, 0.002346308, 0.002345335, 0.002344357, 0.002343375, 0.002342388, 0.002341396, 0.0023404, 0.002339399, 0.002338394, 0.002337384, 0.00233637, 0.002335351, 0.002334327, 0.002333299, 0.002332267, 0.00233123, 0.002330189, 0.002329143, 0.002328093, 0.002327038, 0.002325979, 0.002324916, 0.002323848, 0.002322776, 0.0023217, 0.002320619, 0.002319534, 0.002318445, 0.002317352, 0.002316254, 0.002315152, 0.002314046, 0.002312936, 0.002311821, 0.002310703, 0.00230958, 0.002308453, 0.002307322, 0.002306187, 0.002305048, 0.002303905, 0.002302758, 0.002301606, 0.002300451, 0.002299292, 0.002298129, 0.002296961, 0.00229579, 0.002294615, 0.002293436, 0.002292253, 0.002291067, 0.002289876, 0.002288681, 0.002287483, 0.002286281, 0.002285075, 0.002283865, 0.002282651, 0.002281434, 0.002280213, 0.002278988, 0.00227776, 0.002276527, 0.002275292, 0.002274052, 0.002272809, 0.002271562, 0.002270312, 0.002269057, 0.0022678, 0.002266538, 0.002265274, 0.002264005, 0.002262733, 0.002261458, 0.002260179, 0.002258896, 0.00225761, 0.002256321, 0.002255028, 0.002253732, 0.002252432, 0.002251129, 0.002249823, 0.002248513, 0.0022472, 0.002245883, 0.002244563, 0.00224324, 0.002241913, 0.002240584, 0.002239251, 0.002237915, 0.002236575, 0.002235232, 0.002233886, 0.002232537, 0.002231185, 0.002229829, 0.00222847, 0.002227109, 0.002225744, 0.002224376, 0.002223004, 0.00222163, 0.002220253, 0.002218872, 0.002217489, 0.002216103, 0.002214713, 0.002213321, 0.002211925, 0.002210527, 0.002209125, 0.002207721, 0.002206314, 0.002204904, 0.002203491, 0.002202075, 0.002200656, 0.002199234, 0.00219781, 0.002196382, 0.002194952, 0.002193519, 0.002192083, 0.002190645, 0.002189203, 0.002187759, 0.002186312, 0.002184863, 0.002183411, 0.002181956, 0.002180498, 0.002179038, 0.002177575, 0.002176109, 0.002174641, 0.00217317, 0.002171696, 0.00217022, 0.002168741, 0.00216726, 0.002165776, 0.00216429, 0.002162801, 0.00216131, 0.002159816, 0.00215832, 0.002156821, 0.00215532, 0.002153816, 0.00215231, 0.002150801, 0.00214929, 0.002147777, 0.002146261, 0.002144743, 0.002143222, 0.002141699, 0.002140174, 0.002138646, 0.002137117, 0.002135584, 0.00213405, 0.002132513, 0.002130974, 0.002129433, 0.00212789, 0.002126344, 0.002124796, 0.002123246, 0.002121694, 0.002120139, 0.002118583, 0.002117024, 0.002115463, 0.0021139, 0.002112335, 0.002110768, 0.002109198, 0.002107627, 0.002106054, 0.002104478, 0.002102901, 0.002101321, 0.002099739, 0.002098156, 0.00209657, 0.002094983, 0.002093393, 0.002091802, 0.002090208, 0.002088613, 0.002087016, 0.002085416, 0.002083815, 0.002082212, 0.002080607, 0.002079001, 0.002077392, 0.002075782, 0.00207417, 0.002072556, 0.00207094, 0.002069322, 0.002067703, 0.002066081, 0.002064458, 0.002062834, 0.002061207, 0.002059579, 0.002057949, 0.002056318, 0.002054684, 0.002053049, 0.002051413, 0.002049774, 0.002048134, 0.002046493, 0.00204485, 0.002043205, 0.002041558, 0.00203991, 0.002038261, 0.002036609, 0.002034957, 0.002033302, 0.002031647, 0.002029989, 0.00202833, 0.00202667, 0.002025008, 0.002023345, 0.00202168, 0.002020014, 0.002018346, 0.002016677, 0.002015006, 0.002013334, 0.002011661, 0.002009986, 0.00200831, 0.002006632, 0.002004953, 0.002003272, 0.002001591, 0.001999908, 0.001998223, 0.001996538, 0.001994851, 0.001993162, 0.001991473, 0.001989782, 0.00198809, 0.001986396, 0.001984702, 0.001983006, 0.001981309, 0.001979611, 0.001977911, 0.00197621, 0.001974508, 0.001972805, 0.001971101, 0.001969396, 0.001967689, 0.001965982, 0.001964273, 0.001962563, 0.001960852, 0.00195914, 0.001957426, 0.001955712, 0.001953997, 0.00195228, 0.001950563, 0.001948844, 0.001947125, 0.001945404, 0.001943683, 0.00194196, 0.001940236, 0.001938512, 0.001936786, 0.00193506, 0.001933332, 0.001931604, 0.001929875, 0.001928144, 0.001926413, 0.001924681, 0.001922948, 0.001921214, 0.001919479, 0.001917744, 0.001916007, 0.00191427, 0.001912532, 0.001910793, 0.001909053, 0.001907312, 0.00190557, 0.001903828, 0.001902085, 0.001900341, 0.001898597, 0.001896851, 0.001895105, 0.001893358, 0.00189161, 0.001889862, 0.001888113, 0.001886363, 0.001884613, 0.001882861, 0.001881109, 0.001879357, 0.001877604, 0.00187585, 0.001874095, 0.00187234, 0.001870584, 0.001868827, 0.00186707, 0.001865313, 0.001863554, 0.001861795, 0.001860036, 0.001858276, 0.001856515, 0.001854754, 0.001852992, 0.00185123, 0.001849467, 0.001847703, 0.00184594, 0.001844175, 0.00184241, 0.001840645, 0.001838879, 0.001837113, 0.001835346, 0.001833578, 0.001831811, 0.001830042, 0.001828274, 0.001826505, 0.001824735, 0.001822965, 0.001821195, 0.001819424, 0.001817653, 0.001815881, 0.001814109, 0.001812337, 0.001810565, 0.001808792, 0.001807018, 0.001805244, 0.00180347, 0.001801696, 0.001799921, 0.001798146, 0.001796371, 0.001794596, 0.00179282, 0.001791044, 0.001789267, 0.00178749, 0.001785714, 0.001783936, 0.001782159, 0.001780381, 0.001778603, 0.001776825, 0.001775047, 0.001773268, 0.00177149, 0.001769711, 0.001767932, 0.001766152, 0.001764373, 0.001762593, 0.001760813, 0.001759033, 0.001757253, 0.001755473, 0.001753693, 0.001751912, 0.001750132, 0.001748351, 0.00174657, 0.001744789, 0.001743008, 0.001741227, 0.001739446, 0.001737665, 0.001735883, 0.001734102, 0.001732321, 0.001730539, 0.001728758, 0.001726976, 0.001725195, 0.001723413, 0.001721632, 0.00171985, 0.001718069, 0.001716287, 0.001714505, 0.001712724, 0.001710943, 0.001709161, 0.00170738, 0.001705598, 0.001703817, 0.001702036, 0.001700255, 0.001698474, 0.001696693, 0.001694912, 0.001693131, 0.00169135, 0.00168957, 0.001687789, 0.001686009, 0.001684228, 0.001682448, 0.001680668, 0.001678889, 0.001677109, 0.001675329, 0.00167355, 0.001671771, 0.001669992, 0.001668213, 0.001666434, 0.001664656, 0.001662877, 0.001661099, 0.001659321, 0.001657544, 0.001655766, 0.001653989, 0.001652212, 0.001650435, 0.001648658, 0.001646882, 0.001645106, 0.00164333, 0.001641555, 0.00163978, 0.001638005, 0.00163623, 0.001634456, 0.001632682, 0.001630908, 0.001629134, 0.001627361, 0.001625588, 0.001623816, 0.001622043, 0.001620272, 0.0016185, 0.001616729, 0.001614958, 0.001613187, 0.001611417, 0.001609647, 0.001607878, 0.001606109, 0.00160434, 0.001602572, 0.001600804, 0.001599036, 0.001597269, 0.001595503, 0.001593736, 0.00159197, 0.001590205, 0.00158844, 0.001586675, 0.001584911, 0.001583147, 0.001581384, 0.001579621, 0.001577859, 0.001576097, 0.001574336, 0.001572575, 0.001570814, 0.001569054, 0.001567295, 0.001565535, 0.001563777, 0.001562019, 0.001560261, 0.001558504, 0.001556748, 0.001554992, 0.001553236, 0.001551481, 0.001549727, 0.001547973, 0.001546219, 0.001544467, 0.001542714, 0.001540963, 0.001539211, 0.001537461, 0.001535711, 0.001533961, 0.001532213, 0.001530464, 0.001528717, 0.00152697, 0.001525223, 0.001523477, 0.001521732, 0.001519987, 0.001518243, 0.0015165, 0.001514757, 0.001513014, 0.001511273, 0.001509532, 0.001507792, 0.001506052, 0.001504313, 0.001502575, 0.001500837, 0.0014991, 0.001497363, 0.001495628, 0.001493893, 0.001492158, 0.001490424, 0.001488691, 0.001486959, 0.001485228, 0.001483497, 0.001481766, 0.001480037, 0.001478308, 0.00147658, 0.001474853, 0.001473126, 0.0014714, 0.001469675, 0.00146795, 0.001466227, 0.001464504, 0.001462781, 0.00146106, 0.001459339, 0.001457619, 0.0014559, 0.001454181, 0.001452464, 0.001450747, 0.00144903, 0.001447315, 0.0014456, 0.001443887, 0.001442174, 0.001440461, 0.00143875, 0.001437039, 0.001435329, 0.00143362, 0.001431912, 0.001430205, 0.001428498, 0.001426793, 0.001425088, 0.001423383, 0.00142168, 0.001419978, 0.001418276, 0.001416575, 0.001414875, 0.001413176, 0.001411478, 0.001409781, 0.001408084, 0.001406389, 0.001404694, 0.001403, 0.001401307, 0.001399615, 0.001397923, 0.001396233, 0.001394544, 0.001392855, 0.001391167, 0.00138948, 0.001387794, 0.001386109, 0.001384425, 0.001382742, 0.00138106, 0.001379378, 0.001377698, 0.001376018, 0.00137434, 0.001372662, 0.001370985, 0.001369309, 0.001367634, 0.00136596, 0.001364287, 0.001362615, 0.001360944, 0.001359274, 0.001357605, 0.001355936, 0.001354269, 0.001352603, 0.001350937, 0.001349273, 0.001347609, 0.001345947, 0.001344285, 0.001342625, 0.001340965, 0.001339307, 0.001337649, 0.001335992, 0.001334337, 0.001332682, 0.001331029, 0.001329376, 0.001327724, 0.001326074, 0.001324424, 0.001322776, 0.001321128, 0.001319482, 0.001317836, 0.001316192, 0.001314548, 0.001312906, 0.001311264, 0.001309624, 0.001307984, 0.001306346, 0.001304709, 0.001303073, 0.001301437, 0.001299803, 0.00129817, 0.001296538, 0.001294907, 0.001293277, 0.001291648, 0.00129002, 0.001288394, 0.001286768, 0.001285143, 0.00128352, 0.001281897, 0.001280276, 0.001278656, 0.001277036, 0.001275418, 0.001273801, 0.001272185, 0.00127057, 0.001268956, 0.001267344, 0.001265732, 0.001264122, 0.001262512, 0.001260904, 0.001259297, 0.001257691, 0.001256086, 0.001254482, 0.001252879, 0.001251277, 0.001249677, 0.001248077, 0.001246479, 0.001244882, 0.001243286, 0.001241691, 0.001240097, 0.001238505, 0.001236913, 0.001235323, 0.001233733, 0.001232145, 0.001230558, 0.001228973, 0.001227388, 0.001225804, 0.001224222, 0.001222641, 0.001221061, 0.001219482, 0.001217904, 0.001216327, 0.001214752, 0.001213178, 0.001211605, 0.001210033, 0.001208462, 0.001206892, 0.001205324, 0.001203756, 0.00120219, 0.001200625, 0.001199062, 0.001197499, 0.001195938, 0.001194378, 0.001192819, 0.001191261, 0.001189704, 0.001188149, 0.001186594, 0.001185041, 0.00118349, 0.001181939, 0.001180389, 0.001178841, 0.001177294, 0.001175748, 0.001174204, 0.00117266, 0.001171118, 0.001169577, 0.001168037, 0.001166499, 0.001164961, 0.001163425, 0.00116189, 0.001160356, 0.001158824, 0.001157292, 0.001155762, 0.001154234, 0.001152706, 0.001151179, 0.001149654, 0.00114813, 0.001146608, 0.001145086, 0.001143566, 0.001142047, 0.001140529, 0.001139013, 0.001137497, 0.001135983, 0.001134471, 0.001132959, 0.001131449, 0.00112994, 0.001128432, 0.001126925, 0.00112542, 0.001123916, 0.001122413, 0.001120911, 0.001119411, 0.001117912, 0.001116414, 0.001114918, 0.001113422, 0.001111928, 0.001110436, 0.001108944, 0.001107454, 0.001105965, 0.001104477, 0.001102991, 0.001101506, 0.001100022, 0.001098539, 0.001097058, 0.001095578, 0.001094099, 0.001092621, 0.001091145, 0.00108967, 0.001088197, 0.001086724, 0.001085253, 0.001083783, 0.001082315, 0.001080847, 0.001079381, 0.001077917, 0.001076453, 0.001074991, 0.00107353, 0.001072071, 0.001070612, 0.001069155, 0.0010677, 0.001066245, 0.001064792, 0.00106334, 0.00106189, 0.001060441, 0.001058993, 0.001057546, 0.001056101, 0.001054657, 0.001053214, 0.001051773, 0.001050333, 0.001048894, 0.001047456, 0.00104602, 0.001044585, 0.001043151, 0.001041719, 0.001040288, 0.001038859, 0.00103743, 0.001036003, 0.001034577, 0.001033153, 0.00103173, 0.001030308, 0.001028888, 0.001027468, 0.001026051, 0.001024634, 0.001023219, 0.001021805, 0.001020392, 0.001018981, 0.001017571, 0.001016162, 0.001014755, 0.001013349, 0.001011944, 0.001010541, 0.001009139, 0.001007738, 0.001006339, 0.001004941, 0.001003544, 0.001002149, 0.001000755, 9.99362E-4, 9.97971E-4, 9.9658E-4, 9.95192E-4, 9.93804E-4, 9.92418E-4, 9.91033E-4, 9.8965E-4, 9.88268E-4, 9.86887E-4, 9.85507E-4, 9.84129E-4, 9.82753E-4, 9.81377E-4, 9.80003E-4, 9.7863E-4, 9.77259E-4, 9.75889E-4, 9.7452E-4, 9.73152E-4, 9.71786E-4, 9.70421E-4, 9.69058E-4, 9.67696E-4, 9.66335E-4, 9.64976E-4, 9.63618E-4, 9.62261E-4, 9.60905E-4, 9.59551E-4, 9.58199E-4, 9.56847E-4, 9.55497E-4, 9.54148E-4, 9.52801E-4, 9.51455E-4, 9.5011E-4, 9.48767E-4, 9.47425E-4, 9.46084E-4, 9.44745E-4, 9.43407E-4, 9.4207E-4, 9.40735E-4, 9.39401E-4, 9.38069E-4, 9.36737E-4, 9.35407E-4, 9.34079E-4, 9.32752E-4, 9.31426E-4, 9.30101E-4, 9.28778E-4, 9.27456E-4, 9.26136E-4, 9.24816E-4, 9.23499E-4, 9.22182E-4, 9.20867E-4, 9.19553E-4, 9.18241E-4, 9.1693E-4, 9.1562E-4, 9.14312E-4, 9.13005E-4, 9.11699E-4, 9.10395E-4, 9.09092E-4, 9.0779E-4, 9.0649E-4, 9.05191E-4, 9.03893E-4, 9.02597E-4, 9.01302E-4, 9.00009E-4, 8.98716E-4, 8.97426E-4, 8.96136E-4, 8.94848E-4, 8.93561E-4, 8.92276E-4, 8.90992E-4, 8.89709E-4, 8.88427E-4, 8.87147E-4, 8.85869E-4, 8.84591E-4, 8.83315E-4, 8.82041E-4, 8.80767E-4, 8.79495E-4, 8.78225E-4, 8.76955E-4, 8.75687E-4, 8.74421E-4, 8.73156E-4, 8.71892E-4, 8.70629E-4, 8.69368E-4, 8.68108E-4, 8.6685E-4, 8.65593E-4, 8.64337E-4, 8.63082E-4, 8.61829E-4, 8.60578E-4, 8.59327E-4, 8.58078E-4, 8.5683E-4, 8.55584E-4, 8.54339E-4, 8.53095E-4, 8.51853E-4, 8.50612E-4, 8.49373E-4, 8.48134E-4, 8.46897E-4, 8.45662E-4, 8.44428E-4, 8.43195E-4, 8.41963E-4, 8.40733E-4, 8.39504E-4, 8.38277E-4, 8.37051E-4, 8.35826E-4, 8.34602E-4, 8.3338E-4, 8.32159E-4, 8.3094E-4, 8.29722E-4, 8.28505E-4, 8.2729E-4, 8.26076E-4, 8.24863E-4, 8.23652E-4, 8.22442E-4, 8.21233E-4, 8.20026E-4, 8.1882E-4, 8.17615E-4, 8.16412E-4, 8.1521E-4, 8.14009E-4, 8.1281E-4, 8.11612E-4, 8.10415E-4, 8.0922E-4, 8.08026E-4, 8.06833E-4, 8.05642E-4, 8.04452E-4, 8.03264E-4, 8.02076E-4, 8.00891E-4, 7.99706E-4, 7.98523E-4, 7.97341E-4, 7.9616E-4, 7.94981E-4, 7.93803E-4, 7.92627E-4, 7.91451E-4, 7.90278E-4, 7.89105E-4, 7.87934E-4, 7.86764E-4, 7.85596E-4, 7.84428E-4, 7.83262E-4, 7.82098E-4, 7.80935E-4, 7.79773E-4, 7.78612E-4, 7.77453E-4, 7.76295E-4, 7.75139E-4, 7.73983E-4, 7.7283E-4, 7.71677E-4, 7.70526E-4, 7.69376E-4, 7.68227E-4, 7.6708E-4, 7.65934E-4, 7.64789E-4, 7.63646E-4, 7.62504E-4, 7.61364E-4, 7.60224E-4, 7.59086E-4, 7.5795E-4, 7.56814E-4, 7.5568E-4, 7.54548E-4, 7.53416E-4, 7.52286E-4, 7.51158E-4, 7.5003E-4, 7.48904E-4, 7.47779E-4, 7.46656E-4, 7.45534E-4, 7.44413E-4, 7.43293E-4, 7.42175E-4, 7.41058E-4, 7.39943E-4, 7.38829E-4, 7.37716E-4, 7.36604E-4, 7.35494E-4, 7.34385E-4, 7.33277E-4, 7.32171E-4, 7.31066E-4, 7.29962E-4, 7.2886E-4, 7.27758E-4, 7.26659E-4, 7.2556E-4, 7.24463E-4, 7.23367E-4, 7.22273E-4, 7.21179E-4, 7.20087E-4, 7.18997E-4, 7.17907E-4, 7.16819E-4, 7.15733E-4, 7.14647E-4, 7.13563E-4, 7.1248E-4, 7.11399E-4, 7.10318E-4, 7.09239E-4, 7.08162E-4, 7.07085E-4, 7.0601E-4, 7.04937E-4, 7.03864E-4, 7.02793E-4, 7.01723E-4, 7.00655E-4, 6.99587E-4, 6.98521E-4, 6.97457E-4, 6.96393E-4, 6.95331E-4, 6.9427E-4, 6.93211E-4, 6.92153E-4, 6.91096E-4, 6.9004E-4, 6.88986E-4, 6.87933E-4, 6.86881E-4, 6.8583E-4, 6.84781E-4, 6.83733E-4, 6.82687E-4, 6.81641E-4, 6.80597E-4, 6.79554E-4, 6.78513E-4, 6.77473E-4, 6.76434E-4, 6.75396E-4, 6.7436E-4, 6.73324E-4, 6.72291E-4, 6.71258E-4, 6.70227E-4, 6.69197E-4, 6.68168E-4, 6.67141E-4, 6.66114E-4, 6.65089E-4, 6.64066E-4, 6.63043E-4, 6.62022E-4, 6.61002E-4, 6.59984E-4, 6.58967E-4, 6.5795E-4, 6.56936E-4, 6.55922E-4, 6.5491E-4, 6.53899E-4, 6.52889E-4, 6.51881E-4, 6.50874E-4, 6.49868E-4, 6.48863E-4, 6.4786E-4, 6.46857E-4, 6.45857E-4, 6.44857E-4, 6.43859E-4, 6.42861E-4, 6.41866E-4, 6.40871E-4, 6.39878E-4, 6.38885E-4, 6.37895E-4, 6.36905E-4, 6.35917E-4, 6.34929E-4, 6.33944E-4, 6.32959E-4, 6.31976E-4, 6.30993E-4, 6.30013E-4, 6.29033E-4, 6.28055E-4, 6.27077E-4, 6.26102E-4, 6.25127E-4, 6.24153E-4, 6.23181E-4, 6.2221E-4, 6.21241E-4, 6.20272E-4, 6.19305E-4, 6.18339E-4, 6.17374E-4, 6.16411E-4, 6.15448E-4, 6.14487E-4, 6.13527E-4, 6.12569E-4, 6.11611E-4, 6.10655E-4, 6.097E-4, 6.08747E-4, 6.07794E-4, 6.06843E-4, 6.05893E-4, 6.04944E-4, 6.03997E-4, 6.0305E-4, 6.02105E-4, 6.01161E-4, 6.00219E-4, 5.99277E-4, 5.98337E-4, 5.97398E-4, 5.9646E-4, 5.95524E-4, 5.94588E-4, 5.93654E-4, 5.92721E-4, 5.91789E-4, 5.90859E-4, 5.89929E-4, 5.89001E-4, 5.88074E-4, 5.87149E-4, 5.86224E-4, 5.85301E-4, 5.84379E-4, 5.83458E-4, 5.82538E-4, 5.8162E-4, 5.80703E-4, 5.79787E-4, 5.78872E-4, 5.77958E-4, 5.77046E-4, 5.76134E-4, 5.75224E-4, 5.74315E-4, 5.73408E-4, 5.72501E-4, 5.71596E-4, 5.70692E-4, 5.69789E-4, 5.68887E-4, 5.67987E-4, 5.67087E-4, 5.66189E-4, 5.65292E-4, 5.64396E-4, 5.63502E-4, 5.62608E-4, 5.61716E-4, 5.60825E-4, 5.59935E-4, 5.59046E-4, 5.58159E-4, 5.57273E-4, 5.56387E-4, 5.55503E-4, 5.54621E-4, 5.53739E-4, 5.52859E-4, 5.51979E-4, 5.51101E-4, 5.50224E-4, 5.49348E-4, 5.48474E-4, 5.476E-4, 5.46728E-4, 5.45857E-4, 5.44987E-4, 5.44118E-4, 5.43251E-4, 5.42384E-4, 5.41519E-4, 5.40655E-4, 5.39792E-4, 5.3893E-4, 5.38069E-4, 5.3721E-4, 5.36351E-4, 5.35494E-4, 5.34638E-4, 5.33783E-4, 5.32929E-4, 5.32077E-4, 5.31225E-4, 5.30375E-4, 5.29526E-4, 5.28678E-4, 5.27831E-4, 5.26985E-4, 5.26141E-4, 5.25297E-4, 5.24455E-4, 5.23614E-4, 5.22774E-4, 5.21935E-4, 5.21097E-4, 5.20261E-4, 5.19425E-4, 5.18591E-4, 5.17758E-4, 5.16926E-4, 5.16095E-4, 5.15265E-4, 5.14437E-4, 5.13609E-4, 5.12783E-4, 5.11957E-4, 5.11133E-4, 5.1031E-4, 5.09488E-4, 5.08668E-4, 5.07848E-4, 5.07029E-4, 5.06212E-4, 5.05396E-4, 5.0458E-4, 5.03766E-4, 5.02953E-4, 5.02142E-4, 5.01331E-4, 5.00521E-4, 4.99713E-4, 4.98906E-4, 4.98099E-4, 4.97294E-4, 4.9649E-4, 4.95687E-4, 4.94885E-4, 4.94085E-4, 4.93285E-4, 4.92486E-4, 4.91689E-4, 4.90893E-4, 4.90098E-4, 4.89303E-4, 4.8851E-4, 4.87719E-4, 4.86928E-4, 4.86138E-4, 4.85349E-4, 4.84562E-4, 4.83775E-4, 4.8299E-4, 4.82206E-4, 4.81423E-4, 4.80641E-4, 4.7986E-4, 4.7908E-4, 4.78301E-4, 4.77523E-4, 4.76746E-4, 4.75971E-4, 4.75196E-4, 4.74423E-4, 4.73651E-4, 4.72879E-4, 4.72109E-4, 4.7134E-4, 4.70572E-4, 4.69805E-4, 4.69039E-4, 4.68274E-4, 4.67511E-4, 4.66748E-4, 4.65986E-4, 4.65226E-4, 4.64466E-4, 4.63708E-4, 4.62951E-4, 4.62194E-4, 4.61439E-4, 4.60685E-4, 4.59932E-4, 4.5918E-4, 4.58429E-4, 4.57679E-4, 4.5693E-4, 4.56182E-4, 4.55436E-4, 4.5469E-4, 4.53945E-4, 4.53202E-4, 4.52459E-4, 4.51718E-4, 4.50977E-4, 4.50238E-4, 4.495E-4, 4.48762E-4, 4.48026E-4, 4.47291E-4, 4.46557E-4, 4.45824E-4, 4.45092E-4, 4.44361E-4, 4.43631E-4, 4.42902E-4, 4.42174E-4, 4.41447E-4, 4.40721E-4, 4.39996E-4, 4.39272E-4, 4.3855E-4, 4.37828E-4, 4.37107E-4, 4.36387E-4, 4.35669E-4, 4.34951E-4, 4.34235E-4, 4.33519E-4, 4.32804E-4, 4.32091E-4, 4.31378E-4, 4.30667E-4, 4.29956E-4, 4.29247E-4, 4.28538E-4, 4.27831E-4, 4.27125E-4, 4.26419E-4, 4.25715E-4, 4.25012E-4, 4.24309E-4, 4.23608E-4, 4.22907E-4, 4.22208E-4, 4.2151E-4, 4.20812E-4, 4.20116E-4, 4.19421E-4, 4.18727E-4, 4.18033E-4, 4.17341E-4, 4.1665E-4, 4.15959E-4, 4.1527E-4, 4.14582E-4, 4.13894E-4, 4.13208E-4, 4.12523E-4, 4.11838E-4, 4.11155E-4, 4.10472E-4, 4.09791E-4, 4.09111E-4, 4.08431E-4, 4.07753E-4, 4.07075E-4, 4.06399E-4, 4.05723E-4, 4.05049E-4, 4.04375E-4, 4.03703E-4, 4.03031E-4, 4.02361E-4, 4.01691E-4, 4.01023E-4, 4.00355E-4, 3.99688E-4, 3.99022E-4, 3.98358E-4, 3.97694E-4, 3.97031E-4, 3.96369E-4, 3.95708E-4, 3.95049E-4, 3.9439E-4, 3.93732E-4, 3.93075E-4, 3.92419E-4, 3.91763E-4, 3.91109E-4, 3.90456E-4, 3.89804E-4, 3.89153E-4, 3.88502E-4, 3.87853E-4, 3.87205E-4, 3.86557E-4, 3.85911E-4, 3.85265E-4, 3.84621E-4, 3.83977E-4, 3.83334E-4, 3.82692E-4, 3.82052E-4, 3.81412E-4, 3.80773E-4, 3.80135E-4, 3.79498E-4, 3.78862E-4, 3.78226E-4, 3.77592E-4, 3.76959E-4, 3.76327E-4, 3.75695E-4, 3.75065E-4, 3.74435E-4, 3.73806E-4, 3.73179E-4, 3.72552E-4, 3.71926E-4, 3.71301E-4, 3.70677E-4, 3.70054E-4, 3.69432E-4, 3.68811E-4, 3.68191E-4, 3.67571E-4, 3.66953E-4, 3.66335E-4, 3.65719E-4, 3.65103E-4, 3.64488E-4, 3.63874E-4, 3.63261E-4, 3.62649E-4, 3.62038E-4, 3.61428E-4, 3.60819E-4, 3.6021E-4, 3.59603E-4, 3.58996E-4, 3.5839E-4, 3.57786E-4, 3.57182E-4, 3.56579E-4, 3.55977E-4, 3.55375E-4, 3.54775E-4, 3.54176E-4, 3.53577E-4, 3.5298E-4, 3.52383E-4, 3.51787E-4, 3.51192E-4, 3.50598E-4, 3.50005E-4, 3.49413E-4, 3.48822E-4, 3.48231E-4, 3.47642E-4, 3.47053E-4, 3.46465E-4, 3.45878E-4, 3.45292E-4, 3.44707E-4, 3.44123E-4, 3.43539E-4, 3.42957E-4, 3.42375E-4, 3.41794E-4, 3.41215E-4, 3.40636E-4, 3.40057E-4, 3.3948E-4, 3.38904E-4, 3.38328E-4, 3.37754E-4, 3.3718E-4, 3.36607E-4, 3.36035E-4, 3.35464E-4, 3.34893E-4, 3.34324E-4, 3.33755E-4, 3.33188E-4, 3.32621E-4, 3.32055E-4, 3.31489E-4, 3.30925E-4, 3.30362E-4, 3.29799E-4, 3.29237E-4, 3.28677E-4, 3.28117E-4, 3.27557E-4, 3.26999E-4, 3.26442E-4, 3.25885E-4, 3.25329E-4, 3.24774E-4, 3.2422E-4, 3.23667E-4, 3.23114E-4, 3.22563E-4, 3.22012E-4, 3.21462E-4, 3.20913E-4, 3.20365E-4, 3.19818E-4, 3.19271E-4, 3.18725E-4, 3.1818E-4, 3.17636E-4, 3.17093E-4, 3.16551E-4, 3.16009E-4, 3.15469E-4, 3.14929E-4, 3.1439E-4, 3.13851E-4, 3.13314E-4, 3.12777E-4, 3.12242E-4, 3.11707E-4, 3.11173E-4, 3.10639E-4, 3.10107E-4, 3.09575E-4, 3.09044E-4, 3.08514E-4, 3.07985E-4, 3.07457E-4, 3.06929E-4, 3.06402E-4, 3.05876E-4, 3.05351E-4, 3.04827E-4, 3.04303E-4, 3.0378E-4, 3.03258E-4, 3.02737E-4, 3.02217E-4, 3.01697E-4, 3.01179E-4, 3.00661E-4, 3.00144E-4, 2.99627E-4, 2.99112E-4, 2.98597E-4, 2.98083E-4, 2.9757E-4, 2.97058E-4, 2.96546E-4, 2.96035E-4, 2.95525E-4, 2.95016E-4, 2.94508E-4, 2.94E-4, 2.93493E-4, 2.92987E-4, 2.92482E-4, 2.91978E-4, 2.91474E-4, 2.90971E-4, 2.90469E-4, 2.89968E-4, 2.89467E-4, 2.88967E-4, 2.88468E-4, 2.8797E-4, 2.87473E-4, 2.86976E-4, 2.8648E-4, 2.85985E-4, 2.85491E-4, 2.84997E-4, 2.84504E-4, 2.84012E-4, 2.83521E-4, 2.8303E-4, 2.82541E-4, 2.82052E-4, 2.81563E-4, 2.81076E-4, 2.80589E-4, 2.80103E-4, 2.79618E-4, 2.79134E-4, 2.7865E-4, 2.78167E-4, 2.77685E-4, 2.77203E-4, 2.76723E-4, 2.76243E-4, 2.75764E-4, 2.75285E-4, 2.74808E-4, 2.74331E-4, 2.73855E-4, 2.73379E-4, 2.72905E-4, 2.72431E-4, 2.71958E-4, 2.71485E-4, 2.71014E-4, 2.70543E-4, 2.70072E-4, 2.69603E-4, 2.69134E-4, 2.68666E-4, 2.68199E-4, 2.67732E-4, 2.67267E-4, 2.66802E-4, 2.66337E-4, 2.65874E-4, 2.65411E-4, 2.64949E-4, 2.64487E-4, 2.64027E-4, 2.63567E-4, 2.63108E-4, 2.62649E-4, 2.62191E-4, 2.61734E-4, 2.61278E-4, 2.60822E-4, 2.60368E-4, 2.59913E-4, 2.5946E-4, 2.59007E-4, 2.58555E-4, 2.58104E-4, 2.57653E-4, 2.57204E-4, 2.56754E-4, 2.56306E-4, 2.55858E-4, 2.55411E-4, 2.54965E-4, 2.54519E-4, 2.54074E-4, 2.5363E-4, 2.53187E-4, 2.52744E-4, 2.52302E-4, 2.51861E-4, 2.5142E-4, 2.5098E-4, 2.50541E-4, 2.50102E-4, 2.49664E-4, 2.49227E-4, 2.48791E-4, 2.48355E-4, 2.4792E-4, 2.47485E-4, 2.47052E-4, 2.46619E-4, 2.46186E-4, 2.45755E-4, 2.45324E-4, 2.44894E-4, 2.44464E-4, 2.44035E-4, 2.43607E-4, 2.43179E-4, 2.42753E-4, 2.42326E-4, 2.41901E-4, 2.41476E-4, 2.41052E-4, 2.40629E-4, 2.40206E-4, 2.39784E-4, 2.39363E-4, 2.38942E-4, 2.38522E-4, 2.38102E-4, 2.37684E-4, 2.37266E-4, 2.36848E-4, 2.36432E-4, 2.36016E-4, 2.356E-4, 2.35186E-4, 2.34772E-4, 2.34358E-4, 2.33946E-4, 2.33533E-4, 2.33122E-4, 2.32711E-4, 2.32301E-4, 2.31892E-4, 2.31483E-4, 2.31075E-4, 2.30668E-4, 2.30261E-4, 2.29855E-4, 2.2945E-4, 2.29045E-4, 2.28641E-4, 2.28237E-4, 2.27834E-4, 2.27432E-4, 2.27031E-4, 2.2663E-4, 2.26229E-4, 2.2583E-4, 2.25431E-4, 2.25033E-4, 2.24635E-4, 2.24238E-4, 2.23842E-4, 2.23446E-4, 2.23051E-4, 2.22656E-4, 2.22262E-4, 2.21869E-4, 2.21477E-4, 2.21085E-4, 2.20694E-4, 2.20303E-4, 2.19913E-4, 2.19524E-4, 2.19135E-4, 2.18747E-4, 2.18359E-4, 2.17972E-4, 2.17586E-4, 2.17201E-4, 2.16816E-4, 2.16431E-4, 2.16048E-4, 2.15664E-4, 2.15282E-4, 2.149E-4, 2.14519E-4, 2.14138E-4, 2.13758E-4, 2.13379E-4, 2.13E-4, 2.12622E-4, 2.12244E-4, 2.11868E-4, 2.11491E-4, 2.11116E-4, 2.10741E-4, 2.10366E-4, 2.09992E-4, 2.09619E-4, 2.09246E-4, 2.08874E-4, 2.08503E-4, 2.08132E-4, 2.07762E-4, 2.07392E-4, 2.07023E-4, 2.06655E-4, 2.06287E-4, 2.0592E-4, 2.05553E-4, 2.05187E-4, 2.04822E-4, 2.04457E-4, 2.04093E-4, 2.03729E-4, 2.03366E-4, 2.03004E-4, 2.02642E-4, 2.02281E-4, 2.0192E-4, 2.0156E-4, 2.01201E-4, 2.00842E-4, 2.00484E-4, 2.00126E-4, 1.99769E-4, 1.99413E-4, 1.99057E-4, 1.98701E-4, 1.98347E-4, 1.97992E-4, 1.97639E-4, 1.97286E-4, 1.96933E-4, 1.96582E-4, 1.9623E-4, 1.9588E-4, 1.9553E-4, 1.9518E-4, 1.94831E-4, 1.94483E-4, 1.94135E-4, 1.93788E-4, 1.93441E-4, 1.93095E-4, 1.92749E-4, 1.92404E-4, 1.9206E-4, 1.91716E-4, 1.91373E-4, 1.9103E-4, 1.90688E-4, 1.90347E-4, 1.90006E-4, 1.89665E-4, 1.89325E-4, 1.88986E-4, 1.88647E-4, 1.88309E-4, 1.87972E-4, 1.87635E-4, 1.87298E-4, 1.86962E-4, 1.86627E-4, 1.86292E-4, 1.85958E-4, 1.85624E-4, 1.85291E-4, 1.84958E-4, 1.84626E-4, 1.84295E-4, 1.83964E-4, 1.83633E-4, 1.83303E-4, 1.82974E-4, 1.82645E-4, 1.82317E-4, 1.81989E-4, 1.81662E-4, 1.81336E-4, 1.8101E-4, 1.80684E-4, 1.80359E-4, 1.80035E-4, 1.79711E-4, 1.79387E-4, 1.79065E-4, 1.78742E-4, 1.78421E-4, 1.78099E-4, 1.77779E-4, 1.77459E-4, 1.77139E-4, 1.7682E-4, 1.76501E-4, 1.76183E-4, 1.75866E-4, 1.75549E-4, 1.75233E-4, 1.74917E-4, 1.74601E-4, 1.74287E-4, 1.73972E-4, 1.73658E-4, 1.73345E-4, 1.73032E-4, 1.7272E-4, 1.72409E-4, 1.72097E-4, 1.71787E-4, 1.71477E-4, 1.71167E-4, 1.70858E-4, 1.70549E-4, 1.70241E-4, 1.69934E-4, 1.69627E-4, 1.6932E-4, 1.69014E-4, 1.68709E-4, 1.68404E-4, 1.68099E-4, 1.67795E-4, 1.67492E-4, 1.67189E-4, 1.66887E-4, 1.66585E-4, 1.66283E-4, 1.65982E-4, 1.65682E-4, 1.65382E-4, 1.65083E-4, 1.64784E-4, 1.64485E-4, 1.64187E-4, 1.6389E-4, 1.63593E-4, 1.63297E-4, 1.63001E-4, 1.62706E-4, 1.62411E-4, 1.62116E-4, 1.61822E-4, 1.61529E-4, 1.61236E-4, 1.60944E-4, 1.60652E-4, 1.6036E-4, 1.60069E-4, 1.59779E-4, 1.59489E-4, 1.59199E-4, 1.5891E-4, 1.58622E-4, 1.58334E-4, 1.58046E-4, 1.57759E-4, 1.57473E-4, 1.57187E-4, 1.56901E-4, 1.56616E-4, 1.56331E-4, 1.56047E-4, 1.55764E-4, 1.5548E-4, 1.55198E-4, 1.54916E-4, 1.54634E-4, 1.54353E-4, 1.54072E-4, 1.53791E-4, 1.53512E-4, 1.53232E-4, 1.52953E-4, 1.52675E-4, 1.52397E-4, 1.52119E-4, 1.51842E-4, 1.51566E-4, 1.5129E-4, 1.51014E-4, 1.50739E-4, 1.50464E-4, 1.5019E-4, 1.49916E-4, 1.49643E-4, 1.4937E-4, 1.49098E-4, 1.48826E-4, 1.48555E-4, 1.48284E-4, 1.48013E-4, 1.47743E-4, 1.47474E-4, 1.47205E-4, 1.46936E-4, 1.46668E-4, 1.464E-4, 1.46133E-4, 1.45866E-4, 1.45599E-4, 1.45334E-4, 1.45068E-4, 1.44803E-4, 1.44538E-4, 1.44274E-4, 1.44011E-4, 1.43747E-4, 1.43485E-4, 1.43222E-4, 1.4296E-4, 1.42699E-4, 1.42438E-4, 1.42177E-4, 1.41917E-4, 1.41658E-4, 1.41399E-4, 1.4114E-4, 1.40881E-4, 1.40624E-4, 1.40366E-4, 1.40109E-4, 1.39853E-4, 1.39596E-4, 1.39341E-4, 1.39086E-4, 1.38831E-4, 1.38576E-4, 1.38322E-4, 1.38069E-4, 1.37816E-4, 1.37563E-4, 1.37311E-4, 1.37059E-4, 1.36808E-4, 1.36557E-4, 1.36306E-4, 1.36056E-4, 1.35807E-4, 1.35558E-4, 1.35309E-4, 1.35061E-4, 1.34813E-4, 1.34565E-4, 1.34318E-4, 1.34071E-4, 1.33825E-4, 1.33579E-4, 1.33334E-4, 1.33089E-4, 1.32845E-4, 1.326E-4, 1.32357E-4, 1.32114E-4, 1.31871E-4, 1.31628E-4, 1.31386E-4, 1.31145E-4, 1.30903E-4, 1.30663E-4, 1.30422E-4, 1.30182E-4, 1.29943E-4, 1.29704E-4, 1.29465E-4, 1.29227E-4, 1.28989E-4, 1.28751E-4, 1.28514E-4, 1.28278E-4, 1.28041E-4, 1.27806E-4, 1.2757E-4, 1.27335E-4, 1.27101E-4, 1.26866E-4, 1.26633E-4, 1.26399E-4, 1.26166E-4, 1.25934E-4, 1.25701E-4, 1.2547E-4, 1.25238E-4, 1.25007E-4, 1.24777E-4, 1.24546E-4, 1.24317E-4, 1.24087E-4, 1.23858E-4, 1.2363E-4, 1.23401E-4, 1.23174E-4, 1.22946E-4, 1.22719E-4, 1.22493E-4, 1.22266E-4, 1.2204E-4, 1.21815E-4, 1.2159E-4, 1.21365E-4, 1.21141E-4, 1.20917E-4, 1.20694E-4, 1.2047E-4, 1.20248E-4, 1.20025E-4, 1.19803E-4, 1.19582E-4, 1.19361E-4, 1.1914E-4, 1.18919E-4, 1.18699E-4, 1.1848E-4, 1.1826E-4, 1.18041E-4, 1.17823E-4, 1.17605E-4, 1.17387E-4, 1.1717E-4, 1.16953E-4, 1.16736E-4, 1.1652E-4, 1.16304E-4, 1.16088E-4, 1.15873E-4, 1.15659E-4, 1.15444E-4, 1.1523E-4, 1.15017E-4, 1.14803E-4, 1.1459E-4, 1.14378E-4, 1.14166E-4, 1.13954E-4, 1.13743E-4, 1.13532E-4, 1.13321E-4, 1.13111E-4, 1.12901E-4, 1.12691E-4, 1.12482E-4, 1.12273E-4, 1.12065E-4, 1.11857E-4, 1.11649E-4, 1.11441E-4, 1.11234E-4, 1.11028E-4, 1.10822E-4, 1.10616E-4, 1.1041E-4, 1.10205E-4, 1.1E-4, 1.09795E-4, 1.09591E-4, 1.09388E-4, 1.09184E-4, 1.08981E-4, 1.08778E-4, 1.08576E-4, 1.08374E-4, 1.08172E-4, 1.07971E-4, 1.0777E-4, 1.0757E-4, 1.07369E-4, 1.07169E-4, 1.0697E-4, 1.06771E-4, 1.06572E-4, 1.06373E-4, 1.06175E-4, 1.05977E-4, 1.0578E-4, 1.05583E-4, 1.05386E-4, 1.0519E-4, 1.04994E-4, 1.04798E-4, 1.04603E-4, 1.04408E-4, 1.04213E-4, 1.04019E-4, 1.03825E-4, 1.03631E-4, 1.03438E-4, 1.03245E-4, 1.03052E-4, 1.0286E-4, 1.02668E-4, 1.02476E-4, 1.02285E-4, 1.02094E-4, 1.01903E-4, 1.01713E-4, 1.01523E-4, 1.01333E-4, 1.01144E-4, 1.00955E-4, 1.00766E-4, 1.00578E-4, 1.0039E-4, 1.00203E-4, 1.00015E-4, 9.98284E-5, 9.96418E-5, 9.94555E-5, 9.92695E-5, 9.90839E-5, 9.88986E-5, 9.87136E-5, 9.85289E-5, 9.83446E-5, 9.81606E-5, 9.79769E-5, 9.77936E-5, 9.76105E-5, 9.74278E-5, 9.72454E-5, 9.70634E-5, 9.68816E-5, 9.67002E-5, 9.65191E-5, 9.63383E-5, 9.61579E-5, 9.59777E-5, 9.57979E-5, 9.56184E-5, 9.54392E-5, 9.52604E-5, 9.50818E-5, 9.49036E-5, 9.47257E-5, 9.45481E-5, 9.43708E-5, 9.41938E-5, 9.40171E-5, 9.38408E-5, 9.36647E-5, 9.3489E-5, 9.33136E-5, 9.31385E-5, 9.29637E-5, 9.27892E-5, 9.26151E-5, 9.24412E-5, 9.22677E-5, 9.20944E-5, 9.19215E-5, 9.17488E-5, 9.15765E-5, 9.14045E-5, 9.12328E-5, 9.10614E-5, 9.08903E-5, 9.07195E-5, 9.0549E-5, 9.03788E-5, 9.02089E-5, 9.00393E-5, 8.987E-5, 8.97011E-5, 8.95324E-5, 8.9364E-5, 8.91959E-5, 8.90281E-5, 8.88606E-5, 8.86934E-5, 8.85266E-5, 8.836E-5, 8.81937E-5, 8.80277E-5, 8.7862E-5, 8.76966E-5, 8.75315E-5, 8.73666E-5, 8.72021E-5, 8.70379E-5, 8.68739E-5, 8.67103E-5, 8.65469E-5, 8.63839E-5, 8.62211E-5, 8.60586E-5, 8.58964E-5, 8.57345E-5, 8.55729E-5, 8.54116E-5, 8.52506E-5, 8.50898E-5, 8.49293E-5, 8.47692E-5, 8.46093E-5, 8.44497E-5, 8.42904E-5, 8.41313E-5, 8.39726E-5, 8.38141E-5, 8.36559E-5, 8.3498E-5, 8.33404E-5, 8.31831E-5, 8.3026E-5, 8.28693E-5, 8.27128E-5, 8.25566E-5, 8.24006E-5, 8.2245E-5, 8.20896E-5, 8.19345E-5, 8.17797E-5, 8.16252E-5, 8.14709E-5, 8.13169E-5, 8.11632E-5, 8.10098E-5, 8.08566E-5, 8.07037E-5, 8.05511E-5, 8.03988E-5, 8.02467E-5, 8.00949E-5, 7.99434E-5, 7.97922E-5, 7.96412E-5, 7.94905E-5, 7.93401E-5, 7.91899E-5, 7.904E-5, 7.88904E-5, 7.8741E-5, 7.8592E-5, 7.84431E-5, 7.82946E-5, 7.81463E-5, 7.79983E-5, 7.78505E-5, 7.77031E-5, 7.75558E-5, 7.74089E-5, 7.72622E-5, 7.71158E-5, 7.69696E-5, 7.68237E-5, 7.66781E-5, 7.65327E-5, 7.63876E-5, 7.62427E-5, 7.60981E-5, 7.59538E-5, 7.58097E-5, 7.56659E-5, 7.55224E-5, 7.53791E-5, 7.5236E-5, 7.50933E-5, 7.49508E-5, 7.48085E-5, 7.46665E-5, 7.45247E-5, 7.43832E-5, 7.4242E-5, 7.4101E-5, 7.39603E-5, 7.38198E-5, 7.36796E-5, 7.35396E-5, 7.33999E-5, 7.32604E-5, 7.31212E-5, 7.29823E-5, 7.28436E-5, 7.27051E-5, 7.25669E-5, 7.24289E-5, 7.22912E-5, 7.21538E-5, 7.20166E-5, 7.18796E-5, 7.17429E-5, 7.16064E-5, 7.14702E-5, 7.13342E-5, 7.11985E-5, 7.1063E-5, 7.09278E-5, 7.07928E-5, 7.0658E-5, 7.05235E-5, 7.03893E-5, 7.02553E-5, 7.01215E-5, 6.99879E-5, 6.98547E-5, 6.97216E-5, 6.95888E-5, 6.94562E-5, 6.93239E-5, 6.91918E-5, 6.906E-5, 6.89284E-5, 6.8797E-5, 6.86659E-5, 6.8535E-5, 6.84043E-5, 6.82739E-5, 6.81437E-5, 6.80138E-5, 6.78841E-5, 6.77546E-5, 6.76254E-5, 6.74964E-5, 6.73676E-5, 6.7239E-5, 6.71107E-5, 6.69827E-5, 6.68548E-5, 6.67272E-5, 6.65999E-5, 6.64727E-5, 6.63458E-5, 6.62191E-5, 6.60927E-5, 6.59665E-5, 6.58405E-5, 6.57147E-5, 6.55892E-5, 6.54639E-5, 6.53388E-5, 6.5214E-5, 6.50894E-5, 6.4965E-5, 6.48408E-5, 6.47169E-5, 6.45932E-5, 6.44697E-5, 6.43464E-5, 6.42234E-5, 6.41006E-5, 6.3978E-5, 6.38556E-5, 6.37335E-5, 6.36115E-5, 6.34898E-5, 6.33684E-5, 6.32471E-5, 6.31261E-5, 6.30053E-5, 6.28847E-5, 6.27643E-5, 6.26441E-5, 6.25242E-5, 6.24045E-5, 6.2285E-5, 6.21657E-5, 6.20467E-5, 6.19278E-5, 6.18092E-5, 6.16908E-5, 6.15726E-5, 6.14546E-5, 6.13369E-5, 6.12193E-5, 6.1102E-5, 6.09849E-5, 6.0868E-5, 6.07513E-5, 6.06348E-5, 6.05186E-5, 6.04025E-5, 6.02867E-5, 6.01711E-5, 6.00557E-5, 5.99405E-5, 5.98255E-5, 5.97107E-5, 5.95961E-5, 5.94818E-5, 5.93676E-5, 5.92537E-5, 5.91399E-5, 5.90264E-5, 5.89131E-5, 5.88E-5, 5.86871E-5, 5.85744E-5, 5.84619E-5, 5.83496E-5, 5.82376E-5, 5.81257E-5, 5.8014E-5, 5.79026E-5, 5.77913E-5, 5.76803E-5, 5.75694E-5, 5.74588E-5, 5.73484E-5, 5.72381E-5, 5.71281E-5, 5.70183E-5, 5.69086E-5, 5.67992E-5, 5.669E-5, 5.65809E-5, 5.64721E-5, 5.63635E-5, 5.62551E-5, 5.61468E-5, 5.60388E-5, 5.5931E-5, 5.58233E-5, 5.57159E-5, 5.56087E-5, 5.55016E-5, 5.53948E-5, 5.52881E-5, 5.51817E-5, 5.50754E-5, 5.49694E-5, 5.48635E-5, 5.47579E-5, 5.46524E-5, 5.45471E-5, 5.4442E-5, 5.43371E-5, 5.42324E-5, 5.41279E-5, 5.40236E-5, 5.39195E-5, 5.38156E-5, 5.37118E-5, 5.36083E-5, 5.35049E-5, 5.34018E-5, 5.32988E-5, 5.3196E-5, 5.30934E-5, 5.2991E-5, 5.28888E-5, 5.27868E-5, 5.26849E-5, 5.25833E-5, 5.24818E-5, 5.23805E-5, 5.22795E-5, 5.21786E-5, 5.20778E-5, 5.19773E-5, 5.1877E-5, 5.17768E-5, 5.16768E-5, 5.1577E-5, 5.14774E-5, 5.1378E-5, 5.12788E-5, 5.11797E-5, 5.10809E-5, 5.09822E-5, 5.08837E-5, 5.07853E-5, 5.06872E-5, 5.05892E-5, 5.04915E-5, 5.03939E-5, 5.02965E-5, 5.01992E-5, 5.01022E-5, 5.00053E-5, 4.99086E-5, 4.98121E-5, 4.97157E-5, 4.96196E-5, 4.95236E-5, 4.94278E-5, 4.93322E-5, 4.92367E-5, 4.91414E-5, 4.90463E-5, 4.89514E-5, 4.88567E-5, 4.87621E-5, 4.86677E-5, 4.85735E-5, 4.84795E-5, 4.83856E-5, 4.82919E-5, 4.81984E-5, 4.8105E-5, 4.80118E-5, 4.79188E-5, 4.7826E-5, 4.77334E-5, 4.76409E-5, 4.75486E-5, 4.74564E-5, 4.73645E-5, 4.72727E-5, 4.7181E-5, 4.70896E-5, 4.69983E-5, 4.69072E-5, 4.68162E-5, 4.67254E-5, 4.66348E-5, 4.65444E-5, 4.64541E-5, 4.6364E-5, 4.6274E-5, 4.61843E-5, 4.60947E-5, 4.60052E-5, 4.5916E-5, 4.58269E-5, 4.57379E-5, 4.56491E-5, 4.55605E-5, 4.54721E-5, 4.53838E-5, 4.52957E-5, 4.52077E-5, 4.51199E-5, 4.50323E-5, 4.49449E-5, 4.48576E-5, 4.47704E-5, 4.46835E-5, 4.45966E-5, 4.451E-5, 4.44235E-5, 4.43372E-5, 4.4251E-5, 4.4165E-5, 4.40792E-5, 4.39935E-5, 4.3908E-5, 4.38226E-5, 4.37374E-5, 4.36523E-5, 4.35675E-5, 4.34827E-5, 4.33981E-5, 4.33137E-5, 4.32295E-5, 4.31454E-5, 4.30614E-5, 4.29777E-5, 4.2894E-5, 4.28106E-5, 4.27272E-5, 4.26441E-5, 4.25611E-5, 4.24782E-5, 4.23955E-5, 4.2313E-5, 4.22306E-5, 4.21484E-5, 4.20663E-5, 4.19844E-5, 4.19026E-5, 4.1821E-5, 4.17395E-5, 4.16582E-5, 4.1577E-5, 4.1496E-5, 4.14152E-5, 4.13344E-5, 4.12539E-5, 4.11735E-5, 4.10932E-5, 4.10131E-5, 4.09332E-5, 4.08534E-5, 4.07737E-5, 4.06942E-5, 4.06148E-5, 4.05356E-5, 4.04566E-5, 4.03777E-5, 4.02989E-5, 4.02203E-5, 4.01418E-5, 4.00635E-5, 3.99853E-5, 3.99073E-5, 3.98294E-5, 3.97517E-5, 3.96741E-5, 3.95966E-5, 3.95193E-5, 3.94422E-5, 3.93652E-5, 3.92883E-5, 3.92116E-5, 3.9135E-5, 3.90586E-5, 3.89823E-5, 3.89061E-5, 3.88301E-5, 3.87543E-5, 3.86786E-5, 3.8603E-5, 3.85275E-5, 3.84523E-5, 3.83771E-5, 3.83021E-5, 3.82272E-5, 3.81525E-5, 3.80779E-5, 3.80035E-5, 3.79292E-5, 3.7855E-5, 3.7781E-5, 3.77071E-5, 3.76333E-5, 3.75597E-5, 3.74862E-5, 3.74129E-5, 3.73397E-5, 3.72666E-5, 3.71937E-5, 3.71209E-5, 3.70483E-5, 3.69758E-5, 3.69034E-5, 3.68312E-5, 3.67591E-5, 3.66871E-5, 3.66153E-5, 3.65436E-5, 3.6472E-5, 3.64006E-5, 3.63293E-5, 3.62581E-5, 3.61871E-5, 3.61162E-5, 3.60455E-5, 3.59749E-5, 3.59044E-5, 3.5834E-5, 3.57638E-5, 3.56937E-5, 3.56237E-5, 3.55539E-5, 3.54842E-5, 3.54147E-5, 3.53452E-5, 3.52759E-5, 3.52068E-5, 3.51377E-5, 3.50688E-5, 3.5E-5, 3.49314E-5, 3.48629E-5, 3.47945E-5, 3.47262E-5, 3.46581E-5, 3.45901E-5, 3.45222E-5, 3.44545E-5, 3.43868E-5, 3.43193E-5, 3.4252E-5, 3.41848E-5, 3.41176E-5, 3.40507E-5, 3.39838E-5, 3.39171E-5, 3.38505E-5, 3.3784E-5, 3.37176E-5, 3.36514E-5, 3.35853E-5, 3.35193E-5, 3.34535E-5, 3.33878E-5, 3.33222E-5, 3.32567E-5, 3.31913E-5, 3.31261E-5, 3.3061E-5, 3.2996E-5, 3.29312E-5, 3.28664E-5, 3.28018E-5, 3.27373E-5, 3.2673E-5, 3.26087E-5, 3.25446E-5, 3.24806E-5, 3.24167E-5, 3.23529E-5, 3.22893E-5, 3.22258E-5, 3.21624E-5, 3.20991E-5, 3.20359E-5, 3.19729E-5, 3.191E-5, 3.18472E-5, 3.17845E-5, 3.17219E-5, 3.16595E-5, 3.15972E-5, 3.1535E-5, 3.14729E-5, 3.14109E-5, 3.1349E-5, 3.12873E-5, 3.12257E-5, 3.11642E-5, 3.11028E-5, 3.10415E-5, 3.09804E-5, 3.09193E-5, 3.08584E-5, 3.07976E-5, 3.07369E-5, 3.06764E-5, 3.06159E-5, 3.05556E-5, 3.04953E-5, 3.04352E-5, 3.03752E-5, 3.03153E-5, 3.02556E-5, 3.01959E-5, 3.01363E-5, 3.00769E-5, 3.00176E-5, 2.99584E-5, 2.98993E-5, 2.98403E-5, 2.97814E-5, 2.97227E-5, 2.9664E-5, 2.96055E-5, 2.95471E-5, 2.94888E-5, 2.94306E-5, 2.93725E-5, 2.93145E-5, 2.92567E-5, 2.91989E-5, 2.91412E-5, 2.90837E-5, 2.90263E-5, 2.8969E-5, 2.89118E-5, 2.88547E-5, 2.87977E-5, 2.87408E-5, 2.8684E-5, 2.86273E-5, 2.85708E-5, 2.85143E-5, 2.8458E-5, 2.84018E-5, 2.83456E-5, 2.82896E-5, 2.82337E-5, 2.81779E-5, 2.81222E-5, 2.80666E-5, 2.80111E-5, 2.79557E-5, 2.79004E-5, 2.78453E-5, 2.77902E-5, 2.77352E-5, 2.76804E-5, 2.76256E-5, 2.7571E-5, 2.75165E-5, 2.7462E-5, 2.74077E-5, 2.73535E-5, 2.72993E-5, 2.72453E-5, 2.71914E-5, 2.71376E-5, 2.70839E-5, 2.70302E-5, 2.69767E-5, 2.69233E-5, 2.687E-5, 2.68168E-5, 2.67637E-5, 2.67107E-5, 2.66578E-5, 2.6605E-5, 2.65523E-5, 2.64997E-5, 2.64472E-5, 2.63949E-5, 2.63426E-5, 2.62904E-5, 2.62383E-5, 2.61863E-5, 2.61344E-5, 2.60826E-5, 2.60309E-5, 2.59793E-5, 2.59278E-5, 2.58764E-5, 2.58251E-5, 2.57739E-5, 2.57228E-5, 2.56718E-5, 2.56209E-5, 2.55701E-5, 2.55194E-5, 2.54687E-5, 2.54182E-5, 2.53678E-5, 2.53175E-5, 2.52672E-5, 2.52171E-5, 2.51671E-5, 2.51171E-5, 2.50673E-5, 2.50175E-5, 2.49679E-5, 2.49183E-5, 2.48689E-5, 2.48195E-5, 2.47702E-5, 2.4721E-5, 2.4672E-5, 2.4623E-5, 2.45741E-5, 2.45253E-5, 2.44766E-5, 2.4428E-5, 2.43794E-5, 2.4331E-5, 2.42827E-5, 2.42344E-5, 2.41863E-5, 2.41382E-5, 2.40902E-5, 2.40424E-5, 2.39946E-5, 2.39469E-5, 2.38993E-5, 2.38518E-5, 2.38044E-5, 2.37571E-5, 2.37098E-5, 2.36627E-5, 2.36156E-5, 2.35687E-5, 2.35218E-5, 2.3475E-5, 2.34283E-5, 2.33817E-5, 2.33352E-5, 2.32888E-5, 2.32425E-5, 2.31962E-5, 2.31501E-5, 2.3104E-5, 2.3058E-5, 2.30121E-5, 2.29663E-5, 2.29206E-5, 2.2875E-5, 2.28295E-5, 2.2784E-5, 2.27387E-5, 2.26934E-5, 2.26482E-5, 2.26031E-5, 2.25581E-5, 2.25132E-5, 2.24683E-5, 2.24236E-5, 2.23789E-5, 2.23343E-5, 2.22899E-5, 2.22454E-5, 2.22011E-5};
        double[] realCDF = new double[]{0.0, 0.002469023, 0.004877283, 0.007225669, 0.009516331, 0.011750524, 0.013929721, 0.016054362, 0.018127049, 0.020148601, 0.022120303, 0.024043411, 0.025919158, 0.0277477, 0.029531789, 0.031271878, 0.032969065, 0.034624423, 0.036238999, 0.037813819, 0.039349052, 0.040847035, 0.042308115, 0.043733212, 0.045123226, 0.046479033, 0.047801491, 0.049091438, 0.05034969, 0.051577047, 0.05277326, 0.053940875, 0.055079824, 0.056190826, 0.057274584, 0.058331782, 0.059363091, 0.060369163, 0.061350635, 0.062308132, 0.063241384, 0.064152548, 0.065041485, 0.065908756, 0.066754911, 0.067580484, 0.068385999, 0.069171966, 0.069938883, 0.070687237, 0.071417501, 0.072130141, 0.072824726, 0.073503305, 0.074165561, 0.074811915, 0.075442773, 0.076058537, 0.076659594, 0.077246326, 0.077819104, 0.07837829, 0.078924238, 0.079457294, 0.07997705, 0.080485209, 0.080981448, 0.08146608, 0.08193941, 0.082401736, 0.082853349, 0.083294532, 0.083725562, 0.08414671, 0.08455824, 0.08496041, 0.085353471, 0.085737669, 0.086112509, 0.086479596, 0.086838512, 0.08718948, 0.087532716, 0.087868433, 0.088196838, 0.088518132, 0.088832514, 0.089140176, 0.089441306, 0.089736088, 0.090024702, 0.090307322, 0.090584121, 0.090854535, 0.091120099, 0.091380321, 0.091635357, 0.091885358, 0.092130472, 0.092370843, 0.092606613, 0.092837918, 0.093064893, 0.09328767, 0.093506377, 0.093721138, 0.093932078, 0.094139314, 0.094342306, 0.094542411, 0.094739149, 0.094932627, 0.095122952, 0.095310226, 0.095494551, 0.095676025, 0.095854745, 0.096030804, 0.096204295, 0.096375307, 0.096543929, 0.096710244, 0.096874338, 0.097036293, 0.097196187, 0.097353426, 0.097509367, 0.097663471, 0.09781581, 0.097966457, 0.098115479, 0.098262945, 0.09840892, 0.098553469, 0.098696655, 0.09883854, 0.098979184, 0.099118645, 0.099256982, 0.09939425, 0.099530505, 0.099665213, 0.099799546, 0.099933019, 0.100065681, 0.100197582, 0.100328768, 0.100459287, 0.100589183, 0.100718502, 0.100847286, 0.100975578, 0.10110342, 0.101230853, 0.101357915, 0.101484646, 0.101611083, 0.101737264, 0.101863225, 0.101988422, 0.102113999, 0.102239457, 0.102364827, 0.102490143, 0.102615435, 0.102740735, 0.102866072, 0.102991476, 0.103116976, 0.103242599, 0.103368374, 0.103494326, 0.103620483, 0.103746869, 0.10387351, 0.104000431, 0.104127656, 0.104254665, 0.104382523, 0.104510751, 0.10463937, 0.104768402, 0.104897867, 0.105027785, 0.105158178, 0.105289063, 0.105420461, 0.105552389, 0.105684867, 0.105817911, 0.105951539, 0.106085769, 0.106220617, 0.106356099, 0.106492231, 0.106629029, 0.106765982, 0.106904118, 0.107042961, 0.107182527, 0.107322829, 0.10746388, 0.107605693, 0.107748282, 0.107891659, 0.108035837, 0.108180827, 0.108326641, 0.108473291, 0.108620788, 0.108769144, 0.108918368, 0.109068472, 0.109219465, 0.109371359, 0.109523672, 0.109677361, 0.109831975, 0.109987526, 0.110144021, 0.11030147, 0.11045988, 0.110619261, 0.11077962, 0.110940964, 0.111103303, 0.111266644, 0.111430993, 0.111596358, 0.111762746, 0.111930165, 0.11209862, 0.112268119, 0.112438667, 0.112610271, 0.112782465, 0.112956168, 0.113130944, 0.113306797, 0.113483733, 0.113661758, 0.113840877, 0.114021094, 0.114202416, 0.114384846, 0.114568389, 0.11475305, 0.114938834, 0.115125745, 0.115313786, 0.115502963, 0.115693279, 0.115884738, 0.116077345, 0.116271102, 0.116465571, 0.116661613, 0.116858814, 0.117057179, 0.11725671, 0.11745741, 0.117659282, 0.11786233, 0.118066557, 0.118271964, 0.118478554, 0.118686331, 0.118895296, 0.119105453, 0.119316803, 0.119529349, 0.119743093, 0.119958037, 0.120174183, 0.120391533, 0.120609686, 0.120829427, 0.121050375, 0.121272534, 0.121495905, 0.121720489, 0.121946288, 0.122173303, 0.122401535, 0.122630987, 0.122861659, 0.123093552, 0.123326667, 0.123561007, 0.12379657, 0.12403336, 0.124271376, 0.124510619, 0.124751091, 0.124992792, 0.125235722, 0.125479502, 0.125724872, 0.125971472, 0.126219304, 0.126468367, 0.126718662, 0.126970189, 0.127222949, 0.127476942, 0.127732168, 0.127988627, 0.12824632, 0.128505246, 0.128765405, 0.129026799, 0.129289426, 0.129553287, 0.129818381, 0.130084709, 0.13035227, 0.130621065, 0.130891092, 0.131161979, 0.131434451, 0.131708154, 0.131983088, 0.132259252, 0.132536645, 0.132815269, 0.133095121, 0.133376201, 0.133658509, 0.133942045, 0.134226806, 0.134512794, 0.134800007, 0.135088444, 0.135378105, 0.135668989, 0.135961095, 0.136254422, 0.13654897, 0.136844738, 0.137141385, 0.137439571, 0.137738973, 0.13803959, 0.138341421, 0.138644465, 0.138948721, 0.139254187, 0.139560863, 0.139868747, 0.140177839, 0.140488137, 0.14079964, 0.141112346, 0.141426255, 0.141741364, 0.142057674, 0.142375182, 0.142693887, 0.143013789, 0.143334884, 0.143657173, 0.143980335, 0.144304989, 0.144630831, 0.14495786, 0.145286074, 0.145615471, 0.14594605, 0.14627781, 0.146610748, 0.146944864, 0.147280155, 0.14761662, 0.147954257, 0.148293065, 0.148633042, 0.148974186, 0.149316495, 0.149659969, 0.150004604, 0.150350399, 0.150697354, 0.151045464, 0.151394436, 0.15174484, 0.152096395, 0.152449098, 0.152802949, 0.153157944, 0.153514083, 0.153871362, 0.154229781, 0.154589337, 0.154950028, 0.155311853, 0.155674809, 0.156038894, 0.156404106, 0.156770444, 0.157137905, 0.157506487, 0.157876188, 0.158247006, 0.158618939, 0.158991985, 0.159366142, 0.159741126, 0.160117484, 0.160494947, 0.160873511, 0.161253174, 0.161633935, 0.162015791, 0.162398739, 0.162782778, 0.163167906, 0.16355412, 0.163941417, 0.164329797, 0.164719255, 0.165109791, 0.165501401, 0.165894084, 0.166287838, 0.166682659, 0.167078546, 0.167475496, 0.167873506, 0.168272576, 0.168672436, 0.169073604, 0.169475822, 0.169879089, 0.170283402, 0.170688759, 0.171095157, 0.171502593, 0.171911067, 0.172320574, 0.172731113, 0.173142681, 0.173555276, 0.173968895, 0.174383536, 0.174799195, 0.175215872, 0.175633563, 0.176052265, 0.176471977, 0.176892695, 0.177314418, 0.177737142, 0.178160619, 0.178585328, 0.17901103, 0.179437724, 0.179865406, 0.180294074, 0.180723725, 0.181154356, 0.181585966, 0.182018551, 0.18245211, 0.182886638, 0.183322134, 0.183758595, 0.184196019, 0.184634402, 0.185073743, 0.185514038, 0.185955285, 0.186397481, 0.186840623, 0.18728471, 0.187729738, 0.188175478, 0.18862237, 0.189070196, 0.189518951, 0.189968634, 0.190419242, 0.190870771, 0.191323221, 0.191776586, 0.192230866, 0.192686057, 0.193142156, 0.193599161, 0.19405707, 0.194515878, 0.194975584, 0.195436185, 0.195897678, 0.196360061, 0.19682333, 0.197287483, 0.197752517, 0.198218429, 0.198685217, 0.199152663, 0.199621185, 0.200090574, 0.200560827, 0.201031942, 0.201503915, 0.201976744, 0.202450426, 0.202924959, 0.203400339, 0.203876563, 0.20435363, 0.204831535, 0.205310277, 0.205789853, 0.206270259, 0.206751493, 0.207233552, 0.207716433, 0.208200134, 0.208684652, 0.209169983, 0.209656126, 0.210143077, 0.210630632, 0.211119182, 0.211608532, 0.212098679, 0.21258962, 0.213081351, 0.213573871, 0.214067176, 0.214561264, 0.215056131, 0.215551775, 0.216048193, 0.216545383, 0.21704334, 0.217542063, 0.218041549, 0.218541795, 0.219042797, 0.219544554, 0.220047062, 0.220550318, 0.221054321, 0.221559065, 0.22206455, 0.222570586, 0.223077534, 0.223585214, 0.224093623, 0.224602756, 0.225112613, 0.225623189, 0.226134482, 0.226646489, 0.227159207, 0.227672634, 0.228186766, 0.228701601, 0.229217136, 0.229733368, 0.230250294, 0.230767911, 0.231286217, 0.231805208, 0.232324882, 0.232845236, 0.233366267, 0.233887973, 0.23441035, 0.234933223, 0.235456928, 0.235981295, 0.236506322, 0.237032006, 0.237558344, 0.238085334, 0.238612972, 0.239141255, 0.239670182, 0.240199748, 0.240729952, 0.24126079, 0.241792259, 0.242324357, 0.24285708, 0.243390427, 0.243924394, 0.244458978, 0.244994177, 0.245529987, 0.246066407, 0.246603432, 0.247141061, 0.24767929, 0.248217954, 0.248757369, 0.249297376, 0.249837972, 0.250379155, 0.25092092, 0.251463266, 0.25200619, 0.252549689, 0.25309376, 0.253638401, 0.254183607, 0.254729378, 0.25527571, 0.255822599, 0.256370045, 0.256918042, 0.25746659, 0.258015684, 0.258565323, 0.259115503, 0.259666222, 0.260217477, 0.260769265, 0.261321584, 0.261874277, 0.262427642, 0.262981529, 0.263535935, 0.264090858, 0.264646294, 0.265202241, 0.265758696, 0.266315657, 0.26687312, 0.267431083, 0.267989543, 0.268548498, 0.269107944, 0.269667879, 0.2702283, 0.270789205, 0.271350591, 0.271912454, 0.272474793, 0.273037604, 0.273600885, 0.274164633, 0.274728846, 0.275293521, 0.275858511, 0.276424096, 0.276990134, 0.277556623, 0.27812356, 0.278690942, 0.279258767, 0.279827032, 0.280395734, 0.280964871, 0.28153444, 0.282104438, 0.282674863, 0.283245712, 0.283816982, 0.284388671, 0.284960775, 0.285533293, 0.286106222, 0.286679559, 0.287253301, 0.287827446, 0.288401991, 0.288976933, 0.28955227, 0.290127868, 0.290703982, 0.291280484, 0.291857369, 0.292434636, 0.293012283, 0.293590305, 0.294168701, 0.294747469, 0.295326605, 0.295906107, 0.296485973, 0.297066199, 0.297646783, 0.298227724, 0.298809017, 0.299390661, 0.299972652, 0.30055499, 0.30113767, 0.30172069, 0.302304048, 0.302887741, 0.303471767, 0.304056122, 0.304640684, 0.305225689, 0.305811015, 0.306396662, 0.306982625, 0.307568904, 0.308155494, 0.308742395, 0.309329603, 0.309917115, 0.31050493, 0.311093044, 0.311681456, 0.312270163, 0.312859161, 0.31344845, 0.314038026, 0.314627887, 0.31521803, 0.315808453, 0.316399153, 0.316990129, 0.317581377, 0.318172895, 0.318764681, 0.319356621, 0.319948931, 0.320541502, 0.32113433, 0.321727413, 0.32232075, 0.322914337, 0.323508172, 0.324102253, 0.324696578, 0.325291143, 0.325885947, 0.326480987, 0.327076261, 0.327671766, 0.3282675, 0.328863461, 0.329459646, 0.330056053, 0.330652679, 0.331249523, 0.331846581, 0.332443852, 0.333041333, 0.333639022, 0.334236916, 0.33483491, 0.335433205, 0.336031698, 0.336630387, 0.33722927, 0.337828345, 0.338427608, 0.339027059, 0.339626694, 0.340226511, 0.340826508, 0.341426683, 0.342027034, 0.342627557, 0.343228251, 0.343829114, 0.344430143, 0.345031337, 0.345632692, 0.346234206, 0.346835879, 0.347437706, 0.348039686, 0.348641816, 0.349244095, 0.349846521, 0.350448993, 0.3510517, 0.351654548, 0.352257532, 0.352860652, 0.353463904, 0.354067288, 0.354670799, 0.355274437, 0.355878199, 0.356482084, 0.357086088, 0.357690209, 0.358294446, 0.358898796, 0.359503258, 0.360107829, 0.360712506, 0.361317288, 0.361922173, 0.362527159, 0.363132243, 0.363737423, 0.364342697, 0.364948063, 0.36555352, 0.366158974, 0.366764601, 0.367370311, 0.367976104, 0.368581975, 0.369187924, 0.369793949, 0.370400046, 0.371006215, 0.371612453, 0.372218758, 0.372825127, 0.37343156, 0.374038054, 0.374644607, 0.375251216, 0.375857881, 0.376464598, 0.377071366, 0.377678183, 0.378285047, 0.378891955, 0.379498907, 0.380105899, 0.38071293, 0.381319998, 0.381927017, 0.38253415, 0.383141314, 0.383748507, 0.384355727, 0.384962972, 0.38557024, 0.386177529, 0.386784837, 0.387392162, 0.387999503, 0.388606857, 0.389214222, 0.389821597, 0.39042898, 0.391036368, 0.39164376, 0.392251154, 0.392858548, 0.393465941, 0.394073329, 0.394680712, 0.395288087, 0.395895453, 0.396502808, 0.39711015, 0.3977174, 0.398324708, 0.398931997, 0.399539266, 0.400146512, 0.400753734, 0.401360929, 0.401968097, 0.402575236, 0.403182343, 0.403789416, 0.404396455, 0.405003456, 0.405610419, 0.406217341, 0.406824222, 0.407431058, 0.408037848, 0.408644591, 0.409251284, 0.409857926, 0.410464516, 0.41107105, 0.411677529, 0.412283949, 0.41289031, 0.413496539, 0.414102772, 0.41470894, 0.415315042, 0.415921075, 0.416527038, 0.417132929, 0.417738746, 0.418344488, 0.418950153, 0.419555739, 0.420161245, 0.420766669, 0.421372009, 0.421977263, 0.422582431, 0.42318751, 0.423792498, 0.424397394, 0.425002197, 0.425606904, 0.426211515, 0.426816027, 0.427420438, 0.428024748, 0.428628955, 0.429233056, 0.429836985, 0.43044087, 0.431044644, 0.431648307, 0.432251857, 0.432855292, 0.433458611, 0.434061813, 0.434664894, 0.435267855, 0.435870693, 0.436473407, 0.437075996, 0.437678457, 0.43828079, 0.438882992, 0.439485063, 0.440087, 0.440688802, 0.441290468, 0.441891996, 0.442493384, 0.443094632, 0.443695737, 0.444296698, 0.444897514, 0.445498183, 0.446098642, 0.446699011, 0.447299229, 0.447899294, 0.448499204, 0.449098958, 0.449698556, 0.450297994, 0.450897273, 0.45149639, 0.452095344, 0.452694133, 0.453292757, 0.453891213, 0.4544895, 0.455087617, 0.455685563, 0.456283336, 0.456880934, 0.457478357, 0.458075602, 0.458672669, 0.459269556, 0.459866261, 0.460462784, 0.461059123, 0.461655221, 0.462251186, 0.462846962, 0.46344255, 0.464037946, 0.46463315, 0.46522816, 0.465822975, 0.466417595, 0.467012016, 0.467606239, 0.468200261, 0.468794082, 0.4693877, 0.469981113, 0.470574322, 0.471167323, 0.471760116, 0.4723527, 0.472945074, 0.473537235, 0.474129183, 0.474720917, 0.475312435, 0.475903736, 0.476494818, 0.477085682, 0.477676273, 0.478266692, 0.478856887, 0.479446858, 0.480036604, 0.480626122, 0.481215412, 0.481804473, 0.482393303, 0.482981901, 0.483570266, 0.484158396, 0.484746291, 0.48533395, 0.485921371, 0.486508552, 0.487095494, 0.487682193, 0.488268651, 0.488854864, 0.489440833, 0.490026555, 0.490612031, 0.491197257, 0.491782235, 0.492366961, 0.492951436, 0.49353561, 0.494119577, 0.494703288, 0.495286742, 0.49586994, 0.496452878, 0.497035557, 0.497617975, 0.498200131, 0.498782023, 0.499363652, 0.499945015, 0.500526113, 0.501106942, 0.501687503, 0.502267795, 0.502847816, 0.503427565, 0.504007042, 0.504586244, 0.505165172, 0.505743824, 0.506322198, 0.506900295, 0.507478113, 0.50805565, 0.508632906, 0.509209837, 0.509786527, 0.510362933, 0.510939053, 0.511514887, 0.512090434, 0.512665692, 0.513240661, 0.51381534, 0.514389728, 0.514963823, 0.515537625, 0.516111133, 0.516684346, 0.517257262, 0.517829882, 0.518402203, 0.518974225, 0.519545947, 0.520117369, 0.520688488, 0.521259304, 0.521829817, 0.522400024, 0.522969927, 0.523539522, 0.52410881, 0.524677789, 0.525246419, 0.525814777, 0.526382825, 0.52695056, 0.527517982, 0.528085091, 0.528651884, 0.529218362, 0.529784523, 0.530350366, 0.530915892, 0.531481098, 0.532045983, 0.532610548, 0.533174791, 0.533738711, 0.534302308, 0.53486558, 0.535428526, 0.535991147, 0.53655344, 0.537115406, 0.537677043, 0.538238351, 0.538799328, 0.539359974, 0.539920288, 0.540480232, 0.541039879, 0.541599191, 0.542158168, 0.542716809, 0.543275113, 0.543833079, 0.544390707, 0.544947995, 0.545504944, 0.546061552, 0.546617818, 0.547173741, 0.547729322, 0.548284559, 0.548839451, 0.549393997, 0.549948198, 0.550502051, 0.551055557, 0.551608714, 0.552161522, 0.55271398, 0.553266087, 0.553817843, 0.554369247, 0.554920298, 0.555470962, 0.556021304, 0.556571291, 0.557120922, 0.557670197, 0.558219115, 0.558767675, 0.559315876, 0.559863718, 0.5604112, 0.560958322, 0.561505082, 0.56205148, 0.562597515, 0.563143187, 0.563688495, 0.564233438, 0.564778016, 0.565322228, 0.565866073, 0.56640955, 0.56695266, 0.567495401, 0.568037772, 0.568579774, 0.569121405, 0.569662665, 0.570203553, 0.570744037, 0.571284179, 0.571823946, 0.57236334, 0.572902358, 0.573441001, 0.573979268, 0.574517157, 0.57505467, 0.575591804, 0.57612856, 0.576664936, 0.577200933, 0.577736549, 0.578271784, 0.578806638, 0.579341109, 0.579875198, 0.580408904, 0.580942225, 0.581475162, 0.582007715, 0.582539881, 0.583071662, 0.583603056, 0.584134062, 0.584664681, 0.585194912, 0.585724724, 0.586254176, 0.586783237, 0.587311908, 0.587840189, 0.588368077, 0.588895574, 0.589422678, 0.589949389, 0.590475706, 0.59100163, 0.591527158, 0.592052292, 0.59257703, 0.593101371, 0.593625316, 0.594148864, 0.594672015, 0.595194767, 0.595717121, 0.596239076, 0.596760631, 0.597281786, 0.597802541, 0.598322894, 0.598842847, 0.599362397, 0.599881545, 0.600400263, 0.600918605, 0.601436542, 0.601954076, 0.602471204, 0.602987928, 0.603504246, 0.604020159, 0.604535665, 0.605050764, 0.605565455, 0.60607974, 0.606593616, 0.607107083, 0.607620142, 0.608132791, 0.608645031, 0.60915686, 0.609668279, 0.610179287, 0.610689883, 0.611200068, 0.61170984, 0.6122192, 0.612728147, 0.613236681, 0.6137448, 0.614252482, 0.614759772, 0.615266648, 0.615773108, 0.616279153, 0.616784782, 0.617289994, 0.61779479, 0.618299169, 0.61880313, 0.619306673, 0.619809798, 0.620312505, 0.620814792, 0.621316661, 0.62181811, 0.622319139, 0.622819748, 0.623319936, 0.623819703, 0.624319049, 0.624817974, 0.625316476, 0.625814557, 0.626312214, 0.626809449, 0.627306261, 0.62780265, 0.628298592, 0.628794132, 0.629289247, 0.629783938, 0.630278204, 0.630772044, 0.631265459, 0.631758448, 0.632251011, 0.632743147, 0.633234857, 0.633726139, 0.634216994, 0.634707422, 0.635197421, 0.635686993, 0.636176136, 0.63666485, 0.637153136, 0.637640992, 0.638128419, 0.638615416, 0.639101983, 0.63958812, 0.640073826, 0.640559101, 0.641043946, 0.641528359, 0.64201232, 0.64249587, 0.642978987, 0.643461673, 0.643943925, 0.644425746, 0.644907133, 0.645388087, 0.645868608, 0.646348695, 0.646828349, 0.647307568, 0.647786354, 0.648264705, 0.648742621, 0.649220102, 0.649697148, 0.650173759, 0.650649935, 0.651125675, 0.651600979, 0.652075847, 0.652550279, 0.653024274, 0.653497833, 0.653970955, 0.65444364, 0.654915887, 0.655387698, 0.655859051, 0.656329986, 0.656800483, 0.657270542, 0.657740162, 0.658209344, 0.658678088, 0.659146393, 0.659614259, 0.660081686, 0.660548673, 0.661015222, 0.661481331, 0.661947, 0.66241223, 0.662877019, 0.663341369, 0.663805278, 0.664268747, 0.664731775, 0.665194363, 0.66565651, 0.666118216, 0.666579481, 0.667040305, 0.667500688, 0.667960629, 0.668420129, 0.66887917, 0.669337785, 0.66979596, 0.670253692, 0.670710982, 0.671167829, 0.671624235, 0.672080198, 0.672535718, 0.672990796, 0.673445431, 0.673899624, 0.674353373, 0.67480668, 0.675259543, 0.675711963, 0.67616394, 0.676615473, 0.677066563, 0.67751721, 0.677967412, 0.678417172, 0.678866487, 0.679315358, 0.679763786, 0.68021177, 0.680659309, 0.681106405, 0.68155304, 0.681999247, 0.682445009, 0.682890327, 0.6833352, 0.683779629, 0.684223614, 0.684667154, 0.685110249, 0.685552899, 0.685995105, 0.686436866, 0.686878182, 0.687319053, 0.68775948, 0.688199461, 0.688638998, 0.689078089, 0.689516735, 0.689954936, 0.690392692, 0.690830003, 0.691266869, 0.69170329, 0.692139265, 0.692574795, 0.69300988, 0.693444519, 0.693878713, 0.694312447, 0.69474575, 0.695178608, 0.695611021, 0.696042988, 0.69647451, 0.696905586, 0.697336217, 0.697766403, 0.698196143, 0.698625438, 0.699054287, 0.699482691, 0.69991065, 0.700338164, 0.700765232, 0.701191854, 0.701618032, 0.702043764, 0.702469051, 0.702893892, 0.703318289, 0.70374224, 0.704165746, 0.704588806, 0.705011422, 0.705433592, 0.705855318, 0.706276584, 0.706697419, 0.707117809, 0.707537754, 0.707957254, 0.708376309, 0.70879492, 0.709213085, 0.709630806, 0.710048082, 0.710464913, 0.710881299, 0.711297241, 0.711712739, 0.712127792, 0.7125424, 0.712956564, 0.713370284, 0.71378356, 0.714196391, 0.714608778, 0.715020721, 0.71543222, 0.715843275, 0.716253887, 0.716664054, 0.717073778, 0.717483057, 0.717891894, 0.718300274, 0.718708223, 0.719115728, 0.719522791, 0.719929409, 0.720335585, 0.720741318, 0.721146608, 0.721551454, 0.721955858, 0.72235982, 0.722763338, 0.723166414, 0.723569047, 0.723971239, 0.724372987, 0.724774294, 0.725175158, 0.725575581, 0.725975561, 0.7263751, 0.726774197, 0.727172852, 0.727571066, 0.727968838, 0.728366169, 0.728763059, 0.729159508, 0.729555516, 0.729951071, 0.730346197, 0.730740883, 0.731135127, 0.731528932, 0.731922296, 0.73231522, 0.732707704, 0.733099748, 0.733491352, 0.733882516, 0.734273241, 0.734663526, 0.735053372, 0.735442779, 0.735831747, 0.736220276, 0.736608366, 0.736996017, 0.73738323, 0.737770004, 0.73815634, 0.738542238, 0.738927698, 0.739312721, 0.739697305, 0.740081452, 0.740465162, 0.740848423, 0.741231258, 0.741613656, 0.741995617, 0.742377141, 0.742758229, 0.74313888, 0.743519096, 0.743898875, 0.744278218, 0.744657125, 0.745035597, 0.745413633, 0.745791234, 0.7461684, 0.74654513, 0.746921426, 0.747297288, 0.747672714, 0.748047707, 0.748422265, 0.748796389, 0.74917008, 0.749543336, 0.74991616, 0.750288549, 0.750660506, 0.75103203, 0.751403121, 0.751773769, 0.752143995, 0.752513788, 0.75288315, 0.753252079, 0.753620577, 0.753988642, 0.754356277, 0.75472348, 0.755090253, 0.755456594, 0.755822505, 0.756187986, 0.756553036, 0.756917656, 0.757281846, 0.757645606, 0.758008937, 0.758371839, 0.758734311, 0.759096355, 0.75945797, 0.759819156, 0.760179914, 0.760540244, 0.760900145, 0.761259619, 0.761618666, 0.761977285, 0.762335468, 0.762693233, 0.763050571, 0.763407482, 0.763763968, 0.764120027, 0.76447566, 0.764830867, 0.765185649, 0.765540006, 0.765893938, 0.766247444, 0.766600526, 0.766953184, 0.767305417, 0.767657227, 0.768008612, 0.768359574, 0.768710113, 0.769060228, 0.769409921, 0.769759191, 0.770108038, 0.770456463, 0.770804466, 0.771152048, 0.771499207, 0.771845946, 0.772192263, 0.772538151, 0.772883626, 0.773228681, 0.773573316, 0.773917531, 0.774261326, 0.774604701, 0.774947657, 0.775290194, 0.775632312, 0.775974012, 0.776315293, 0.776656156, 0.776996601, 0.777336628, 0.777676239, 0.778015431, 0.778354207, 0.778692567, 0.779030509, 0.779368036, 0.779705146, 0.780041841, 0.78037812, 0.780713984, 0.781049433, 0.781384468, 0.781719088, 0.782053293, 0.782387077, 0.782720455, 0.783053419, 0.783385969, 0.783718107, 0.784049832, 0.784381144, 0.784712045, 0.785042533, 0.785372609, 0.785702274, 0.786031528, 0.78636037, 0.786688802, 0.787016824, 0.787344435, 0.787671636, 0.787998428, 0.78832481, 0.788650783, 0.788976347, 0.789301502, 0.789626249, 0.789950588, 0.790274518, 0.790598042, 0.790921158, 0.791243867, 0.791566169, 0.791888057, 0.792209546, 0.792530629, 0.792851307, 0.793171578, 0.793491445, 0.793810907, 0.794129964, 0.794448616, 0.794766865, 0.795084709, 0.79540215, 0.795719188, 0.796035823, 0.796352055, 0.796667884, 0.796983311, 0.797298337, 0.79761296, 0.797927182, 0.798241004, 0.798554424, 0.798867444, 0.799180063, 0.799492283, 0.799804102, 0.800115523, 0.800426544, 0.800737166, 0.801047384, 0.801357209, 0.801666637, 0.801975666, 0.802284298, 0.802592533, 0.802900371, 0.803207813, 0.803514858, 0.803821507, 0.804127761, 0.804433619, 0.804739081, 0.805044149, 0.805348823, 0.805653102, 0.805956987, 0.806260478, 0.806563576, 0.806866281, 0.807168593, 0.807470512, 0.80777204, 0.808073175, 0.808373918, 0.808674271, 0.808974232, 0.809273802, 0.809572982, 0.809871772, 0.810170166, 0.810468176, 0.810765796, 0.811063028, 0.811359871, 0.811656326, 0.811952392, 0.812248071, 0.812543362, 0.812838266, 0.813132783, 0.813426913, 0.813720658, 0.814014016, 0.814306988, 0.814599575, 0.814891777, 0.815183594, 0.815475027, 0.815766075, 0.81605674, 0.816347021, 0.816636918, 0.816926433, 0.817215565, 0.817504315, 0.817792682, 0.818080668, 0.818368273, 0.818655491, 0.818942333, 0.819228795, 0.819514877, 0.819800578, 0.8200859, 0.820370843, 0.820655407, 0.820939592, 0.821223399, 0.821506828, 0.821789879, 0.822072553, 0.822354849, 0.822636769, 0.822918312, 0.82319948, 0.823480271, 0.823760686, 0.824040727, 0.824320392, 0.824599683, 0.8248786, 0.825157143, 0.825435312, 0.825713108, 0.82599053, 0.82626758, 0.826544258, 0.826820558, 0.827096492, 0.827372054, 0.827647245, 0.827922065, 0.828196515, 0.828470595, 0.828744304, 0.829017645, 0.829290615, 0.829563218, 0.829835451, 0.830107316, 0.830378813, 0.830649943, 0.830920705, 0.831191101, 0.831461129, 0.831730792, 0.832000088, 0.832269019, 0.832537584, 0.832805784, 0.83307362, 0.833341091, 0.833608198, 0.833874941, 0.834141321, 0.834407338, 0.834672992, 0.834938279, 0.835203208, 0.835467776, 0.835731981, 0.835995826, 0.83625931, 0.836522434, 0.836785197, 0.8370476, 0.837309644, 0.837571329, 0.837832654, 0.838093622, 0.838354231, 0.838614482, 0.838874375, 0.839133911, 0.83939309, 0.839651913, 0.83991038, 0.84016849, 0.840426245, 0.840683645, 0.840940689, 0.841197379, 0.841453715, 0.841709697, 0.841965325, 0.842220599, 0.842475521, 0.842730086, 0.842984303, 0.843238168, 0.843491681, 0.843744843, 0.843997653, 0.844250114, 0.844502223, 0.844753983, 0.845005393, 0.845256454, 0.845507166, 0.845757529, 0.846007543, 0.84625721, 0.846506529, 0.8467555, 0.847004125, 0.847252403, 0.847500334, 0.84774792, 0.84799516, 0.848242054, 0.848488604, 0.848734808, 0.848980669, 0.849226185, 0.849471358, 0.849716187, 0.849960669, 0.850204813, 0.850448614, 0.850692073, 0.850935191, 0.851177967, 0.851420402, 0.851662496, 0.85190425, 0.852145664, 0.852386738, 0.852627473, 0.852867869, 0.853107926, 0.853347645, 0.853587026, 0.853826069, 0.854064775, 0.854303143, 0.854541175, 0.854778871, 0.855016231, 0.855253255, 0.855489944, 0.855726298, 0.855962317, 0.856198001, 0.856433352, 0.856668369, 0.856903053, 0.857137401, 0.857371419, 0.857605105, 0.857838459, 0.858071481, 0.858304172, 0.858536532, 0.858768561, 0.85900026, 0.859231629, 0.859462669, 0.859693379, 0.85992376, 0.860153813, 0.860383537, 0.860612933, 0.860842002, 0.861070744, 0.861299158, 0.861527246, 0.861755008, 0.861982444, 0.862209554, 0.86243634, 0.8626628, 0.862888935, 0.863114747, 0.863340234, 0.863565398, 0.863790236, 0.864014754, 0.864238949, 0.864462822, 0.864686373, 0.864909603, 0.865132511, 0.865355099, 0.865577366, 0.865799313, 0.86602094, 0.866242247, 0.866463236, 0.866683905, 0.866904256, 0.867124289, 0.867344004, 0.867563402, 0.867782482, 0.868001246, 0.868219693, 0.868437824, 0.868655639, 0.868873139, 0.869090323, 0.869307193, 0.869523748, 0.86973999, 0.869955917, 0.870171531, 0.870386829, 0.870601818, 0.870816493, 0.871030857, 0.871244909, 0.871458649, 0.871672079, 0.871885197, 0.872098005, 0.872310503, 0.872522692, 0.872734571, 0.872946141, 0.873157402, 0.873368355, 0.873579, 0.873789337, 0.873999367, 0.874209089, 0.874418505, 0.874627615, 0.874836418, 0.875044916, 0.875253109, 0.875460996, 0.875668579, 0.875875857, 0.876082832, 0.876289503, 0.87649587, 0.876701932, 0.876907693, 0.877113153, 0.87731831, 0.877523166, 0.87772772, 0.877931974, 0.878135926, 0.878339579, 0.878542931, 0.878745984, 0.878948737, 0.879151192, 0.879353347, 0.879555205, 0.879756764, 0.879958026, 0.880158991, 0.880359658, 0.880560029, 0.880760104, 0.880959882, 0.881159366, 0.881358553, 0.881557446, 0.881756044, 0.881954348, 0.882152358, 0.882350074, 0.882547497, 0.882744624, 0.882941462, 0.883138007, 0.88333426, 0.883530221, 0.883725891, 0.88392127, 0.884116359, 0.884311157, 0.884505665, 0.884699884, 0.884893813, 0.885087453, 0.885280805, 0.885473868, 0.885666644, 0.885859131, 0.886051332, 0.886243245, 0.886434872, 0.886626213, 0.886817267, 0.887008036, 0.887198519, 0.887388718, 0.887578632, 0.887768261, 0.887957607, 0.888146669, 0.888335447, 0.888523941, 0.888712154, 0.888900084, 0.889087733, 0.889275099, 0.889462185, 0.889648989, 0.889835513, 0.890021756, 0.89020772, 0.890393403, 0.890578807, 0.890763933, 0.890948779, 0.891133347, 0.891317637, 0.891501649, 0.891685384, 0.891868842, 0.892052023, 0.892234928, 0.892417556, 0.892599909, 0.892781986, 0.892963788, 0.893145316, 0.893326569, 0.893507547, 0.893688252, 0.893868684, 0.89404884, 0.894228726, 0.894408339, 0.89458768, 0.894766749, 0.894945546, 0.895124072, 0.895302328, 0.895480313, 0.895658027, 0.895835472, 0.896012647, 0.896189553, 0.89636619, 0.896542559, 0.896718659, 0.896894491, 0.897070055, 0.897245353, 0.897420383, 0.897595147, 0.897769644, 0.897943875, 0.898117841, 0.898291541, 0.898464976, 0.898638147, 0.898811053, 0.898983695, 0.899156073, 0.899328186, 0.899500038, 0.899671627, 0.899842953, 0.900014018, 0.90018482, 0.900355361, 0.900525641, 0.90069566, 0.900865418, 0.901034917, 0.901204155, 0.901373134, 0.901541853, 0.901710314, 0.901878516, 0.902046459, 0.902214145, 0.902381573, 0.902548744, 0.902715657, 0.902882314, 0.903048715, 0.903214859, 0.903380748, 0.903546381, 0.903711759, 0.903876882, 0.904041751, 0.904206366, 0.904370725, 0.904534832, 0.904698686, 0.904862287, 0.905025636, 0.905188732, 0.905351577, 0.905514169, 0.905676511, 0.905838601, 0.906000441, 0.90616203, 0.906323369, 0.906484459, 0.906645299, 0.906805889, 0.906966232, 0.907126325, 0.907286171, 0.907445768, 0.907605118, 0.907764221, 0.907923076, 0.908081686, 0.908240048, 0.908398165, 0.908556037, 0.908713662, 0.908871043, 0.909028179, 0.909185069, 0.909341716, 0.90949812, 0.90965428, 0.909810197, 0.909965871, 0.910121302, 0.910276491, 0.910431438, 0.910586144, 0.910740608, 0.910894831, 0.911048814, 0.911202556, 0.911356057, 0.911509319, 0.911662342, 0.911815125, 0.91196767, 0.912119976, 0.912272043, 0.912423873, 0.912575465, 0.91272682, 0.912877937, 0.913028818, 0.913179463, 0.913329871, 0.913480044, 0.913629981, 0.913779683, 0.913929148, 0.91407838, 0.914227378, 0.914376142, 0.914524672, 0.914672969, 0.914821033, 0.914968864, 0.915116463, 0.915263829, 0.915410964, 0.915557867, 0.915704538, 0.915850979, 0.915997189, 0.916143168, 0.916288918, 0.916434438, 0.916579728, 0.916724789, 0.916869622, 0.917014225, 0.917158601, 0.917302748, 0.917446668, 0.917590361, 0.917733826, 0.917877065, 0.918020077, 0.918162863, 0.918305422, 0.918447756, 0.918589866, 0.91873175, 0.918873409, 0.919014845, 0.919156056, 0.919297043, 0.919437807, 0.919578347, 0.919718665, 0.91985876, 0.919998633, 0.920138283, 0.920277712, 0.92041692, 0.920555906, 0.920694672, 0.920833217, 0.920971541, 0.921109646, 0.921247531, 0.921385197, 0.921522643, 0.921659871, 0.921796881, 0.921933672, 0.922070245, 0.9222066, 0.922342738, 0.922478658, 0.922614363, 0.922749851, 0.922885122, 0.923020178, 0.923155018, 0.923289643, 0.923424053, 0.923558248, 0.923692229, 0.923825995, 0.923959548, 0.924092887, 0.924226013, 0.924358926, 0.924491626, 0.924624114, 0.924756389, 0.924888453, 0.925020305, 0.925151946, 0.925283375, 0.925414595, 0.925545603, 0.925676402, 0.92580699, 0.92593737, 0.926067539, 0.9261975, 0.926327252, 0.926456796, 0.92658613, 0.926715258, 0.926844178, 0.926972891, 0.927101396, 0.927229695, 0.927357788, 0.927485674, 0.927613355, 0.927740829, 0.927868099, 0.927995163, 0.928122023, 0.928248678, 0.928375129, 0.928501376, 0.928627419, 0.928753259, 0.928878896, 0.92900433, 0.929129562, 0.929254591, 0.929379419, 0.929504044, 0.929628468, 0.929752691, 0.929876714, 0.930000535, 0.930124156, 0.930247578, 0.930370798, 0.93049382, 0.930616643, 0.930739267, 0.930861692, 0.930983919, 0.931105947, 0.931227778, 0.931349411, 0.931470847, 0.931592086, 0.931713128, 0.931833974, 0.931954623, 0.932075077, 0.932195335, 0.932315397, 0.932435265, 0.932554937, 0.932674415, 0.932793699, 0.932912789, 0.933031684, 0.933150387, 0.933268896, 0.933387212, 0.933505336, 0.933623267, 0.933741006, 0.933858553, 0.933975908, 0.934093072, 0.934210045, 0.934326828, 0.934443419, 0.934559821, 0.934676032, 0.934792054, 0.934907887, 0.93502353, 0.935138984, 0.93525425, 0.935369327, 0.935484216, 0.935598917, 0.93571343, 0.935827756, 0.935941896, 0.936055848, 0.936169614, 0.936283193, 0.936396586, 0.936509794, 0.936622816, 0.936735653, 0.936848305, 0.936960772, 0.937073055, 0.937185154, 0.937297068, 0.937408799, 0.937520346, 0.93763171, 0.937742892, 0.937853891, 0.937964707, 0.938075342, 0.938185794, 0.938296065, 0.938406155, 0.938516063, 0.938625791, 0.938735338, 0.938844705, 0.938953892, 0.939062899, 0.939171726, 0.939280375, 0.939388844, 0.939497134, 0.939605246, 0.93971318, 0.939820936, 0.939928513, 0.940035914, 0.940143137, 0.940250183, 0.940357053, 0.940463746, 0.940570262, 0.940676603, 0.940782768, 0.940888757, 0.940994572, 0.941100211, 0.941205676, 0.941310966, 0.941416082, 0.941521024, 0.941625793, 0.941730388, 0.941834809, 0.941939058, 0.942043134, 0.942147038, 0.942250769, 0.942354329, 0.942457717, 0.942560933, 0.942663978, 0.942766852, 0.942869556, 0.942972089, 0.943074451, 0.943176644, 0.943278667, 0.943380521, 0.943482205, 0.94358372, 0.943685067, 0.943786245, 0.943887255, 0.943988096, 0.94408877, 0.944189276, 0.944289615, 0.944389788, 0.944489793, 0.944589632, 0.944689304, 0.944788811, 0.944888151, 0.944987327, 0.945086336, 0.945185181, 0.945283861, 0.945382376, 0.945480727, 0.945578913, 0.945676936, 0.945774795, 0.945872491, 0.945970023, 0.946067393, 0.9461646, 0.946261644, 0.946358526, 0.946455247, 0.946551805, 0.946648202, 0.946744438, 0.946840512, 0.946936426, 0.947032179, 0.947127772, 0.947223205, 0.947318478, 0.947413591, 0.947508545, 0.94760334, 0.947697976, 0.947792454, 0.947886773, 0.947980933, 0.948074936, 0.948168781, 0.948262468, 0.948355999, 0.948449372, 0.948542588, 0.948635648, 0.948728551, 0.948821299, 0.94891389, 0.949006326, 0.949098606, 0.949190731, 0.949282702, 0.949374517, 0.949466178, 0.949557685, 0.949649037, 0.949740236, 0.949831281, 0.949922173, 0.950012912, 0.950103498, 0.950193931, 0.950284212, 0.95037434, 0.950464317, 0.950554142, 0.950643815, 0.950733337, 0.950822708, 0.950911928, 0.951000997, 0.951089916, 0.951178685, 0.951267304, 0.951355773, 0.951444093, 0.951532263, 0.951620285, 0.951708157, 0.951795881, 0.951883456, 0.951970884, 0.952058163, 0.952145294, 0.952232279, 0.952319115, 0.952405805, 0.952492348, 0.952578744, 0.952664994, 0.952751097, 0.952837055, 0.952922867, 0.953008534, 0.953094055, 0.953179431, 0.953264662, 0.953349749, 0.953434691, 0.953519489, 0.953604143, 0.953688653, 0.95377302, 0.953857243, 0.953941324, 0.954025261, 0.954109055, 0.954192708, 0.954276218, 0.954359585, 0.954442811, 0.954525896, 0.954608839, 0.954691641, 0.954774302, 0.954856822, 0.954939201, 0.95502144, 0.95510354, 0.955185498, 0.955267318, 0.955348998, 0.955430539, 0.95551194, 0.955593203, 0.955674328, 0.955755313, 0.955836161, 0.955916871, 0.955997443, 0.956077877, 0.956158174, 0.956238334, 0.956318356, 0.956398242, 0.956477992, 0.956557605, 0.956637082, 0.956716424, 0.956795629, 0.956874699, 0.956953634, 0.957032433, 0.957111098, 0.957189628, 0.957268024, 0.957346285, 0.957424413, 0.957502406, 0.957580266, 0.957657992, 0.957735586, 0.957813046, 0.957890373, 0.957967568, 0.95804463, 0.958121561, 0.958198359, 0.958275025, 0.95835156, 0.958427963, 0.958504235, 0.958580377, 0.958656387, 0.958732267, 0.958808016, 0.958883636, 0.958959125, 0.959034485, 0.959109715, 0.959184815, 0.959259786, 0.959334629, 0.959409342, 0.959483928, 0.959558384, 0.959632713, 0.959706913, 0.959780986, 0.959854931, 0.959928749, 0.960002439, 0.960076002, 0.960149439, 0.960222749, 0.960295933, 0.96036899, 0.960441922, 0.960514727, 0.960587407, 0.960659962, 0.960732391, 0.960804696, 0.960876875, 0.96094893, 0.96102086, 0.961092666, 0.961164348, 0.961235906, 0.961307341, 0.961378652, 0.961449839, 0.961520904, 0.961591846, 0.961662664, 0.961733361, 0.961803935, 0.961874387, 0.961944717, 0.962014925, 0.962085011, 0.962154976, 0.96222482, 0.962294543, 0.962364145, 0.962433626, 0.962502988, 0.962572228, 0.962641349, 0.96271035, 0.962779231, 0.962847993, 0.962916635, 0.962985158, 0.963053562, 0.963121848, 0.963190015, 0.963258063, 0.963325994, 0.963393806, 0.963461501, 0.963529077, 0.963596537, 0.963663879, 0.963731104, 0.963798212, 0.963865204, 0.963932078, 0.963998837, 0.964065479, 0.964132006, 0.964198416, 0.964264711, 0.96433089, 0.964396955, 0.964462904, 0.964528738, 0.964594458, 0.964660063, 0.964725554, 0.96479093, 0.964856193, 0.964921341, 0.964986376, 0.965051298, 0.965116107, 0.965180802, 0.965245384, 0.965309854, 0.965374211, 0.965438456, 0.965502588, 0.965566609, 0.965630517, 0.965694314, 0.965758, 0.965821574, 0.965885037, 0.965948389, 0.966011631, 0.966074762, 0.966137782, 0.966200692, 0.966263492, 0.966326182, 0.966388762, 0.966451233, 0.966513594, 0.966575847, 0.96663799, 0.966700024, 0.96676195, 0.966823767, 0.966885476, 0.966947076, 0.967008569, 0.967069954, 0.967131231, 0.967192401, 0.967253463, 0.967314418, 0.967375266, 0.967436008, 0.967496643, 0.967557171, 0.967617593, 0.967677909, 0.96773812, 0.967798224, 0.967858223, 0.967918116, 0.967977904, 0.968037587, 0.968097165, 0.968156638, 0.968216007, 0.968275271, 0.968334431, 0.968393487, 0.968452439, 0.968511287, 0.968570031, 0.968628673, 0.968687211, 0.968745646, 0.968803977, 0.968862207, 0.968920333, 0.968978357, 0.969036279, 0.969094099, 0.969151817, 0.969209433, 0.969266948, 0.969324361, 0.969381672, 0.969438883, 0.969495993, 0.969553002, 0.96960991, 0.969666718, 0.969723425, 0.969780033, 0.96983654, 0.969892948, 0.969949256, 0.970005464, 0.970061573, 0.970117583, 0.970173494, 0.970229306, 0.970285019, 0.970340634, 0.970396151, 0.970451569, 0.970506889, 0.970562111, 0.970617236, 0.970672263, 0.970727192, 0.970782025, 0.97083676, 0.970891398, 0.970945939, 0.971000384, 0.971054733, 0.971108985, 0.97116314, 0.9712172, 0.971271164, 0.971325033, 0.971378805, 0.971432483, 0.971486065, 0.971539552, 0.971592944, 0.971646241, 0.971699444, 0.971752552, 0.971805566, 0.971858486, 0.971911312, 0.971964044, 0.972016682, 0.972069227, 0.972121678, 0.972174037, 0.972226302, 0.972278474, 0.972330553, 0.97238254, 0.972434434, 0.972486236, 0.972537946, 0.972589564, 0.97264109, 0.972692524, 0.972743866, 0.972795118, 0.972846278, 0.972897346, 0.972948324, 0.972999211, 0.973050007, 0.973100713, 0.973151329, 0.973201854, 0.973252289, 0.973302634, 0.973352889, 0.973403055, 0.973453131, 0.973503118, 0.973553016, 0.973602824, 0.973652544, 0.973702175, 0.973751718, 0.973801171, 0.973850537, 0.973899814, 0.973949004, 0.973998105, 0.974047119, 0.974096045, 0.974144884, 0.974193635, 0.974242299, 0.974290877, 0.974339367, 0.97438777, 0.974436087, 0.974484318, 0.974532462, 0.97458052, 0.974628492, 0.974676378, 0.974724179, 0.974771894, 0.974819523, 0.974867067, 0.974914526, 0.974961899, 0.975009188, 0.975056393, 0.975103512, 0.975150547, 0.975197498, 0.975244365, 0.975291147, 0.975337846, 0.97538446, 0.975430992, 0.975477439, 0.975523804, 0.975570085, 0.975616283, 0.975662398, 0.97570843, 0.97575438, 0.975800247, 0.975846031, 0.975891734, 0.975937354, 0.975982892, 0.976028349, 0.976073723, 0.976119017, 0.976164228, 0.976209359, 0.976254408, 0.976299376, 0.976344263, 0.97638907, 0.976433795, 0.976478441, 0.976523006, 0.976567491, 0.976611895, 0.97665622, 0.976700465, 0.97674463, 0.976788716, 0.976832722, 0.976876649, 0.976920496, 0.976964265, 0.977007955, 0.977051566, 0.977095098, 0.977138552, 0.977181927, 0.977225224, 0.977268443, 0.977311585, 0.977354648, 0.977397633, 0.977440541, 0.977483372, 0.977526125, 0.977568801, 0.977611399, 0.977653921, 0.977696366, 0.977738735, 0.977781026, 0.977823242, 0.977865381, 0.977907444, 0.97794943, 0.977991341, 0.978033176, 0.978074936, 0.97811662, 0.978158228, 0.978199761, 0.978241219, 0.978282602, 0.97832391, 0.978365144, 0.978406302, 0.978447386, 0.978488396, 0.978529332, 0.978570193, 0.97861098, 0.978651693, 0.978692333, 0.978732899, 0.978773391, 0.97881381, 0.978854155, 0.978894428, 0.978934627, 0.978974754, 0.979014807, 0.979054788, 0.979094697, 0.979134533, 0.979174296, 0.979213988, 0.979253608, 0.979293155, 0.979332631, 0.979372035, 0.979411367, 0.979450628, 0.979489818, 0.979528936, 0.979567984, 0.97960696, 0.979645865, 0.9796847, 0.979723464, 0.979762158, 0.979800781, 0.979839334, 0.979877817, 0.97991623, 0.979954573, 0.979992846, 0.98003105, 0.980069184, 0.980107248, 0.980145243, 0.980183169, 0.980221026, 0.980258814, 0.980296534, 0.980334184, 0.980371766, 0.980409279, 0.980446724, 0.980484101, 0.980521409, 0.98055865, 0.980595822, 0.980632927, 0.980669964, 0.980706934, 0.980743836, 0.980780671, 0.980817438, 0.980854139, 0.980890772, 0.980927339, 0.980963839, 0.981000272, 0.981036638, 0.981072939, 0.981109172, 0.98114534, 0.981181442, 0.981217477, 0.981253447, 0.981289351, 0.981325189, 0.981360962, 0.98139667, 0.981432312, 0.981467889, 0.981503401, 0.981538847, 0.981574229, 0.981609547, 0.981644799, 0.981679987, 0.981715111, 0.981750171, 0.981785166, 0.981820097, 0.981854964, 0.981889767, 0.981924507, 0.981959183, 0.981993795, 0.982028344, 0.98206283, 0.982097252, 0.982131611, 0.982165907, 0.982200141, 0.982234311, 0.982268419, 0.982302465, 0.982336448, 0.982370368, 0.982404226, 0.982438023, 0.982471757, 0.982505429, 0.982539039, 0.982572588, 0.982606075, 0.982639501, 0.982672865, 0.982706168, 0.982739409, 0.98277259, 0.98280571, 0.982838768, 0.982871766, 0.982904704, 0.982937581, 0.982970397, 0.983003153, 0.983035849, 0.983068484, 0.98310106, 0.983133576, 0.983166031, 0.983198428, 0.983230764, 0.983263041, 0.983295258, 0.983327417, 0.983359516, 0.983391556, 0.983423536, 0.983455458, 0.983487322, 0.983519126, 0.983550872, 0.983582559, 0.983614188, 0.983645759, 0.983677271, 0.983708726, 0.983740122, 0.98377146, 0.983802741, 0.983833964, 0.983865129, 0.983896237, 0.983927288, 0.983958281, 0.983989217, 0.984020096, 0.984050918, 0.984081683, 0.984112391, 0.984143042, 0.984173637, 0.984204175, 0.984234657, 0.984265083, 0.984295452, 0.984325766, 0.984356023, 0.984386224, 0.98441637, 0.984446459, 0.984476493, 0.984506472, 0.984536395, 0.984566263, 0.984596075, 0.984625833, 0.984655535, 0.984685183, 0.984714775, 0.984744313, 0.984773796, 0.984803224, 0.984832598, 0.984861918, 0.984891183, 0.984920394, 0.984949551, 0.984978654, 0.985007703, 0.985036698, 0.98506564, 0.985094528, 0.985123362, 0.985152143, 0.98518087, 0.985209545, 0.985238166, 0.985266734, 0.985295249, 0.985323711, 0.98535212, 0.985380477, 0.98540878, 0.985437032, 0.985465231, 0.985493378, 0.985521472, 0.985549514, 0.985577504, 0.985605442, 0.985633329, 0.985661163, 0.985688946, 0.985716677, 0.985744357, 0.985771985, 0.985799562, 0.985827087, 0.985854562, 0.985881985, 0.985909358, 0.985936679, 0.98596395, 0.98599117, 0.986018339, 0.986045458, 0.986072526, 0.986099544, 0.986126511, 0.986153429, 0.986180296, 0.986207114, 0.986233881, 0.986260599, 0.986287266, 0.986313884, 0.986340453, 0.986366972, 0.986393442, 0.986419862, 0.986446233, 0.986472555, 0.986498828, 0.986525052, 0.986551227, 0.986577353, 0.986603431, 0.98662946, 0.98665544, 0.986681372, 0.986707256, 0.986733091, 0.986758878, 0.986784617, 0.986810308, 0.986835951, 0.986861546, 0.986887093, 0.986912593, 0.986938045, 0.986963449, 0.986988806, 0.987014116, 0.987039378, 0.987064594, 0.987089762, 0.987114883, 0.987139957, 0.987164984, 0.987189965, 0.987214898, 0.987239786, 0.987264626, 0.98728942, 0.987314168, 0.98733887, 0.987363525, 0.987388134, 0.987412697, 0.987437214, 0.987461686, 0.987486111, 0.987510491, 0.987534825, 0.987559114, 0.987583357, 0.987607555, 0.987631707, 0.987655814, 0.987679876, 0.987703893, 0.987727865, 0.987751792, 0.987775674, 0.987799512, 0.987823305, 0.987847053, 0.987870756, 0.987894416, 0.98791803, 0.987941601, 0.987965127, 0.98798861, 0.988012048, 0.988035442, 0.988058792, 0.988082099, 0.988105362, 0.988128581, 0.988151756, 0.988174888, 0.988197977, 0.988221022, 0.988244024, 0.988266983, 0.988289899, 0.988312771, 0.988335601, 0.988358388, 0.988381132, 0.988403833, 0.988426491, 0.988449107, 0.988471681, 0.988494212, 0.9885167, 0.988539147, 0.988561551, 0.988583913, 0.988606233, 0.988628511, 0.988650747, 0.988672941, 0.988695094, 0.988717205, 0.988739274, 0.988761301, 0.988783288, 0.988805233, 0.988827136, 0.988848998, 0.988870819, 0.988892599, 0.988914338, 0.988936036, 0.988957693, 0.98897931, 0.989000885, 0.98902242, 0.989043915, 0.989065369, 0.989086782, 0.989108155, 0.989129488, 0.98915078, 0.989172033, 0.989193245, 0.989214417, 0.98923555, 0.989256642, 0.989277695, 0.989298708, 0.989319681, 0.989340615, 0.989361509, 0.989382364, 0.98940318, 0.989423956, 0.989444693, 0.98946539, 0.989486049, 0.989506669, 0.989527249, 0.989547791, 0.989568294, 0.989588758, 0.989609184, 0.989629571, 0.98964992, 0.98967023, 0.989690501, 0.989710734, 0.989730929, 0.989751086, 0.989771205, 0.989791286, 0.989811328, 0.989831333, 0.9898513, 0.989871229, 0.989891121, 0.989910975, 0.989930791, 0.98995057, 0.989970311, 0.989990015, 0.990009681, 0.990029311, 0.990048903, 0.990068458, 0.990087976, 0.990107457, 0.990126901, 0.990146309, 0.990165679, 0.990185013, 0.990204311, 0.990223571, 0.990242795, 0.990261983, 0.990281134, 0.990300249, 0.990319328, 0.990338371, 0.990357377, 0.990376348, 0.990395282, 0.990414181, 0.990433043, 0.99045187, 0.990470662, 0.990489417, 0.990508137, 0.990526821, 0.99054547, 0.990564084, 0.990582662, 0.990601205, 0.990619712, 0.990638185, 0.990656622, 0.990675025, 0.990693392, 0.990711725, 0.990730022, 0.990748285, 0.990766513, 0.990784707, 0.990802866, 0.990820991, 0.990839081, 0.990857136, 0.990875157, 0.990893144, 0.990911097, 0.990929016, 0.990946901, 0.990964751, 0.990982568, 0.99100035, 0.991018099, 0.991035814, 0.991053496, 0.991071143, 0.991088757, 0.991106338, 0.991123885, 0.991141399, 0.991158879, 0.991176326, 0.99119374, 0.99121112, 0.991228468, 0.991245782, 0.991263064, 0.991280312, 0.991297528, 0.991314711, 0.991331861, 0.991348978, 0.991366063, 0.991383115, 0.991400135, 0.991417122, 0.991434077, 0.991451, 0.99146789, 0.991484748, 0.991501574, 0.991518367, 0.991535129, 0.991551859, 0.991568557, 0.991585222, 0.991601856, 0.991618459, 0.991635029, 0.991651568, 0.991668076, 0.991684552, 0.991700996, 0.991717409, 0.991733791, 0.991750141, 0.99176646, 0.991782748, 0.991799005, 0.991815231, 0.991831425, 0.991847589, 0.991863722, 0.991879824, 0.991895895, 0.991911936, 0.991927945, 0.991943925, 0.991959873, 0.991975791, 0.991991679, 0.992007536, 0.992023363, 0.99203916, 0.992054926, 0.992070662, 0.992086369, 0.992102045, 0.992117691, 0.992133307, 0.992148893, 0.992164449, 0.992179976, 0.992195473, 0.99221094, 0.992226377, 0.992241785, 0.992257164, 0.992272512, 0.992287832, 0.992303122, 0.992318383, 0.992333615, 0.992348817, 0.99236399, 0.992379134, 0.99239425, 0.992409336, 0.992424393, 0.992439421, 0.992454421, 0.992469392, 0.992484334, 0.992499247, 0.992514132, 0.992528988, 0.992543815, 0.992558615, 0.992573385, 0.992588128, 0.992602842, 0.992617528, 0.992632186, 0.992646815, 0.992661417, 0.99267599, 0.992690535, 0.992705053, 0.992719542, 0.992734004, 0.992748438, 0.992762844, 0.992777223, 0.992791574, 0.992805897, 0.992820193, 0.992834461, 0.992848702, 0.992862915, 0.992877102, 0.99289126, 0.992905392, 0.992919496, 0.992933574, 0.992947624, 0.992961647, 0.992975643, 0.992989613, 0.993003555, 0.993017471, 0.993031359, 0.993045222, 0.993059057, 0.993072866, 0.993086648, 0.993100403, 0.993114132, 0.993127835, 0.993141511, 0.993155161, 0.993168785, 0.993182382, 0.993195954, 0.993209499, 0.993223018, 0.99323651, 0.993249977, 0.993263418, 0.993276833, 0.993290222, 0.993303586, 0.993316923, 0.993330235, 0.993343521, 0.993356782, 0.993370017, 0.993383226, 0.99339641, 0.993409569, 0.993422702, 0.99343581, 0.993448892, 0.993461949, 0.993474981, 0.993487988, 0.99350097, 0.993513927, 0.993526859, 0.993539765, 0.993552647, 0.993565504, 0.993578336, 0.993591143, 0.993603926, 0.993616684, 0.993629417, 0.993642126, 0.99365481, 0.993667469, 0.993680104, 0.993692715, 0.993705301, 0.993717863, 0.993730401, 0.993742914, 0.993755404, 0.993767869, 0.99378031, 0.993792727, 0.99380512, 0.993817488, 0.993829833, 0.993842155, 0.993854452, 0.993866725, 0.993878975, 0.993891201, 0.993903403, 0.993915582, 0.993927737, 0.993939869, 0.993951977, 0.993964062, 0.993976123, 0.993988161, 0.994000175, 0.994012167, 0.994024135, 0.99403608, 0.994048002, 0.9940599, 0.994071776, 0.994083628, 0.994095458, 0.994107265, 0.994119049, 0.99413081, 0.994142548, 0.994154263, 0.994165956, 0.994177626, 0.994189273, 0.994200898, 0.9942125, 0.99422408, 0.994235637, 0.994247172, 0.994258685, 0.994270175, 0.994281643, 0.994293088, 0.994304512, 0.994315913, 0.994327292, 0.994338649, 0.994349984, 0.994361297, 0.994372588, 0.994383857, 0.994395104, 0.994406329, 0.994417533, 0.994428715, 0.994439875, 0.994451013, 0.99446213, 0.994473225, 0.994484298, 0.99449535, 0.994506381, 0.99451739, 0.994528377, 0.994539344, 0.994550289, 0.994561212, 0.994572115, 0.994582996, 0.994593856, 0.994604695, 0.994615513, 0.99462631, 0.994637086, 0.994647841, 0.994658575, 0.994669288, 0.99467998, 0.994690651, 0.994701302, 0.994711932, 0.994722541, 0.99473313, 0.994743698, 0.994754245, 0.994764772, 0.994775278, 0.994785764, 0.99479623, 0.994806675, 0.994817099, 0.994827504, 0.994837888, 0.994848252, 0.994858595, 0.994868919, 0.994879222, 0.994889506, 0.994899769, 0.994910012, 0.994920236, 0.994930439, 0.994940622, 0.994950786, 0.99496093, 0.994971054, 0.994981158, 0.994991243, 0.995001308, 0.995011353, 0.995021379, 0.995031385, 0.995041371, 0.995051338, 0.995061286, 0.995071214, 0.995081123, 0.995091013, 0.995100883, 0.995110734, 0.995120565, 0.995130378, 0.995140171, 0.995149945, 0.9951597, 0.995169436, 0.995179153, 0.995188852, 0.995198531, 0.995208191, 0.995217832, 0.995227455, 0.995237058, 0.995246643, 0.995256209, 0.995265757, 0.995275286, 0.995284796, 0.995294287, 0.99530376, 0.995313215, 0.995322651, 0.995332068, 0.995341467, 0.995350848, 0.995360211, 0.995369555, 0.99537888, 0.995388188, 0.995397477, 0.995406748, 0.995416002, 0.995425236, 0.995434453, 0.995443652, 0.995452833, 0.995461996, 0.99547114, 0.995480267, 0.995489376, 0.995498468, 0.995507541, 0.995516597, 0.995525635, 0.995534655, 0.995543657, 0.995552642, 0.99556161, 0.995570559, 0.995579491, 0.995588406, 0.995597303, 0.995606183, 0.995615045, 0.99562389, 0.995632718, 0.995641528, 0.995650322, 0.995659097, 0.995667856, 0.995676597, 0.995685322, 0.995694029, 0.995702719, 0.995711392, 0.995720048, 0.995728687, 0.995737309, 0.995745914, 0.995754502, 0.995763074, 0.995771628, 0.995780166, 0.995788687, 0.995797192, 0.995805679, 0.99581415, 0.995822604, 0.995831042, 0.995839463, 0.995847868, 0.995856256, 0.995864628, 0.995872983, 0.995881321, 0.995889644, 0.99589795, 0.99590624, 0.995914513, 0.99592277, 0.995931011, 0.995939236, 0.995947444, 0.995955637, 0.995963813, 0.995971973, 0.995980117, 0.995988245, 0.995996357, 0.996004454, 0.996012534, 0.996020598, 0.996028647, 0.99603668, 0.996044696, 0.996052698, 0.996060683, 0.996068653, 0.996076606, 0.996084545, 0.996092467, 0.996100375, 0.996108266, 0.996116142, 0.996124002, 0.996131847, 0.996139677, 0.996147491, 0.99615529, 0.996163073, 0.996170841, 0.996178594, 0.996186331, 0.996194054, 0.996201761, 0.996209453, 0.996217129, 0.996224791, 0.996232437, 0.996240068, 0.996247685, 0.996255286, 0.996262872, 0.996270444, 0.996278, 0.996285542, 0.996293068, 0.99630058, 0.996308077, 0.996315559, 0.996323027, 0.99633048, 0.996337918, 0.996345341, 0.99635275, 0.996360144, 0.996367523, 0.996374888, 0.996382238, 0.996389574, 0.996396896, 0.996404203, 0.996411495, 0.996418773, 0.996426037, 0.996433286, 0.996440522, 0.996447742, 0.996454949, 0.996462141, 0.996469319, 0.996476483, 0.996483633, 0.996490769, 0.99649789, 0.996504998, 0.996512091, 0.99651917, 0.996526236, 0.996533287, 0.996540325, 0.996547348, 0.996554358, 0.996561354, 0.996568336, 0.996575304, 0.996582259, 0.996589199, 0.996596126, 0.996603039, 0.996609939, 0.996616825, 0.996623697, 0.996630556, 0.996637401, 0.996644233, 0.996651051, 0.996657855, 0.996664647, 0.996671424, 0.996678188, 0.996684939, 0.996691677, 0.996698401, 0.996705112, 0.996711809, 0.996718494, 0.996725165, 0.996731823, 0.996738467, 0.996745099, 0.996751717, 0.996758322, 0.996764915, 0.996771494, 0.99677806, 0.996784613, 0.996791153, 0.99679768, 0.996804194, 0.996810696, 0.996817184, 0.996823659, 0.996830122, 0.996836572, 0.996843009, 0.996849433, 0.996855845, 0.996862244, 0.99686863, 0.996875004, 0.996881364, 0.996887713, 0.996894048, 0.996900371, 0.996906682, 0.99691298, 0.996919266, 0.996925539, 0.996931799, 0.996938047, 0.996944283, 0.996950507, 0.996956718, 0.996962916, 0.996969103, 0.996975277, 0.996981439, 0.996987588, 0.996993726, 0.996999851, 0.997005964, 0.997012065, 0.997018154, 0.99702423, 0.997030295, 0.997036348, 0.997042388, 0.997048417, 0.997054433, 0.997060438, 0.997066431, 0.997072411, 0.99707838, 0.997084337, 0.997090283, 0.997096216, 0.997102137, 0.997108047, 0.997113945, 0.997119832, 0.997125706, 0.997131569, 0.99713742, 0.99714326, 0.997149088, 0.997154904, 0.997160709, 0.997166503, 0.997172284, 0.997178055, 0.997183813, 0.997189561, 0.997195296, 0.997201021, 0.997206734, 0.997212436, 0.997218126, 0.997223805, 0.997229473, 0.997235129, 0.997240774, 0.997246408, 0.997252031, 0.997257642, 0.997263243, 0.997268832, 0.99727441, 0.997279977, 0.997285533};
        double x = 0.0;
        int i = 0;
        while (x <= 1.0) {
            double calcPDF = this.var3.pdf(x);
            double calcCDF = this.var3.cdf(x);
            SparseContProbTest.assertEquals((String)"Probability Density Function non equal", (double)realPDF[i], (double)calcPDF, (double)1.0E-5);
            SparseContProbTest.assertEquals((String)"Cumulative Probability Function  non equal", (double)realCDF[i], (double)calcCDF, (double)1.0E-5);
            x += 0.25;
            ++i;
        }
        SparseContProbTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix3).add(-1.0, this.var3.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContProbTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector3).add(-1.0, this.var3.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }
}

