/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import jphase.SparseContPhaseVar;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class SparseContMomentTest
extends TestCase {
    SparseContPhaseVar var;
    double[][] matrix = new double[][]{{-6.0, 2.0, 1.0, 2.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, -5.0, 1.0, 0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 1.0, -7.0, 0.0, 0.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 0.0, 0.0, -9.0, 2.0, 1.0, 0.0, 1.0, 3.0, 0.0, 0.0}, {0.0, 2.0, 0.0, 1.0, -8.0, 1.0, 0.0, 1.0, 0.0, 3.0, 0.0}, {0.0, 0.0, 2.0, 2.0, 1.0, -10.0, 0.0, 2.0, 0.0, 0.0, 3.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 2.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -5.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -4.0, 2.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, -3.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 1.0, -5.0}};
    double[] vector = new double[]{0.02, 0.04, 0.04, 0.04, 0.08, 0.08, 0.1, 0.2, 0.04, 0.08, 0.08};

    public static void main(String[] args) {
        TestRunner.run(SparseContMomentTest.class);
    }

    protected void setUp() throws Exception {
        this.var = new SparseContPhaseVar(this.vector, this.matrix);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testExpectedValue() {
        double calcEV = this.var.expectedValue();
        double realEV = 0.786212;
        SparseContMomentTest.assertEquals((String)"Expected Value non equal", (double)realEV, (double)calcEV, (double)1.0E-5);
        SparseContMomentTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix).add(-1.0, this.var.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContMomentTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector).add(-1.0, this.var.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testVariance() {
        double calcVar = this.var.variance();
        double realVar = 0.908712;
        SparseContMomentTest.assertEquals((String)"Variance non equal", (double)realVar, (double)calcVar, (double)1.0E-5);
        SparseContMomentTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix).add(-1.0, this.var.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContMomentTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector).add(-1.0, this.var.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testCV() {
        double calcCV = this.var.CV();
        double realCV = 1.470101;
        SparseContMomentTest.assertEquals((String)"Coefficient of Variance non equal", (double)realCV, (double)calcCV, (double)1.0E-5);
        SparseContMomentTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix).add(-1.0, this.var.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContMomentTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector).add(-1.0, this.var.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testMoment2() {
        double calcM2 = this.var.moment(2);
        double realM2 = 1.526841;
        SparseContMomentTest.assertEquals((String)"Second Moment non equal", (double)realM2, (double)calcM2, (double)1.0E-5);
        SparseContMomentTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix).add(-1.0, this.var.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContMomentTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector).add(-1.0, this.var.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testMoment3() {
        double calcM3 = this.var.moment(3);
        double realM3 = 4.382719;
        SparseContMomentTest.assertEquals((String)"Third Moment non equal", (double)realM3, (double)calcM3, (double)1.0E-5);
        SparseContMomentTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix).add(-1.0, this.var.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContMomentTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector).add(-1.0, this.var.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testMoment4() {
        double calcM4 = this.var.moment(4);
        double realM4 = 16.677425;
        SparseContMomentTest.assertEquals((String)"Fourth Moment non equal", (double)realM4, (double)calcM4, (double)1.0E-5);
        SparseContMomentTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix).add(-1.0, this.var.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContMomentTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector).add(-1.0, this.var.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }
}

