/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jphase.GUI.GeneratorPanel;
import jphase.GeneratorLEcuyer;

class UniformDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public final String ACEPTAR = "Acept";
    public final String CANCELAR = "Cancel";
    public GeneratorPanel panel;
    public GeneratorLEcuyer gen;
    public ButtonGroup grupo;
    public JButton aceptarB;
    public JButton cancelarB;
    public ArrayList<JRadioButton> botones;
    public ArrayList<JButton> info;
    public ArrayList<String> uniformes;

    public UniformDialog(GeneratorLEcuyer genle, GeneratorPanel pan) {
        this.panel = pan;
        this.gen = genle;
        this.aceptarB = new JButton("Acept");
        this.aceptarB.setActionCommand("Acept");
        this.aceptarB.addActionListener(this);
        this.cancelarB = new JButton("Cancel");
        this.cancelarB.setActionCommand("Cancel");
        this.cancelarB.addActionListener(this);
        this.uniformes = this.gen.darGeneradoresUniformes();
        this.botones = new ArrayList();
        this.grupo = new ButtonGroup();
        this.setSize(200, this.uniformes.size() * 30 + 20);
        this.setResizable(false);
        JPanel izq = new JPanel();
        izq.setLayout(new GridLayout(this.uniformes.size() + 1, 1));
        JPanel der = new JPanel();
        der.setLayout(new GridLayout(this.uniformes.size() + 1, 1));
        int i = 0;
        while (i != this.uniformes.size()) {
            String nom = this.uniformes.get(i);
            JRadioButton boton = new JRadioButton(nom);
            this.grupo.add(boton);
            this.botones.add(boton);
            izq.add(boton);
            boton.setSelected(false);
            if (i == 0) {
                boton.setSelected(true);
            }
            JButton bot = new JButton("i");
            bot.setActionCommand(nom);
            bot.addActionListener(this);
            der.add(bot);
            ++i;
        }
        JPanel sur = new JPanel();
        sur.add(this.cancelarB);
        sur.add(this.aceptarB);
        this.setLayout(new BorderLayout());
        this.add((Component)sur, "South");
        this.add((Component)izq, "West");
        this.add((Component)der, "East");
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setTitle("Uniform variable generators");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String evento = e.getActionCommand();
        if (evento.equals("Acept")) {
            int j = 0;
            int i = 0;
            while (i != this.botones.size()) {
                if (this.botones.get(i).isSelected()) {
                    j = i;
                    break;
                }
                ++i;
            }
            this.panel.setAlgoUni(this.uniformes.get(j));
            this.dispose();
        } else if (evento.equals("Cancel")) {
            this.dispose();
        } else {
            this.darInfo(evento);
        }
    }

    public void darInfo(String evento) {
        String info = this.panel.darInfoUnif(evento);
        JOptionPane.showMessageDialog(this, info, String.valueOf(evento) + " info", 1);
    }

    @Override
    public void dispose() {
        this.panel.setEnable(true);
        this.panel.reEnable();
        super.dispose();
    }
}

