/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jphase.FittingLEcuyer;
import jphase.GUI.AceptPanel;
import jphase.GUI.FitResultDialog;
import jphase.GUI.GOFPanel;
import jphase.GUI.GeneratorPanel;
import jphase.GeneratorLEcuyer;
import jphase.values.FitResult;
import jphase.values.GenerationResult;

public class GenerateVarFrame
extends JFrame {
    private static final long serialVersionUID = 6181837692334903139L;
    public GeneratorPanel panelGenerador;
    public AceptPanel panelAceptar;
    public GOFPanel panelFOG;
    public GeneratorLEcuyer generador;
    public FittingLEcuyer fitting;
    public JTabbedPane tabble = new JTabbedPane();

    public GenerateVarFrame() {
        this.generador = new GeneratorLEcuyer();
        this.fitting = new FittingLEcuyer();
        this.setTitle("Goodness of Fit test and R.V. Generator");
        this.setSize(new Dimension(500, 255));
        this.setResizable(true);
        this.panelGenerador = new GeneratorPanel(this, this.generador);
        this.panelFOG = new GOFPanel(this, this.fitting);
        this.panelAceptar = new AceptPanel(this);
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        pan.add((Component)this.panelGenerador, "North");
        pan.add((Component)this.panelAceptar, "South");
        this.tabble.addTab("Generator", pan);
        this.tabble.addTab("Goodness Of Fit", this.panelFOG);
        this.add(this.tabble);
        this.setLocationRelativeTo(this.panelAceptar.aceptarB);
    }

    public static void main(String[] args) {
        GenerateVarFrame i = new GenerateVarFrame();
        i.setVisible(true);
    }

    public int darNumeroIteraciones() {
        int n = 0;
        try {
            n = Integer.parseInt(this.panelGenerador.darNumero());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public void generar(int n) {
        String ubicacion = this.panelGenerador.darUbicacion();
        if (ubicacion != null) {
            this.generador.setN(n);
            this.generador.setUbicacion(ubicacion);
            this.generador.setNombre(this.panelGenerador.darNombre());
            try {
                FitResult result = this.generador.generar();
                GenerationResult gen = this.generador.darInfo();
                if (result != null) {
                    FitResultDialog dia = new FitResultDialog(result);
                    dia.setVisible(true);
                    JOptionPane.showMessageDialog(this, gen.toString(), "Done", 1);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(this, "Please select a location for the data", "Error", 0);
            this.panelGenerador.cambiarUbicacion();
        }
    }

    public void generateMoments() {
        String ubicacion = this.panelGenerador.darUbicacion();
        System.out.println(ubicacion);
        if (ubicacion != null) {
            this.generador.setUbicacion(ubicacion);
            try {
                double[] dob = this.generador.generateMoments();
                JOptionPane.showMessageDialog(this, "Moments:\n\tMoment 1: " + Math.rint(dob[0] * 1000.0) / 1000.0 + "\n\tMoment 2: " + Math.rint(dob[1] * 1000.0) / 1000.0 + "\n\tMoment 3: " + Math.rint(dob[2] * 1000.0) / 1000.0, "Done", 1);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

