/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import jphase.AbstractDiscPhaseVar;
import jphase.DiscPhaseVar;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class DenseDiscPhaseVar
extends AbstractDiscPhaseVar
implements DiscPhaseVar {
    protected DenseMatrix A;
    protected DenseVector alpha;

    public DenseDiscPhaseVar() {
        this.A = new DenseMatrix((double[][])new double[][]{{0.0}});
        this.alpha = new DenseVector(new double[]{0.0});
    }

    public DenseDiscPhaseVar(int n) {
        this.A = new DenseMatrix(n, n);
        this.alpha = new DenseVector(n);
    }

    public DenseDiscPhaseVar(DenseVector alpha, DenseMatrix A) {
        this.A = A;
        this.alpha = alpha;
    }

    public DenseDiscPhaseVar(Vector alpha, Matrix A) {
        this.A = (DenseMatrix)A.copy();
        this.alpha = (DenseVector)alpha.copy();
    }

    public DenseDiscPhaseVar(double[] alpha, double[][] A) {
        int n1 = alpha.length;
        int n2 = A.length;
        if (n1 != n2) {
            throw new IndexOutOfBoundsException("Vector and matrix not of the same size");
        }
        DenseMatrix Am = new DenseMatrix(A);
        DenseVector Vm = new DenseVector(alpha);
        this.A = Am;
        this.alpha = Vm;
    }

    public static DenseDiscPhaseVar Geom(double p) {
        double[][] matriz = new double[1][1];
        matriz[0][0] = 1.0 - p;
        DenseMatrix A = new DenseMatrix(matriz);
        double[] vector = new double[]{1.0};
        DenseVector alpha = new DenseVector(vector);
        return new DenseDiscPhaseVar(alpha, A);
    }

    public static DenseDiscPhaseVar NegativeBinomial(double p, int r) {
        double[][] matriz = new double[r][r];
        int i = 0;
        while (i < r) {
            matriz[i][i] = 1.0 - p;
            if (i < r - 1) {
                matriz[i][i + 1] = p;
            }
            ++i;
        }
        DenseMatrix A = new DenseMatrix(matriz);
        double[] vector = new double[r];
        vector[0] = 1.0;
        DenseVector alpha = new DenseVector(vector);
        return new DenseDiscPhaseVar(alpha, A);
    }

    @Override
    public Matrix getMatrix() {
        return this.A;
    }

    @Override
    public Vector getVector() {
        return this.alpha;
    }

    @Override
    public void setMatrix(Matrix A) {
        this.A = (DenseMatrix)A;
    }

    @Override
    public void setVector(Vector alpha) {
        this.alpha = (DenseVector)alpha;
    }

    @Override
    public DiscPhaseVar copy() {
        return new DenseDiscPhaseVar(this.getVector(), this.getMatrix());
    }

    @Override
    public DiscPhaseVar newVar(int n) {
        return new DenseDiscPhaseVar(n);
    }
}

