/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import jphase.AbstractContPhaseVar;
import jphase.ContPhaseVar;
import jphase.HyperErlangVar;
import jphase.HypoExponentialVar;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class DenseContPhaseVar
extends AbstractContPhaseVar {
    protected DenseMatrix A;
    protected DenseVector alpha;

    public DenseContPhaseVar() {
        this.A = new DenseMatrix((double[][])new double[][]{{-1.0}});
        this.alpha = new DenseVector(new double[]{0.0});
    }

    public DenseContPhaseVar(int n) {
        this.A = new DenseMatrix(n, n);
        this.alpha = new DenseVector(n);
    }

    public DenseContPhaseVar(DenseVector alpha, DenseMatrix A) {
        this.A = A;
        this.alpha = alpha;
    }

    public DenseContPhaseVar(Vector alpha, Matrix A) {
        this.A = (DenseMatrix)A.copy();
        this.alpha = (DenseVector)alpha.copy();
    }

    public DenseContPhaseVar(double[] alpha, double[][] A) {
        int n1 = alpha.length;
        int n2 = A.length;
        if (n1 != n2) {
            throw new IndexOutOfBoundsException("Vector and matrix not of the same size");
        }
        DenseMatrix Am = new DenseMatrix(A);
        DenseVector Vm = new DenseVector(alpha);
        this.A = Am;
        this.alpha = Vm;
    }

    public static DenseContPhaseVar expo(double lambda) {
        double[][] matriz = new double[1][1];
        matriz[0][0] = -lambda;
        DenseMatrix A = new DenseMatrix(matriz);
        double[] vector = new double[]{1.0};
        DenseVector alpha = new DenseVector(vector);
        return new DenseContPhaseVar(alpha, A);
    }

    public static DenseContPhaseVar Erlang(double lambda, int n) {
        double[][] matriz = new double[n][n];
        int i = 0;
        while (i < n) {
            matriz[i][i] = -lambda;
            if (i < n - 1) {
                matriz[i][i + 1] = lambda;
            }
            ++i;
        }
        DenseMatrix A = new DenseMatrix(matriz);
        double[] vector = new double[n];
        vector[0] = 1.0;
        DenseVector alpha = new DenseVector(vector);
        return new DenseContPhaseVar(alpha, A);
    }

    public static DenseContPhaseVar HipoExponential(double[] lambdas) {
        HypoExponentialVar var = new HypoExponentialVar(lambdas);
        Matrix A = var.getMatrix();
        Vector alpha = var.getVector();
        return new DenseContPhaseVar(alpha, A);
    }

    public static DenseContPhaseVar HyperExpo(double[] lambdas, double[] probs) {
        if (lambdas.length == probs.length) {
            int n = lambdas.length;
            double[][] matrix = new double[n][n];
            double[] vector = new double[n];
            int i = 0;
            while (i < n) {
                matrix[i][i] = -lambdas[i];
                vector[i] = probs[i];
                ++i;
            }
            DenseMatrix A = new DenseMatrix(matrix);
            DenseVector alpha = new DenseVector(vector);
            return new DenseContPhaseVar(alpha, A);
        }
        throw new RuntimeException("Rates and probability vectors have different length");
    }

    public static DenseContPhaseVar HyperErlang(int k, double[] lambdas, int[] n, double[] probs) {
        int r = 0;
        int l = 0;
        int N = 0;
        int i = 0;
        while (i < k) {
            N += n[i];
            ++i;
        }
        double[][] matriz = new double[N][N];
        double[] vector = new double[N];
        int i2 = 0;
        while (i2 < k) {
            vector[l] = probs[i2];
            int j = 0;
            while (j < n[i2]) {
                matriz[l][l] = -lambdas[i2];
                if (l < N - 1 && j < n[i2] - 1) {
                    matriz[l][l + 1] = lambdas[i2];
                }
                ++l;
                ++j;
            }
            r += n[i2];
            ++i2;
        }
        DenseMatrix A = new DenseMatrix(matriz);
        DenseVector alpha = new DenseVector(vector);
        return new DenseContPhaseVar(alpha, A);
    }

    public static DenseContPhaseVar HyperErlang(HyperErlangVar var) {
        DenseMatrix A = new DenseMatrix(var.getMatrix());
        DenseVector alpha = new DenseVector(var.getVector());
        return new DenseContPhaseVar(alpha, A);
    }

    public static DenseContPhaseVar Coxian(int n, double[] lambdas, double[] probs) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of phases in theCoxian distribution must be greater than zero");
        }
        if (lambdas.length != n) {
            throw new IllegalArgumentException("The number of rates is different from the number of phases");
        }
        if (probs.length != n - 1) {
            throw new IllegalArgumentException("The number of probabilities is different from the number of phases - 1");
        }
        double[][] matriz = new double[n][n];
        double[] vector = new double[n];
        vector[0] = 1.0;
        int i = 0;
        while (i < n) {
            matriz[i][i] = -lambdas[i];
            if (i < n - 1) {
                matriz[i][i + 1] = probs[i] * lambdas[i];
            }
            ++i;
        }
        DenseMatrix A = new DenseMatrix(matriz);
        DenseVector alpha = new DenseVector(vector);
        return new DenseContPhaseVar(alpha, A);
    }

    public static DenseContPhaseVar ErlangCoxian(int n, double p, double lambdaY, double lambdaX1, double lambdaX2, double px) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of phases in theErlang-Coxian distribution must be greater than zero");
        }
        if (n == 1) {
            return DenseContPhaseVar.expo(lambdaX1);
        }
        if (n == 2) {
            return DenseContPhaseVar.Coxian(n, new double[]{lambdaX1, lambdaX2}, new double[]{px});
        }
        double[][] matriz = new double[n][n];
        int i = 0;
        while (i < n - 2) {
            matriz[i][i] = -lambdaY;
            matriz[i][i + 1] = lambdaY;
            ++i;
        }
        matriz[n - 2][n - 2] = -lambdaX1;
        matriz[n - 2][n - 1] = px * lambdaX1;
        matriz[n - 1][n - 1] = -lambdaX2;
        double[] vector = new double[n];
        vector[0] = p;
        DenseMatrix A = new DenseMatrix(matriz);
        DenseVector alpha = new DenseVector(vector);
        return new DenseContPhaseVar(alpha, A);
    }

    @Override
    public Matrix getMatrix() {
        return this.A;
    }

    @Override
    public Vector getVector() {
        return this.alpha;
    }

    @Override
    public void setMatrix(Matrix A) {
        this.A = (DenseMatrix)A.copy();
    }

    @Override
    public void setVector(Vector alpha) {
        this.alpha = (DenseVector)alpha.copy();
    }

    @Override
    public ContPhaseVar copy() {
        return new DenseContPhaseVar(this.getVector(), this.getMatrix());
    }

    @Override
    public ContPhaseVar newVar(int n) {
        return new DenseContPhaseVar(n);
    }
}

