/*
 * Decompiled with CFR 0.152.
 */
package jmdp;

import examples.jmdp.ControlProdNonEvents;
import examples.jmdp.ControlProduccion;
import examples.jmdp.InvLevel;
import examples.jmdp.Order;
import jmarkov.jmdp.solvers.RelativeValueIterationSolver;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class ControlProduccionTest
extends TestCase {
    ControlProduccion prob2 = null;
    ControlProdNonEvents prob = null;
    private double intRate = 0.9;

    protected void setUp() throws Exception {
        int M = 9;
        double K = 50.0;
        double cost = 400.0;
        double price = 1000.0;
        double holdingCost = 80.0;
        double demandMean = 4.0;
        this.prob2 = new ControlProduccion(M, K, cost, price, holdingCost, this.intRate, demandMean);
        this.prob = new ControlProdNonEvents(M, K, cost, price, holdingCost, this.intRate, demandMean);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.prob = null;
        this.prob2 = null;
    }

    public void testGetOptimalValueFunctionValueIteration() throws Exception {
        RelativeValueIterationSolver<InvLevel, Order> solv = new RelativeValueIterationSolver<InvLevel, Order>(this.prob);
        this.prob.setSolver(solv);
        InvLevel initialState = new InvLevel(0);
        double vf_cero = -2058.0203;
        double vf = this.prob.getOptimalValueFunction().get(initialState);
        ControlProduccionTest.assertEquals((String)"Value Function not equal", (double)vf_cero, (double)vf, (double)0.001);
    }

    public void testGetOptimalNonEventsValueFunctionValueIteration() throws Exception {
        RelativeValueIterationSolver<InvLevel, Order> solv = new RelativeValueIterationSolver<InvLevel, Order>(this.prob2);
        this.prob2.setSolver(solv);
        InvLevel initialState = new InvLevel(0);
        double vf_cero = -2058.0203;
        double vf = this.prob.getOptimalValueFunction().get(initialState);
        ControlProduccionTest.assertEquals((String)"Value Function not equal", (double)vf_cero, (double)vf, (double)0.001);
    }

    public static void main(String[] args) {
        TestRunner.run(ControlProduccionTest.class);
    }
}

