/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.solvers;

import Jama.Matrix;
import jmarkov.MarkovProcess;
import jmarkov.basic.exceptions.NotUnichainException;
import jmarkov.solvers.SteadyStateSolver;

public final class JamaSolver
extends SteadyStateSolver {
    public JamaSolver(MarkovProcess mp) {
        super(mp);
    }

    @Override
    public double[] getSteadyState() throws NotUnichainException {
        Matrix pi;
        Matrix Q = new Matrix(this.mp.getGenerator()).copy();
        this.mp.debug(1, "Computing  Steady State Probabilities ..");
        int n = Q.getRowDimension();
        int i = 0;
        while (i < n) {
            Q.set(i, n - 1, 1.0);
            ++i;
        }
        Matrix b = new Matrix(1, n);
        b.set(0, n - 1, 1.0);
        try {
            long initialTime = System.currentTimeMillis();
            pi = Q.solveTranspose(b);
            long processTime = System.currentTimeMillis() - initialTime;
            this.mp.debug(1, "Solve time : " + processTime + " milliseconds.");
        }
        catch (Exception e) {
            throw new NotUnichainException("Exception Solving Steady state probabilities with JAMA solver. ", e);
        }
        return pi.getRowPackedCopy();
    }

    @Override
    public String label() {
        return "JAMA solver";
    }

    @Override
    public String description() {
        return "JAMA SOLVER. This solver uses the JAMA package to handle matrices.";
    }
}

