/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import java.io.PrintWriter;
import jmarkov.basic.Action;
import jmarkov.basic.JMarkovElement;
import jmarkov.basic.Policy;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.basic.ValueFunction;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.MDP;

public abstract class Solver<S extends State, A extends Action>
implements JMarkovElement {
    protected Policy<S, A> policy = null;
    protected ValueFunction<S> valueFunction = new ValueFunction();
    protected boolean solved = false;
    protected MDP<S, A> problem = null;
    protected boolean printProcessTime = false;
    protected boolean printValueFunction = false;

    protected Solver(MDP<S, A> problem) {
        this.problem = problem;
        problem.setSolver(this);
    }

    public MDP<S, A> getProblem() {
        return this.problem;
    }

    public abstract Solution<S, A> solve() throws SolverException;

    public final Policy<S, A> getOptimalPolicy() throws SolverException {
        if (!this.solved) {
            Solution<S, A> sol = this.solve();
            this.policy = sol.getPolicy();
        }
        return this.policy;
    }

    public final ValueFunction<S> getValueFunction() {
        return this.valueFunction;
    }

    public final ValueFunction<S> getOptimalValueFunction() throws SolverException {
        if (!this.solved) {
            Solution<S, A> sol = this.solve();
            this.valueFunction = sol.getValueFunction();
        }
        return this.valueFunction;
    }

    public final boolean isSolved() {
        return this.solved;
    }

    @Override
    public abstract String label();

    @Override
    public String description() {
        return "Solver: " + this.label() + "\nClass: " + this.getClass().getName();
    }

    @Override
    public final String toString() {
        return this.label();
    }

    public abstract long getProcessTime();

    public void setPrintProcessTime(boolean val) {
        this.printProcessTime = val;
    }

    public void setPrintValueFunction(boolean val) {
        this.printValueFunction = val;
    }

    public void printSolution(PrintWriter pw) {
        pw.println(this);
        try {
            this.getOptimalPolicy().print(pw);
            if (this.printValueFunction) {
                this.valueFunction.print(pw);
            }
            if (this.printProcessTime) {
                pw.println("Process time = " + this.getProcessTime() + " milliseconds");
            }
        }
        catch (SolverException e) {
            pw.print(" Error solving the problem :" + e);
        }
    }

    public void printSolution() throws Exception {
        this.printSolution(new PrintWriter(System.out));
    }
}

